/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff.impl;

import com.intellij.util.io.DataExternalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.buildtools.api.jvm.ClassSnapshotGranularity;
import org.jetbrains.kotlin.incremental.DifferenceCalculatorForPackageFacade;
import org.jetbrains.kotlin.incremental.KotlinClassInfo;
import org.jetbrains.kotlin.incremental.PackagePartProtoData;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.classpathDiff.JavaClassMemberLevelSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.JavaClassMemberLevelSnapshotExternalizer;
import org.jetbrains.kotlin.incremental.classpathDiff.JavaClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.JavaElementSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.KotlinClassInfoExternalizer;
import org.jetbrains.kotlin.incremental.classpathDiff.KotlinClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.MultifileClassKotlinClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.PackageFacadeKotlinClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.RegularKotlinClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.impl.ClassFileWithContents;
import org.jetbrains.kotlin.incremental.impl.ClassNodeSnapshotter;
import org.jetbrains.kotlin.incremental.impl.SelectiveClassVisitor;
import org.jetbrains.kotlin.incremental.impl.UtilsKt;
import org.jetbrains.kotlin.incremental.storage.ExternalizersKt;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMemberSignature;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.FieldNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/impl/SingleClassSnapshotter;", "", "<init>", "()V", "snapshotKotlinClass", "Lorg/jetbrains/kotlin/incremental/classpathDiff/KotlinClassSnapshot;", "classFile", "Lorg/jetbrains/kotlin/incremental/classpathDiff/impl/ClassFileWithContents;", "granularity", "Lorg/jetbrains/kotlin/buildtools/api/jvm/ClassSnapshotGranularity;", "kotlinClassInfo", "Lorg/jetbrains/kotlin/incremental/KotlinClassInfo;", "snapshotJavaClass", "Lorg/jetbrains/kotlin/incremental/classpathDiff/JavaClassSnapshot;", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nSingleClassSnapshotter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleClassSnapshotter.kt\norg/jetbrains/kotlin/incremental/classpathDiff/impl/SingleClassSnapshotter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1#2:124\n1563#3:125\n1634#3,3:126\n1563#3:129\n1634#3,3:130\n*S KotlinDebug\n*F\n+ 1 SingleClassSnapshotter.kt\norg/jetbrains/kotlin/incremental/classpathDiff/impl/SingleClassSnapshotter\n*L\n102#1:125\n102#1:126,3\n103#1:129\n103#1:130,3\n*E\n"})
public final class SingleClassSnapshotter {
    @NotNull
    public static final SingleClassSnapshotter INSTANCE = new SingleClassSnapshotter();

    private SingleClassSnapshotter() {
    }

    @NotNull
    public final KotlinClassSnapshot snapshotKotlinClass(@NotNull ClassFileWithContents classFile, @NotNull ClassSnapshotGranularity granularity, @NotNull KotlinClassInfo kotlinClassInfo) {
        KotlinClassSnapshot kotlinClassSnapshot;
        KotlinClassInfo kotlinClassInfo2;
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)((Object)granularity), (String)"granularity");
        Intrinsics.checkNotNullParameter((Object)kotlinClassInfo, (String)"kotlinClassInfo");
        ClassId classId = kotlinClassInfo.getClassId();
        long classAbiHash = UtilsKt.hashToLong(ExternalizersKt.toByteArray(KotlinClassInfoExternalizer.INSTANCE, kotlinClassInfo));
        KotlinClassInfo it = kotlinClassInfo2 = kotlinClassInfo;
        boolean bl = false;
        KotlinClassInfo classMemberLevelSnapshot = granularity == ClassSnapshotGranularity.CLASS_MEMBER_LEVEL ? kotlinClassInfo2 : null;
        switch (WhenMappings.$EnumSwitchMapping$0[kotlinClassInfo.getClassKind().ordinal()]) {
            case 1: {
                Object object;
                kotlinClassSnapshot = new RegularKotlinClassSnapshot(classId, classAbiHash, classMemberLevelSnapshot, classFile.getClassInfo().getSupertypes(), (object = kotlinClassInfo.getCompanionObject()) != null && (object = ((ClassId)object).getShortClassName()) != null ? ((Name)object).getIdentifier() : null, kotlinClassInfo.getConstantsInCompanionObject());
                break;
            }
            case 2: 
            case 3: {
                ProtoData protoData = kotlinClassInfo.getProtoData();
                Intrinsics.checkNotNull((Object)protoData, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.incremental.PackagePartProtoData");
                kotlinClassSnapshot = new PackageFacadeKotlinClassSnapshot(classId, classAbiHash, classMemberLevelSnapshot, CollectionsKt.toSet((Iterable)DifferenceCalculatorForPackageFacade.Companion.getNonPrivateMembers((PackagePartProtoData)protoData)));
                break;
            }
            case 4: {
                kotlinClassSnapshot = new MultifileClassKotlinClassSnapshot(classId, classAbiHash, classMemberLevelSnapshot, kotlinClassInfo.getExtraInfo().getConstantSnapshots().keySet());
                break;
            }
            case 5: {
                throw new IllegalStateException(("Unexpected class " + classId + " with class kind SYNTHETIC_CLASS (synthetic classes should have been removed earlier)").toString());
            }
            case 6: {
                throw new IllegalStateException(("Can't handle class " + classId + " with class kind UNKNOWN").toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return kotlinClassSnapshot;
    }

    @NotNull
    public final JavaClassSnapshot snapshotJavaClass(@NotNull ClassFileWithContents classFile, @NotNull ClassSnapshotGranularity granularity) {
        long l2;
        JavaClassMemberLevelSnapshot classMemberLevelSnapshot;
        JavaClassMemberLevelSnapshot javaClassMemberLevelSnapshot;
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)((Object)granularity), (String)"granularity");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(classFile.getContents());
        SelectiveClassVisitor selectiveClassVisitor = new SelectiveClassVisitor(classNode, (Function3<? super JvmMemberSignature.Field, ? super Boolean, ? super Boolean, Boolean>)((Function3)SingleClassSnapshotter::snapshotJavaClass$lambda$1), (Function2<? super JvmMemberSignature.Method, ? super Boolean, Boolean>)((Function2)SingleClassSnapshotter::snapshotJavaClass$lambda$2));
        classReader.accept(selectiveClassVisitor, 1);
        ClassNodeSnapshotter.INSTANCE.sortClassMembers(classNode);
        if (granularity == ClassSnapshotGranularity.CLASS_MEMBER_LEVEL) {
            Collection<JavaElementSnapshot> collection;
            MethodNode it;
            Collection collection2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String string = classNode.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            JavaElementSnapshot javaElementSnapshot = new JavaElementSnapshot(string, ClassNodeSnapshotter.snapshotClassExcludingMembers$default(ClassNodeSnapshotter.INSTANCE, classNode, false, 2, null));
            List<FieldNode> list = classNode.fields;
            Intrinsics.checkNotNullExpressionValue(list, (String)"fields");
            Iterable iterable = list;
            JavaElementSnapshot javaElementSnapshot2 = javaElementSnapshot;
            boolean $i$f$map = false;
            void var9_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FieldNode fieldNode = (FieldNode)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                String string2 = ((FieldNode)((Object)it)).name;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                Intrinsics.checkNotNull((Object)it);
                collection2.add(new JavaElementSnapshot(string2, ClassNodeSnapshotter.INSTANCE.snapshotField((FieldNode)((Object)it))));
            }
            List<MethodNode> list2 = classNode.methods;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"methods");
            $this$map$iv = list2;
            collection2 = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (MethodNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string3 = it.name;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
                Intrinsics.checkNotNull((Object)it);
                collection.add(new JavaElementSnapshot(string3, ClassNodeSnapshotter.INSTANCE.snapshotMethod(it, classNode.version)));
            }
            collection = (List)destination$iv$iv;
            List list3 = collection;
            Collection collection3 = collection2;
            JavaElementSnapshot javaElementSnapshot3 = javaElementSnapshot2;
            javaClassMemberLevelSnapshot = new JavaClassMemberLevelSnapshot(javaElementSnapshot3, (List<JavaElementSnapshot>)collection3, list3);
        } else {
            javaClassMemberLevelSnapshot = classMemberLevelSnapshot = null;
        }
        if (granularity == ClassSnapshotGranularity.CLASS_MEMBER_LEVEL) {
            DataExternalizer dataExternalizer = JavaClassMemberLevelSnapshotExternalizer.INSTANCE;
            JavaClassMemberLevelSnapshot javaClassMemberLevelSnapshot2 = classMemberLevelSnapshot;
            Intrinsics.checkNotNull(javaClassMemberLevelSnapshot2);
            l2 = UtilsKt.hashToLong(ExternalizersKt.toByteArray(dataExternalizer, javaClassMemberLevelSnapshot2));
        } else {
            l2 = ClassNodeSnapshotter.INSTANCE.snapshotClass(classNode);
        }
        long classAbiHash = l2;
        return new JavaClassSnapshot(classFile.getClassInfo().getClassId(), classAbiHash, classMemberLevelSnapshot, classFile.getClassInfo().getSupertypes());
    }

    private static final boolean snapshotJavaClass$lambda$1(JvmMemberSignature.Field field, boolean isPrivate, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"<unused var>");
        return !isPrivate;
    }

    private static final boolean snapshotJavaClass$lambda$2(JvmMemberSignature.Method method, boolean isPrivate) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"<unused var>");
        return !isPrivate;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinClassHeader.Kind.values().length];
            try {
                nArray[KotlinClassHeader.Kind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.FILE_FACADE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS_PART.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.SYNTHETIC_CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.UNKNOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

