/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIntrinsics;
import org.jetbrains.kotlin.ir.backend.js.lower.JsCodeOutlineTransformer;
import org.jetbrains.kotlin.ir.backend.js.lower.JsCodeOutliningLoweringKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@PhaseDescription(name="JsCodeOutliningLowering")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012(\b\u0002\u0010\b\u001a\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\tj\u0004\u0018\u0001`\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\fH\u0016J&\u0010\u001d\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R1\u0010\b\u001a\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\tj\u0004\u0018\u0001`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsCodeOutliningLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "loweringContext", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "intrinsics", "Lorg/jetbrains/kotlin/ir/backend/js/JsIntrinsics;", "dynamicType", "Lorg/jetbrains/kotlin/ir/types/IrDynamicType;", "reportInlinableFunctionCaptured", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/InlinableLambdaCapturingReporter;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;Lorg/jetbrains/kotlin/ir/backend/js/JsIntrinsics;Lorg/jetbrains/kotlin/ir/types/IrDynamicType;Lkotlin/jvm/functions/Function3;)V", "getLoweringContext", "()Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "getIntrinsics", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIntrinsics;", "getDynamicType", "()Lorg/jetbrains/kotlin/ir/types/IrDynamicType;", "getReportInlinableFunctionCaptured", "()Lkotlin/jvm/functions/Function3;", "lower", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "putOutlinedFunctionsIntoContainer", "outlinedFunctions", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Companion", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsCodeOutliningLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsCodeOutliningLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsCodeOutliningLowering\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,413:1\n18#2,2:414\n389#3,13:416\n133#4,2:429\n*S KotlinDebug\n*F\n+ 1 JsCodeOutliningLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsCodeOutliningLowering\n*L\n117#1:414,2\n125#1:416,13\n125#1:429,2\n*E\n"})
public final class JsCodeOutliningLowering
implements BodyLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LoweringContext loweringContext;
    @NotNull
    private final JsIntrinsics intrinsics;
    @NotNull
    private final IrDynamicType dynamicType;
    @Nullable
    private final Function3<IrExpression, IrValueDeclaration, IrDeclaration, Unit> reportInlinableFunctionCaptured;
    @NotNull
    private static final IrDeclarationOriginImpl OUTLINED_JS_CODE_ORIGIN = new IrDeclarationOriginImpl("OUTLINED_JS_CODE", false, 2, null);

    public JsCodeOutliningLowering(@NotNull LoweringContext loweringContext, @NotNull JsIntrinsics intrinsics, @NotNull IrDynamicType dynamicType, @Nullable Function3<? super IrExpression, ? super IrValueDeclaration, ? super IrDeclaration, Unit> reportInlinableFunctionCaptured) {
        Intrinsics.checkNotNullParameter((Object)loweringContext, (String)"loweringContext");
        Intrinsics.checkNotNullParameter((Object)intrinsics, (String)"intrinsics");
        Intrinsics.checkNotNullParameter((Object)dynamicType, (String)"dynamicType");
        this.loweringContext = loweringContext;
        this.intrinsics = intrinsics;
        this.dynamicType = dynamicType;
        this.reportInlinableFunctionCaptured = reportInlinableFunctionCaptured;
    }

    public /* synthetic */ JsCodeOutliningLowering(LoweringContext loweringContext, JsIntrinsics jsIntrinsics, IrDynamicType irDynamicType, Function3 function3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            function3 = null;
        }
        this(loweringContext, jsIntrinsics, irDynamicType, (Function3<? super IrExpression, ? super IrValueDeclaration, ? super IrDeclaration, Unit>)function3);
    }

    @NotNull
    public final LoweringContext getLoweringContext() {
        return this.loweringContext;
    }

    @NotNull
    public final JsIntrinsics getIntrinsics() {
        return this.intrinsics;
    }

    @NotNull
    public final IrDynamicType getDynamicType() {
        return this.dynamicType;
    }

    @Nullable
    public final Function3<IrExpression, IrValueDeclaration, IrDeclaration, Unit> getReportInlinableFunctionCaptured() {
        return this.reportInlinableFunctionCaptured;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (!JsCodeOutliningLoweringKt.access$containsCallsTo(irBody, this.intrinsics.getJsCode())) {
            return;
        }
        JsCodeOutlineTransformer replacer = new JsCodeOutlineTransformer(this.loweringContext, this.intrinsics, this.dynamicType, container, this.reportInlinableFunctionCaptured);
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, replacer);
        List<IrFunction> outlinedFunctions = replacer.getOutlinedFunctions();
        if (outlinedFunctions.isEmpty()) {
            return;
        }
        this.putOutlinedFunctionsIntoContainer(outlinedFunctions, container, irBody);
    }

    /*
     * WARNING - void declaration
     */
    private final void putOutlinedFunctionsIntoContainer(List<? extends IrFunction> outlinedFunctions, IrDeclaration container, IrBody irBody) {
        IrElementBase irElementBase;
        for (IrFunction irFunction : outlinedFunctions) {
            Object v0;
            block8: {
                void $this$firstIsInstanceOrNull$iv;
                Sequence<IrDeclaration> sequence2 = IrUtilsKt.getParentDeclarationsWithSelf(container);
                irElementBase = irFunction;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof IrDeclarationParent)) continue;
                    v0 = element$iv;
                    break block8;
                }
                v0 = null;
            }
            IrDeclarationParent irDeclarationParent = v0;
            if (irDeclarationParent == null) {
                CompilationExceptionKt.compilationException("Unexpected container to insert the outlined function to", container);
                throw new KotlinNothingValueException();
            }
            ((IrDeclarationBase)irElementBase).setParent(irDeclarationParent);
        }
        IrBody irBody2 = irBody;
        if (irBody2 instanceof IrBlockBody) {
            ((IrBlockBody)irBody).getStatements().addAll(0, (Collection<IrStatement>)outlinedFunctions);
        } else if (irBody2 instanceof IrExpressionBody) {
            void $this$putOutlinedFunctionsIntoContainer_u24lambda_u240;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlock_u24default$iv;
            DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder$default(this.loweringContext, container.getSymbol(), 0, 0, 6, null);
            IrBuilderWithScope irBuilderWithScope = declarationIrBuilder;
            int $this$firstIsInstanceOrNull$iv = irBody.getStartOffset();
            int endOffset$iv = irBody.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void var14_17 = this_$iv$iv;
            irElementBase = (IrExpressionBody)irBody;
            boolean bl = false;
            $this$putOutlinedFunctionsIntoContainer_u24lambda_u240.unaryPlus(outlinedFunctions);
            $this$putOutlinedFunctionsIntoContainer_u24lambda_u240.unaryPlus(((IrExpressionBody)irBody).getExpression());
            ((IrExpressionBody)irElementBase).setExpression((IrExpression)this_$iv$iv.doBuild());
        } else {
            if (irBody2 instanceof IrSyntheticBody) {
                org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.syntheticBodyIsNotSupported(container);
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsCodeOutliningLowering$Companion;", "", "<init>", "()V", "OUTLINED_JS_CODE_ORIGIN", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "getOUTLINED_JS_CODE_ORIGIN", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "backend.js"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrDeclarationOriginImpl getOUTLINED_JS_CODE_ORIGIN() {
            return OUTLINED_JS_CODE_ORIGIN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

