/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.stubs.KotlinCallableStubBase;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassifierStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderWithTextStub;
import org.jetbrains.kotlin.psi.stubs.KotlinStubWithFqName;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinStubBaseImplKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u0019*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0019B%\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u0012\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0002\b\u00030\u0007H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0010\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010H\u0002J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0014H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinStubBaseImpl;", "T", "Lorg/jetbrains/kotlin/psi/KtElementImplStub;", "Lcom/intellij/psi/stubs/StubBase;", "parent", "Lcom/intellij/psi/stubs/StubElement;", "elementType", "Lcom/intellij/psi/stubs/IStubElementType;", "<init>", "(Lcom/intellij/psi/stubs/StubElement;Lcom/intellij/psi/stubs/IStubElementType;)V", "getStubType", "toString", "", "renderPropertyValues", "", "stubInterface", "Ljava/lang/Class;", "", "collectProperties", "", "Ljava/lang/reflect/Method;", "renderProperty", "property", "getPropertyName", "method", "Companion", "psi"})
@SourceDebugExtension(value={"SMAP\nKotlinStubBaseImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStubBaseImpl.kt\norg/jetbrains/kotlin/psi/stubs/impl/KotlinStubBaseImpl\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n2945#2,12:83\n3829#2:108\n4344#2,2:109\n1617#3,9:95\n1869#3:104\n1870#3:106\n1626#3:107\n1#4:105\n1#4:111\n*S KotlinDebug\n*F\n+ 1 KotlinStubBaseImpl.kt\norg/jetbrains/kotlin/psi/stubs/impl/KotlinStubBaseImpl\n*L\n26#1:83,12\n41#1:108\n41#1:109,2\n36#1:95,9\n36#1:104\n36#1:106\n36#1:107\n36#1:105\n*E\n"})
public class KotlinStubBaseImpl<T extends KtElementImplStub<?>>
extends StubBase<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final List<Class<? extends Object>> BASE_STUB_INTERFACES;

    public KotlinStubBaseImpl(@Nullable StubElement<?> parent2, @NotNull IStubElementType<?, ?> elementType) {
        Intrinsics.checkNotNullParameter(elementType, (String)"elementType");
        super(parent2, elementType);
    }

    @Override
    @NotNull
    public IStubElementType<? extends StubElement<?>, ?> getStubType() {
        IStubElementType iStubElementType = super.getStubType();
        Intrinsics.checkNotNull((Object)iStubElementType, (String)"null cannot be cast to non-null type com.intellij.psi.stubs.IStubElementType<out com.intellij.psi.stubs.StubElement<*>, *>");
        return iStubElementType;
    }

    @Override
    @NotNull
    public String toString() {
        Class<?>[] classArray = this.getClass().getInterfaces();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"getInterfaces(...)");
        Object[] $this$single$iv = classArray;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            Class it = (Class)element$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"Stub", (boolean)false, (int)2, null)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Array contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        Class stubInterface = (Class)single$iv;
        Intrinsics.checkNotNull((Object)stubInterface);
        List<String> propertiesValues = this.renderPropertyValues(stubInterface);
        if (propertiesValues.isEmpty()) {
            return KotlinStubBaseImplKt.getSTUB_TO_STRING_PREFIX() + this.getStubType();
        }
        String properties2 = CollectionsKt.joinToString$default((Iterable)propertiesValues, (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null);
        return KotlinStubBaseImplKt.getSTUB_TO_STRING_PREFIX() + this.getStubType() + properties2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> renderPropertyValues(Class<? extends Object> stubInterface) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.collectProperties(stubInterface);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Method property2 = (Method)element$iv$iv;
            boolean bl2 = false;
            if (this.renderProperty(property2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Method> collectProperties(Class<?> stubInterface) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        ArrayList<Method> result2 = new ArrayList<Method>();
        Method[] methodArray = stubInterface.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
        Object[] objectArray = methodArray;
        ArrayList<Method> arrayList = result2;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Method it = (Method)element$iv$iv;
            boolean bl = false;
            Class<?>[] classArray = it.getParameterTypes();
            Intrinsics.checkNotNull(classArray);
            boolean bl2 = classArray.length == 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        arrayList.addAll((List)destination$iv$iv);
        Class<?>[] classArray = stubInterface.getInterfaces();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"getInterfaces(...)");
        for (Class<?> baseInterface : classArray) {
            if (!BASE_STUB_INTERFACES.contains(baseInterface)) continue;
            Intrinsics.checkNotNull((Object)baseInterface);
            result2.addAll(this.collectProperties(baseInterface));
        }
        return result2;
    }

    private final String renderProperty(Method property2) {
        String string;
        try {
            Object value2 = property2.invoke((Object)this, new Object[0]);
            String name2 = this.getPropertyName(property2);
            string = name2 + '=' + value2;
        }
        catch (Exception e2) {
            LOGGER.error(e2);
            string = null;
        }
        return string;
    }

    private final String getPropertyName(Method method) {
        String string = method.getName();
        Intrinsics.checkNotNull((Object)string);
        String methodName = string;
        if (StringsKt.startsWith$default((String)methodName, (String)"get", (boolean)false, (int)2, null)) {
            String string2;
            String string3 = methodName.substring(3);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String string4 = string3;
            if (((CharSequence)string4).length() > 0) {
                char p0 = string4.charAt(0);
                boolean bl = false;
                char c2 = Character.toLowerCase(p0);
                String string5 = string4;
                int n2 = 1;
                String string6 = string5.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                string5 = string6;
                string2 = c2 + string5;
            } else {
                string2 = string4;
            }
            return string2;
        }
        return methodName;
    }

    static {
        Logger logger = Logger.getInstance(KotlinStubBaseImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
        Object[] objectArray = new Class[]{KotlinStubWithFqName.class, KotlinClassifierStub.class, KotlinClassOrObjectStub.class, NamedStub.class, KotlinCallableStubBase.class, KotlinPlaceHolderWithTextStub.class};
        BASE_STUB_INTERFACES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinStubBaseImpl$Companion;", "", "<init>", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "BASE_STUB_INTERFACES", "", "Ljava/lang/Class;", "psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

