/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// This file was generated automatically. See compiler/ir/ir.tree/tree-generator/ReadMe.md.
// DO NOT MODIFY IT MANUALLY.

package org.jetbrains.kotlin.ir.util

import org.jetbrains.kotlin.ir.IrElement
import org.jetbrains.kotlin.ir.symbols.*

/**
 * Auto-generated by [org.jetbrains.kotlin.ir.generator.print.symbol.ReferencedSymbolVisitorInterfacePrinter]
 */
interface ReferencedSymbolVisitor {

    fun visitReferencedClass(container: IrElement, symbol: IrClassSymbol) { visitReferencedSymbol(container, symbol) }

    fun visitReferencedProperty(container: IrElement, symbol: IrPropertySymbol) { visitReferencedSymbol(container, symbol) }

    fun visitReferencedScript(container: IrElement, symbol: IrScriptSymbol) { visitReferencedSymbol(container, symbol) }

    fun visitReferencedConstructor(container: IrElement, symbol: IrConstructorSymbol) { visitReferencedSymbol(container, symbol) }

    fun visitReferencedEnumEntry(container: IrElement, symbol: IrEnumEntrySymbol) { visitReferencedSymbol(container, symbol) }

    fun visitReferencedFunction(container: IrElement, symbol: IrFunctionSymbol) {
        when (symbol) {
            is IrConstructorSymbol -> visitReferencedConstructor(container, symbol)
            is IrSimpleFunctionSymbol -> visitReferencedSimpleFunction(container, symbol)
        }
    }

    fun visitReferencedSimpleFunction(container: IrElement, symbol: IrSimpleFunctionSymbol) { visitReferencedSymbol(container, symbol) }

    fun visitReferencedField(container: IrElement, symbol: IrFieldSymbol) { visitReferencedSymbol(container, symbol) }

    fun visitReferencedLocalDelegatedProperty(container: IrElement, symbol: IrLocalDelegatedPropertySymbol) { visitReferencedSymbol(container, symbol) }

    fun visitReferencedVariable(container: IrElement, symbol: IrVariableSymbol) { visitReferencedSymbol(container, symbol) }

    fun visitReferencedDeclarationWithAccessors(container: IrElement, symbol: IrDeclarationWithAccessorsSymbol) {
        when (symbol) {
            is IrPropertySymbol -> visitReferencedProperty(container, symbol)
            is IrLocalDelegatedPropertySymbol -> visitReferencedLocalDelegatedProperty(container, symbol)
        }
    }

    fun visitReferencedClassifier(container: IrElement, symbol: IrClassifierSymbol) {
        when (symbol) {
            is IrClassSymbol -> visitReferencedClass(container, symbol)
            is IrScriptSymbol -> visitReferencedScript(container, symbol)
            is IrTypeParameterSymbol -> visitReferencedTypeParameter(container, symbol)
        }
    }

    fun visitReferencedTypeParameter(container: IrElement, symbol: IrTypeParameterSymbol) { visitReferencedSymbol(container, symbol) }

    fun visitReferencedReturnTarget(container: IrElement, symbol: IrReturnTargetSymbol) {
        when (symbol) {
            is IrFunctionSymbol -> visitReferencedFunction(container, symbol)
            is IrReturnableBlockSymbol -> visitReferencedReturnableBlock(container, symbol)
        }
    }

    fun visitReferencedReturnableBlock(container: IrElement, symbol: IrReturnableBlockSymbol) { visitReferencedSymbol(container, symbol) }

    fun visitReferencedValue(container: IrElement, symbol: IrValueSymbol) {
        when (symbol) {
            is IrValueParameterSymbol -> visitReferencedValueParameter(container, symbol)
            is IrVariableSymbol -> visitReferencedVariable(container, symbol)
        }
    }

    fun visitReferencedValueParameter(container: IrElement, symbol: IrValueParameterSymbol) { visitReferencedSymbol(container, symbol) }

    fun visitReferencedTypeAlias(container: IrElement, symbol: IrTypeAliasSymbol) { visitReferencedSymbol(container, symbol) }

    fun visitReferencedSymbol(container: IrElement, symbol: IrSymbol)
}
