/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CapturingInClosureCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.expressions.CaptureKind;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u000eH\u0002J\u0018\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)H\u0002J&\u0010*\u001a\u0010\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-\u0018\u00010+2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010.\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)H\u0002\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CapturingInClosureChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCapturingInClosure", "variable", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "checkFieldInExactlyOnceLambdaInitialization", "scopeContainer", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "nameElement", "isLhsOfAssignment", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isCapturedVariable", "variableParent", "getCaptureKind", "Lorg/jetbrains/kotlin/types/expressions/CaptureKind;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isArgument", "isValInWhen", "isCatchBlockParameter", "isForLoopParameter", "isExactlyOnceParameter", "function", "parameter", "isExactlyOnceContract", "bindingContext", "argument", "Lorg/jetbrains/kotlin/psi/KtFunction;", "getCalleeDescriptorAndParameter", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "isCrossinlineParameter", "frontend"})
@SourceDebugExtension(value={"SMAP\nCapturingInClosureChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CapturingInClosureChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/CapturingInClosureChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n1#2:192\n808#3,11:193\n*S KotlinDebug\n*F\n+ 1 CapturingInClosureChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/CapturingInClosureChecker\n*L\n157#1:193,11\n*E\n"})
public final class CapturingInClosureChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        ResolvedCall<?> variableResolvedCall;
        Object obj;
        VariableDescriptor variableDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? (VariableAsFunctionResolvedCall)((Object)resolvedCall2) : null;
        if (object == null || (object = object.getVariableCall()) == null) {
            object = resolvedCall2;
        }
        VariableDescriptor variableDescriptor2 = variableDescriptor = (obj = (variableResolvedCall = object).getResultingDescriptor()) instanceof VariableDescriptor ? (VariableDescriptor)obj : null;
        if (variableDescriptor != null) {
            this.checkCapturingInClosure(variableDescriptor, context2.getTrace(), context2.getScope());
            this.checkFieldInExactlyOnceLambdaInitialization(variableDescriptor, context2.getTrace(), context2.getScope().getOwnerDescriptor(), reportOn);
        }
    }

    private final void checkCapturingInClosure(VariableDescriptor variable, BindingTrace trace, LexicalScope scope2) {
        DeclarationDescriptor declarationDescriptor = variable.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor variableParent = declarationDescriptor;
        DeclarationDescriptor scopeContainer = scope2.getOwnerDescriptor();
        if (this.isCapturedVariable(variableParent, scopeContainer) && trace.get(BindingContext.CAPTURED_IN_CLOSURE, variable) != CaptureKind.NOT_INLINE) {
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            trace.record(BindingContext.CAPTURED_IN_CLOSURE, variable, this.getCaptureKind(bindingContext, scopeContainer, variableParent, variable));
            return;
        }
    }

    private final void checkFieldInExactlyOnceLambdaInitialization(VariableDescriptor variable, BindingTrace trace, DeclarationDescriptor scopeContainer, PsiElement nameElement) {
        if (!(variable instanceof PropertyDescriptor) || !(scopeContainer instanceof AnonymousFunctionDescriptor) || ((PropertyDescriptor)variable).isVar()) {
            return;
        }
        Intrinsics.checkNotNull((Object)nameElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        if (!this.isLhsOfAssignment((KtExpression)nameElement)) {
            return;
        }
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(scopeContainer);
        KtFunction ktFunction = psiElement instanceof KtFunction ? (KtFunction)psiElement : null;
        if (ktFunction == null) {
            return;
        }
        KtFunction scopeDeclaration = ktFunction;
        if (!(((AnonymousFunctionDescriptor)scopeContainer).getContainingDeclaration() instanceof ConstructorDescriptor) && !(((AnonymousFunctionDescriptor)scopeContainer).getContainingDeclaration() instanceof PropertyDescriptor)) {
            return;
        }
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        if (!this.isExactlyOnceContract(bindingContext, scopeDeclaration)) {
            return;
        }
        if (trace.getBindingContext().get(BindingContext.CAPTURED_IN_CLOSURE, variable) == CaptureKind.NOT_INLINE) {
            return;
        }
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"getBindingContext(...)");
        Pair<CallableDescriptor, ValueParameterDescriptor> pair = this.getCalleeDescriptorAndParameter(bindingContext2, scopeDeclaration);
        if (pair == null) {
            return;
        }
        Pair<CallableDescriptor, ValueParameterDescriptor> pair2 = pair;
        CallableDescriptor callee = (CallableDescriptor)pair2.component1();
        ValueParameterDescriptor param = (ValueParameterDescriptor)pair2.component2();
        if (!(callee instanceof FunctionDescriptor)) {
            return;
        }
        if (!((FunctionDescriptor)callee).isInline() || param.isCrossinline() || !InlineUtil.isInlineParameter(param)) {
            trace.report(Errors.CAPTURED_VAL_INITIALIZATION.on((KtExpression)nameElement, variable));
        }
    }

    private final boolean isLhsOfAssignment(KtExpression nameElement) {
        PsiElement psiElement = nameElement.getParent();
        KtBinaryExpression ktBinaryExpression = psiElement instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression parent2 = ktBinaryExpression;
        return Intrinsics.areEqual((Object)parent2.getOperationToken(), (Object)KtTokens.EQ) && Intrinsics.areEqual((Object)parent2.getLeft(), (Object)nameElement);
    }

    private final boolean isCapturedVariable(DeclarationDescriptor variableParent, DeclarationDescriptor scopeContainer) {
        if (!(variableParent instanceof FunctionDescriptor) || Intrinsics.areEqual((Object)scopeContainer, (Object)variableParent)) {
            return false;
        }
        if (variableParent instanceof ConstructorDescriptor) {
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)variableParent).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptorWithTypeParameters, (String)"getContainingDeclaration(...)");
            ClassifierDescriptorWithTypeParameters classDescriptor = classifierDescriptorWithTypeParameters;
            if (Intrinsics.areEqual((Object)scopeContainer, (Object)classDescriptor)) {
                return false;
            }
            if (scopeContainer instanceof PropertyDescriptor && Intrinsics.areEqual((Object)((PropertyDescriptor)scopeContainer).getContainingDeclaration(), (Object)classDescriptor)) {
                return false;
            }
        }
        return true;
    }

    private final CaptureKind getCaptureKind(BindingContext context2, DeclarationDescriptor scopeContainer, DeclarationDescriptor variableParent, VariableDescriptor variable) {
        PsiElement scopeDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(scopeContainer);
        if (!InlineUtil.canBeInlineArgument(scopeDeclaration)) {
            return CaptureKind.NOT_INLINE;
        }
        Intrinsics.checkNotNull((Object)scopeDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        if (InlineUtil.isInlinedArgument((KtFunction)scopeDeclaration, context2, false) && !this.isCrossinlineParameter(context2, (KtFunction)scopeDeclaration)) {
            DeclarationDescriptor declarationDescriptor = scopeContainer.getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new IllegalStateException(("parent is null for " + scopeContainer).toString());
            }
            DeclarationDescriptor scopeContainerParent = declarationDescriptor;
            return !this.isCapturedVariable(variableParent, scopeContainerParent) || this.getCaptureKind(context2, scopeContainerParent, variableParent, variable) == CaptureKind.INLINE_ONLY ? CaptureKind.INLINE_ONLY : CaptureKind.NOT_INLINE;
        }
        boolean exactlyOnceContract = this.isExactlyOnceContract(context2, (KtFunction)scopeDeclaration);
        if (!exactlyOnceContract) {
            return CaptureKind.NOT_INLINE;
        }
        return this.isArgument(variable, variableParent) || CapturingInClosureCheckerKt.findDestructuredVariable(variable, variableParent) != null || this.isForLoopParameter(variable) || this.isCatchBlockParameter(variable) || this.isValInWhen(variable) ? CaptureKind.NOT_INLINE : CaptureKind.EXACTLY_ONCE_EFFECT;
    }

    private final boolean isArgument(VariableDescriptor variable, DeclarationDescriptor variableParent) {
        return variable instanceof ValueParameterDescriptor && variableParent instanceof CallableDescriptor && ((CallableDescriptor)variableParent).getValueParameters().contains(variable);
    }

    private final boolean isValInWhen(VariableDescriptor variable) {
        boolean bl;
        LocalVariableDescriptor localVariableDescriptor = variable instanceof LocalVariableDescriptor ? (LocalVariableDescriptor)variable : null;
        Object object = localVariableDescriptor != null ? localVariableDescriptor.getSource() : null;
        Object object2 = object instanceof KotlinSourceElement ? (KotlinSourceElement)object : null;
        if (object2 == null || (object2 = ((KotlinSourceElement)object2).getPsi()) == null) {
            return false;
        }
        Object psi = object2;
        object = psi.getParent();
        KtWhenExpression ktWhenExpression = object instanceof KtWhenExpression ? (KtWhenExpression)object : null;
        if (ktWhenExpression != null) {
            KtWhenExpression it = ktWhenExpression;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it.getSubjectVariable(), (Object)psi);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCatchBlockParameter(VariableDescriptor variable) {
        LocalVariableDescriptor localVariableDescriptor = variable instanceof LocalVariableDescriptor ? (LocalVariableDescriptor)variable : null;
        SourceElement sourceElement = localVariableDescriptor != null ? localVariableDescriptor.getSource() : null;
        if (!(sourceElement instanceof KotlinSourceElement)) return false;
        KotlinSourceElement kotlinSourceElement = (KotlinSourceElement)sourceElement;
        Object object = kotlinSourceElement;
        if (kotlinSourceElement == null) return false;
        if ((object = ((KotlinSourceElement)object).getPsi()) == null) {
            return false;
        }
        Object psi = object;
        PsiElement it = psi.getParent().getParent();
        boolean bl = false;
        if (!(it instanceof KtCatchClause)) return false;
        KtParameterList ktParameterList = ((KtCatchClause)it).getParameterList();
        Object object2 = ktParameterList;
        if (ktParameterList == null) return false;
        List<KtParameter> list = ((KtParameterList)object2).getParameters();
        object2 = list;
        if (list == null) return false;
        if (!CollectionsKt.contains((Iterable)((Iterable)object2), (Object)psi)) return false;
        return true;
    }

    private final boolean isForLoopParameter(VariableDescriptor variable) {
        LocalVariableDescriptor localVariableDescriptor = variable instanceof LocalVariableDescriptor ? (LocalVariableDescriptor)variable : null;
        SourceElement sourceElement = localVariableDescriptor != null ? localVariableDescriptor.getSource() : null;
        Object object = sourceElement instanceof KotlinSourceElement ? (KotlinSourceElement)sourceElement : null;
        if (object == null || (object = ((KotlinSourceElement)object).getPsi()) == null) {
            return false;
        }
        Object psi = object;
        if (psi.getParent() instanceof KtForExpression) {
            PsiElement psiElement = psi.getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtForExpression");
            KtForExpression forExpression = (KtForExpression)psiElement;
            return Intrinsics.areEqual((Object)forExpression.getLoopParameter(), (Object)psi);
        }
        if (psi.getParent() instanceof KtDestructuringDeclaration) {
            PsiElement psiElement = psi.getParent().getParent();
            KtParameter ktParameter = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
            if (ktParameter == null) {
                return false;
            }
            KtParameter parameter = ktParameter;
            PsiElement psiElement2 = parameter.getParent();
            KtForExpression ktForExpression = psiElement2 instanceof KtForExpression ? (KtForExpression)psiElement2 : null;
            if (ktForExpression == null) {
                return false;
            }
            KtForExpression forExpression = ktForExpression;
            return Intrinsics.areEqual((Object)forExpression.getLoopParameter(), (Object)parameter);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isExactlyOnceParameter(DeclarationDescriptor function2, VariableDescriptor parameter) {
        Object v1;
        block6: {
            void $this$filterIsInstanceTo$iv$iv;
            if (!(function2 instanceof CallableDescriptor)) {
                return false;
            }
            if (!(parameter instanceof ValueParameterDescriptor)) {
                return false;
            }
            Object object = (AbstractContractProvider)((CallableDescriptor)function2).getUserData(ContractProviderKey.INSTANCE);
            if (object == null || (object = ((AbstractContractProvider)object).getContractDescription()) == null) {
                return false;
            }
            Object contractDescription2 = object;
            Iterable $this$filterIsInstance$iv = ((ContractDescription)contractDescription2).getEffects();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof CallsEffectDeclaration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e2 : iterable2) {
                CallsEffectDeclaration it = (CallsEffectDeclaration)e2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getVariableReference().getDescriptor(), (Object)((ValueParameterDescriptor)parameter).getOriginal())) continue;
                v1 = e2;
                break block6;
            }
            v1 = null;
        }
        CallsEffectDeclaration callsEffectDeclaration = v1;
        if (callsEffectDeclaration == null) {
            return false;
        }
        CallsEffectDeclaration effect = callsEffectDeclaration;
        return effect.getKind() == EventOccurrencesRange.EXACTLY_ONCE;
    }

    private final boolean isExactlyOnceContract(BindingContext bindingContext, KtFunction argument) {
        Pair<CallableDescriptor, ValueParameterDescriptor> pair = this.getCalleeDescriptorAndParameter(bindingContext, argument);
        if (pair == null) {
            return false;
        }
        Pair<CallableDescriptor, ValueParameterDescriptor> pair2 = pair;
        CallableDescriptor descriptor = (CallableDescriptor)pair2.component1();
        ValueParameterDescriptor parameter = (ValueParameterDescriptor)pair2.component2();
        return this.isExactlyOnceParameter(descriptor, parameter);
    }

    private final Pair<CallableDescriptor, ValueParameterDescriptor> getCalleeDescriptorAndParameter(BindingContext bindingContext, KtFunction argument) {
        KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent(argument);
        if (ktExpression == null) {
            return null;
        }
        KtExpression call2 = ktExpression;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(call2, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
        CallableDescriptor descriptor = callableDescriptor;
        Call call3 = resolvedCall3.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call3, (String)"getCall(...)");
        ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression(call3, argument);
        if (valueArgument == null) {
            return null;
        }
        ValueArgument valueArgument2 = valueArgument;
        ArgumentMapping argumentMapping2 = resolvedCall3.getArgumentMapping(valueArgument2);
        ArgumentMatch argumentMatch = argumentMapping2 instanceof ArgumentMatch ? (ArgumentMatch)argumentMapping2 : null;
        if (argumentMatch == null) {
            return null;
        }
        ArgumentMatch mapping = argumentMatch;
        ValueParameterDescriptor parameter = mapping.getValueParameter();
        return TuplesKt.to((Object)descriptor, (Object)parameter);
    }

    private final boolean isCrossinlineParameter(BindingContext bindingContext, KtFunction argument) {
        Object object = this.getCalleeDescriptorAndParameter(bindingContext, argument);
        return object != null && (object = (ValueParameterDescriptor)object.getSecond()) != null ? object.isCrossinline() : false;
    }
}

