/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.linkage.issues.SignatureClashDetector;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformerKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendErrors;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.JvmIrConflictingDeclarationsData;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMemberSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\n\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002J\u001e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J&\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J4\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001c2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/JvmMethodSignatureClashDetector;", "Lorg/jetbrains/kotlin/backend/common/linkage/issues/SignatureClashDetector;", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMemberSignature$Method;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "classCodegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;)V", "trackFakeOverrideMethod", "", "irFunction", "mapRawSignature", "getOverriddenFunctions", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "collectOverridesOf", "result", "", "collectOverridesTree", "visited", "isSpecialOverride", "", "reportErrorsTo", "diagnosticReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "reportSignatureConflict", "signature", "declarations", "", "reportPredefinedMethodSignatureConflicts", "reportJvmSignatureClash", "diagnosticFactory1", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;", "", "irDeclarations", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "conflictingJvmDeclarationsData", "Lorg/jetbrains/kotlin/backend/jvm/codegen/JvmIrConflictingDeclarationsData;", "Companion", "backend.jvm.codegen"})
@SourceDebugExtension(value={"SMAP\nJvmMethodSignatureClashDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmMethodSignatureClashDetector.kt\norg/jetbrains/kotlin/backend/jvm/codegen/JvmMethodSignatureClashDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1833#2,4:187\n1833#2,4:191\n1806#2,3:195\n776#2:198\n872#2,2:199\n776#2:201\n872#2,2:202\n*S KotlinDebug\n*F\n+ 1 JvmMethodSignatureClashDetector.kt\norg/jetbrains/kotlin/backend/jvm/codegen/JvmMethodSignatureClashDetector\n*L\n75#1:187,4\n76#1:191,4\n96#1:195,3\n112#1:198\n112#1:199,2\n121#1:201\n121#1:202,2\n*E\n"})
public final class JvmMethodSignatureClashDetector
extends SignatureClashDetector<JvmMemberSignature.Method, IrFunction> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassCodegen classCodegen;
    @NotNull
    private static final Set<IrDeclarationOriginImpl> SPECIAL_BRIDGES_AND_OVERRIDES;
    @NotNull
    private static final List<JvmMemberSignature.Method> PREDEFINED_SIGNATURES;

    public JvmMethodSignatureClashDetector(@NotNull ClassCodegen classCodegen) {
        Intrinsics.checkNotNullParameter((Object)classCodegen, (String)"classCodegen");
        this.classCodegen = classCodegen;
    }

    public final void trackFakeOverrideMethod(@NotNull IrFunction irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        if (irFunction.getDispatchReceiverParameter() != null) {
            for (IrFunction overriddenFunction : this.getOverriddenFunctions((IrSimpleFunction)irFunction)) {
                if (IrFakeOverrideUtilsKt.isFakeOverride(overriddenFunction)) continue;
                this.trackDeclaration((IrDeclaration)irFunction, this.mapRawSignature(overriddenFunction));
            }
        } else {
            this.trackDeclaration((IrDeclaration)irFunction, this.mapRawSignature(irFunction));
        }
    }

    private final JvmMemberSignature.Method mapRawSignature(IrFunction irFunction) {
        JvmMethodSignature jvmSignature = this.classCodegen.getMethodSignatureMapper().mapFakeOverrideSignatureSkipGeneric(irFunction);
        String string = jvmSignature.getAsmMethod().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = jvmSignature.getAsmMethod().getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescriptor(...)");
        return new JvmMemberSignature.Method(string, string2);
    }

    private final Set<IrFunction> getOverriddenFunctions(IrSimpleFunction irFunction) {
        LinkedHashSet result2 = new LinkedHashSet();
        this.collectOverridesOf(irFunction, result2);
        return result2;
    }

    private final void collectOverridesOf(IrSimpleFunction irFunction, Set<IrFunction> result2) {
        for (IrSimpleFunctionSymbol overriddenSymbol : irFunction.getOverriddenSymbols()) {
            this.collectOverridesTree((IrSimpleFunction)overriddenSymbol.getOwner(), result2);
        }
    }

    private final void collectOverridesTree(IrSimpleFunction irFunction, Set<IrFunction> visited2) {
        if (!visited2.add(irFunction)) {
            return;
        }
        this.collectOverridesOf(irFunction, visited2);
    }

    private final boolean isSpecialOverride(IrFunction $this$isSpecialOverride) {
        return CollectionsKt.contains((Iterable)SPECIAL_BRIDGES_AND_OVERRIDES, (Object)$this$isSpecialOverride.getOrigin());
    }

    @Override
    public void reportErrorsTo(@NotNull IrDiagnosticReporter diagnosticReporter) {
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        super.reportErrorsTo(diagnosticReporter);
        this.reportPredefinedMethodSignatureConflicts(diagnosticReporter);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void reportSignatureConflict(@NotNull JvmMemberSignature.Method signature, @NotNull Collection<? extends IrFunction> declarations2, @NotNull IrDiagnosticReporter diagnosticReporter) {
        block16: {
            Iterable $this$any$iv;
            JvmIrConflictingDeclarationsData conflictingJvmDeclarationsData;
            block17: {
                block18: {
                    boolean bl;
                    block14: {
                        int specialOverridesCount;
                        int fakeOverridesCount;
                        block15: {
                            int n2;
                            int n3;
                            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                            Intrinsics.checkNotNullParameter(declarations2, (String)"declarations");
                            Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
                            Iterable $this$count$iv = declarations2;
                            boolean $i$f$count = false;
                            if (((Collection)$this$count$iv).isEmpty()) {
                                n3 = 0;
                            } else {
                                int count$iv = 0;
                                for (Object element$iv : $this$count$iv) {
                                    IrFunction it = (IrFunction)element$iv;
                                    boolean bl2 = false;
                                    if (!IrFakeOverrideUtilsKt.isFakeOverride(it) || ++count$iv >= 0) continue;
                                    CollectionsKt.throwCountOverflow();
                                }
                                n3 = count$iv;
                            }
                            fakeOverridesCount = n3;
                            Iterable $this$count$iv2 = declarations2;
                            boolean $i$f$count2 = false;
                            if (((Collection)$this$count$iv2).isEmpty()) {
                                n2 = 0;
                            } else {
                                int count$iv = 0;
                                for (Object element$iv : $this$count$iv2) {
                                    IrFunction it = (IrFunction)element$iv;
                                    boolean bl3 = false;
                                    if (!this.isSpecialOverride(it) || ++count$iv >= 0) continue;
                                    CollectionsKt.throwCountOverflow();
                                }
                                n2 = count$iv;
                            }
                            specialOverridesCount = n2;
                            int realMethodsCount = declarations2.size() - fakeOverridesCount - specialOverridesCount;
                            conflictingJvmDeclarationsData = new JvmIrConflictingDeclarationsData(signature, declarations2);
                            if (realMethodsCount != 0 || fakeOverridesCount <= 1 && specialOverridesCount <= 1) break block15;
                            if (!Intrinsics.areEqual((Object)this.classCodegen.getIrClass().getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getDEFAULT_IMPLS())) {
                                this.reportJvmSignatureClash(diagnosticReporter, JvmBackendErrors.INSTANCE.getCONFLICTING_INHERITED_JVM_DECLARATIONS(), CollectionsKt.listOf((Object)this.classCodegen.getIrClass()), conflictingJvmDeclarationsData);
                            }
                            break block16;
                        }
                        if (fakeOverridesCount != 0 || specialOverridesCount != 0) break block17;
                        if (!Intrinsics.areEqual((Object)this.classCodegen.getIrClass().getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getDEFAULT_IMPLS())) break block18;
                        $this$any$iv = declarations2;
                        boolean $i$f$any = false;
                        if (((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                IrFunction it = (IrFunction)element$iv;
                                boolean bl4 = false;
                                if (!DescriptorVisibilities.isPrivate(it.getVisibility())) continue;
                                bl = true;
                                break block14;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block16;
                }
                this.reportJvmSignatureClash(diagnosticReporter, JvmBackendErrors.INSTANCE.getCONFLICTING_JVM_DECLARATIONS(), declarations2, conflictingJvmDeclarationsData);
                break block16;
            }
            if (!Intrinsics.areEqual((Object)this.classCodegen.getIrClass().getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getDEFAULT_IMPLS())) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Object element$iv;
                $this$any$iv = declarations2;
                KtDiagnosticFactory1<String> ktDiagnosticFactory1 = JvmBackendErrors.INSTANCE.getACCIDENTAL_OVERRIDE();
                IrDiagnosticReporter irDiagnosticReporter = diagnosticReporter;
                JvmMethodSignatureClashDetector jvmMethodSignatureClashDetector = this;
                boolean $i$f$filter = false;
                element$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    IrFunction it = (IrFunction)element$iv$iv;
                    boolean bl = false;
                    if (!(!IrFakeOverrideUtilsKt.isFakeOverride(it) && !this.isSpecialOverride(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                jvmMethodSignatureClashDetector.reportJvmSignatureClash(irDiagnosticReporter, ktDiagnosticFactory1, list, conflictingJvmDeclarationsData);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportPredefinedMethodSignatureConflicts(IrDiagnosticReporter diagnosticReporter) {
        for (JvmMemberSignature.Method predefinedSignature : PREDEFINED_SIGNATURES) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.declarationsWithSignature(predefinedSignature);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IrFunction it = (IrFunction)element$iv$iv;
                boolean bl = false;
                if (!(!IrFakeOverrideUtilsKt.isFakeOverride(it) && !this.isSpecialOverride(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List methods2 = (List)destination$iv$iv;
            if (methods2.isEmpty()) continue;
            this.reportJvmSignatureClash(diagnosticReporter, JvmBackendErrors.INSTANCE.getACCIDENTAL_OVERRIDE(), methods2, new JvmIrConflictingDeclarationsData(predefinedSignature, methods2));
        }
    }

    private final void reportJvmSignatureClash(IrDiagnosticReporter diagnosticReporter, KtDiagnosticFactory1<String> diagnosticFactory1, Collection<? extends IrDeclaration> irDeclarations, JvmIrConflictingDeclarationsData conflictingJvmDeclarationsData) {
        this.reportSignatureClashTo(diagnosticReporter, diagnosticFactory1, irDeclarations, conflictingJvmDeclarationsData.render(), arg_0 -> JvmMethodSignatureClashDetector.reportJvmSignatureClash$lambda$0(this, arg_0));
    }

    private static final IrElement reportJvmSignatureClash$lambda$0(JvmMethodSignatureClashDetector this$0, IrDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.classCodegen.getIrClass();
    }

    static {
        Object[] objectArray = new IrDeclarationOriginImpl[]{IrDeclarationOrigin.Companion.getBRIDGE(), IrDeclarationOrigin.Companion.getBRIDGE_SPECIAL(), IrDeclarationOrigin.Companion.getIR_BUILTINS_STUB(), JvmLoweredDeclarationOrigin.INSTANCE.getTO_ARRAY(), JvmLoweredDeclarationOrigin.INSTANCE.getSUPER_INTERFACE_METHOD_BRIDGE(), AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION()};
        SPECIAL_BRIDGES_AND_OVERRIDES = SetsKt.setOf((Object[])objectArray);
        objectArray = new JvmMemberSignature.Method[]{new JvmMemberSignature.Method("getClass", "()Ljava/lang/Class;"), new JvmMemberSignature.Method("notify", "()V"), new JvmMemberSignature.Method("notifyAll", "()V"), new JvmMemberSignature.Method("wait", "()V"), new JvmMemberSignature.Method("wait", "(J)V"), new JvmMemberSignature.Method("wait", "(JI)V")};
        PREDEFINED_SIGNATURES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/JvmMethodSignatureClashDetector$Companion;", "", "<init>", "()V", "SPECIAL_BRIDGES_AND_OVERRIDES", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "getSPECIAL_BRIDGES_AND_OVERRIDES", "()Ljava/util/Set;", "PREDEFINED_SIGNATURES", "", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMemberSignature$Method;", "getPREDEFINED_SIGNATURES", "()Ljava/util/List;", "backend.jvm.codegen"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<IrDeclarationOriginImpl> getSPECIAL_BRIDGES_AND_OVERRIDES() {
            return SPECIAL_BRIDGES_AND_OVERRIDES;
        }

        @NotNull
        public final List<JvmMemberSignature.Method> getPREDEFINED_SIGNATURES() {
            return PREDEFINED_SIGNATURES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

