/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.EnumClassLowering$EnumClassTransformer$run$;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBodyKind;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@PhaseDescription(name="EnumClass")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "EnumClassTransformer", "backend.jvm.lower"})
public final class EnumClassLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public EnumClassLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        if (!IrUtilsKt.isEnumClass(irClass)) {
            return;
        }
        new EnumClassTransformer(irClass, this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.EnumEntries)).run();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0002()B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0011H\u0002J\b\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020#H\u0002J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\tj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\tj\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00110\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\u00020\u0005*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001d\u001a\u00020\u0005*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "supportsEnumEntries", "", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Z)V", "loweredEnumConstructors", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "Lkotlin/collections/HashMap;", "loweredEnumConstructorParameters", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "enumEntryOrdinals", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "", "declarationToEnumEntry", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "enumArrayType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "run", "", "hasGetEntriesFunction", "getHasGetEntriesFunction", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "isGetEntriesFunction", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Z", "buildEnumEntryField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "enumEntry", "buildValuesHelperFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "buildValuesField", "valuesHelperFunction", "buildEntriesField", "valuesField", "EnumClassDeclarationsTransformer", "EnumClassCallTransformer", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nEnumClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 6 IrArrayBuilder.kt\norg/jetbrains/kotlin/backend/jvm/ir/IrArrayBuilderKt\n*L\n1#1,319:1\n478#2:320\n1341#2:321\n1342#2:323\n1#3:322\n1#3:340\n1806#4,3:324\n811#4,12:341\n281#5:327\n275#5:328\n269#5,10:329\n81#5:353\n75#5,10:354\n81#5:364\n75#5,10:365\n20#6:339\n*S KotlinDebug\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer\n*L\n96#1:320\n96#1:321\n96#1:323\n152#1:340\n132#1:324,3\n153#1:341,12\n145#1:327\n145#1:328\n145#1:329,10\n160#1:353\n160#1:354,10\n175#1:364\n175#1:365,10\n152#1:339\n*E\n"})
    private final class EnumClassTransformer {
        @NotNull
        private final IrClass irClass;
        private final boolean supportsEnumEntries;
        @NotNull
        private final HashMap<IrConstructorSymbol, IrConstructor> loweredEnumConstructors;
        @NotNull
        private final HashMap<IrValueParameterSymbol, IrValueParameter> loweredEnumConstructorParameters;
        @NotNull
        private final HashMap<IrEnumEntry, Integer> enumEntryOrdinals;
        @NotNull
        private final Map<IrDeclaration, IrEnumEntry> declarationToEnumEntry;
        @NotNull
        private final IrSimpleType enumArrayType;

        public EnumClassTransformer(IrClass irClass, boolean supportsEnumEntries) {
            Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
            this.irClass = irClass;
            this.supportsEnumEntries = supportsEnumEntries;
            this.loweredEnumConstructors = new HashMap();
            this.loweredEnumConstructorParameters = new HashMap();
            this.enumEntryOrdinals = new HashMap();
            this.declarationToEnumEntry = new LinkedHashMap();
            IrType[] irTypeArray = new IrType[]{IrUtilsKt.getDefaultType(this.irClass)};
            this.enumArrayType = IrTypesKt.typeWith((IrClassifierSymbol)EnumClassLowering.this.context.getIrBuiltIns().getArrayClass(), irTypeArray);
        }

        public final void run() {
            IrField irField;
            Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)this.irClass.getDeclarations());
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)EnumClassTransformer$run$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$forEach$iv = SequencesKt.withIndex((Sequence)sequence2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IndexedValue indexedValue = (IndexedValue)element$iv;
                boolean bl = false;
                int index = indexedValue.component1();
                IrEnumEntry enumEntry = (IrEnumEntry)indexedValue.component2();
                ((Map)this.enumEntryOrdinals).put(enumEntry, index);
                if (enumEntry.getCorrespondingClass() != null) {
                    IrClass entryClass;
                    boolean bl2 = false;
                    this.declarationToEnumEntry.put(entryClass, enumEntry);
                }
                this.declarationToEnumEntry.put(this.buildEnumEntryField(enumEntry), enumEntry);
            }
            CollectionsKt.removeAll(this.irClass.getDeclarations(), EnumClassTransformer::run$lambda$1);
            CollectionsKt.addAll((Collection)this.irClass.getDeclarations(), (Iterable)this.declarationToEnumEntry.keySet());
            IrFunction valuesHelperFunction = this.buildValuesHelperFunction();
            IrField valuesField = this.buildValuesField(valuesHelperFunction);
            if (!this.getHasGetEntriesFunction(this.irClass)) {
                irField = null;
            } else {
                if (!this.supportsEnumEntries) {
                    throw new IllegalStateException("The frontend must have checked if the feature is supported while emitting the IR".toString());
                }
                irField = this.buildEntriesField(valuesField);
            }
            IrField entriesField = irField;
            IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, new EnumClassDeclarationsTransformer(valuesField, entriesField));
            IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, new EnumClassCallTransformer());
        }

        private final boolean getHasGetEntriesFunction(IrClass $this$hasGetEntriesFunction) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = $this$hasGetEntriesFunction.getDeclarations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrDeclaration it = (IrDeclaration)element$iv;
                        boolean bl2 = false;
                        if (!this.isGetEntriesFunction(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean isGetEntriesFunction(IrDeclaration $this$isGetEntriesFunction) {
            return $this$isGetEntriesFunction instanceof IrFunction && Intrinsics.areEqual((Object)((IrFunction)$this$isGetEntriesFunction).getName(), (Object)SpecialNames.ENUM_GET_ENTRIES) && Intrinsics.areEqual((Object)$this$isGetEntriesFunction.getOrigin(), (Object)IrDeclarationOrigin.Companion.getENUM_CLASS_SPECIAL_MEMBER());
        }

        /*
         * WARNING - void declaration
         */
        private final IrField buildEnumEntryField(IrEnumEntry enumEntry) {
            IrExpressionBody irExpressionBody;
            IrField irField = EnumClassLowering.this.context.getCachedDeclarations().getFieldForEnumEntry(enumEntry);
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            IrField $this$buildEnumEntryField_u24lambda_u240 = irField;
            boolean bl = false;
            IrField irField2 = $this$buildEnumEntryField_u24lambda_u240;
            IrExpressionBody irExpressionBody2 = enumEntry.getInitializerExpression();
            if (irExpressionBody2 != null) {
                void it;
                IrExpressionBody irExpressionBody3 = irExpressionBody2;
                IrField irField3 = irField2;
                boolean bl2 = false;
                irExpressionBody = IrFactoryHelpersKt.createExpressionBody(enumClassLowering.context.getIrFactory(), (IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)it.getExpression(), $this$buildEnumEntryField_u24lambda_u240));
                irField2 = irField3;
            } else {
                irExpressionBody = null;
            }
            irField2.setInitializer(irExpressionBody);
            $this$buildEnumEntryField_u24lambda_u240.setAnnotations(CollectionsKt.plus((Collection)$this$buildEnumEntryField_u24lambda_u240.getAnnotations(), (Iterable)enumEntry.getAnnotations()));
            return irField;
        }

        /*
         * WARNING - void declaration
         */
        private final IrFunction buildValuesHelperFunction() {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$irArray$iv;
            IrArrayBuilder irArrayBuilder;
            void $this$buildValuesHelperFunction_u24lambda_u241_u240;
            IrSimpleFunction irSimpleFunction;
            void $this$addFunction$iv$iv;
            IrClass $this$addFunction$iv = this.irClass;
            boolean $i$f$addFunction = false;
            IrFactory irFactory = $this$addFunction$iv.getFactory();
            IrDeclarationContainer klass$iv$iv = $this$addFunction$iv;
            boolean $i$f$addFunction22 = false;
            void $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u240$iv$iv$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$buildValuesHelperFunction_u24lambda_u240 = $this$buildFun_u24lambda_u240$iv$iv$iv;
            boolean bl2 = false;
            Name name2 = Name.identifier("$values");
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            $this$buildValuesHelperFunction_u24lambda_u240.setName(name2);
            $this$buildValuesHelperFunction_u24lambda_u240.setReturnType(this.enumArrayType);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
            $this$buildValuesHelperFunction_u24lambda_u240.setVisibility(descriptorVisibility);
            $this$buildValuesHelperFunction_u24lambda_u240.setOrigin(IrDeclarationOrigin.Companion.getSYNTHETIC_HELPER_FOR_ENUM_VALUES());
            IrSimpleFunction function$iv$iv = irSimpleFunction = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u240$iv$iv$iv);
            boolean $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = false;
            klass$iv$iv.getDeclarations().add(function$iv$iv);
            function$iv$iv.setParent(klass$iv$iv);
            IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            IrSimpleFunction $this$buildValuesHelperFunction_u24lambda_u241 = irSimpleFunction2;
            boolean bl3 = false;
            JvmIrBuilder $i$f$addFunction22 = JvmIrBuilderKt.createJvmIrBuilder$default(enumClassLowering.context, $this$buildValuesHelperFunction_u24lambda_u241.getSymbol(), 0, 0, 6, null);
            irSimpleFunction = $this$buildValuesHelperFunction_u24lambda_u241;
            boolean bl4 = false;
            void $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = $this$buildValuesHelperFunction_u24lambda_u241_u240;
            IrType arrayType$iv = $this$buildValuesHelperFunction_u24lambda_u241.getReturnType();
            boolean $i$f$irArray = false;
            IrArrayBuilder $this$irArray_u24lambda_u240$iv = irArrayBuilder = new IrArrayBuilder((JvmIrBuilder)$this$irArray$iv, arrayType$iv);
            boolean bl5 = false;
            IrArrayBuilder irArrayBuilder2 = $this$irArray_u24lambda_u240$iv;
            IrBuilder irBuilder = (IrBuilder)$this$buildValuesHelperFunction_u24lambda_u241_u240;
            boolean bl6 = false;
            Iterable $this$filterIsInstance$iv = this.declarationToEnumEntry.keySet();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrField)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (IrField irField : (List)destination$iv$iv) {
                void $this$buildValuesHelperFunction_u24lambda_u241_u240_u240;
                $this$buildValuesHelperFunction_u24lambda_u241_u240_u240.unaryPlus(ExpressionHelpersKt.irGetField$default((IrBuilder)$this$buildValuesHelperFunction_u24lambda_u241_u240, null, irField, null, 4, null));
            }
            irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilder, irArrayBuilder.build()));
            return irSimpleFunction2;
        }

        /*
         * WARNING - void declaration
         */
        private final IrField buildValuesField(IrFunction valuesHelperFunction) {
            void $this$buildValuesField_u24lambda_u241_u240;
            IrClass $this$addField$iv = this.irClass;
            boolean $i$f$addField = false;
            Object $this$buildField$iv$iv = $this$addField$iv.getFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u241$iv$iv = new IrFieldBuilder();
            boolean bl = false;
            IrFieldBuilder $this$buildValuesField_u24lambda_u240 = $this$buildField_u24lambda_u241$iv$iv;
            boolean bl2 = false;
            Name name2 = Name.identifier("$VALUES");
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            $this$buildValuesField_u24lambda_u240.setName(name2);
            $this$buildValuesField_u24lambda_u240.setType(this.enumArrayType);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
            $this$buildValuesField_u24lambda_u240.setVisibility(descriptorVisibility);
            $this$buildValuesField_u24lambda_u240.setOrigin(IrDeclarationOrigin.Companion.getFIELD_FOR_ENUM_VALUES());
            $this$buildValuesField_u24lambda_u240.setFinal(true);
            $this$buildValuesField_u24lambda_u240.setStatic(true);
            Object field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, $this$buildField_u24lambda_u241$iv$iv);
            boolean $i$a$-also-DeclarationBuildersKt$addField$1$iv22 = false;
            ((IrDeclarationBase)field$iv).setParent($this$addField$iv);
            $this$addField$iv.getDeclarations().add((IrDeclaration)field$iv);
            Object object = $this$buildField$iv$iv;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            Object $this$buildValuesField_u24lambda_u241 = object;
            boolean bl3 = false;
            JvmIrBuilder $i$a$-also-DeclarationBuildersKt$addField$1$iv22 = JvmIrBuilderKt.createJvmIrBuilder$default(enumClassLowering.context, ((IrField)$this$buildValuesField_u24lambda_u241).getSymbol(), 0, 0, 6, null);
            Object object2 = $this$buildValuesField_u24lambda_u241;
            boolean bl4 = false;
            ((IrField)object2).setInitializer(ExpressionHelpersKt.irExprBody((IrBuilder)$this$buildValuesField_u24lambda_u241_u240, ExpressionHelpersKt.irCall((IrBuilder)$this$buildValuesField_u24lambda_u241_u240, valuesHelperFunction.getSymbol())));
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final IrField buildEntriesField(IrField valuesField) {
            void $this$buildEntriesField_u24lambda_u241_u240_u240;
            void $this$buildEntriesField_u24lambda_u241_u240;
            IrCall irCall;
            void $this$addField$iv;
            Object object = this.irClass;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            boolean $i$f$addField = false;
            Object $this$buildField$iv$iv = $this$addField$iv.getFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u241$iv$iv = new IrFieldBuilder();
            boolean bl = false;
            IrFieldBuilder $this$buildEntriesField_u24lambda_u240 = $this$buildField_u24lambda_u241$iv$iv;
            boolean $i$a$-addField-EnumClassLowering$EnumClassTransformer$buildEntriesField$22 = false;
            Name name2 = Name.identifier("$ENTRIES");
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            $this$buildEntriesField_u24lambda_u240.setName(name2);
            $this$buildEntriesField_u24lambda_u240.setType(IrTypesKt.getDefaultType(enumClassLowering.context.getSymbols().getEnumEntries()));
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
            $this$buildEntriesField_u24lambda_u240.setVisibility(descriptorVisibility);
            $this$buildEntriesField_u24lambda_u240.setOrigin(IrDeclarationOrigin.Companion.getFIELD_FOR_ENUM_ENTRIES());
            $this$buildEntriesField_u24lambda_u240.setFinal(true);
            $this$buildEntriesField_u24lambda_u240.setStatic(true);
            Object field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, $this$buildField_u24lambda_u241$iv$iv);
            boolean bl2 = false;
            ((IrDeclarationBase)field$iv).setParent((IrDeclarationParent)$this$addField$iv);
            $this$addField$iv.getDeclarations().add((IrDeclaration)field$iv);
            object = $this$buildField$iv$iv;
            enumClassLowering = EnumClassLowering.this;
            Object $this$buildEntriesField_u24lambda_u241 = object;
            boolean bl3 = false;
            field$iv = JvmIrBuilderKt.createJvmIrBuilder$default(enumClassLowering.context, ((IrField)$this$buildEntriesField_u24lambda_u241).getSymbol(), 0, 0, 6, null);
            Object object2 = $this$buildEntriesField_u24lambda_u241;
            boolean bl4 = false;
            IrCall $i$a$-addField-EnumClassLowering$EnumClassTransformer$buildEntriesField$22 = irCall = ExpressionHelpersKt.irCall((IrBuilder)$this$buildEntriesField_u24lambda_u241_u240, enumClassLowering.context.getSymbols().getCreateEnumEntries());
            IrBuilder irBuilder = (IrBuilder)$this$buildEntriesField_u24lambda_u241_u240;
            boolean bl5 = false;
            $this$buildEntriesField_u24lambda_u241_u240_u240.getArguments().set(0, ExpressionHelpersKt.irGetField$default((IrBuilder)$this$buildEntriesField_u24lambda_u241_u240, null, valuesField, null, 4, null));
            ((IrField)object2).setInitializer(ExpressionHelpersKt.irExprBody(irBuilder, irCall));
            return object;
        }

        private static final boolean run$lambda$1(IrDeclaration it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof IrEnumEntry;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassCallTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;)V", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "passConstructorArguments", "", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "original", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "backend.jvm.lower"})
        @SourceDebugExtension(value={"SMAP\nEnumClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassCallTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,319:1\n1#2:320\n*E\n"})
        private final class EnumClassCallTransformer
        extends IrElementTransformerVoidWithContext {
            @Override
            @NotNull
            public IrStatement visitClassNew(@NotNull IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                return IrUtilsKt.isEnumEntry(declaration) ? super.visitClassNew(declaration) : (IrStatement)declaration;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementBase irElementBase = (IrValueParameter)((Map)EnumClassTransformer.this.loweredEnumConstructorParameters).get(expression2.getSymbol());
                if (irElementBase != null) {
                    IrValueParameter it = irElementBase;
                    boolean bl = false;
                    IrGetValueImpl irGetValueImpl = BuildersKt.IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), expression2.getOrigin());
                    irElementBase = irGetValueImpl;
                    if (irGetValueImpl != null) {
                        irExpression = (IrExpression)irElementBase;
                        return irExpression;
                    }
                }
                irExpression = expression2;
                return irExpression;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.transformChildrenVoid(expression2);
                IrElementBase irElementBase = (IrValueParameter)((Map)EnumClassTransformer.this.loweredEnumConstructorParameters).get(expression2.getSymbol());
                if (irElementBase != null) {
                    IrValueParameter it = irElementBase;
                    boolean bl = false;
                    IrSetValueImpl irSetValueImpl = BuildersKt.IrSetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), expression2.getValue(), expression2.getOrigin());
                    irElementBase = irSetValueImpl;
                    if (irSetValueImpl != null) {
                        irExpression = (IrExpression)irElementBase;
                        return irExpression;
                    }
                }
                irExpression = expression2;
                return irExpression;
            }

            @Override
            @NotNull
            public IrExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrFunctionAccessExpression irFunctionAccessExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)scopeWithIr);
                IrSymbol scopeOwnerSymbol = scopeWithIr.getScope().getScopeOwnerSymbol();
                IrBuilder irBuilder = LowerUtilsKt.at((IrBuilder)LowerUtilsKt.createIrBuilder$default(EnumClassLowering.this.context, scopeOwnerSymbol, 0, 0, 6, null), expression2);
                EnumClassTransformer enumClassTransformer = EnumClassTransformer.this;
                DeclarationIrBuilder $this$visitEnumConstructorCall_u24lambda_u240 = (DeclarationIrBuilder)irBuilder;
                boolean bl = false;
                IrConstructor irConstructor = (IrConstructor)enumClassTransformer.loweredEnumConstructors.get(expression2.getSymbol());
                if (irConstructor == null) {
                    irConstructor = (IrConstructor)expression2.getSymbol().getOwner();
                }
                IrConstructor constructor = irConstructor;
                IrFunctionAccessExpression it = irFunctionAccessExpression = scopeOwnerSymbol instanceof IrConstructorSymbol ? (IrFunctionAccessExpression)ExpressionHelpersKt.irDelegatingConstructorCall($this$visitEnumConstructorCall_u24lambda_u240, constructor) : ExpressionHelpersKt.irCall((IrBuilder)$this$visitEnumConstructorCall_u24lambda_u240, constructor);
                boolean bl2 = false;
                IrBuilderWithScope irBuilderWithScope = $this$visitEnumConstructorCall_u24lambda_u240;
                IrFunctionAccessExpression irFunctionAccessExpression2 = expression2;
                Map map = enumClassTransformer.declarationToEnumEntry;
                IrSymbolOwner irSymbolOwner = scopeOwnerSymbol.getOwner();
                Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
                this.passConstructorArguments(irBuilderWithScope, it, irFunctionAccessExpression2, (IrEnumEntry)map.get((IrDeclaration)irSymbolOwner));
                return irFunctionAccessExpression;
            }

            @Override
            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrDelegatingConstructorCall irDelegatingConstructorCall;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrConstructor irConstructor = (IrConstructor)EnumClassTransformer.this.loweredEnumConstructors.get(expression2.getSymbol());
                if (irConstructor == null) {
                    return expression2;
                }
                IrConstructor replacement = irConstructor;
                LoweringContext loweringContext = EnumClassLowering.this.context;
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)scopeWithIr);
                DeclarationIrBuilder $this$visitDelegatingConstructorCall_u24lambda_u240 = (DeclarationIrBuilder)LowerUtilsKt.at((IrBuilder)LowerUtilsKt.createIrBuilder$default(loweringContext, scopeWithIr.getScope().getScopeOwnerSymbol(), 0, 0, 6, null), expression2);
                boolean bl = false;
                IrDelegatingConstructorCall it = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall($this$visitDelegatingConstructorCall_u24lambda_u240, replacement);
                boolean bl2 = false;
                EnumClassCallTransformer.passConstructorArguments$default(this, $this$visitDelegatingConstructorCall_u24lambda_u240, it, expression2, null, 4, null);
                return irDelegatingConstructorCall;
            }

            private final void passConstructorArguments(IrBuilderWithScope $this$passConstructorArguments, IrFunctionAccessExpression call2, IrFunctionAccessExpression original, IrEnumEntry enumEntry) {
                IrExpressionsKt.copyTypeArgumentsFrom$default(call2, original, 0, 2, null);
                if (enumEntry != null) {
                    IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = call2.getArguments();
                    IrBuilder irBuilder = $this$passConstructorArguments;
                    String string = enumEntry.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    valueArgumentsList.set(0, ExpressionHelpersKt.irString(irBuilder, string));
                    IrMemberAccessExpression.ValueArgumentsList valueArgumentsList2 = call2.getArguments();
                    IrBuilder irBuilder2 = $this$passConstructorArguments;
                    Object v2 = EnumClassTransformer.this.enumEntryOrdinals.get(enumEntry);
                    Intrinsics.checkNotNull(v2);
                    valueArgumentsList2.set(1, ExpressionHelpersKt.irInt$default(irBuilder2, ((Number)v2).intValue(), null, 2, null));
                } else {
                    ScopeWithIr scopeWithIr = this.getCurrentScope();
                    Intrinsics.checkNotNull((Object)scopeWithIr);
                    IrSymbol irSymbol = scopeWithIr.getScope().getScopeOwnerSymbol();
                    Intrinsics.checkNotNull((Object)irSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol");
                    IrConstructorSymbol constructor = (IrConstructorSymbol)irSymbol;
                    call2.getArguments().set(0, ExpressionHelpersKt.irGet($this$passConstructorArguments, ((IrConstructor)constructor.getOwner()).getParameters().get(0)));
                    call2.getArguments().set(1, ExpressionHelpersKt.irGet($this$passConstructorArguments, ((IrConstructor)constructor.getOwner()).getParameters().get(1)));
                }
                Iterator iterator2 = ((Iterable)original.getArguments()).iterator();
                int n2 = 0;
                while (iterator2.hasNext()) {
                    int index = n2++;
                    IrExpression argument = (IrExpression)iterator2.next();
                    if (argument == null) continue;
                    call2.getArguments().set(index + 2, argument);
                }
            }

            static /* synthetic */ void passConstructorArguments$default(EnumClassCallTransformer enumClassCallTransformer, IrBuilderWithScope irBuilderWithScope, IrFunctionAccessExpression irFunctionAccessExpression, IrFunctionAccessExpression irFunctionAccessExpression2, IrEnumEntry irEnumEntry, int n2, Object object) {
                if ((n2 & 4) != 0) {
                    irEnumEntry = null;
                }
                enumClassCallTransformer.passConstructorArguments(irBuilderWithScope, irFunctionAccessExpression, irFunctionAccessExpression2, irEnumEntry);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "valuesField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "entriesField", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;Lorg/jetbrains/kotlin/ir/declarations/IrField;Lorg/jetbrains/kotlin/ir/declarations/IrField;)V", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "backend.jvm.lower"})
        @SourceDebugExtension(value={"SMAP\nEnumClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,319:1\n315#2,4:320\n1585#3:324\n1660#3,3:325\n*S KotlinDebug\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer\n*L\n200#1:320,4\n213#1:324\n213#1:325,3\n*E\n"})
        private final class EnumClassDeclarationsTransformer
        extends IrElementTransformerVoid {
            @NotNull
            private final IrField valuesField;
            @Nullable
            private final IrField entriesField;

            public EnumClassDeclarationsTransformer(@Nullable IrField valuesField, IrField entriesField) {
                Intrinsics.checkNotNullParameter((Object)valuesField, (String)"valuesField");
                this.valuesField = valuesField;
                this.entriesField = entriesField;
            }

            @Override
            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                return IrUtilsKt.isEnumEntry(declaration) ? super.visitClass(declaration) : (IrStatement)declaration;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public IrStatement visitConstructor(@NotNull IrConstructor declaration) {
                Collection<IrValueParameter> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrFactory $this$buildConstructor$iv = EnumClassLowering.this.context.getIrFactory();
                boolean $i$f$buildConstructor = false;
                IrFunctionBuilder $this$buildConstructor_u24lambda_u241$iv = new IrFunctionBuilder();
                boolean bl = false;
                IrFunctionBuilder $this$visitConstructor_u24lambda_u240 = $this$buildConstructor_u24lambda_u241$iv;
                boolean $i$a$-buildConstructor-EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer$visitConstructor$22 = false;
                $this$visitConstructor_u24lambda_u240.updateFrom(declaration);
                $this$visitConstructor_u24lambda_u240.setReturnType(declaration.getReturnType());
                IrConstructor irConstructor = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv, $this$buildConstructor_u24lambda_u241$iv);
                EnumClassLowering enumClassLowering = EnumClassLowering.this;
                EnumClassTransformer enumClassTransformer = EnumClassTransformer.this;
                IrConstructor $this$visitConstructor_u24lambda_u241 = irConstructor;
                boolean bl2 = false;
                $this$visitConstructor_u24lambda_u241.setParent(declaration.getParent());
                $this$visitConstructor_u24lambda_u241.setAnnotations(declaration.getAnnotations());
                DeclarationBuildersKt.addValueParameter((IrFunction)$this$visitConstructor_u24lambda_u241, "$enum$name", enumClassLowering.context.getIrBuiltIns().getStringType(), (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getENUM_CONSTRUCTOR_SYNTHETIC_PARAMETER());
                DeclarationBuildersKt.addValueParameter((IrFunction)$this$visitConstructor_u24lambda_u241, "$enum$ordinal", enumClassLowering.context.getIrBuiltIns().getIntType(), (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getENUM_CONSTRUCTOR_SYNTHETIC_PARAMETER());
                Iterable $i$a$-buildConstructor-EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer$visitConstructor$22 = declaration.getParameters();
                Collection collection2 = $this$visitConstructor_u24lambda_u241.getParameters();
                IrConstructor irConstructor2 = $this$visitConstructor_u24lambda_u241;
                boolean $i$f$map = false;
                void var11_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void param;
                    IrValueParameter irValueParameter;
                    IrValueParameter irValueParameter2 = (IrValueParameter)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    IrValueParameter newParam = irValueParameter = IrUtilsKt.copyTo$default((IrValueParameter)param, $this$visitConstructor_u24lambda_u241, null, 0, 0, null, null, null, null, null, false, false, false, null, null, 16382, null);
                    boolean bl4 = false;
                    ((Map)enumClassTransformer.loweredEnumConstructorParameters).put(param.getSymbol(), newParam);
                    collection.add(irValueParameter);
                }
                collection = (List)destination$iv$iv;
                irConstructor2.setParameters(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
                IrBody irBody = declaration.getBody();
                $this$visitConstructor_u24lambda_u241.setBody(irBody != null ? (IrBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irBody, $this$visitConstructor_u24lambda_u241) : null);
                ((Map)enumClassTransformer.loweredEnumConstructors).put(declaration.getSymbol(), $this$visitConstructor_u24lambda_u241);
                $this$visitConstructor_u24lambda_u241.setMetadata(declaration.getMetadata());
                return irConstructor;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
                IrDeclarationReference irDeclarationReference;
                void $this$visitSimpleFunction_u24lambda_u240;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Object object = declaration.getBody();
                IrSyntheticBody irSyntheticBody = object instanceof IrSyntheticBody ? (IrSyntheticBody)object : null;
                if (irSyntheticBody == null) {
                    return declaration;
                }
                IrSyntheticBody body = irSyntheticBody;
                JvmIrBuilder jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder$default(EnumClassLowering.this.context, declaration.getSymbol(), 0, 0, 6, null);
                object = EnumClassLowering.this;
                EnumClassTransformer enumClassTransformer = EnumClassTransformer.this;
                JvmIrBuilder jvmIrBuilder2 = jvmIrBuilder;
                IrSimpleFunction irSimpleFunction = declaration;
                boolean bl = false;
                IrBuilder irBuilder = (IrBuilder)$this$visitSimpleFunction_u24lambda_u240;
                switch (WhenMappings.$EnumSwitchMapping$0[body.getKind().ordinal()]) {
                    case 1: {
                        void $this$visitSimpleFunction_u24lambda_u240_u240;
                        IrCall irCall;
                        IrCall irCall2 = irCall = ExpressionHelpersKt.irCall$default((IrBuilder)$this$visitSimpleFunction_u24lambda_u240, ((EnumClassLowering)object).context.getSymbols().getObjectCloneFunction(), declaration.getReturnType(), 0, null, 12, null);
                        IrBuilder irBuilder2 = irBuilder;
                        boolean bl2 = false;
                        $this$visitSimpleFunction_u24lambda_u240_u240.setDispatchReceiver(ExpressionHelpersKt.irGetField$default((IrBuilder)$this$visitSimpleFunction_u24lambda_u240, null, this.valuesField, null, 4, null));
                        irBuilder = irBuilder2;
                        irDeclarationReference = irCall;
                        break;
                    }
                    case 2: {
                        void $this$visitSimpleFunction_u24lambda_u240_u241;
                        IrCall irCall;
                        IrCall $this$visitSimpleFunction_u24lambda_u240_u240 = irCall = ExpressionHelpersKt.irCall((IrBuilder)$this$visitSimpleFunction_u24lambda_u240, $this$visitSimpleFunction_u24lambda_u240.getBackendContext().getSymbols().getEnumValueOfFunction());
                        IrBuilder irBuilder3 = irBuilder;
                        boolean bl3 = false;
                        $this$visitSimpleFunction_u24lambda_u240_u241.getArguments().set(0, JvmIrUtilsKt.javaClassReference((JvmIrBuilder)$this$visitSimpleFunction_u24lambda_u240, IrUtilsKt.getDefaultType(enumClassTransformer.irClass)));
                        $this$visitSimpleFunction_u24lambda_u240_u241.getArguments().set(1, ExpressionHelpersKt.irGet((IrBuilder)$this$visitSimpleFunction_u24lambda_u240, declaration.getParameters().get(0)));
                        irBuilder = irBuilder3;
                        irDeclarationReference = irCall;
                        break;
                    }
                    case 3: {
                        IrBuilder irBuilder4 = (IrBuilder)$this$visitSimpleFunction_u24lambda_u240;
                        IrField irField = this.entriesField;
                        Intrinsics.checkNotNull((Object)irField);
                        irDeclarationReference = ExpressionHelpersKt.irGetField$default(irBuilder4, null, irField, null, 4, null);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilder, irDeclarationReference));
                return declaration;
            }

            @Metadata(mv={2, 3, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[IrSyntheticBodyKind.values().length];
                    try {
                        nArray[IrSyntheticBodyKind.ENUM_VALUES.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[IrSyntheticBodyKind.ENUM_VALUEOF.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[IrSyntheticBodyKind.ENUM_ENTRIES.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }
}

