/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@PhaseDescription(name="RenameFields")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/RenameFieldsLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nRenameFieldsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameFieldsLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/RenameFieldsLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1020#2,2:50\n*S KotlinDebug\n*F\n+ 1 RenameFieldsLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/RenameFieldsLowering\n*L\n22#1:50,2\n*E\n"})
public final class RenameFieldsLowering
implements ClassLoweringPass {
    public RenameFieldsLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
    }

    @Override
    public void lower(@NotNull IrClass irClass) {
        List fields2;
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        List $this$sortBy$iv = fields2 = SequencesKt.toMutableList(IrUtilsKt.getFields(irClass));
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    IrField it = (IrField)a2;
                    boolean bl = false;
                    int n2 = it.getVisibility().isPublicAPI() ? 0 : (it.isStatic() ? 1 : 2);
                    it = (IrField)b2;
                    Comparable comparable = Integer.valueOf(n2);
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.getVisibility().isPublicAPI() ? 0 : (it.isStatic() ? 1 : 2)));
                }
            });
        }
        HashMap count = new HashMap();
        for (IrField field : fields2) {
            int index;
            Name oldName = field.getName();
            Integer n2 = (Integer)count.get(oldName);
            int n3 = index = n2 != null ? n2 : 0;
            if (index != 0 && !field.getVisibility().isPublicAPI()) {
                Name name2 = Name.identifier("" + oldName + '$' + index);
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                field.setName(name2);
            }
            ((Map)count).put(oldName, index + 1);
        }
    }
}

