/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.output;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.output.NoPermissionException;
import org.jetbrains.kotlin.incremental.components.ICFileMappingTracker;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aL\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u000428\u0010\u0005\u001a4\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006\u001a\u0012\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a,\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a8\u0006\u0013"}, d2={"writeAll", "", "Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "outputDir", "Ljava/io/File;", "report", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/backend/common/output/OutputFile;", "Lkotlin/ParameterName;", "name", "outputInfo", "output", "writeAllTo", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "reportOutputFiles", "", "fileMappingTracker", "Lorg/jetbrains/kotlin/incremental/components/ICFileMappingTracker;", "cli"})
@SourceDebugExtension(value={"SMAP\noutputUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 outputUtils.kt\norg/jetbrains/kotlin/cli/common/output/OutputUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n2791#2,3:84\n*S KotlinDebug\n*F\n+ 1 outputUtils.kt\norg/jetbrains/kotlin/cli/common/output/OutputUtilsKt\n*L\n64#1:84,3\n*E\n"})
public final class OutputUtilsKt {
    public static final void writeAll(@NotNull OutputFileCollection $this$writeAll, @NotNull File outputDir, @Nullable Function2<? super OutputFile, ? super File, Unit> report2) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        for (OutputFile file : $this$writeAll.asList()) {
            File output2 = new File(outputDir, file.getRelativePath());
            Function2<? super OutputFile, ? super File, Unit> function2 = report2;
            if (function2 != null) {
                function2.invoke((Object)file, (Object)output2);
            }
            try {
                FileUtil.writeToFile(output2, file.asByteArray());
            }
            catch (FileNotFoundException e2) {
                if (outputDir.isDirectory()) {
                    throw new NoPermissionException("error while writing " + output2 + " (Permission denied)", e2);
                }
                throw e2;
            }
        }
    }

    public static final void writeAllTo(@NotNull OutputFileCollection $this$writeAllTo, @NotNull File outputDir) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAllTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        OutputUtilsKt.writeAll($this$writeAllTo, outputDir, null);
    }

    public static final void writeAll(@NotNull OutputFileCollection $this$writeAll, @NotNull File outputDir, @NotNull MessageCollector messageCollector, boolean reportOutputFiles, @Nullable ICFileMappingTracker fileMappingTracker) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        try {
            if (!reportOutputFiles && fileMappingTracker == null) {
                OutputUtilsKt.writeAllTo($this$writeAll, outputDir);
            } else {
                OutputUtilsKt.writeAll($this$writeAll, outputDir, (Function2<? super OutputFile, ? super File, Unit>)((Function2)(arg_0, arg_1) -> OutputUtilsKt.writeAll$lambda$0(fileMappingTracker, reportOutputFiles, messageCollector, arg_0, arg_1)));
            }
        }
        catch (NoPermissionException e2) {
            String string = e2.getMessage();
            Intrinsics.checkNotNull((Object)string);
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, string, null, 4, null);
        }
        catch (FileNotFoundException e3) {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "directory not found: " + outputDir, null, 4, null);
        }
    }

    private static final CharSequence writeAll$lambda$0$0$1$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    private static final Unit writeAll$lambda$0(ICFileMappingTracker $fileMappingTracker, boolean $reportOutputFiles, MessageCollector $messageCollector, OutputFile outputInfo, File output2) {
        Intrinsics.checkNotNullParameter((Object)outputInfo, (String)"outputInfo");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        ICFileMappingTracker iCFileMappingTracker = $fileMappingTracker;
        if (iCFileMappingTracker != null) {
            ICFileMappingTracker tracker = iCFileMappingTracker;
            boolean bl = false;
            boolean bl2 = outputInfo.getGeneratedForCompilerPlugin();
            if (!bl2) {
                tracker.recordSourceFilesToOutputFileMapping((Collection<? extends File>)outputInfo.getSourceFiles(), output2);
            } else if (bl2) {
                boolean bl3;
                block10: {
                    Iterable $this$none$iv = outputInfo.getSourceFiles();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            File it = (File)element$iv;
                            boolean bl4 = false;
                            if (!it.exists()) continue;
                            bl3 = false;
                            break block10;
                        }
                        bl3 = true;
                    }
                }
                if (!bl3) {
                    boolean bl5 = false;
                    String string = "Plugin generated file shouldn't have sources, but got " + CollectionsKt.joinToString$default((Iterable)outputInfo.getSourceFiles(), null, null, null, (int)0, null, OutputUtilsKt::writeAll$lambda$0$0$1$0, (int)31, null);
                    throw new IllegalStateException(string.toString());
                }
                tracker.recordSourceFilesToOutputFileMapping((Collection<? extends File>)outputInfo.getSourceFiles(), output2);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        if ($reportOutputFiles) {
            String string = OutputMessageUtil.formatOutputMessage((Collection<File>)outputInfo.getSourceFiles(), output2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatOutputMessage(...)");
            MessageCollector.report$default($messageCollector, CompilerMessageSeverity.OUTPUT, string, null, 4, null);
        }
        return Unit.INSTANCE;
    }
}

