/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDelegatedPropertyChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeConstraintSystemHasContradiction;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicabilityKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDelegatedPropertyChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "checkers"})
public final class FirDelegatedPropertyChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirDelegatedPropertyChecker INSTANCE = new FirDelegatedPropertyChecker();

    private FirDelegatedPropertyChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirProperty declaration) {
        block4: {
            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDelegatedPropertyChecker$check$DelegatedPropertyAccessorVisitor", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "isGet", "", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Z)V", "visitElement", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitImplicitInvokeCall", "implicitInvokeCall", "Lorg/jetbrains/kotlin/fir/expressions/FirImplicitInvokeCall;", "checkFunctionCall", "checkFunctionReferenceErrors", "checkReturnType", "checkers"})
            @SourceDebugExtension(value={"SMAP\nFirDelegatedPropertyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDelegatedPropertyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDelegatedPropertyChecker$check$DelegatedPropertyAccessorVisitor\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n57#2:143\n1585#3:144\n1660#3,3:145\n1585#3:148\n1660#3,3:149\n*S KotlinDebug\n*F\n+ 1 FirDelegatedPropertyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDelegatedPropertyChecker$check$DelegatedPropertyAccessorVisitor\n*L\n70#1:143\n100#1:144\n100#1:145,3\n102#1:148\n102#1:149,3\n*E\n"})
            public final class DelegatedPropertyAccessorVisitor
            extends FirVisitorVoid {
                private final boolean isGet;
                final /* synthetic */ CheckerContext $context;
                final /* synthetic */ DiagnosticReporter $reporter;
                final /* synthetic */ KtSourceElement $source;
                final /* synthetic */ ConeKotlinType $delegateType;
                final /* synthetic */ FirProperty $declaration;

                public DelegatedPropertyAccessorVisitor(CheckerContext $context, DiagnosticReporter $reporter, KtSourceElement $source, ConeKotlinType $delegateType, FirProperty $declaration, boolean isGet) {
                    this.$context = $context;
                    this.$reporter = $reporter;
                    this.$source = $source;
                    this.$delegateType = $delegateType;
                    this.$declaration = $declaration;
                    this.isGet = isGet;
                }

                public void visitElement(FirElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    element.acceptChildren(this);
                }

                public void visitFunctionCall(FirFunctionCall functionCall) {
                    Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
                    this.checkFunctionCall(functionCall);
                }

                public void visitImplicitInvokeCall(FirImplicitInvokeCall implicitInvokeCall) {
                    Intrinsics.checkNotNullParameter((Object)implicitInvokeCall, (String)"implicitInvokeCall");
                    this.checkFunctionCall(implicitInvokeCall);
                }

                private final void checkFunctionCall(FirFunctionCall functionCall) {
                    boolean hasReferenceError = this.checkFunctionReferenceErrors(functionCall);
                    if (this.isGet && !hasReferenceError) {
                        this.checkReturnType(functionCall);
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                private final boolean checkFunctionReferenceErrors(FirFunctionCall functionCall) {
                    FirNamedReference reference2 = functionCall.getCalleeReference();
                    if (!FirReferenceUtilsKt.isError(reference2)) {
                        return false;
                    }
                    ConeDiagnostic diagnostic = ((FirDiagnosticHolder)((Object)reference2)).getDiagnostic();
                    KtSourceElement ktSourceElement = ((FirDiagnosticHolder)((Object)reference2)).getSource();
                    if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
                        return false;
                    }
                    FirCall $this$arguments$iv = functionCall;
                    boolean $i$f$getArguments = false;
                    String expectedFunctionSignature = (this.isGet ? "getValue" : "setValue") + '(' + CollectionsKt.joinToString$default((Iterable)$this$arguments$iv.getArgumentList().getArguments(), (CharSequence)", ", null, null, (int)0, null, DelegatedPropertyAccessorVisitor::checkFunctionReferenceErrors$lambda$0, (int)30, null) + ')';
                    String delegateDescription = this.isGet ? "delegate" : "delegate for var (read-write property)";
                    boolean errorReported = true;
                    ConeDiagnostic coneDiagnostic = diagnostic;
                    if (coneDiagnostic instanceof ConeUnresolvedNameError) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)this.$context, this.$reporter, (AbstractKtSourceElement)this.$source, FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_MISSING(), (Object)expectedFunctionSignature, (Object)this.$delegateType, (Object)delegateDescription, null, 64, null);
                    } else if (coneDiagnostic instanceof ConeAmbiguityError) {
                        if (CandidateApplicabilityKt.isSuccess(((ConeAmbiguityError)diagnostic).getApplicability())) {
                            Collection<FirBasedSymbol<?>> collection;
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            Iterable iterable = ((ConeAmbiguityError)diagnostic).getCandidates();
                            String string = expectedFunctionSignature;
                            KtDiagnosticFactory2<String, Collection<FirBasedSymbol<?>>> ktDiagnosticFactory2 = FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_AMBIGUITY();
                            AbstractKtSourceElement abstractKtSourceElement = this.$source;
                            DiagnosticReporter diagnosticReporter = this.$reporter;
                            DiagnosticContext diagnosticContext2 = this.$context;
                            boolean $i$f$map = false;
                            void var10_22 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                AbstractCandidate abstractCandidate = (AbstractCandidate)item$iv$iv;
                                collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(it.getSymbol());
                            }
                            collection = (List)destination$iv$iv;
                            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext2, diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory2, (Object)string, (Object)collection, null, 32, null);
                        } else {
                            Collection<FirBasedSymbol<?>> collection;
                            Iterable $this$map$iv = ((ConeAmbiguityError)diagnostic).getCandidates();
                            String string = expectedFunctionSignature;
                            KtSourceElement ktSourceElement2 = this.$source;
                            DiagnosticReporter diagnosticReporter = this.$reporter;
                            CheckerContext checkerContext = this.$context;
                            boolean $i$f$map = false;
                            Iterable $this$mapTo$iv$iv = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                AbstractCandidate it = (AbstractCandidate)item$iv$iv;
                                collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(it.getSymbol());
                            }
                            collection = (List)destination$iv$iv;
                            DelegatedPropertyAccessorVisitor.checkFunctionReferenceErrors$reportInapplicableDiagnostics(checkerContext, diagnosticReporter, ktSourceElement2, string, (Collection)collection);
                        }
                    } else if (coneDiagnostic instanceof ConeInapplicableWrongReceiver) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)this.$context, this.$reporter, (AbstractKtSourceElement)this.$source, FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_MISSING(), (Object)expectedFunctionSignature, (Object)this.$delegateType, (Object)delegateDescription, null, 64, null);
                    } else if (coneDiagnostic instanceof ConeInapplicableCandidateError) {
                        DelegatedPropertyAccessorVisitor.checkFunctionReferenceErrors$reportInapplicableDiagnostics(this.$context, this.$reporter, this.$source, expectedFunctionSignature, CollectionsKt.listOf(((ConeInapplicableCandidateError)diagnostic).getCandidate().getSymbol()));
                    } else if (coneDiagnostic instanceof ConeConstraintSystemHasContradiction) {
                        DelegatedPropertyAccessorVisitor.checkFunctionReferenceErrors$reportInapplicableDiagnostics(this.$context, this.$reporter, this.$source, expectedFunctionSignature, CollectionsKt.listOf(((ConeConstraintSystemHasContradiction)diagnostic).getCandidate().getSymbol()));
                    } else {
                        errorReported = false;
                    }
                    return errorReported;
                }

                private final void checkReturnType(FirFunctionCall functionCall) {
                    ConeKotlinType returnType = FirTypeUtilsKt.getResolvedType(functionCall);
                    ConeKotlinType propertyType = FirTypeUtilsKt.getConeType(this.$declaration.getReturnTypeRef());
                    if (!AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(this.$context.getSession()), (KotlinTypeMarker)returnType, (KotlinTypeMarker)propertyType, false, 8, null)) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)this.$context, this.$reporter, (AbstractKtSourceElement)this.$source, FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_RETURN_TYPE_MISMATCH(), (Object)"getValue", (Object)propertyType, (Object)returnType, null, 64, null);
                    }
                }

                private static final CharSequence checkFunctionReferenceErrors$lambda$0(FirExpression it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return ConeTypeUtilsKt.renderReadable(FirTypeUtilsKt.getResolvedType(it));
                }

                private static final void checkFunctionReferenceErrors$reportInapplicableDiagnostics(CheckerContext $context, DiagnosticReporter $reporter, KtSourceElement source, String expectedFunctionSignature, Collection<? extends FirBasedSymbol<?>> candidates) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE(), (Object)expectedFunctionSignature, candidates, null, 32, null);
                }
            }
            FirPureAbstractElement firPureAbstractElement;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            FirExpression firExpression = declaration.getDelegate();
            if (firExpression == null) {
                return;
            }
            FirExpression delegate = firExpression;
            ConeKotlinType delegateType = FirTypeUtilsKt.getResolvedType(delegate);
            KtSourceElement source = delegate.getSource();
            if (delegateType instanceof ConeErrorType) {
                if (source != null && FirHelpersKt.hasDiagnosticKind(delegateType, DiagnosticKind.RecursionInImplicitTypes)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getRECURSION_IN_IMPLICIT_TYPES(), null, 8, null);
                }
                return;
            }
            FirPureAbstractElement firPureAbstractElement2 = declaration.getGetter();
            if (firPureAbstractElement2 != null && (firPureAbstractElement2 = ((FirPropertyAccessor)firPureAbstractElement2).getBody()) != null) {
                firPureAbstractElement2.acceptChildren(new DelegatedPropertyAccessorVisitor(context2, reporter, source, delegateType, declaration, true));
            }
            if ((firPureAbstractElement = declaration.getSetter()) == null || (firPureAbstractElement = ((FirPropertyAccessor)firPureAbstractElement).getBody()) == null) break block4;
            firPureAbstractElement.acceptChildren(new DelegatedPropertyAccessorVisitor(context2, reporter, source, delegateType, declaration, false));
        }
    }
}

