/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.resolve.ContainingClassUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOptInEnumEntryChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumEntryChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInEnumEntryChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInEnumEntryChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOptInEnumEntryChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1585#2:35\n1660#2,3:36\n*S KotlinDebug\n*F\n+ 1 FirOptInEnumEntryChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOptInEnumEntryChecker\n*L\n27#1:35\n27#1:36,3\n*E\n"})
public final class FirOptInEnumEntryChecker
extends FirDeclarationChecker<FirEnumEntry> {
    @NotNull
    public static final FirOptInEnumEntryChecker INSTANCE = new FirOptInEnumEntryChecker();

    private FirOptInEnumEntryChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirEnumEntry declaration) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration.getInitializer() != null) {
            return;
        }
        FirBasedSymbol firBasedSymbol = ContainingClassUtilsKt.getContainingClassSymbol(declaration.getSymbol());
        if (firBasedSymbol == null || (firBasedSymbol = ScopeUtilsKt.getPrimaryConstructorSymbol(firBasedSymbol, context2.getSession(), context2.getScopeSession())) == null) {
            return;
        }
        FirBasedSymbol primaryConstructorSymbol = firBasedSymbol;
        Iterable $this$map$iv = FirOptInUsageBaseChecker.INSTANCE.loadExperimentalitiesFromConstructor(context2, (FirConstructorSymbol)primaryConstructorSymbol);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirOptInUsageBaseChecker.Experimentality experimentality = (FirOptInUsageBaseChecker.Experimentality)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.CheckOptInOnPureEnumEntries) ? it : FirOptInUsageBaseChecker.Experimentality.copy$default((FirOptInUsageBaseChecker.Experimentality)it, null, FirOptInUsageBaseChecker.Experimentality.Severity.WARNING, null, null, false, 29, null));
        }
        List experimentalities = (List)destination$iv$iv;
        FirOptInUsageBaseChecker.reportNotAcceptedExperimentalities$default(FirOptInUsageBaseChecker.INSTANCE, context2, reporter, experimentalities, declaration, null, 16, null);
    }
}

