/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.FirOverridesBackwardCompatibilityHelperKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirAbstractOverrideChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirDeprecationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.CallToPotentiallyHiddenSymbolResult;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.DeprecationsPerUseSite;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeprecationInfo;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.resolve.ContainingClassUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverrideFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverridePropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.types.TypeCheckerState;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002OPB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0011J9\u0010\u0012\u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002J*\u0010\u001b\u001a\u0018\u0012\u0004\u0012\u00020\u001d\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\u001e0\u001c2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002J*\u0010\u001f\u001a\u0018\u0012\u0004\u0012\u00020\u001d\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\u001e0\u001c2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002J \u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0010\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140%H\u0002J$\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014*\u00020'2\u0010\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140%H\u0002JG\u0010(\u001a\u00020\n*\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010)\u001a\u00020\u00102\u0010\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140%H\u0002R\u00020\rR\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010*J?\u0010.\u001a\u00020\n*\u0006\u0012\u0002\b\u00030\u00142\u0010\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140%H\u0002R\u00020\rR\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010/J-\u00100\u001a\u00020\n*\u0006\u0012\u0002\b\u000301H\u0002R\u00020\rR\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u00102JG\u00103\u001a\u00020\n*\u0006\u0012\u0002\b\u00030\u00142\u0010\u00104\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140%2\u0006\u0010)\u001a\u00020\u0010H\u0002R\u00020\rR\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u00105JG\u00106\u001a\u00020\n*\u0006\u0012\u0002\b\u00030\u00142\u0010\u00104\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140%2\u0006\u0010)\u001a\u00020\u0010H\u0002R\u00020\rR\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u00105JI\u00107\u001a\u00020\n2\n\u00108\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010)\u001a\u00020\u00102\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0002R\u00020\rR\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010=JO\u0010>\u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030\u00142\u0010\u00104\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140%2\u0006\u0010)\u001a\u00020\u00102\u0006\u00109\u001a\u00020:H\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010?JC\u0010@\u001a\u00020\n2\n\u0010A\u001a\u0006\u0012\u0002\b\u00030\u00142\u0010\u00104\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140%H\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010BJ1\u0010C\u001a\u00020\n*\u00020\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010;\u001a\u00020<H\u0002R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010DJ5\u0010E\u001a\u00020\n*\u00020\r2\n\u0010F\u001a\u0006\u0012\u0002\b\u00030\u00142\n\u0010G\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010HJ5\u0010I\u001a\u00020\n*\u00020\r2\n\u0010F\u001a\u0006\u0012\u0002\b\u00030\u00142\n\u0010G\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010HJ5\u0010J\u001a\u00020\n*\u00020\r2\n\u0010F\u001a\u0006\u0012\u0002\b\u00030\u00142\n\u0010G\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010HJ5\u0010K\u001a\u00020\n*\u00020\r2\n\u0010F\u001a\u0006\u0012\u0002\b\u00030\u00142\n\u0010G\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010HJ5\u0010L\u001a\u00020\n*\u00020\r2\n\u0010F\u001a\u0006\u0012\u0002\b\u00030\u00142\n\u0010G\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010HJ5\u0010M\u001a\u00020\n*\u00020\r2\n\u0010F\u001a\u0006\u0012\u0002\b\u00030\u00142\n\u0010G\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010HJ5\u0010N\u001a\u00020\n*\u00020\r2\n\u0010F\u001a\u0006\u0012\u0002\b\u00030\u00142\n\u0010G\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010HR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0018\u0010+\u001a\u00020\u0013*\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u0082\u0001\u0002QR\u00a8\u0006S"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAbstractOverrideChecker;", "mppKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "consideredOrigins", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOrigin;", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "ensureKnownVisibility", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/KtSourceElement;)Z", "chooseCannotInferVisibilityFor", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;", "symbol", "chooseCannotChangeAccessPrivilegeFor", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory3;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/name/Name;", "chooseCannotWeakenAccessPrivilegeFor", "wouldMissDiagnosticInK1", "getWouldMissDiagnosticInK1", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "checkModality", "overriddenSymbols", "", "checkMutability", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "checkVisibility", "containingClass", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/declarations/FirClass;Ljava/util/List;)V", "canDelegateVisibilityConsistencyChecksToAccessors", "getCanDelegateVisibilityConsistencyChecksToAccessors", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Z", "checkDeprecation", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Ljava/util/List;)V", "checkDefaultValues", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;)V", "checkDataClassCopy", "overriddenMemberSymbols", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Ljava/util/List;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkSuspend", "checkMember", "member", "typeCheckerState", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "firTypeScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/types/TypeCheckerState;Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;)V", "checkDataClassMembers", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Ljava/util/List;Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/types/TypeCheckerState;)Z", "checkOverriddenExperimentalities", "memberSymbol", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Ljava/util/List;)V", "reportNothingToOverride", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;)V", "reportOverridingFinalMember", "overriding", "overridden", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V", "reportVarOverriddenByVal", "reportCannotWeakenAccessPrivilege", "reportCannotChangeAccessPrivilege", "reportReturnTypeMismatchOnFunction", "reportTypeMismatchOnProperty", "reportTypeMismatchOnVariable", "Regular", "ForExpectClass", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$Regular;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOverrideChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 7 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,611:1\n1806#2,3:612\n1585#2:619\n1660#2,2:620\n1662#2:623\n1067#2:624\n1585#2:625\n1660#2,3:626\n1641#2,10:629\n1914#2:639\n1915#2:641\n1651#2:642\n1806#2,3:644\n1299#2,2:647\n1314#2,4:649\n295#2:660\n296#2:662\n1806#2,2:663\n1808#2:666\n295#2:669\n296#2:679\n1390#2:690\n1479#2,5:691\n776#2:696\n872#2:697\n873#2:711\n22#3:615\n22#3:617\n17#3:618\n22#3:622\n22#3:643\n35#3:661\n35#3:665\n35#3:667\n29#3:668\n20#3:689\n19#3:709\n18#3:710\n22#3:712\n22#3:713\n1#4:616\n1#4:640\n507#5,7:653\n115#6:670\n108#6,3:671\n99#6:674\n87#6:675\n93#6:677\n112#6:678\n115#6:680\n108#6,3:681\n99#6:684\n87#6:685\n93#6:687\n112#6:688\n161#6:698\n118#6,4:699\n99#6:703\n87#6:704\n93#6:706\n122#6,2:707\n53#7:676\n53#7:686\n53#7:705\n*S KotlinDebug\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker\n*L\n134#1:612,3\n225#1:619\n225#1:620,2\n225#1:623\n227#1:624\n235#1:625\n235#1:626,3\n239#1:629,10\n239#1:639\n239#1:641\n239#1:642\n258#1:644,3\n294#1:647,2\n294#1:649,4\n357#1:660\n357#1:662\n358#1:663,2\n358#1:666\n392#1:669\n392#1:679\n505#1:690\n505#1:691,5\n531#1:696\n531#1:697\n531#1:711\n175#1:615\n195#1:617\n201#1:618\n226#1:622\n243#1:643\n357#1:661\n358#1:665\n362#1:667\n378#1:668\n476#1:689\n533#1:709\n533#1:710\n566#1:712\n581#1:713\n239#1:640\n296#1:653,7\n394#1:670\n394#1:671,3\n394#1:674\n394#1:675\n394#1:677\n394#1:678\n401#1:680\n401#1:681,3\n401#1:684\n401#1:685\n401#1:687\n401#1:688\n532#1:698\n532#1:699,4\n532#1:703\n532#1:704\n532#1:706\n532#1:707,2\n394#1:676\n401#1:686\n532#1:705\n*E\n"})
public abstract class FirOverrideChecker
extends FirAbstractOverrideChecker {
    @NotNull
    private final Set<FirDeclarationOrigin> consideredOrigins;

    private FirOverrideChecker(MppCheckerKind mppKind) {
        super(mppKind);
        Object[] objectArray = new FirDeclarationOrigin[]{FirDeclarationOrigin.Source.INSTANCE, FirDeclarationOrigin.Synthetic.DataClassMember.INSTANCE, FirDeclarationOrigin.Delegated.INSTANCE, FirDeclarationOrigin.IntersectionOverride.INSTANCE};
        this.consideredOrigins = SetsKt.setOf((Object[])objectArray);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Iterable $this$any$iv = declaration.getSuperTypeRefs();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirTypeRef it = (FirTypeRef)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof FirErrorTypeRef)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        TypeCheckerState typeCheckerState = TypeComponentsKt.getTypeContext(context2.getSession()).newTypeCheckerState(false, false, LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.AllowDnnTypeOverridingFlexibleType));
        FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(context2, declaration);
        FirContainingNamesAwareScopeKt.processAllProperties(firTypeScope, (Function1)new Function1<FirCallableSymbol<?>, Unit>(this, declaration, reporter, context2, typeCheckerState, firTypeScope){
            final /* synthetic */ FirOverrideChecker this$0;
            final /* synthetic */ FirClass $declaration;
            final /* synthetic */ DiagnosticReporter $reporter;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ TypeCheckerState $typeCheckerState;
            final /* synthetic */ FirTypeScope $firTypeScope;
            {
                this.this$0 = $receiver;
                this.$declaration = $declaration;
                this.$reporter = $reporter;
                this.$context = $context;
                this.$typeCheckerState = $typeCheckerState;
                this.$firTypeScope = $firTypeScope;
                super(1, Intrinsics.Kotlin.class, "checkMember", "check$checkMember(Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/types/TypeCheckerState;Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V", 0);
            }

            public final void invoke(FirCallableSymbol<?> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                FirOverrideChecker.access$check$checkMember(this.this$0, this.$declaration, this.$reporter, this.$context, this.$typeCheckerState, this.$firTypeScope, p0);
            }
        });
        FirContainingNamesAwareScopeKt.processAllFunctions(firTypeScope, (Function1<? super FirNamedFunctionSymbol, Unit>)new Function1<FirCallableSymbol<?>, Unit>(this, declaration, reporter, context2, typeCheckerState, firTypeScope){
            final /* synthetic */ FirOverrideChecker this$0;
            final /* synthetic */ FirClass $declaration;
            final /* synthetic */ DiagnosticReporter $reporter;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ TypeCheckerState $typeCheckerState;
            final /* synthetic */ FirTypeScope $firTypeScope;
            {
                this.this$0 = $receiver;
                this.$declaration = $declaration;
                this.$reporter = $reporter;
                this.$context = $context;
                this.$typeCheckerState = $typeCheckerState;
                this.$firTypeScope = $firTypeScope;
                super(1, Intrinsics.Kotlin.class, "checkMember", "check$checkMember(Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/types/TypeCheckerState;Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V", 0);
            }

            public final void invoke(FirCallableSymbol<?> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                FirOverrideChecker.access$check$checkMember(this.this$0, this.$declaration, this.$reporter, this.$context, this.$typeCheckerState, this.$firTypeScope, p0);
            }
        });
    }

    private final boolean ensureKnownVisibility(CheckerContext context2, DiagnosticReporter reporter, FirCallableSymbol<?> $this$ensureKnownVisibility, KtSourceElement source) {
        boolean bl;
        FirCallableSymbol<?> $this$visibility$iv = $this$ensureKnownVisibility;
        boolean $i$f$getVisibility = false;
        if (!Intrinsics.areEqual((Object)$this$visibility$iv.getResolvedStatus().getVisibility(), (Object)Visibilities.Unknown.INSTANCE)) {
            bl = true;
        } else {
            boolean bl2;
            boolean it = bl2 = false;
            boolean bl3 = false;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, this.chooseCannotInferVisibilityFor($this$ensureKnownVisibility), $this$ensureKnownVisibility, null, 16, null);
            bl = bl2;
        }
        return bl;
    }

    static /* synthetic */ boolean ensureKnownVisibility$default(FirOverrideChecker firOverrideChecker, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, FirCallableSymbol firCallableSymbol, KtSourceElement ktSourceElement, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: ensureKnownVisibility");
        }
        if ((n2 & 4) != 0) {
            ktSourceElement = firCallableSymbol.getSource();
        }
        return firOverrideChecker.ensureKnownVisibility(checkerContext, diagnosticReporter, firCallableSymbol, ktSourceElement);
    }

    private final KtDiagnosticFactory1<FirCallableSymbol<?>> chooseCannotInferVisibilityFor(FirCallableSymbol<?> symbol) {
        return !this.getWouldMissDiagnosticInK1(symbol) ? FirErrors.INSTANCE.getCANNOT_INFER_VISIBILITY() : FirErrors.INSTANCE.getCANNOT_INFER_VISIBILITY_WARNING();
    }

    private final KtDiagnosticFactory3<Visibility, FirCallableSymbol<?>, Name> chooseCannotChangeAccessPrivilegeFor(FirCallableSymbol<?> symbol) {
        return !this.getWouldMissDiagnosticInK1(symbol) ? FirErrors.INSTANCE.getCANNOT_CHANGE_ACCESS_PRIVILEGE() : FirErrors.INSTANCE.getCANNOT_CHANGE_ACCESS_PRIVILEGE_WARNING();
    }

    private final KtDiagnosticFactory3<Visibility, FirCallableSymbol<?>, Name> chooseCannotWeakenAccessPrivilegeFor(FirCallableSymbol<?> symbol) {
        return !this.getWouldMissDiagnosticInK1(symbol) ? FirErrors.INSTANCE.getCANNOT_WEAKEN_ACCESS_PRIVILEGE() : FirErrors.INSTANCE.getCANNOT_WEAKEN_ACCESS_PRIVILEGE_WARNING();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getWouldMissDiagnosticInK1(FirCallableSymbol<?> $this$wouldMissDiagnosticInK1) {
        if (!($this$wouldMissDiagnosticInK1 instanceof FirPropertyAccessorSymbol)) return false;
        if (!ClassMembersKt.isIntersectionOverride(((FirPropertyAccessorSymbol)$this$wouldMissDiagnosticInK1).getPropertySymbol())) return false;
        FirCallableSymbol $this$visibility$iv = $this$wouldMissDiagnosticInK1;
        boolean $i$f$getVisibility = false;
        Visibility visibility = $this$visibility$iv.getResolvedStatus().getVisibility();
        $this$visibility$iv = ((FirPropertyAccessorSymbol)$this$wouldMissDiagnosticInK1).getPropertySymbol();
        $i$f$getVisibility = false;
        if (Intrinsics.areEqual((Object)visibility, (Object)$this$visibility$iv.getResolvedStatus().getVisibility())) return false;
        return true;
    }

    private final FirCallableSymbol<?> checkModality(List<? extends FirCallableSymbol<?>> overriddenSymbols) {
        Iterator<FirCallableSymbol<?>> iterator2 = overriddenSymbols.iterator();
        while (iterator2.hasNext()) {
            FirCallableSymbol<?> overridden;
            FirCallableSymbol<?> $this$modality$iv = overridden = iterator2.next();
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() != Modality.FINAL) continue;
            return overridden;
        }
        return null;
    }

    private final FirCallableSymbol<?> checkMutability(FirPropertySymbol $this$checkMutability, List<? extends FirCallableSymbol<?>> overriddenSymbols) {
        Object v2;
        block2: {
            if ($this$checkMutability.isVar()) {
                return null;
            }
            Iterable iterable = overriddenSymbols;
            for (Object t2 : iterable) {
                FirCallableSymbol it = (FirCallableSymbol)t2;
                boolean bl = false;
                FirPropertySymbol firPropertySymbol = it instanceof FirPropertySymbol ? (FirPropertySymbol)it : null;
                boolean bl2 = firPropertySymbol != null ? firPropertySymbol.isVar() : false;
                if (!bl2) continue;
                v2 = t2;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVisibility(DiagnosticReporter reporter, CheckerContext context2, FirCallableSymbol<?> $this$checkVisibility, FirClass containingClass, List<? extends FirCallableSymbol<?>> overriddenSymbols) {
        boolean hasVisibleBase;
        block14: {
            boolean bl;
            block16: {
                List visibilities;
                block15: {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Collection<FirCallableSymbol> collection;
                    void $this$mapTo$iv$iv;
                    DiagnosticReporter diagnosticReporter;
                    CheckerContext checkerContext;
                    FirCallableSymbol firCallableSymbol;
                    FirClass firClass;
                    Object $this$sortedBy$iv;
                    Object object;
                    void $this$mapTo$iv$iv2;
                    if (!FirOverrideChecker.ensureKnownVisibility$default(this, context2, reporter, $this$checkVisibility, null, 4, null)) {
                        return;
                    }
                    if (overriddenSymbols.isEmpty()) {
                        return;
                    }
                    Iterable $this$map$iv = overriddenSymbols;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        FirCallableSymbol firCallableSymbol2 = (FirCallableSymbol)item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl2 = false;
                        void $this$visibility$iv = it;
                        boolean $i$f$getVisibility = false;
                        object.add(TuplesKt.to((Object)it, (Object)$this$visibility$iv.getResolvedStatus().getVisibility()));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$sortedBy2 = false;
                    visibilities = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator($this$checkVisibility){
                        final /* synthetic */ FirCallableSymbol $this_checkVisibility$inlined;
                        {
                            this.$this_checkVisibility$inlined = firCallableSymbol;
                        }

                        public final int compare(T a2, T b2) {
                            Pair pair = (Pair)a2;
                            boolean bl = false;
                            FirCallableSymbol $this$visibility$iv = this.$this_checkVisibility$inlined;
                            boolean $i$f$getVisibility = false;
                            Integer n2 = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), (Visibility)pair.getSecond());
                            pair = (Pair)b2;
                            Comparable comparable = Integer.valueOf(n2 != null ? n2 : Integer.MIN_VALUE);
                            bl = false;
                            $this$visibility$iv = this.$this_checkVisibility$inlined;
                            $i$f$getVisibility = false;
                            Integer n3 = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), (Visibility)pair.getSecond());
                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(n3 != null ? n3 : Integer.MIN_VALUE));
                        }
                    });
                    if (!($this$checkVisibility instanceof FirPropertySymbol) || !this.getCanDelegateVisibilityConsistencyChecksToAccessors((FirPropertySymbol)$this$checkVisibility)) break block15;
                    $this$sortedBy$iv = ((FirPropertySymbol)$this$checkVisibility).getGetterSymbol();
                    if ($this$sortedBy$iv != null) {
                        void $this$map$iv2;
                        Iterable $i$f$sortedBy2 = overriddenSymbols;
                        firClass = containingClass;
                        firCallableSymbol = (FirCallableSymbol)$this$sortedBy$iv;
                        checkerContext = context2;
                        diagnosticReporter = reporter;
                        object = this;
                        boolean $i$f$map2 = false;
                        destination$iv$iv = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            FirCallableSymbol bl2 = (FirCallableSymbol)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
                            FirPropertyAccessorSymbol firPropertyAccessorSymbol = ((FirPropertySymbol)it).getGetterSymbol();
                            collection.add((FirCallableSymbol)(firPropertyAccessorSymbol != null ? (FirCallableSymbol)firPropertyAccessorSymbol : it));
                        }
                        collection = (List)destination$iv$iv2;
                        super.checkVisibility(diagnosticReporter, checkerContext, firCallableSymbol, firClass, (List<? extends FirCallableSymbol<?>>)collection);
                    }
                    if (($this$sortedBy$iv = ((FirPropertySymbol)$this$checkVisibility).getSetterSymbol()) == null) break block16;
                    Iterable $this$map$iv2 = overriddenSymbols;
                    firClass = containingClass;
                    firCallableSymbol = (FirCallableSymbol)$this$sortedBy$iv;
                    checkerContext = context2;
                    diagnosticReporter = reporter;
                    object = this;
                    boolean $i$f$mapNotNull = false;
                    $this$mapTo$iv$iv = $this$mapNotNull$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator it = $this$forEach$iv$iv$iv.iterator();
                    while (it.hasNext()) {
                        FirPropertyAccessorSymbol it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = it.next();
                        boolean bl4 = false;
                        FirCallableSymbol it2 = (FirCallableSymbol)element$iv$iv;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
                        if (((FirPropertySymbol)it2).getSetterSymbol() == null) continue;
                        boolean bl6 = false;
                        destination$iv$iv3.add(it$iv$iv);
                    }
                    collection = (List)destination$iv$iv3;
                    super.checkVisibility(diagnosticReporter, checkerContext, firCallableSymbol, firClass, (List<? extends FirCallableSymbol<?>>)collection);
                    break block16;
                }
                for (Pair $this$mapNotNull$iv : visibilities) {
                    FirCallableSymbol overridden = (FirCallableSymbol)$this$mapNotNull$iv.component1();
                    Visibility overriddenVisibility = (Visibility)$this$mapNotNull$iv.component2();
                    FirCallableSymbol<?> $this$visibility$iv = $this$checkVisibility;
                    boolean $i$f$getVisibility = false;
                    Integer compare = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), overriddenVisibility);
                    if (compare == null) {
                        this.reportCannotChangeAccessPrivilege(context2, reporter, $this$checkVisibility, overridden);
                        break;
                    }
                    if (compare >= 0) continue;
                    this.reportCannotWeakenAccessPrivilege(context2, reporter, $this$checkVisibility, overridden);
                    break;
                }
            }
            if ($this$checkVisibility instanceof FirPropertyAccessorSymbol) {
                return;
            }
            FirFileSymbol firFileSymbol = context2.getContainingFileSymbol();
            if (firFileSymbol == null) {
                return;
            }
            FirFileSymbol file = firFileSymbol;
            List containingDeclarations = CollectionsKt.plus((Collection)context2.getContainingDeclarations(), containingClass.getSymbol());
            FirVisibilityChecker visibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker(context2.getSession());
            Iterable $this$any$iv = overriddenSymbols;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirCallableSymbol it = (FirCallableSymbol)element$iv;
                    boolean bl7 = false;
                    FirLazyDeclarationResolverKt.lazyResolveToPhase(it, FirResolvePhase.STATUS);
                    if (!FirVisibilityCheckerKt.isVisible(visibilityChecker, it, context2.getSession(), file, containingDeclarations, null, true)) continue;
                    bl = true;
                    break block14;
                }
                bl = hasVisibleBase = false;
            }
        }
        if (!hasVisibleBase) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)$this$checkVisibility.getSource(), FirErrors.INSTANCE.getCANNOT_OVERRIDE_INVISIBLE_MEMBER(), $this$checkVisibility, CollectionsKt.first(overriddenSymbols), null, 32, null);
        }
    }

    private final boolean getCanDelegateVisibilityConsistencyChecksToAccessors(FirPropertySymbol $this$canDelegateVisibilityConsistencyChecksToAccessors) {
        return $this$canDelegateVisibilityConsistencyChecksToAccessors.getGetterSymbol() != null || $this$canDelegateVisibilityConsistencyChecksToAccessors.getSetterSymbol() != null;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDeprecation(DiagnosticReporter reporter, CheckerContext context2, FirCallableSymbol<?> $this$checkDeprecation, List<? extends FirCallableSymbol<?>> overriddenSymbols) {
        Iterator $this$filterValues$iv;
        Iterator $this$associateWithTo$iv$iv;
        DeprecationsPerUseSite ownDeprecation = $this$checkDeprecation.getDeprecation(context2.getLanguageVersionSettings());
        if (ownDeprecation != null && ownDeprecation.isNotEmpty()) {
            return;
        }
        Object $this$associateWith$iv = overriddenSymbols;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator2 = $this$associateWithTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            DeprecationsPerUseSite deprecationsPerUseSite;
            void overriddenSymbol;
            Object element$iv$iv = iterator2.next();
            FirCallableSymbol firCallableSymbol = (FirCallableSymbol)element$iv$iv;
            Object t2 = element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            if (overriddenSymbol.getDeprecation(context2.getLanguageVersionSettings()) != null) {
                DeprecationsPerUseSite deprecationsPerUseSite2;
                DeprecationsPerUseSite it = deprecationsPerUseSite2;
                boolean bl2 = false;
                deprecationsPerUseSite = it.isNotEmpty() ? deprecationsPerUseSite2 : null;
            } else {
                deprecationsPerUseSite = null;
            }
            DeprecationsPerUseSite deprecationsPerUseSite3 = deprecationsPerUseSite;
            map.put(t2, deprecationsPerUseSite3);
        }
        $this$associateWith$iv = destination$iv$iv;
        boolean $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            DeprecationsPerUseSite it = (DeprecationsPerUseSite)entry$iv.getValue();
            boolean bl = false;
            if (!(it != null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map overriddenWithDeprecation = result$iv;
        if (overriddenWithDeprecation.size() == overriddenSymbols.size()) {
            for (Map.Entry entry : overriddenWithDeprecation.entrySet()) {
                Object object;
                DeprecationsPerUseSite deprecationInfoFromOverridden;
                FirCallableSymbol overriddenSymbol = (FirCallableSymbol)entry.getKey();
                DeprecationsPerUseSite deprecationsPerUseSite = deprecationInfoFromOverridden = (DeprecationsPerUseSite)entry.getValue();
                Intrinsics.checkNotNull((Object)deprecationsPerUseSite);
                FirDeprecationInfo firDeprecationInfo = deprecationsPerUseSite.getAll();
                if (firDeprecationInfo == null && ((object = deprecationInfoFromOverridden.getBySpecificSite()) != null && (object = object.values()) != null ? (FirDeprecationInfo)CollectionsKt.firstOrNull((Iterable)((Iterable)object)) : (firDeprecationInfo = null)) == null) continue;
                FirDeprecationInfo deprecationFromOverriddenSymbol = firDeprecationInfo;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)$this$checkDeprecation.getSource(), FirErrors.INSTANCE.getOVERRIDE_DEPRECATION(), (Object)overriddenSymbol, (Object)deprecationFromOverriddenSymbol, null, 32, null);
                return;
            }
        }
        if ($this$checkDeprecation instanceof FirNamedFunctionSymbol) {
            String string = ((FirNamedFunctionSymbol)$this$checkDeprecation).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String callableName = string;
            if (FirDeprecationChecker.INSTANCE.getDeprecatedOverrideOfHiddenReplacements$checkers().containsKey(callableName)) {
                FirHelpersKt.processOverriddenFunctionsWithActionSafe(context2, (FirNamedFunctionSymbol)$this$checkDeprecation, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)arg_0 -> FirOverrideChecker.checkDeprecation$lambda$2(callableName, context2, reporter, $this$checkDeprecation, arg_0)));
            }
        }
    }

    private final void checkDefaultValues(DiagnosticReporter reporter, CheckerContext context2, FirFunctionSymbol<?> $this$checkDefaultValues) {
        for (FirValueParameterSymbol valueParameterSymbol : $this$checkDefaultValues.getValueParameterSymbols()) {
            if (!valueParameterSymbol.getHasDefaultValue()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)valueParameterSymbol.getDefaultValueSource(), FirErrors.INSTANCE.getDEFAULT_VALUE_NOT_ALLOWED_IN_OVERRIDE(), null, 8, null);
        }
    }

    private final void checkDataClassCopy(DiagnosticReporter reporter, CheckerContext context2, FirCallableSymbol<?> $this$checkDataClassCopy, List<? extends FirCallableSymbol<?>> overriddenMemberSymbols, FirClass containingClass) {
        FirCallableSymbol firCallableSymbol = (FirCallableSymbol)CollectionsKt.firstOrNull(overriddenMemberSymbols);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol overridden = firCallableSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol = ContainingClassUtilsKt.getContainingClassSymbol(overridden);
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if (firClassSymbol == null) {
            return;
        }
        FirClassSymbol overriddenClass = firClassSymbol;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)containingClass.getSource(), FirErrors.INSTANCE.getDATA_CLASS_OVERRIDE_DEFAULT_VALUES(), $this$checkDataClassCopy, (Object)overriddenClass, null, 32, null);
    }

    private final void checkSuspend(DiagnosticReporter reporter, CheckerContext context2, FirCallableSymbol<?> $this$checkSuspend, List<? extends FirCallableSymbol<?>> overriddenMemberSymbols, FirClass containingClass) {
        boolean bl;
        FirCallableSymbol overriddenSymbolWithMismatch;
        block7: {
            Object v1;
            block6: {
                Iterable $this$firstOrNull$iv = overriddenMemberSymbols;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FirCallableSymbol<?> it = (FirCallableSymbol<?>)element$iv;
                    boolean bl2 = false;
                    FirCallableSymbol<?> $this$isSuspend$iv = it;
                    boolean $i$f$isSuspend = false;
                    boolean bl3 = $this$isSuspend$iv.getRawStatus().isSuspend();
                    $this$isSuspend$iv = $this$checkSuspend;
                    $i$f$isSuspend = false;
                    if (!(bl3 != $this$isSuspend$iv.getRawStatus().isSuspend())) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            FirCallableSymbol firCallableSymbol = v1;
            if (firCallableSymbol == null) {
                return;
            }
            overriddenSymbolWithMismatch = firCallableSymbol;
            Iterable $this$any$iv = overriddenMemberSymbols;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirCallableSymbol it = (FirCallableSymbol)element$iv;
                    boolean bl4 = false;
                    FirCallableSymbol $this$isSuspend$iv = it;
                    boolean $i$f$isSuspend = false;
                    boolean bl5 = $this$isSuspend$iv.getRawStatus().isSuspend();
                    $this$isSuspend$iv = overriddenSymbolWithMismatch;
                    $i$f$isSuspend = false;
                    if (!(bl5 != $this$isSuspend$iv.getRawStatus().isSuspend())) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)$this$checkSuspend.getSource(), FirErrors.INSTANCE.getCONFLICTING_INHERITED_MEMBERS(), containingClass.getSymbol(), overriddenMemberSymbols, null, 32, null);
            return;
        }
        FirCallableSymbol<?> $this$isSuspend$iv = $this$checkSuspend;
        boolean $i$f$isSuspend = false;
        KtDiagnosticFactory2<FirCallableSymbol<?>, FirCallableSymbol<?>> error = $this$isSuspend$iv.getRawStatus().isSuspend() ? FirErrors.INSTANCE.getNON_SUSPEND_OVERRIDDEN_BY_SUSPEND() : FirErrors.INSTANCE.getSUSPEND_OVERRIDDEN_BY_NON_SUSPEND();
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)$this$checkSuspend.getSource(), error, $this$checkSuspend, (Object)overriddenSymbolWithMismatch, null, 32, null);
    }

    /*
     * Unable to fully structure code
     */
    private final void checkMember(DiagnosticReporter reporter, CheckerContext context, FirCallableSymbol<?> member, FirClass containingClass, TypeCheckerState typeCheckerState, FirTypeScope firTypeScope) {
        block36: {
            block38: {
                block37: {
                    block35: {
                        overriddenMemberSymbols = FirTypeScopeKt.getDirectOverriddenSafe(firTypeScope, member);
                        this.checkSuspend(reporter, context, member, overriddenMemberSymbols, containingClass);
                        if (this.checkDataClassMembers(context, reporter, member, overriddenMemberSymbols, containingClass, typeCheckerState)) {
                            return;
                        }
                        $this$isOverride$iv = member;
                        $i$f$isOverride = false;
                        if ($this$isOverride$iv.getResolvedStatus().isOverride()) break block36;
                        if (overriddenMemberSymbols.isEmpty() || FirOverridesBackwardCompatibilityHelperKt.getOverridesBackwardCompatibilityHelper(context.getSession()).overrideCanBeOmitted(context, overriddenMemberSymbols)) {
                            return;
                        }
                        v0 = member.getSource();
                        v1 = kind = v0 != null ? v0.getKind() : null;
                        if (!(kind instanceof KtRealSourceElementKind) && !(kind instanceof KtFakeSourceElementKind.PropertyFromParameter)) {
                            return;
                        }
                        visibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker(context.getSession());
                        v2 = context.getContainingFileSymbol();
                        if (v2 == null) {
                            return;
                        }
                        file = v2;
                        containingDeclarations = CollectionsKt.plus((Collection)context.getContainingDeclarations(), containingClass.getSymbol());
                        $this$firstOrNull$iv = overriddenMemberSymbols;
                        $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            it = (FirCallableSymbol)element$iv;
                            $i$a$-firstOrNull-FirOverrideChecker$checkMember$overridden$1 = false;
                            var20_26 = it;
                            var21_27 = visibilityChecker;
                            $i$f$originalOrSelf = false;
                            $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
                            $i$f$originalOrSelf = false;
                            result$iv$iv = $this$originalOrSelf$iv$iv;
                            while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
                                $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
                                $i$f$originalIfFakeOverride = false;
                                $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                                $i$f$getOriginalForSubstitutionOverride = false;
                                if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
                                $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
                                $i$f$isSynthetic = false;
                                if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                                // 2 sources

                                {
                                    v3 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
                                } else {
                                    v3 = v4 = null;
                                }
                                if (v3 == null) {
                                    $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                                    $i$f$getBaseForIntersectionOverride = false;
                                    v4 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                                }
                                if (v4 == null) break;
                                result$iv$iv = v4;
                            }
                            v5 = result$iv$iv.getSymbol();
                            if (v5 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
                            }
                            if (!FirVisibilityCheckerKt.isVisible(var21_27, (FirBasedSymbol)v5, context.getSession(), file, containingDeclarations, null, true)) continue;
                            v6 = element$iv;
                            break block35;
                        }
                        v6 = null;
                    }
                    var13_43 = v6;
                    if (var13_43 == null) break block37;
                    $i$f$firstOrNull = var13_43;
                    $i$f$originalOrSelf = false;
                    $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
                    $i$f$originalOrSelf = false;
                    result$iv$iv = $this$originalOrSelf$iv$iv;
                    while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
                        $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
                        $i$f$originalIfFakeOverride = false;
                        $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                        $i$f$getOriginalForSubstitutionOverride = false;
                        if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
                        $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
                        $i$f$isSynthetic = false;
                        if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                        // 2 sources

                        {
                            v7 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
                        } else {
                            v7 = v8 = null;
                        }
                        if (v7 == null) {
                            $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                            $i$f$getBaseForIntersectionOverride = false;
                            v8 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                        }
                        if (v8 == null) break;
                        result$iv$iv = v8;
                    }
                    v9 = result$iv$iv.getSymbol();
                    if (v9 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
                    }
                    var14_16 = v9;
                    if (var14_16 != null) break block38;
                }
                return;
            }
            overridden = var14_16;
            var14_16 = ClassMembersKt.containingClassLookupTag(overridden);
            if (var14_16 == null || (var15_18 = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context, (ConeClassLikeLookupTag)var14_16)) == null) {
                return;
            }
            originalContainingClassSymbol = var15_18;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)member.getSource(), FirErrors.INSTANCE.getVIRTUAL_MEMBER_HIDDEN(), member, (Object)originalContainingClassSymbol, null, 32, null);
            return;
        }
        if (overriddenMemberSymbols.isEmpty()) {
            this.reportNothingToOverride(context, reporter, member, firTypeScope);
            return;
        }
        this.checkOverriddenExperimentalities(context, reporter, member, overriddenMemberSymbols);
        if (!ClassMembersKt.isIntersectionOverride(member) && !ClassMembersKt.isDelegated(member)) {
            v10 = this.checkModality(overriddenMemberSymbols);
            if (v10 != null) {
                it = v10;
                $i$a$-let-FirOverrideChecker$checkMember$1 = false;
                this.reportOverridingFinalMember(context, reporter, member, it);
            }
        }
        if (member instanceof FirPropertySymbol && !ClassMembersKt.isDelegated(member)) {
            v11 = this.checkMutability((FirPropertySymbol)member, overriddenMemberSymbols);
            if (v11 != null) {
                it = v11;
                $i$a$-let-FirOverrideChecker$checkMember$2 = false;
                this.reportVarOverriddenByVal(context, reporter, member, it);
            }
        }
        this.checkVisibility(reporter, context, member, containingClass, overriddenMemberSymbols);
        if (Intrinsics.areEqual((Object)member.getOrigin(), (Object)FirDeclarationOrigin.Source.INSTANCE)) {
            this.checkDeprecation(reporter, context, member, overriddenMemberSymbols);
        }
        if (member instanceof FirFunctionSymbol && !Intrinsics.areEqual((Object)((FirFunctionSymbol)member).getOrigin(), (Object)FirDeclarationOrigin.Synthetic.DataClassMember.INSTANCE)) {
            this.checkDefaultValues(reporter, context, (FirFunctionSymbol)member);
        }
        if (ClassMembersKt.isIntersectionOverride(member) || ClassMembersKt.isDelegated(member)) {
            return;
        }
        v12 = this.checkReturnType(context, member, overriddenMemberSymbols, typeCheckerState);
        if (v12 == null) {
            return;
        }
        restriction = v12;
        var9_11 = member;
        if (var9_11 instanceof FirNamedFunctionSymbol) {
            this.reportReturnTypeMismatchOnFunction(context, reporter, member, restriction);
        } else if (var9_11 instanceof FirPropertySymbol) {
            if (((FirPropertySymbol)member).isVar()) {
                this.reportTypeMismatchOnVariable(context, reporter, member, restriction);
            } else {
                this.reportTypeMismatchOnProperty(context, reporter, member, restriction);
            }
        }
    }

    private final boolean checkDataClassMembers(CheckerContext context2, DiagnosticReporter reporter, FirCallableSymbol<?> $this$checkDataClassMembers, List<? extends FirCallableSymbol<?>> overriddenMemberSymbols, FirClass containingClass, TypeCheckerState typeCheckerState) {
        KtSourceElement ktSourceElement = $this$checkDataClassMembers.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DataClassGeneratedMembers) {
            FirCallableSymbol<?> conflictingSymbol;
            FirCallableSymbol<?> firCallableSymbol;
            Object v2;
            block5: {
                Iterable iterable = overriddenMemberSymbols;
                for (Object t2 : iterable) {
                    FirCallableSymbol it = (FirCallableSymbol)t2;
                    boolean bl = false;
                    FirCallableSymbol $this$isFinal$iv = it;
                    boolean $i$f$isFinal = false;
                    boolean bl2 = $this$isFinal$iv.getResolvedStatus().getModality() == Modality.FINAL;
                    if (!bl2) continue;
                    v2 = t2;
                    break block5;
                }
                v2 = null;
            }
            if ((firCallableSymbol = (FirCallableSymbol<?>)v2) == null) {
                firCallableSymbol = this.checkReturnType(context2, $this$checkDataClassMembers, overriddenMemberSymbols, typeCheckerState);
            }
            if ((conflictingSymbol = firCallableSymbol) != null) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)containingClass.getSource(), FirErrors.INSTANCE.getDATA_CLASS_OVERRIDE_CONFLICT(), $this$checkDataClassMembers, conflictingSymbol, null, 32, null);
            }
            if (Intrinsics.areEqual((Object)$this$checkDataClassMembers.getName(), (Object)StandardNames.DATA_CLASS_COPY)) {
                this.checkDataClassCopy(reporter, context2, $this$checkDataClassMembers, overriddenMemberSymbols, containingClass);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOverriddenExperimentalities(CheckerContext context2, DiagnosticReporter reporter, FirCallableSymbol<?> memberSymbol, List<? extends FirCallableSymbol<?>> overriddenMemberSymbols) {
        void $this$flatMapTo$iv$iv;
        FirOptInUsageBaseChecker $this$checkOverriddenExperimentalities_u24lambda_u240 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        Set overriddenExperimentalities = new LinkedHashSet();
        FirSession session = context2.getSession();
        Iterable $this$flatMap$iv = overriddenMemberSymbols;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
            boolean bl2 = false;
            FirCallableSymbol firCallableSymbol = it;
            Iterable list$iv$iv = firCallableSymbol instanceof FirIntersectionOverridePropertySymbol ? ((FirIntersectionOverridePropertySymbol)it).getIntersections() : (firCallableSymbol instanceof FirIntersectionOverrideFunctionSymbol ? ((FirIntersectionOverrideFunctionSymbol)it).getIntersections() : (Collection<FirCallableSymbol<Object>>)CollectionsKt.listOf((Object)it));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List overriddenSymbolsWithUnwrappedIntersectionOverrides = (List)destination$iv$iv;
        for (FirCallableSymbol overriddenMemberSymbol : overriddenSymbolsWithUnwrappedIntersectionOverrides) {
            $this$checkOverriddenExperimentalities_u24lambda_u240.loadExperimentalitiesFromAnnotationTo(overriddenMemberSymbol, session, overriddenExperimentalities);
        }
        $this$checkOverriddenExperimentalities_u24lambda_u240.reportNotAcceptedOverrideExperimentalities(context2, reporter, overriddenExperimentalities, memberSymbol);
    }

    /*
     * Unable to fully structure code
     */
    private final void reportNothingToOverride(CheckerContext context, DiagnosticReporter $this$reportNothingToOverride, FirCallableSymbol<?> declaration, FirTypeScope firTypeScope) {
        containingClassSymbol = ContainingClassUtilsKt.getContainingClassSymbol((FirBasedSymbol)declaration);
        var7_6 = declaration instanceof FirPropertySymbol != false ? FirScopeKt.getProperties(firTypeScope, ((FirPropertySymbol)declaration).getName()) : FirScopeKt.getFunctions(firTypeScope, declaration.getName());
        $i$f$filter = false;
        var9_8 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (FirCallableSymbol)element$iv$iv;
            $i$a$-filter-FirOverrideChecker$reportNothingToOverride$candidates$1 = false;
            $this$unwrapFakeOverrides$iv = it;
            $i$f$unwrapFakeOverrides = false;
            $this$unwrapFakeOverrides$iv$iv = (FirCallableDeclaration)$this$unwrapFakeOverrides$iv.getFir();
            $i$f$unwrapFakeOverrides = false;
            current$iv$iv = $this$unwrapFakeOverrides$iv$iv;
            while (true) {
                $this$originalIfFakeOverride$iv$iv$iv = current$iv$iv;
                $i$f$originalIfFakeOverride = false;
                $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                $i$f$getOriginalForSubstitutionOverride = false;
                if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
                $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
                $i$f$isSynthetic = false;
                if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                // 2 sources

                {
                    v0 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
                } else {
                    v0 = v1 = null;
                }
                if (v0 == null) {
                    $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                    $i$f$getBaseForIntersectionOverride = false;
                    v1 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                }
                if (v1 == null) break;
                current$iv$iv = next$iv$iv = v1;
            }
            v2 = current$iv$iv.getSymbol();
            if (v2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
            }
            if (Intrinsics.areEqual(ContainingClassUtilsKt.getContainingClassSymbol((FirBasedSymbol)v2), containingClassSymbol)) ** GOTO lbl-1000
            $this$isOpen$iv = it;
            $i$f$isOpen = false;
            if ($this$isOpen$iv.getResolvedStatus().getModality() == Modality.OPEN) ** GOTO lbl-1000
            $this$isAbstract$iv = it;
            $i$f$isAbstract = false;
            if ($this$isAbstract$iv.getResolvedStatus().getModality() == Modality.ABSTRACT) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        candidates = (List)destination$iv$iv;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, $this$reportNothingToOverride, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getNOTHING_TO_OVERRIDE(), declaration, (Object)candidates, null, 32, null);
    }

    private final void reportOverridingFinalMember(CheckerContext context2, DiagnosticReporter $this$reportOverridingFinalMember, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden) {
        block0: {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
            if (coneClassLikeLookupTag == null) break block0;
            ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, $this$reportOverridingFinalMember, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getOVERRIDING_FINAL_MEMBER(), overridden, (Object)containingClass.getName(), null, 32, null);
        }
    }

    private final void reportVarOverriddenByVal(CheckerContext context2, DiagnosticReporter $this$reportVarOverriddenByVal, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, $this$reportVarOverriddenByVal, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getVAR_OVERRIDDEN_BY_VAL(), overridden, overriding, null, 32, null);
    }

    private final void reportCannotWeakenAccessPrivilege(CheckerContext context2, DiagnosticReporter $this$reportCannotWeakenAccessPrivilege, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirCallableSymbol<?> $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, $this$reportCannotWeakenAccessPrivilege, (AbstractKtSourceElement)overriding.getSource(), this.chooseCannotWeakenAccessPrivilegeFor(overriding), (Object)$this$visibility$iv.getResolvedStatus().getVisibility(), overridden, (Object)containingClass.getName(), null, 64, null);
    }

    private final void reportCannotChangeAccessPrivilege(CheckerContext context2, DiagnosticReporter $this$reportCannotChangeAccessPrivilege, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirCallableSymbol<?> $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, $this$reportCannotChangeAccessPrivilege, (AbstractKtSourceElement)overriding.getSource(), this.chooseCannotChangeAccessPrivilegeFor(overriding), (Object)$this$visibility$iv.getResolvedStatus().getVisibility(), overridden, (Object)containingClass.getName(), null, 64, null);
    }

    private final void reportReturnTypeMismatchOnFunction(CheckerContext context2, DiagnosticReporter $this$reportReturnTypeMismatchOnFunction, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, $this$reportReturnTypeMismatchOnFunction, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, null, 32, null);
    }

    private final void reportTypeMismatchOnProperty(CheckerContext context2, DiagnosticReporter $this$reportTypeMismatchOnProperty, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, $this$reportTypeMismatchOnProperty, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, null, 32, null);
    }

    private final void reportTypeMismatchOnVariable(CheckerContext context2, DiagnosticReporter $this$reportTypeMismatchOnVariable, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, $this$reportTypeMismatchOnVariable, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getVAR_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, null, 32, null);
    }

    private static final void check$checkMember(FirOverrideChecker this$0, FirClass $declaration, DiagnosticReporter $reporter, CheckerContext $context, TypeCheckerState typeCheckerState, FirTypeScope firTypeScope, FirCallableSymbol<?> it) {
        block3: {
            KtSourceElement ktSourceElement;
            block5: {
                block4: {
                    KtSourceElement ktSourceElement2;
                    boolean isFromThis;
                    block2: {
                        boolean bl = isFromThis = this$0.consideredOrigins.contains(it.getOrigin()) && Intrinsics.areEqual((Object)ClassMembersKt.containingClassLookupTag(it), (Object)$declaration.getSymbol().toLookupTag());
                        if (!isFromThis || ClassMembersKt.isSubstitutionOverride(it)) break block2;
                        this$0.checkMember($reporter, $context, it, $declaration, typeCheckerState, firTypeScope);
                        break block3;
                    }
                    ktSourceElement = it.getSource();
                    if (ktSourceElement == null) break block4;
                    KtSourceElement it2 = ktSourceElement2 = ktSourceElement;
                    boolean bl = false;
                    ktSourceElement = isFromThis ? ktSourceElement2 : null;
                    if (ktSourceElement != null) break block5;
                }
                ktSourceElement = $declaration.getSource();
            }
            KtSourceElement source = ktSourceElement;
            this$0.ensureKnownVisibility($context, $reporter, it, source);
        }
    }

    private static final ProcessorAction checkDeprecation$lambda$2(String $callableName, CheckerContext $context, DiagnosticReporter $reporter, FirCallableSymbol $this_checkDeprecation, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (DeprecationUtilsKt.hiddenStatusOfCall(it, false, true) == CallToPotentiallyHiddenSymbolResult.VisibleWithDeprecation) {
            String message2 = FirDeprecationChecker.INSTANCE.getDeprecatedOverrideOfHiddenMessage$checkers($callableName);
            FirDeprecationInfo deprecationInfo2 = new FirDeprecationInfo(message2){
                final /* synthetic */ String $message;
                {
                    this.$message = $message;
                }

                public DeprecationLevelValue getDeprecationLevel() {
                    return DeprecationLevelValue.WARNING;
                }

                public boolean getPropagatesToOverrides() {
                    return false;
                }

                public String getMessage(FirSession session) {
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    return this.$message;
                }
            };
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)((FirNamedFunctionSymbol)$this_checkDeprecation).getSource(), FirErrors.INSTANCE.getOVERRIDE_DEPRECATION(), (Object)it, (Object)deprecationInfo2, null, 32, null);
            return ProcessorAction.STOP;
        }
        return ProcessorAction.NEXT;
    }

    public /* synthetic */ FirOverrideChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    public static final /* synthetic */ void access$check$checkMember(FirOverrideChecker this$0, FirClass $declaration, DiagnosticReporter $reporter, CheckerContext $context, TypeCheckerState typeCheckerState, FirTypeScope firTypeScope, FirCallableSymbol it) {
        FirOverrideChecker.check$checkMember(this$0, $declaration, $reporter, $context, typeCheckerState, firTypeScope, it);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirOverrideChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$ForExpectClass\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,611:1\n35#2:612\n*S KotlinDebug\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$ForExpectClass\n*L\n119#1:612\n*E\n"})
    public static final class ForExpectClass
    extends FirOverrideChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(context2, reporter, declaration);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$Regular;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirOverrideChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$Regular\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,611:1\n35#2:612\n*S KotlinDebug\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$Regular\n*L\n111#1:612\n*E\n"})
    public static final class Regular
    extends FirOverrideChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(context2, reporter, declaration);
        }
    }
}

