/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011R\u00020\nR\u00020\fj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/FirJvmNamesChecker;", "", "<init>", "()V", "INVALID_CHARS", "", "", "DANGEROUS_CHARS", "checkNameAndReport", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "name", "Lorg/jetbrains/kotlin/name/Name;", "declarationSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/KtSourceElement;)V", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmNamesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmNamesChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/FirJvmNamesChecker\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,48:1\n1106#2,2:49\n1106#2,2:51\n*S KotlinDebug\n*F\n+ 1 FirJvmNamesChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/FirJvmNamesChecker\n*L\n32#1:49,2\n38#1:51,2\n*E\n"})
public final class FirJvmNamesChecker {
    @NotNull
    public static final FirJvmNamesChecker INSTANCE = new FirJvmNamesChecker();
    @NotNull
    private static final Set<Character> INVALID_CHARS;
    @NotNull
    private static final Set<Character> DANGEROUS_CHARS;

    private FirJvmNamesChecker() {
    }

    public final void checkNameAndReport(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull Name name2, @Nullable KtSourceElement declarationSource) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (declarationSource != null && !(declarationSource.getKind() instanceof KtFakeSourceElementKind) && !name2.isSpecial()) {
            boolean bl;
            char it;
            char element$iv;
            int n2;
            boolean $i$f$any;
            CharSequence $this$any$iv;
            String nameString;
            block6: {
                String string = name2.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                nameString = string;
                $this$any$iv = nameString;
                $i$f$any = false;
                for (n2 = 0; n2 < $this$any$iv.length(); ++n2) {
                    it = element$iv = $this$any$iv.charAt(n2);
                    boolean bl2 = false;
                    if (!INVALID_CHARS.contains(Character.valueOf(it))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declarationSource, FirErrors.INSTANCE.getINVALID_CHARACTERS(), (Object)("contains illegal characters: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.intersect((Iterable)INVALID_CHARS, (Iterable)StringsKt.toSet((CharSequence)nameString)), (CharSequence)"", null, null, (int)0, null, null, (int)62, null)), null, 16, null);
            } else {
                boolean bl3;
                block7: {
                    $this$any$iv = nameString;
                    $i$f$any = false;
                    for (n2 = 0; n2 < $this$any$iv.length(); ++n2) {
                        it = element$iv = $this$any$iv.charAt(n2);
                        boolean bl4 = false;
                        if (!DANGEROUS_CHARS.contains(Character.valueOf(it))) continue;
                        bl3 = true;
                        break block7;
                    }
                    bl3 = false;
                }
                if (bl3) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declarationSource, FirJvmErrors.INSTANCE.getDANGEROUS_CHARACTERS(), (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.intersect((Iterable)DANGEROUS_CHARS, (Iterable)StringsKt.toSet((CharSequence)nameString)), (CharSequence)"", null, null, (int)0, null, null, (int)62, null), null, 16, null);
                }
            }
        }
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('.'), Character.valueOf(';'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\\')};
        INVALID_CHARS = SetsKt.setOf((Object[])objectArray);
        objectArray = new Character[]{Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('\"'), Character.valueOf('|'), Character.valueOf('%')};
        DANGEROUS_CHARS = SetsKt.setOf((Object[])objectArray);
    }
}

