/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInlineCheckerPlatformSpecificComponent;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirScriptSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ-\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0011JA\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0016H\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/FirJvmInlineCheckerComponent;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirInlineCheckerPlatformSpecificComponent;", "<init>", "()V", "isGenerallyOk", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "checkSuspendFunctionalParameterWithDefaultValue", "", "param", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)V", "checkFunctionalParametersWithInheritedDefaultValues", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "overriddenSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;Ljava/util/List;)V", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmInlineCheckerComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmInlineCheckerComponent.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/FirJvmInlineCheckerComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1390#2:66\n1479#2,2:67\n1605#2:69\n1616#2:70\n1923#2,2:71\n1925#2:75\n1617#2:76\n1481#2,3:77\n1923#2,3:80\n1#3:73\n1#3:74\n*S KotlinDebug\n*F\n+ 1 FirJvmInlineCheckerComponent.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/FirJvmInlineCheckerComponent\n*L\n48#1:66\n48#1:67,2\n50#1:69\n50#1:70\n50#1:71,2\n50#1:75\n50#1:76\n48#1:77,3\n54#1:80,3\n50#1:74\n*E\n"})
public final class FirJvmInlineCheckerComponent
extends FirInlineCheckerPlatformSpecificComponent {
    @Override
    public boolean isGenerallyOk(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (DeclarationUtilsKt.isLocalMember(declaration) && !(CollectionsKt.lastOrNull(context2.getContainingDeclarations()) instanceof FirScriptSymbol)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getNOT_YET_SUPPORTED_LOCAL_INLINE_FUNCTION(), null, 8, null);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    public void checkSuspendFunctionalParameterWithDefaultValue(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirValueParameter param) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)param.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Suspend functional parameters with default values", null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkFunctionalParametersWithInheritedDefaultValues(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirSimpleFunction function2, @NotNull List<? extends FirCallableSymbol<? extends FirCallableDeclaration>> overriddenSymbols) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter(overriddenSymbols, (String)"overriddenSymbols");
        Iterable $this$flatMap$iv = overriddenSymbols;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable iterable2;
            FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof FirFunctionSymbol)) {
                iterable2 = CollectionsKt.emptyList();
            } else {
                void $this$mapIndexedNotNullTo$iv$iv;
                Iterable $this$mapIndexedNotNull$iv = ((FirFunctionSymbol)it).getValueParameterSymbols();
                boolean $i$f$mapIndexedNotNull = false;
                Iterable iterable3 = $this$mapIndexedNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapIndexedNotNullTo = false;
                void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv$iv = 0;
                for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                    Integer it$iv$iv;
                    void param;
                    void element$iv$iv2;
                    int n2;
                    if ((n2 = index$iv$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t2 = item$iv$iv$iv;
                    int index$iv$iv = n2;
                    boolean bl2 = false;
                    FirValueParameterSymbol firValueParameterSymbol = (FirValueParameterSymbol)element$iv$iv2;
                    int idx = index$iv$iv;
                    boolean bl3 = false;
                    Integer n3 = idx;
                    int it2 = ((Number)n3).intValue();
                    boolean bl4 = false;
                    if ((param.getHasDefaultValue() ? n3 : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                iterable2 = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = iterable2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set paramsWithDefaults = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEachIndexed$iv = function2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param;
            int n4;
            Object element$iv$iv;
            if ((n4 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (FirValueParameter)item$iv;
            int idx = n4;
            boolean bl = false;
            if (param.getDefaultValue() != null || !paramsWithDefaults.contains(idx)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)param.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Functional parameters with inherited default values", null, 16, null);
        }
    }
}

