/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionAndScopeSessionHolder;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.NullableMap;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirTypeParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.resolve.FirOuterClassManager;
import org.jetbrains.kotlin.fir.resolve.FirSamConversionTransformerExtension;
import org.jetbrains.kotlin.fir.resolve.FirSamConversionTransformerExtensionKt;
import org.jetbrains.kotlin.fir.resolve.FirSamResolverKt;
import org.jetbrains.kotlin.fir.resolve.SAMInfo;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.FirSyntheticFunctionSymbol;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorByMapKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PublishedApiEffectiveVisibilityKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirFakeOverrideGenerator;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorInfo;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttribute;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u00011B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010!\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u0004\u0018\u00010\u00172\u0006\u0010(\u001a\u00020)J\u0010\u0010*\u001a\u0004\u0018\u00010\u00172\u0006\u0010+\u001a\u00020,J\u0010\u0010-\u001a\u00020.*\u0006\u0012\u0002\b\u00030\u0016H\u0002J\u0018\u0010/\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u00100\u001a\u00020\u0010H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00110\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R&\u0010\u0014\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0004\u0012\u00020\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirSamResolver;", "Lorg/jetbrains/kotlin/fir/SessionAndScopeSessionHolder;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "outerClassManager", "Lorg/jetbrains/kotlin/fir/resolve/FirOuterClassManager;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/resolve/FirOuterClassManager;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "resolvedFunctionType", "Lorg/jetbrains/kotlin/fir/caches/NullableMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/resolve/SAMInfo;", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "Ljava/util/Map;", "samConstructorsCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "samConversionTransformers", "", "Lorg/jetbrains/kotlin/fir/resolve/FirSamConversionTransformerExtension;", "isSamType", "", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getSamInfoForPossibleSamType", "Lorg/jetbrains/kotlin/fir/resolve/FirSamResolver$SamConversionInfo;", "getFunctionTypeForPossibleSamType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "getSamConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "firClassOrTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "buildSamConstructorForRegularClass", "classSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "buildSamConstructorForTypeAlias", "typeAliasSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeAliasSymbol;", "createSyntheticConstructorSymbol", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirSyntheticFunctionSymbol;", "resolveFunctionTypeIfSamInterface", "firRegularClass", "SamConversionInfo", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirSamResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSamResolver.kt\norg/jetbrains/kotlin/fir/resolve/FirSamResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 6 FirSimpleFunctionBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirSimpleFunctionBuilderKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 8 FirValueParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirValueParameterBuilderKt\n+ 9 NullableMap.kt\norg/jetbrains/kotlin/fir/caches/NullableMapKt\n+ 10 NullableMap.kt\norg/jetbrains/kotlin/fir/caches/NullableMap\n*L\n1#1,504:1\n1#2:505\n28#3:506\n20#3:534\n1585#4:507\n1660#4,3:508\n1585#4:511\n1660#4,3:512\n1585#4:515\n1660#4,3:516\n1585#4:519\n1660#4,2:520\n1662#4:523\n1585#4:525\n1660#4,3:526\n1585#4:535\n1660#4,3:536\n1585#4:539\n1660#4,3:540\n52#5:522\n52#5:531\n52#5:533\n83#6:524\n37#7,2:529\n75#8:532\n43#9:543\n44#9,2:546\n46#9:550\n27#10,2:544\n35#10,2:548\n29#10,3:551\n*S KotlinDebug\n*F\n+ 1 FirSamResolver.kt\norg/jetbrains/kotlin/fir/resolve/FirSamResolver\n*L\n134#1:506\n234#1:534\n148#1:507\n148#1:508,3\n166#1:511\n166#1:512,3\n170#1:515\n170#1:516,3\n177#1:519\n177#1:520,2\n177#1:523\n194#1:525\n194#1:526,3\n243#1:535\n243#1:536,3\n246#1:539\n246#1:540,3\n178#1:522\n202#1:531\n211#1:533\n187#1:524\n199#1:529,2\n207#1:532\n282#1:543\n282#1:546,2\n282#1:550\n282#1:544,2\n282#1:548,2\n282#1:551,3\n*E\n"})
public final class FirSamResolver
implements SessionAndScopeSessionHolder {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @Nullable
    private final FirOuterClassManager outerClassManager;
    @NotNull
    private final Map<FirRegularClass, Object> resolvedFunctionType;
    @NotNull
    private final FirCache<FirClassLikeSymbol<?>, FirNamedFunctionSymbol, FirSamResolver> samConstructorsCache;
    @NotNull
    private final List<FirSamConversionTransformerExtension> samConversionTransformers;

    public FirSamResolver(@NotNull FirSession session, @NotNull ScopeSession scopeSession, @Nullable FirOuterClassManager outerClassManager) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        this.session = session;
        this.scopeSession = scopeSession;
        this.outerClassManager = outerClassManager;
        this.resolvedFunctionType = NullableMap.constructor-impl$default(null, 1, null);
        this.samConstructorsCache = FirSamResolverKt.access$getSamConstructorStorage(this.getSession()).getSamConstructors();
        this.samConversionTransformers = FirSamConversionTransformerExtensionKt.getSamConversionTransformers(FirExtensionServiceKt.getExtensionService(this.getSession()));
    }

    public /* synthetic */ FirSamResolver(FirSession firSession, ScopeSession scopeSession, FirOuterClassManager firOuterClassManager, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            firOuterClassManager = null;
        }
        this(firSession, scopeSession, firOuterClassManager);
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    public final boolean isSamType(@NotNull ConeKotlinType type) {
        FirClassLikeSymbol<?> symbol;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ConeKotlinType coneKotlinType = type;
        return coneKotlinType instanceof ConeClassLikeType ? (symbol = ToSymbolUtilsKt.toSymbol((SessionHolder)this, TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)this, (ConeClassLikeType)type).getLookupTag())) instanceof FirRegularClassSymbol && this.resolveFunctionTypeIfSamInterface((FirRegularClass)((FirRegularClassSymbol)symbol).getFir()) != null : (coneKotlinType instanceof ConeFlexibleType ? this.isSamType(((ConeFlexibleType)type).getLowerBound()) && this.isSamType(((ConeFlexibleType)type).getUpperBound()) : false);
    }

    @Nullable
    public final SamConversionInfo getSamInfoForPossibleSamType(@NotNull ConeKotlinType type) {
        SamConversionInfo samConversionInfo;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ConeKotlinType coneKotlinType = type;
        if (coneKotlinType instanceof ConeClassLikeType) {
            ConeLookupTagBasedType coneLookupTagBasedType = this.getFunctionTypeForPossibleSamType(TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)this, (ConeClassLikeType)type));
            if (coneLookupTagBasedType == null) {
                return null;
            }
            samConversionInfo = new SamConversionInfo(coneLookupTagBasedType, type);
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            Object object = this.getSamInfoForPossibleSamType(((ConeFlexibleType)type).getLowerBound());
            if (object == null || (object = ((SamConversionInfo)object).getFunctionalType()) == null) {
                return null;
            }
            Object lowerType = object;
            if (((ConeFlexibleType)type).isTrivial()) {
                samConversionInfo = new SamConversionInfo(TypeUtilsKt.toTrivialFlexibleType(ConeTypeUtilsKt.lowerBoundIfFlexible((ConeKotlinType)lowerType), TypeComponentsKt.getTypeContext(this.getSession())), type);
            } else {
                Object object2 = this.getSamInfoForPossibleSamType(((ConeFlexibleType)type).getUpperBound());
                if (object2 == null || (object2 = ((SamConversionInfo)object2).getFunctionalType()) == null) {
                    return null;
                }
                Object upperType = object2;
                samConversionInfo = new SamConversionInfo(new ConeFlexibleType(ConeTypeUtilsKt.lowerBoundIfFlexible((ConeKotlinType)lowerType), ConeTypeUtilsKt.upperBoundIfFlexible((ConeKotlinType)upperType), false), type);
            }
        } else if (coneKotlinType instanceof ConeStubType || coneKotlinType instanceof ConeTypeParameterType || coneKotlinType instanceof ConeTypeVariableType || coneKotlinType instanceof ConeDefinitelyNotNullType || coneKotlinType instanceof ConeIntersectionType || coneKotlinType instanceof ConeIntegerLiteralType) {
            samConversionInfo = null;
        } else if (coneKotlinType instanceof ConeCapturedType) {
            ConeKotlinType coneKotlinType2 = ((ConeCapturedType)type).getConstructor().getLowerType();
            if (coneKotlinType2 != null) {
                ConeKotlinType it = coneKotlinType2;
                boolean bl = false;
                samConversionInfo = this.getSamInfoForPossibleSamType(it);
            } else {
                samConversionInfo = null;
            }
        } else {
            if (coneKotlinType instanceof ConeLookupTagBasedType) {
                AddToStdlibKt.unreachableBranch(type);
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
        return samConversionInfo;
    }

    private final ConeLookupTagBasedType getFunctionTypeForPossibleSamType(ConeClassLikeType type) {
        ConeKotlinType functionType;
        Object object = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)this, type.getLookupTag());
        if (object == null || (object = (FirRegularClass)((FirBasedSymbol)object).getFir()) == null) {
            return null;
        }
        Object firRegularClass = object;
        SAMInfo<ConeLookupTagBasedType> sAMInfo = this.resolveFunctionTypeIfSamInterface((FirRegularClass)firRegularClass);
        if (sAMInfo == null) {
            return null;
        }
        ConeLookupTagBasedType unsubstitutedFunctionType = sAMInfo.component2();
        ConeKotlinType coneKotlinType = FirSamResolverKt.access$buildSubstitutorWithUpperBounds((FirTypeParameterRefsOwner)firRegularClass, this.getSession(), type).substituteOrNull(unsubstitutedFunctionType);
        if (coneKotlinType == null) {
            coneKotlinType = unsubstitutedFunctionType;
        }
        if (!((functionType = coneKotlinType) instanceof ConeLookupTagBasedType)) {
            boolean bl = false;
            String string = "Function type should always be ConeLookupTagBasedType, but " + Reflection.getOrCreateKotlinClass(functionType.getClass()) + " was found";
            throw new IllegalArgumentException(string.toString());
        }
        return (ConeLookupTagBasedType)TypeUtilsKt.withNullabilityOf(functionType, type, TypeComponentsKt.getTypeContext(this.getSession()));
    }

    @Nullable
    public final FirSimpleFunction getSamConstructor(@NotNull FirClassLikeDeclaration firClassOrTypeAlias) {
        Intrinsics.checkNotNullParameter((Object)firClassOrTypeAlias, (String)"firClassOrTypeAlias");
        if (firClassOrTypeAlias instanceof FirTypeAlias) {
            FirClassLikeSymbol<?> firClassLikeSymbol;
            ConeClassLikeLookupTag coneClassLikeLookupTag;
            ConeClassLikeType coneClassLikeType;
            ConeClassLikeType coneClassLikeType2;
            FirTypeRef $this$coneTypeSafe$iv = ((FirTypeAlias)firClassOrTypeAlias).getSymbol().getResolvedExpandedTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((coneClassLikeType2 = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) != null && (coneClassLikeType = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)this, coneClassLikeType2)) != null && (coneClassLikeLookupTag = coneClassLikeType.getLookupTag()) != null && (firClassLikeSymbol = ToSymbolUtilsKt.toSymbol((SessionHolder)this, coneClassLikeLookupTag)) != null) {
                FirClassLikeSymbol<?> it = firClassLikeSymbol;
                boolean bl = false;
                this.samConstructorsCache.getValue(it, this);
            }
        }
        FirNamedFunctionSymbol firNamedFunctionSymbol = this.samConstructorsCache.getValue(firClassOrTypeAlias.getSymbol(), this);
        return firNamedFunctionSymbol != null ? (FirSimpleFunction)firNamedFunctionSymbol.getFir() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FirNamedFunctionSymbol buildSamConstructorForRegularClass(@NotNull FirRegularClassSymbol classSymbol) {
        FirSimpleFunction firSimpleFunction;
        void $this$buildSamConstructorForRegularClass_u24lambda_u244_u242_u240;
        FirValueParameterBuilder firValueParameterBuilder;
        void $this$buildSamConstructorForRegularClass_u24lambda_u244_u241;
        FirTypeParameterBuilder typeRef;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        Object object;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        FirAnnotationContainerBuilder newTypeParameter;
        void $this$mapTo$iv$iv;
        Iterator $this$map$iv;
        Object item$iv$iv3;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)classSymbol, (String)"classSymbol");
        FirRegularClass firRegularClass = (FirRegularClass)classSymbol.getFir();
        SAMInfo<ConeLookupTagBasedType> sAMInfo = this.resolveFunctionTypeIfSamInterface(firRegularClass);
        if (sAMInfo == null) {
            return null;
        }
        SAMInfo<ConeLookupTagBasedType> sAMInfo2 = sAMInfo;
        FirNamedFunctionSymbol functionSymbol2 = sAMInfo2.component1$resolve();
        ConeLookupTagBasedType functionType = sAMInfo2.component2();
        FirSyntheticFunctionSymbol syntheticFunctionSymbol = this.createSyntheticConstructorSymbol(classSymbol);
        Iterable $this$map$iv3 = firRegularClass.getTypeParameters();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
            FirTypeParameterBuilder firTypeParameterBuilder;
            void typeParameter;
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv2;
            collection = destination$iv$iv2;
            boolean bl = false;
            FirTypeParameter declaredTypeParameter = (FirTypeParameter)typeParameter.getSymbol().getFir();
            FirTypeParameterBuilder $this$buildSamConstructorForRegularClass_u24lambda_u240_u240 = firTypeParameterBuilder = new FirTypeParameterBuilder();
            boolean bl2 = false;
            KtSourceElement ktSourceElement = declaredTypeParameter.getSource();
            $this$buildSamConstructorForRegularClass_u24lambda_u240_u240.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.SamConstructor.INSTANCE, null, 2, null) : null);
            $this$buildSamConstructorForRegularClass_u24lambda_u240_u240.setModuleData(FirModuleDataKt.getModuleData(this.getSession()));
            $this$buildSamConstructorForRegularClass_u24lambda_u240_u240.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
            $this$buildSamConstructorForRegularClass_u24lambda_u240_u240.setResolvePhase(FirResolvePhase.Companion.getDECLARATIONS());
            $this$buildSamConstructorForRegularClass_u24lambda_u240_u240.setName(declaredTypeParameter.getName());
            $this$buildSamConstructorForRegularClass_u24lambda_u240_u240.setSymbol(new FirTypeParameterSymbol());
            $this$buildSamConstructorForRegularClass_u24lambda_u240_u240.setVariance(Variance.INVARIANT);
            $this$buildSamConstructorForRegularClass_u24lambda_u240_u240.setReified(false);
            CollectionsKt.addAll((Collection)$this$buildSamConstructorForRegularClass_u24lambda_u240_u240.getAnnotations(), (Iterable)declaredTypeParameter.getAnnotations());
            $this$buildSamConstructorForRegularClass_u24lambda_u240_u240.setContainingDeclarationSymbol(syntheticFunctionSymbol);
            collection.add(firTypeParameterBuilder);
        }
        List newTypeParameters = (List)destination$iv$iv2;
        Iterable $i$f$map22 = newTypeParameters;
        boolean $i$f$map32 = false;
        destination$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
            void it;
            FirTypeParameterBuilder bl = (FirTypeParameterBuilder)item$iv$iv3;
            collection = destination$iv$iv3;
            boolean bl3 = false;
            collection.add(new ConeTypeParameterTypeImpl(it.getSymbol().toLookupTag(), false, null, 4, null));
        }
        List newTypeParameterTypes = (List)destination$iv$iv3;
        Iterable $i$f$map32 = firRegularClass.getTypeParameters();
        boolean $i$f$map4 = false;
        destination$iv$iv3 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv4 : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameterRef bl3 = (FirTypeParameterRef)item$iv$iv4;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        ConeSubstitutor substitutor2 = ConeSubstitutorByMapKt.substitutorByMap$default(MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)((List)destination$iv$iv4), (Iterable)newTypeParameterTypes)), this.getSession(), false, 4, null);
        for (Pair $i$f$map4 : CollectionsKt.zip((Iterable)newTypeParameters, (Iterable)firRegularClass.getTypeParameters())) {
            void $this$mapTo$iv$iv4;
            newTypeParameter = (FirTypeParameterBuilder)$i$f$map4.component1();
            FirTypeParameterRef oldTypeParameter = (FirTypeParameterRef)$i$f$map4.component2();
            FirTypeParameter declared = (FirTypeParameter)oldTypeParameter.getSymbol().getFir();
            item$iv$iv3 = ((FirTypeParameterBuilder)newTypeParameter).getBounds();
            Iterable $this$map$iv4 = declared.getSymbol().getResolvedBounds();
            boolean $i$f$map5 = false;
            Iterable bl = $this$map$iv4;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv5 : $this$mapTo$iv$iv4) {
                object = (FirResolvedTypeRef)item$iv$iv5;
                collection = destination$iv$iv;
                boolean bl4 = false;
                boolean $i$f$buildResolvedTypeRef = false;
                firAnnotationContainerBuilder = new FirResolvedTypeRefBuilder();
                FirResolvedTypeRefBuilder $this$buildSamConstructorForRegularClass_u24lambda_u243_u240 = firAnnotationContainerBuilder;
                boolean bl5 = false;
                KtSourceElement ktSourceElement = ((FirResolvedTypeRef)((Object)typeRef)).getSource();
                $this$buildSamConstructorForRegularClass_u24lambda_u243_u240.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.SamConstructor.INSTANCE, null, 2, null) : null);
                $this$buildSamConstructorForRegularClass_u24lambda_u243_u240.setConeType(substitutor2.substituteOrSelf(((FirResolvedTypeRef)((Object)typeRef)).getConeType()));
                collection.add(((FirResolvedTypeRefBuilder)firAnnotationContainerBuilder).build());
            }
            $this$map$iv4 = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)item$iv$iv3, (Iterable)$this$map$iv4);
        }
        KtSourceElement ktSourceElement = firRegularClass.getSource();
        KtSourceElement fakeSource = ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.SamConstructor.INSTANCE, null, 2, null) : null;
        boolean $i$f$buildSimpleFunction = false;
        FirAnnotationContainerBuilder $this$buildSamConstructorForRegularClass_u24lambda_u244 = newTypeParameter = new FirSimpleFunctionBuilder();
        boolean bl = false;
        ((FirSimpleFunctionBuilder)$this$buildSamConstructorForRegularClass_u24lambda_u244).setModuleData(FirModuleDataKt.getModuleData(this.getSession()));
        ((FirSimpleFunctionBuilder)$this$buildSamConstructorForRegularClass_u24lambda_u244).setSource(fakeSource);
        ((FirSimpleFunctionBuilder)$this$buildSamConstructorForRegularClass_u24lambda_u244).setName(syntheticFunctionSymbol.getName());
        ((FirSimpleFunctionBuilder)$this$buildSamConstructorForRegularClass_u24lambda_u244).setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
        ((FirSimpleFunctionBuilder)$this$buildSamConstructorForRegularClass_u24lambda_u244).setStatus(UtilsKt.copy$default(firRegularClass.getStatus(), null, Modality.FINAL, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, null, 0x7FFFFD, null));
        ((FirSimpleFunctionBuilder)$this$buildSamConstructorForRegularClass_u24lambda_u244).setSymbol(syntheticFunctionSymbol);
        item$iv$iv3 = ((FirSimpleFunctionBuilder)$this$buildSamConstructorForRegularClass_u24lambda_u244).getTypeParameters();
        Iterable $this$map$iv5 = newTypeParameters;
        boolean $i$f$map6 = false;
        Iterable $this$mapTo$iv$iv4 = $this$map$iv5;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv5 : $this$mapTo$iv$iv4) {
            void it;
            typeRef = (FirTypeParameterBuilder)item$iv$iv5;
            Collection collection2 = destination$iv$iv;
            boolean bl6 = false;
            collection2.add(it.build());
        }
        $this$map$iv5 = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)item$iv$iv3, (Iterable)$this$map$iv5);
        ConeKotlinType substitutedFunctionType = substitutor2.substituteOrSelf(functionType);
        Collection $this$toTypedArray$iv = newTypeParameterTypes;
        boolean $i$f$toTypedArray22 = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        ConeClassLikeTypeImpl substitutedReturnType = new ConeClassLikeTypeImpl(firRegularClass.getSymbol().toLookupTag(), thisCollection$iv.toArray(new ConeTypeParameterTypeImpl[0]), false, null, 8, null);
        boolean $i$f$buildResolvedTypeRef = false;
        FirResolvedTypeRefBuilder $i$f$toTypedArray22 = new FirResolvedTypeRefBuilder();
        thisCollection$iv = $i$f$toTypedArray22;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder2 = $this$buildSamConstructorForRegularClass_u24lambda_u244;
        boolean bl7 = false;
        $this$buildSamConstructorForRegularClass_u24lambda_u244_u241.setSource(fakeSource);
        $this$buildSamConstructorForRegularClass_u24lambda_u244_u241.setConeType(substitutedReturnType);
        ((FirSimpleFunctionBuilder)firAnnotationContainerBuilder2).setReturnTypeRef($i$f$toTypedArray22.build());
        Collection collection3 = ((FirSimpleFunctionBuilder)$this$buildSamConstructorForRegularClass_u24lambda_u244).getValueParameters();
        boolean $i$f$buildValueParameter = false;
        FirValueParameterBuilder $this$buildSamConstructorForRegularClass_u24lambda_u244_u242 = firValueParameterBuilder = new FirValueParameterBuilder();
        boolean bl8 = false;
        $this$buildSamConstructorForRegularClass_u24lambda_u244_u242.setModuleData(FirModuleDataKt.getModuleData(this.getSession()));
        $this$buildSamConstructorForRegularClass_u24lambda_u244_u242.setContainingDeclarationSymbol(syntheticFunctionSymbol);
        $this$buildSamConstructorForRegularClass_u24lambda_u244_u242.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
        boolean $i$f$buildResolvedTypeRef2 = false;
        Object bl6 = object = new FirResolvedTypeRefBuilder();
        firAnnotationContainerBuilder = $this$buildSamConstructorForRegularClass_u24lambda_u244_u242;
        boolean bl9 = false;
        $this$buildSamConstructorForRegularClass_u24lambda_u244_u242_u240.setSource(fakeSource);
        $this$buildSamConstructorForRegularClass_u24lambda_u244_u242_u240.setConeType(substitutedFunctionType);
        ((FirValueParameterBuilder)firAnnotationContainerBuilder).setReturnTypeRef(((FirResolvedTypeRefBuilder)object).build());
        $this$buildSamConstructorForRegularClass_u24lambda_u244_u242.setName(FirSamResolverKt.access$getSAM_PARAMETER_NAME$p());
        $this$buildSamConstructorForRegularClass_u24lambda_u244_u242.setSymbol(new FirValueParameterSymbol());
        $this$buildSamConstructorForRegularClass_u24lambda_u244_u242.setCrossinline(false);
        $this$buildSamConstructorForRegularClass_u24lambda_u244_u242.setNoinline(false);
        $this$buildSamConstructorForRegularClass_u24lambda_u244_u242.setVararg(false);
        $this$buildSamConstructorForRegularClass_u24lambda_u244_u242.setResolvePhase(FirResolvePhase.BODY_RESOLVE);
        FirValueParameter firValueParameter = firValueParameterBuilder.build();
        collection3.add(firValueParameter);
        CollectionsKt.addAll((Collection)((FirSimpleFunctionBuilder)$this$buildSamConstructorForRegularClass_u24lambda_u244).getAnnotations(), (Iterable)functionSymbol2.getAnnotations());
        ((FirSimpleFunctionBuilder)$this$buildSamConstructorForRegularClass_u24lambda_u244).setResolvePhase(FirResolvePhase.BODY_RESOLVE);
        FirSimpleFunction $this$buildSamConstructorForRegularClass_u24lambda_u245 = firSimpleFunction = ((FirSimpleFunctionBuilder)newTypeParameter).build();
        boolean bl10 = false;
        Object object2 = this.outerClassManager;
        ClassMembersKt.setContainingClassForStaticMemberAttr($this$buildSamConstructorForRegularClass_u24lambda_u245, object2 != null && (object2 = ((FirOuterClassManager)object2).outerClass(firRegularClass.getSymbol())) != null ? ((FirClassLikeSymbol)object2).toLookupTag() : null);
        PublishedApiEffectiveVisibilityKt.setNonLazyPublishedApiEffectiveVisibility($this$buildSamConstructorForRegularClass_u24lambda_u245, PublishedApiEffectiveVisibilityKt.getNonLazyPublishedApiEffectiveVisibility(firRegularClass));
        return firSimpleFunction.getSymbol();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FirNamedFunctionSymbol buildSamConstructorForTypeAlias(@NotNull FirTypeAliasSymbol typeAliasSymbol) {
        FirSession $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)typeAliasSymbol, (String)"typeAliasSymbol");
        FirTypeRef $this$coneTypeUnsafe$iv = ((FirTypeAlias)typeAliasSymbol.getFir()).getExpandedTypeRef();
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getConeType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeClassLikeType");
        }
        ConeClassLikeType type = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)this, (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)));
        Object object = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)this, type.getLookupTag());
        if (object == null || (object = (FirRegularClass)((FirBasedSymbol)object).getFir()) == null) {
            return null;
        }
        Object expansionRegularClass = object;
        FirSimpleFunction firSimpleFunction = this.getSamConstructor((FirClassLikeDeclaration)expansionRegularClass);
        if (firSimpleFunction == null) {
            return null;
        }
        FirSimpleFunction samConstructorForClass = firSimpleFunction;
        ConeSubstitutor substitutor2 = FirSamResolverKt.access$buildSubstitutorWithUpperBounds(samConstructorForClass, this.getSession(), type);
        Iterable $this$map$iv = samConstructorForClass.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(substitutor2.substituteOrSelf(FirTypeUtilsKt.getConeType(it.getReturnTypeRef())));
        }
        List newParameterTypes = (List)destination$iv$iv;
        Iterable $this$map$iv2 = samConstructorForClass.getContextParameters();
        boolean $i$f$map22 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirValueParameter bl = (FirValueParameter)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(substitutor2.substituteOrSelf(FirTypeUtilsKt.getConeType(it.getReturnTypeRef())));
        }
        List newContextParameterTypes = (List)destination$iv$iv2;
        Object object2 = FirFakeOverrideGenerator.INSTANCE;
        FirSyntheticFunctionSymbol $i$f$map22 = this.createSyntheticConstructorSymbol(typeAliasSymbol);
        $this$mapTo$iv$iv = this.getSession();
        FirDeclarationOrigin.SamConstructor samConstructor = FirDeclarationOrigin.SamConstructor.INSTANCE;
        ConeClassLikeType coneClassLikeType = (ConeClassLikeType)TypeUtilsKt.withAbbreviation((ConeKotlinType)type, new AbbreviatedTypeAttribute(ScopeUtilsKt.defaultType(typeAliasSymbol)));
        List<FirTypeParameterRef> list = ((FirTypeAlias)typeAliasSymbol.getFir()).getTypeParameters();
        Object it = object2 = FirFakeOverrideGenerator.createCopyForFirFunction$default((FirFakeOverrideGenerator)object2, $i$f$map22, samConstructorForClass, null, $this$mapTo$iv$iv, samConstructor, false, null, newParameterTypes, list, null, newContextParameterTypes, coneClassLikeType, null, null, null, null, true, 61472, null);
        boolean bl = false;
        TypeAliasConstructorsSubstitutingScopeKt.setTypeAliasConstructorInfo((FirFunction)it, new TypeAliasConstructorInfo<FirFunction>(samConstructorForClass, typeAliasSymbol, null));
        PublishedApiEffectiveVisibilityKt.setNonLazyPublishedApiEffectiveVisibility((FirDeclaration)it, PublishedApiEffectiveVisibilityKt.getNonLazyPublishedApiEffectiveVisibility((FirDeclaration)expansionRegularClass));
        return ((FirSimpleFunction)object2).getSymbol();
    }

    /*
     * WARNING - void declaration
     */
    private final FirSyntheticFunctionSymbol createSyntheticConstructorSymbol(FirClassLikeSymbol<?> $this$createSyntheticConstructorSymbol) {
        void it;
        FqName fqName;
        FqName fqName2 = fqName = $this$createSyntheticConstructorSymbol.getClassId().getRelativeClassName().parent();
        FqName fqName3 = $this$createSyntheticConstructorSymbol.getClassId().getPackageFqName();
        boolean bl = false;
        boolean bl2 = !it.isRoot();
        Name name2 = $this$createSyntheticConstructorSymbol.getClassId().getShortClassName();
        FqName fqName4 = bl2 ? fqName : null;
        FqName fqName5 = fqName3;
        CallableId callableId = new CallableId(fqName5, fqName4, name2);
        return new FirSyntheticFunctionSymbol(callableId);
    }

    /*
     * WARNING - void declaration
     */
    private final SAMInfo<ConeLookupTagBasedType> resolveFunctionTypeIfSamInterface(FirRegularClass firRegularClass) {
        SAMInfo<ConeKotlinType> sAMInfo;
        void $v$c$org-jetbrains-kotlin-fir-caches-NullableMap$-this$0$iv$iv;
        void $v$c$org-jetbrains-kotlin-fir-caches-NullableMap$-$this$getOrPut$0$iv;
        Map<FirRegularClass, Object> map = this.resolvedFunctionType;
        FirRegularClass key$iv = firRegularClass;
        boolean bl = false;
        void var5_5 = $v$c$org-jetbrains-kotlin-fir-caches-NullableMap$-$this$getOrPut$0$iv;
        FirRegularClass key$iv$iv = key$iv;
        boolean bl2 = false;
        Object value$iv$iv = $v$c$org-jetbrains-kotlin-fir-caches-NullableMap$-this$0$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            void key$iv$iv2;
            SAMInfo<ConeKotlinType> sAMInfo2;
            SAMInfo<ConeKotlinType> sAMInfo3;
            boolean bl3 = false;
            boolean bl4 = false;
            if (!firRegularClass.getStatus().isFun()) {
                sAMInfo3 = null;
            } else {
                FirSimpleFunction firSimpleFunction = FirSamResolverKt.access$getSingleAbstractMethodOrNull(firRegularClass, this.getSession(), this.getScopeSession());
                if (firSimpleFunction == null) {
                    sAMInfo3 = null;
                } else {
                    ConeLookupTagBasedType coneLookupTagBasedType;
                    FirSimpleFunction abstractMethod;
                    block9: {
                        abstractMethod = firSimpleFunction;
                        for (FirSamConversionTransformerExtension it : (Iterable)this.samConversionTransformers) {
                            boolean bl5 = false;
                            ConeLookupTagBasedType coneLookupTagBasedType2 = it.getCustomFunctionTypeForSamConversion(abstractMethod);
                            if (coneLookupTagBasedType2 == null) continue;
                            coneLookupTagBasedType = coneLookupTagBasedType2;
                            break block9;
                        }
                        coneLookupTagBasedType = null;
                    }
                    ConeLookupTagBasedType typeFromExtension = coneLookupTagBasedType;
                    FirNamedFunctionSymbol firNamedFunctionSymbol = abstractMethod.getSymbol();
                    ConeLookupTagBasedType coneLookupTagBasedType3 = typeFromExtension;
                    if (coneLookupTagBasedType3 == null) {
                        coneLookupTagBasedType3 = FirSamResolverKt.access$getFunctionTypeForAbstractMethod(abstractMethod, this.getSession());
                    }
                    sAMInfo3 = new SAMInfo<ConeKotlinType>(firNamedFunctionSymbol, coneLookupTagBasedType3);
                }
            }
            SAMInfo<ConeKotlinType> it$iv = sAMInfo2 = sAMInfo3;
            boolean bl6 = false;
            void var19_19 = $v$c$org-jetbrains-kotlin-fir-caches-NullableMap$-$this$getOrPut$0$iv;
            FirRegularClass firRegularClass2 = key$iv;
            SAMInfo<ConeKotlinType> value$iv$iv2 = it$iv;
            boolean bl7 = false;
            SAMInfo<ConeKotlinType> sAMInfo4 = value$iv$iv2;
            if (sAMInfo4 == null) {
                sAMInfo4 = NullableMap.NullValue.INSTANCE;
            }
            $v$c$org-jetbrains-kotlin-fir-caches-NullableMap$-this$0$iv$iv.put(key$iv$iv2, sAMInfo4);
            sAMInfo = sAMInfo2;
        } else {
            sAMInfo = Intrinsics.areEqual(value$iv$iv, (Object)NullableMap.NullValue.INSTANCE) ? null : (SAMInfo<ConeKotlinType>)value$iv$iv;
        }
        return sAMInfo;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirSamResolver$SamConversionInfo;", "", "functionalType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "samType", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "getFunctionalType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getSamType", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "resolve"})
    public static final class SamConversionInfo {
        @NotNull
        private final ConeKotlinType functionalType;
        @NotNull
        private final ConeKotlinType samType;

        public SamConversionInfo(@NotNull ConeKotlinType functionalType, @NotNull ConeKotlinType samType) {
            Intrinsics.checkNotNullParameter((Object)functionalType, (String)"functionalType");
            Intrinsics.checkNotNullParameter((Object)samType, (String)"samType");
            this.functionalType = functionalType;
            this.samType = samType;
        }

        @NotNull
        public final ConeKotlinType getFunctionalType() {
            return this.functionalType;
        }

        @NotNull
        public final ConeKotlinType getSamType() {
            return this.samType;
        }

        @NotNull
        public final ConeKotlinType component1() {
            return this.functionalType;
        }

        @NotNull
        public final ConeKotlinType component2() {
            return this.samType;
        }

        @NotNull
        public final SamConversionInfo copy(@NotNull ConeKotlinType functionalType, @NotNull ConeKotlinType samType) {
            Intrinsics.checkNotNullParameter((Object)functionalType, (String)"functionalType");
            Intrinsics.checkNotNullParameter((Object)samType, (String)"samType");
            return new SamConversionInfo(functionalType, samType);
        }

        public static /* synthetic */ SamConversionInfo copy$default(SamConversionInfo samConversionInfo, ConeKotlinType coneKotlinType, ConeKotlinType coneKotlinType2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                coneKotlinType = samConversionInfo.functionalType;
            }
            if ((n2 & 2) != 0) {
                coneKotlinType2 = samConversionInfo.samType;
            }
            return samConversionInfo.copy(coneKotlinType, coneKotlinType2);
        }

        @NotNull
        public String toString() {
            return "SamConversionInfo(functionalType=" + this.functionalType + ", samType=" + this.samType + ')';
        }

        public int hashCode() {
            int result2 = this.functionalType.hashCode();
            result2 = result2 * 31 + this.samType.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SamConversionInfo)) {
                return false;
            }
            SamConversionInfo samConversionInfo = (SamConversionInfo)other;
            if (!Intrinsics.areEqual((Object)this.functionalType, (Object)samConversionInfo.functionalType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.samType, (Object)samConversionInfo.samType);
        }
    }
}

