/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.DslScopeViolation;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitValue;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStagesKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirReceiverParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JQ\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0013J/\u0010\u0014\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0019J3\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001eJ+\u0010\u001f\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00180 2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010!J1\u0010\u001f\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00180 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010%\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/CheckDslScopeViolation;", "", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "context", "receiverValueExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "boundSymbolOfReceiverToCheck", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "closerOrOnTheSameLevelImplicitValues", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitValue;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Ljava/util/List;)V", "containsAnyOfGivenDslMarkers", "", "otherDslMarkers", "", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitValue;Ljava/util/Set;)Z", "getDslMarkersOfImplicitValue", "boundSymbol", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Ljava/util/Set;", "collectDslMarkerAnnotations", "", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Ljava/util/Set;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "annotations", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Ljava/util/Set;Ljava/util/Collection;)V", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckDslScopeViolation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1140:1\n1#2:1141\n1806#3,3:1142\n1806#3,3:1145\n1914#3,2:1148\n1914#3,2:1150\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckDslScopeViolation\n*L\n506#1:1142,3\n516#1:1145,3\n572#1:1148,2\n576#1:1150,2\n*E\n"})
final class CheckDslScopeViolation {
    @NotNull
    public static final CheckDslScopeViolation INSTANCE = new CheckDslScopeViolation();

    private CheckDslScopeViolation() {
    }

    public final void check(@NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull FirExpression receiverValueExpression, @NotNull Candidate candidate2, @NotNull FirBasedSymbol<?> boundSymbolOfReceiverToCheck, @NotNull List<? extends ImplicitValue<?>> closerOrOnTheSameLevelImplicitValues) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)receiverValueExpression, (String)"receiverValueExpression");
            Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
            Intrinsics.checkNotNullParameter(boundSymbolOfReceiverToCheck, (String)"boundSymbolOfReceiverToCheck");
            Intrinsics.checkNotNullParameter(closerOrOnTheSameLevelImplicitValues, (String)"closerOrOnTheSameLevelImplicitValues");
            Collection collection = this.getDslMarkersOfImplicitValue(context2, boundSymbolOfReceiverToCheck, FirTypeUtilsKt.getResolvedType(receiverValueExpression));
            if (collection.isEmpty()) {
                boolean bl2 = false;
                return;
            }
            Set dslMarkers = (Set)collection;
            Iterable $this$any$iv = closerOrOnTheSameLevelImplicitValues;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ImplicitValue it = (ImplicitValue)element$iv;
                    boolean bl3 = false;
                    if (!(!it.isSameImplicitReceiverInstance(receiverValueExpression) && INSTANCE.containsAnyOfGivenDslMarkers(context2, it, dslMarkers))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            sink.reportDiagnostic(new DslScopeViolation(candidate2.getSymbol()));
        }
    }

    private final boolean containsAnyOfGivenDslMarkers(ResolutionContext context2, ImplicitValue<?> $this$containsAnyOfGivenDslMarkers, Set<ClassId> otherDslMarkers) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getDslMarkersOfImplicitValue(context2, (FirBasedSymbol<?>)$this$containsAnyOfGivenDslMarkers.getBoundSymbol(), $this$containsAnyOfGivenDslMarkers.getType());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClassId it = (ClassId)element$iv;
                    boolean bl2 = false;
                    if (!otherDslMarkers.contains(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final Set<ClassId> getDslMarkersOfImplicitValue(ResolutionContext context2, FirBasedSymbol<?> boundSymbol, ConeKotlinType type) {
        Set set;
        Set $this$getDslMarkersOfImplicitValue_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        FirBasedSymbol firBasedSymbol = ResolutionStagesKt.access$containingDeclarationIfParameter(boundSymbol);
        FirAnonymousFunctionSymbol firAnonymousFunctionSymbol = firBasedSymbol instanceof FirAnonymousFunctionSymbol ? (FirAnonymousFunctionSymbol)firBasedSymbol : null;
        if (firAnonymousFunctionSymbol != null) {
            FirAnonymousFunctionSymbol anonymousFunctionSymbol = firAnonymousFunctionSymbol;
            boolean bl2 = false;
            ConeKotlinType coneKotlinType = ClassMembersKt.getMatchingParameterFunctionType((FirAnonymousFunction)anonymousFunctionSymbol.getFir());
            if (coneKotlinType != null) {
                ConeKotlinType matchingParameterFunctionType = coneKotlinType;
                INSTANCE.collectDslMarkerAnnotations(context2, (Set<ClassId>)$this$getDslMarkersOfImplicitValue_u24lambda_u240, (Collection<? extends FirAnnotation>)CustomAnnotationTypeAttributeKt.getCustomAnnotations(matchingParameterFunctionType));
                if (boundSymbol instanceof FirValueParameterSymbol) {
                    int index = anonymousFunctionSymbol.getContextParameterSymbols().indexOf(boundSymbol);
                    ConeKotlinType coneKotlinType2 = (ConeKotlinType)CollectionsKt.getOrNull(FunctionalTypeUtilsKt.contextParameterTypes(matchingParameterFunctionType, context2.getSession()), (int)index);
                    if (coneKotlinType2 != null) {
                        ConeKotlinType contextType = coneKotlinType2;
                        boolean bl3 = false;
                        INSTANCE.collectDslMarkerAnnotations(context2, (Set<ClassId>)$this$getDslMarkersOfImplicitValue_u24lambda_u240, contextType);
                    }
                }
                if (boundSymbol instanceof FirReceiverParameterSymbol) {
                    ConeKotlinType coneKotlinType3 = FunctionalTypeUtilsKt.receiverType(matchingParameterFunctionType, context2.getSession());
                    if (coneKotlinType3 != null) {
                        ConeKotlinType receiverType = coneKotlinType3;
                        boolean bl4 = false;
                        INSTANCE.collectDslMarkerAnnotations(context2, (Set<ClassId>)$this$getDslMarkersOfImplicitValue_u24lambda_u240, receiverType);
                    }
                }
            }
        }
        INSTANCE.collectDslMarkerAnnotations(context2, (Set<ClassId>)$this$getDslMarkersOfImplicitValue_u24lambda_u240, type);
        return SetsKt.build((Set)set);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void collectDslMarkerAnnotations(ResolutionContext context2, Set<ClassId> $this$collectDslMarkerAnnotations, ConeKotlinType type) {
        ConeKotlinType originalType = AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(type);
        this.collectDslMarkerAnnotations(context2, $this$collectDslMarkerAnnotations, (Collection<? extends FirAnnotation>)CustomAnnotationTypeAttributeKt.getCustomAnnotations(originalType));
        ConeKotlinType coneKotlinType = originalType;
        if (coneKotlinType instanceof ConeFlexibleType) {
            this.collectDslMarkerAnnotations(context2, $this$collectDslMarkerAnnotations, ((ConeFlexibleType)originalType).getLowerBound());
            this.collectDslMarkerAnnotations(context2, $this$collectDslMarkerAnnotations, ((ConeFlexibleType)originalType).getUpperBound());
            return;
        } else if (coneKotlinType instanceof ConeCapturedType) {
            if (((ConeCapturedType)originalType).getConstructor().getProjection().getKind() != ProjectionKind.OUT) return;
            List<ConeKotlinType> list = ((ConeCapturedType)originalType).getConstructor().getSupertypes();
            if (list == null) return;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                INSTANCE.collectDslMarkerAnnotations(context2, $this$collectDslMarkerAnnotations, it);
            }
            return;
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            this.collectDslMarkerAnnotations(context2, $this$collectDslMarkerAnnotations, ((ConeDefinitelyNotNullType)originalType).getOriginal());
            return;
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            Iterable $this$forEach$iv = ((ConeIntersectionType)originalType).getIntersectedTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                INSTANCE.collectDslMarkerAnnotations(context2, $this$collectDslMarkerAnnotations, it);
            }
            return;
        } else {
            if (!(coneKotlinType instanceof ConeClassLikeType)) return;
            FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol((SessionHolder)context2, (ConeClassLikeType)originalType);
            if (firClassLikeSymbol == null) {
                return;
            }
            FirClassLikeSymbol<?> classDeclaration = firClassLikeSymbol;
            this.collectDslMarkerAnnotations(context2, $this$collectDslMarkerAnnotations, (Collection<? extends FirAnnotation>)classDeclaration.getResolvedAnnotationsWithClassIds());
            FirClassLikeSymbol<?> firClassLikeSymbol2 = classDeclaration;
            if (firClassLikeSymbol2 instanceof FirClassSymbol) {
                for (ConeKotlinType superType : ((FirClassSymbol)classDeclaration).getResolvedSuperTypes()) {
                    this.collectDslMarkerAnnotations(context2, $this$collectDslMarkerAnnotations, superType);
                }
                return;
            } else {
                if (!(firClassLikeSymbol2 instanceof FirTypeAliasSymbol)) throw new NoWhenBranchMatchedException();
                ConeClassLikeType coneClassLikeType = TypeExpansionUtilsKt.directExpansionType$default((ConeClassLikeType)originalType, context2.getSession(), null, 2, null);
                if (coneClassLikeType == null) return;
                ConeClassLikeType it = coneClassLikeType;
                boolean bl = false;
                INSTANCE.collectDslMarkerAnnotations(context2, $this$collectDslMarkerAnnotations, it);
            }
        }
    }

    private final void collectDslMarkerAnnotations(ResolutionContext context2, Set<ClassId> $this$collectDslMarkerAnnotations, Collection<? extends FirAnnotation> annotations2) {
        for (FirAnnotation firAnnotation : annotations2) {
            FirClassSymbol<?> annotationClass;
            if (ToSymbolUtilsKt.toClassSymbol((SessionHolder)context2, TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, FirTypeUtilsKt.getConeType(firAnnotation.getAnnotationTypeRef()))) == null || !FirAnnotationUtilsKt.hasAnnotation((FirBasedSymbol)annotationClass, StandardClassIds.Annotations.INSTANCE.getDslMarker(), context2.getSession())) continue;
            $this$collectDslMarkerAnnotations.add(annotationClass.getClassId());
        }
    }
}

