/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.InapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.calls.MultipleContextReceiversApplicableForExtensionReceivers;
import org.jetbrains.kotlin.fir.resolve.calls.NoReceiverAllowed;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ArgumentCheckingProcessor;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ImplicitArgumentDescription;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStagesKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0096@R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJD\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0082@R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0012*\u00020\u000bH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/CheckExtensionReceiver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStage;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "context", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolveExtensionReceiver", "receivers", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ImplicitArgumentDescription;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Ljava/util/List;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getExpectedReceiverType", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckExtensionReceiver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CheckerSink.kt\norg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSinkKt\n*L\n1#1,1140:1\n1585#2:1141\n1660#2,3:1142\n776#2:1145\n872#2,2:1146\n29#3,2:1148\n23#3,9:1150\n29#3,2:1159\n23#3,9:1161\n23#3,4:1170\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckExtensionReceiver\n*L\n82#1:1141\n82#1:1142,3\n91#1:1145\n91#1:1146,2\n96#1:1148,2\n96#1:1150,9\n98#1:1159,2\n98#1:1161,9\n124#1:1170,4\n*E\n"})
public final class CheckExtensionReceiver
extends ResolutionStage {
    @NotNull
    public static final CheckExtensionReceiver INSTANCE = new CheckExtensionReceiver();

    private CheckExtensionReceiver() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object check(@NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Candidate candidate2, @NotNull Continuation<? super Unit> $completion) {
        ResolutionDiagnostic diagnostic$iv;
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        FirElement callSite = candidate2.getCallInfo().getCallSite();
        if (callSite instanceof FirImplicitInvokeCall) {
            boolean isInvokeFromExtensionFunctionType = ResolutionStagesKt.isInvokeFromExtensionFunctionType(candidate2);
            boolean isImplicitInvokeCallWithExplicitReceiver = ((FirImplicitInvokeCall)callSite).isCallWithExplicitReceiver();
            if (!isInvokeFromExtensionFunctionType && isImplicitInvokeCallWithExplicitReceiver) {
                sink.reportDiagnostic(NoReceiverAllowed.INSTANCE);
            }
        }
        ConeKotlinType coneKotlinType = this.getExpectedReceiverType(candidate2);
        if (coneKotlinType == null) {
            return Unit.INSTANCE;
        }
        ConeKotlinType expectedReceiverType = coneKotlinType;
        ConeKotlinType expectedType = candidate2.getSubstitutor().substituteOrSelf(expectedReceiverType);
        if (candidate2.getGivenExtensionReceiverOptions().isEmpty()) {
            return Unit.INSTANCE;
        }
        Iterable $this$map$iv = candidate2.getGivenExtensionReceiverOptions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConeResolutionAtom coneResolutionAtom = (ConeResolutionAtom)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ResolutionStagesKt.access$prepareImplicitArgument((ConeResolutionAtom)it, expectedType, context2.getSession()));
        }
        List preparedReceivers = (List)destination$iv$iv;
        if (preparedReceivers.size() == 1) {
            Object object = this.resolveExtensionReceiver(sink, context2, preparedReceivers, candidate2, expectedType, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Iterable $this$filter$iv = preparedReceivers;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ImplicitArgumentDescription it = (ImplicitArgumentDescription)element$iv$iv;
            boolean bl = false;
            if (!ConstraintSystemBuilderKt.isSubtypeConstraintCompatible(candidate2.getSystem(), it.getType(), expectedType)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List successfulReceivers = (List)destination$iv$iv2;
        switch (successfulReceivers.size()) {
            case 0: {
                void $this$yieldDiagnostic$iv;
                CheckerSink $i$f$filter2 = sink;
                diagnostic$iv = new InapplicableWrongReceiver(null, null, 3, null);
                boolean $i$f$yieldDiagnostic = false;
                $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
                void $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
                boolean $i$f$yieldIfNeed = false;
                if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
                    Object object = $this$yieldIfNeed$iv$iv.yield($completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                }
                return Unit.INSTANCE;
            }
            case 1: {
                Object object = this.resolveExtensionReceiver(sink, context2, successfulReceivers, candidate2, expectedType, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }
        CheckerSink $this$yieldDiagnostic$iv = sink;
        diagnostic$iv = new MultipleContextReceiversApplicableForExtensionReceivers();
        boolean $i$f$yieldDiagnostic = false;
        $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
        CheckerSink $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
        boolean $i$f$yieldIfNeed = false;
        if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
            Object object = $this$yieldIfNeed$iv$iv.yield($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        }
        return Unit.INSTANCE;
    }

    private final Object resolveExtensionReceiver(CheckerSink sink, ResolutionContext context2, List<ImplicitArgumentDescription> receivers, Candidate candidate2, ConeKotlinType expectedType, Continuation<? super Unit> $completion) {
        ImplicitArgumentDescription implicitArgumentDescription = (ImplicitArgumentDescription)CollectionsKt.single(receivers);
        ConeResolutionAtom atom = implicitArgumentDescription.component1();
        ConeKotlinType type = implicitArgumentDescription.component2();
        ArgumentCheckingProcessor.INSTANCE.resolvePlainArgumentType(candidate2, atom, type, expectedType, sink, context2, true, false, candidate2.getCallInfo().getCallSite().getSource());
        candidate2.setChosenExtensionReceiver(atom);
        CheckerSink $this$yieldIfNeed$iv = sink;
        boolean $i$f$yieldIfNeed = false;
        if ($this$yieldIfNeed$iv.getNeedYielding()) {
            Object object = $this$yieldIfNeed$iv.yield($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        }
        return Unit.INSTANCE;
    }

    private final ConeKotlinType getExpectedReceiverType(Candidate $this$getExpectedReceiverType) {
        FirBasedSymbol<?> firBasedSymbol = $this$getExpectedReceiverType.getSymbol();
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (firCallableSymbol == null) {
            return null;
        }
        FirCallableSymbol callableSymbol = firCallableSymbol;
        FirPureAbstractElement firPureAbstractElement = ((FirCallableDeclaration)callableSymbol.getFir()).getReceiverParameter();
        return firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null ? FirTypeUtilsKt.getConeType((FirTypeRef)firPureAbstractElement) : null;
    }

    public static final /* synthetic */ Object access$resolveExtensionReceiver(CheckExtensionReceiver $this, CheckerSink sink, ResolutionContext context2, List receivers, Candidate candidate2, ConeKotlinType expectedType, Continuation $completion) {
        return $this.resolveExtensionReceiver(sink, context2, receivers, candidate2, expectedType, (Continuation<? super Unit>)$completion);
    }
}

