/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\n\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u001e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenSelfTypeExhaustivenessChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker;", "<init>", "()V", "isApplicable", "", "subjectType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "computeMissingCases", "", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "destination", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "isExhaustiveThroughSelfTypeCheck", "equals", "other", "", "hashCode", "", "toString", "", "ConditionChecker", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessComputer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenSelfTypeExhaustivenessChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,680:1\n1806#2,3:681\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessComputer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenSelfTypeExhaustivenessChecker\n*L\n658#1:681,3\n*E\n"})
final class WhenSelfTypeExhaustivenessChecker
extends WhenExhaustivenessChecker {
    @NotNull
    public static final WhenSelfTypeExhaustivenessChecker INSTANCE = new WhenSelfTypeExhaustivenessChecker();

    private WhenSelfTypeExhaustivenessChecker() {
        super(null);
    }

    @Override
    public boolean isApplicable(@NotNull ConeKotlinType subjectType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)subjectType, (String)"subjectType");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return true;
    }

    @Override
    public void computeMissingCases(@NotNull FirWhenExpression whenExpression, @NotNull ConeKotlinType subjectType, @NotNull FirSession session, @NotNull Collection<WhenMissingCase> destination) {
        Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
        Intrinsics.checkNotNullParameter((Object)subjectType, (String)"subjectType");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        if (!this.isExhaustiveThroughSelfTypeCheck(whenExpression, subjectType, session)) {
            destination.add(WhenMissingCase.Unknown.INSTANCE);
        }
    }

    public final boolean isExhaustiveThroughSelfTypeCheck(@NotNull FirWhenExpression whenExpression, @NotNull ConeKotlinType subjectType, @NotNull FirSession session) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
            Intrinsics.checkNotNullParameter((Object)subjectType, (String)"subjectType");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            if (WhenOnNullableExhaustivenessChecker.INSTANCE.isApplicable(subjectType, session) && WhenOnNullableExhaustivenessChecker.INSTANCE.isNullBranchMissing(whenExpression)) {
                return false;
            }
            ConeKotlinType convertedSubjectType = TypeUtilsKt.withNullability$default(subjectType, false, TypeComponentsKt.getTypeContext(session), null, false, 12, null);
            Set checkedTypes = new LinkedHashSet();
            whenExpression.accept(new ConditionChecker(session), checkedTypes);
            Iterable $this$any$iv = checkedTypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeKotlinType it = (ConeKotlinType)element$iv;
                    boolean bl2 = false;
                    if (!TypeUtilsKt.isSubtypeOf$default(convertedSubjectType, it, session, false, 4, null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public String toString() {
        return "WhenSelfTypeExhaustivenessChecker";
    }

    public int hashCode() {
        return 1920563880;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WhenSelfTypeExhaustivenessChecker)) {
            return false;
        }
        WhenSelfTypeExhaustivenessChecker cfr_ignored_0 = (WhenSelfTypeExhaustivenessChecker)other;
        return true;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenSelfTypeExhaustivenessChecker$ConditionChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker$AbstractConditionChecker;", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "visitTypeOperatorCall", "", "typeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "data", "visitEqualityOperatorCall", "equalityOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessComputer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenSelfTypeExhaustivenessChecker$ConditionChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,680:1\n57#2:681\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessComputer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenSelfTypeExhaustivenessChecker$ConditionChecker\n*L\n670#1:681\n*E\n"})
    private static final class ConditionChecker
    extends WhenExhaustivenessChecker.AbstractConditionChecker<Set<ConeKotlinType>> {
        @NotNull
        private final FirSession session;

        public ConditionChecker(@NotNull FirSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.session = session;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @Override
        public void visitTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall, @NotNull Set<ConeKotlinType> data) {
            Intrinsics.checkNotNullParameter((Object)typeOperatorCall, (String)"typeOperatorCall");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (typeOperatorCall.getOperation() != FirOperation.IS) {
                return;
            }
            data.add(FirTypeUtilsKt.getConeType(typeOperatorCall.getConversionTypeRef()));
        }

        @Override
        public void visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @NotNull Set<ConeKotlinType> data) {
            Intrinsics.checkNotNullParameter((Object)equalityOperatorCall, (String)"equalityOperatorCall");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).supportsFeature(LanguageFeature.DataFlowBasedExhaustiveness)) {
                return;
            }
            if (equalityOperatorCall.getOperation() != FirOperation.EQ && equalityOperatorCall.getOperation() != FirOperation.IDENTITY) {
                return;
            }
            FirCall $this$arguments$iv = equalityOperatorCall;
            boolean $i$f$getArguments = false;
            FirExpression argument = $this$arguments$iv.getArgumentList().getArguments().get(1);
            Object object = argument instanceof FirResolvedQualifier ? (FirResolvedQualifier)argument : null;
            if (object == null || (object = ((FirResolvedQualifier)object).getSymbol()) == null) {
                return;
            }
            Object symbol = object;
            if (symbol instanceof FirRegularClassSymbol && ((FirRegularClassSymbol)symbol).getClassKind() == ClassKind.OBJECT) {
                data.add(FirTypeUtilsKt.getResolvedType(argument));
            }
        }
    }
}

