/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.symbols.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.declarations.DeprecationsPerUseSite;
import org.jetbrains.kotlin.fir.declarations.EmptyDeprecationsProvider;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVersionRequirementsTableKeyKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolver;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirReceiverParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.RenderingInternals;
import org.jetbrains.kotlin.fir.symbols.impl.UtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.mpp.CallableSymbolMarker;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010@\u001a\u00020AJ\b\u0010B\u001a\u00020CH\u0014J\r\u0010D\u001a\u00020CH\u0000\u00a2\u0006\u0002\bEJ\u0012\u0010F\u001a\u00020\u00132\b\u0010G\u001a\u0004\u0018\u00010HH\u0002J\n\u0010I\u001a\u00020JH\u0096\u0080\u0004J\u0006\u0010K\u001a\u00020JR\u0014\u0010\u0007\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\u0006\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020.0!8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010$R\u0017\u00100\u001a\b\u0012\u0004\u0012\u00020.0!8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010$R\u0013\u00102\u001a\u0004\u0018\u0001038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0012\u00106\u001a\u000207X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0013\u0010:\u001a\u0004\u0018\u00010;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "D", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/mpp/CallableSymbolMarker;", "<init>", "()V", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "getCallableId", "()Lorg/jetbrains/kotlin/name/CallableId;", "callableIdForRendering", "getCallableIdForRendering$annotations", "getCallableIdForRendering", "resolvedReturnTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "getResolvedReturnTypeRef", "()Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "calculateReturnType", "", "resolvedReturnType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getResolvedReturnType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "resolvedReceiverTypeRef", "getResolvedReceiverTypeRef", "resolvedReceiverType", "getResolvedReceiverType", "receiverParameterSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirReceiverParameterSymbol;", "getReceiverParameterSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirReceiverParameterSymbol;", "contextParameterSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "getContextParameterSymbols", "()Ljava/util/List;", "resolvedStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "getResolvedStatus", "()Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "rawStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "getRawStatus", "()Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "typeParameterSymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "getTypeParameterSymbols", "ownTypeParameterSymbols", "getOwnTypeParameterSymbols", "dispatchReceiverType", "Lorg/jetbrains/kotlin/fir/types/ConeSimpleKotlinType;", "getDispatchReceiverType", "()Lorg/jetbrains/kotlin/fir/types/ConeSimpleKotlinType;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "containerSource", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "getContainerSource", "()Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "getDeprecation", "Lorg/jetbrains/kotlin/fir/declarations/DeprecationsPerUseSite;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecationsAreDefinitelyEmpty", "", "currentDeclarationDeprecationsAreDefinitelyEmpty", "currentDeclarationDeprecationsAreDefinitelyEmpty$tree", "ensureType", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "toString", "", "callableIdAsString", "tree"})
@SourceDebugExtension(value={"SMAP\nFirCallableSymbol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCallableSymbol.kt\norg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirLazyDeclarationResolver.kt\norg/jetbrains/kotlin/fir/symbols/FirLazyDeclarationResolver\n*L\n1#1,159:1\n1585#2:160\n1660#2,3:161\n1585#2:164\n1660#2,3:165\n1641#2,10:168\n1914#2:178\n1915#2:180\n1651#2:181\n1#3:179\n61#4,6:182\n*S KotlinDebug\n*F\n+ 1 FirCallableSymbol.kt\norg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol\n*L\n65#1:160\n65#1:161,3\n74#1:164\n74#1:165,3\n77#1:168,10\n77#1:178\n77#1:180\n77#1:181\n77#1:179\n120#1:182,6\n*E\n"})
public abstract class FirCallableSymbol<D extends FirCallableDeclaration>
extends FirBasedSymbol<D>
implements CallableSymbolMarker {
    @Nullable
    public abstract CallableId getCallableId();

    @NotNull
    public final CallableId getCallableIdForRendering() {
        CallableId callableId = this.getCallableId();
        if (callableId == null) {
            callableId = new CallableId(this.getName());
        }
        return callableId;
    }

    @RenderingInternals
    public static /* synthetic */ void getCallableIdForRendering$annotations() {
    }

    @NotNull
    public final FirResolvedTypeRef getResolvedReturnTypeRef() {
        this.calculateReturnType();
        FirTypeRef firTypeRef = ((FirCallableDeclaration)this.getFir()).getReturnTypeRef();
        Intrinsics.checkNotNull((Object)firTypeRef, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirResolvedTypeRef");
        return (FirResolvedTypeRef)firTypeRef;
    }

    public final void calculateReturnType() {
        this.ensureType(((FirCallableDeclaration)this.getFir()).getReturnTypeRef());
        FirTypeRef returnTypeRef = ((FirCallableDeclaration)this.getFir()).getReturnTypeRef();
        if (!(returnTypeRef instanceof FirResolvedTypeRef)) {
            UtilsKt.errorInLazyResolve(this, "returnTypeRef", Reflection.getOrCreateKotlinClass(returnTypeRef.getClass()), Reflection.getOrCreateKotlinClass(FirResolvedTypeRef.class));
            throw new KotlinNothingValueException();
        }
    }

    @NotNull
    public final ConeKotlinType getResolvedReturnType() {
        return this.getResolvedReturnTypeRef().getConeType();
    }

    @Nullable
    public final FirResolvedTypeRef getResolvedReceiverTypeRef() {
        FirReceiverParameterSymbol firReceiverParameterSymbol = this.getReceiverParameterSymbol();
        return firReceiverParameterSymbol != null ? firReceiverParameterSymbol.calculateResolvedTypeRef() : null;
    }

    @Nullable
    public final ConeKotlinType getResolvedReceiverType() {
        FirResolvedTypeRef firResolvedTypeRef = this.getResolvedReceiverTypeRef();
        return firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
    }

    @Nullable
    public final FirReceiverParameterSymbol getReceiverParameterSymbol() {
        FirReceiverParameter firReceiverParameter = ((FirCallableDeclaration)this.getFir()).getReceiverParameter();
        return firReceiverParameter != null ? firReceiverParameter.getSymbol() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirValueParameterSymbol> getContextParameterSymbols() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ((FirCallableDeclaration)this.getFir()).getContextParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final FirResolvedDeclarationStatus getResolvedStatus() {
        return UtilsKt.resolvedStatus((FirMemberDeclaration)this.getFir());
    }

    @NotNull
    public final FirDeclarationStatus getRawStatus() {
        return ((FirCallableDeclaration)this.getFir()).getStatus();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirTypeParameterSymbol> getTypeParameterSymbols() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ((FirCallableDeclaration)this.getFir()).getTypeParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirTypeParameterSymbol> getOwnTypeParameterSymbols() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = ((FirCallableDeclaration)this.getFir()).getTypeParameters();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirTypeParameterSymbol it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirTypeParameterRef it = (FirTypeParameterRef)element$iv$iv;
            boolean bl2 = false;
            FirTypeParameter firTypeParameter = it instanceof FirTypeParameter ? (FirTypeParameter)it : null;
            if ((firTypeParameter != null ? firTypeParameter.getSymbol() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final ConeSimpleKotlinType getDispatchReceiverType() {
        return ((FirCallableDeclaration)this.getFir()).getDispatchReceiverType();
    }

    @NotNull
    public abstract Name getName();

    @Nullable
    public final DeserializedContainerSource getContainerSource() {
        return ((FirCallableDeclaration)this.getFir()).getContainerSource();
    }

    @Nullable
    public final DeprecationsPerUseSite getDeprecation(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (this.deprecationsAreDefinitelyEmpty()) {
            return null;
        }
        FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.COMPILER_REQUIRED_ANNOTATIONS);
        return ((FirCallableDeclaration)this.getFir()).getDeprecationsProvider().getDeprecationsInfo(languageVersionSettings);
    }

    protected boolean deprecationsAreDefinitelyEmpty() {
        return this.currentDeclarationDeprecationsAreDefinitelyEmpty$tree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean currentDeclarationDeprecationsAreDefinitelyEmpty$tree() {
        FirLazyDeclarationResolver this_$iv = FirLazyDeclarationResolverKt.getLazyDeclarationResolver(this.getModuleData().getSession());
        boolean $i$f$forbidLazyResolveInside = false;
        Boolean current$iv = this_$iv.get_lazyResolveIsAllowed().get();
        this_$iv.get_lazyResolveIsAllowed().set(false);
        try {
            Collection collection;
            boolean bl = false;
            if (this.getOrigin() instanceof FirDeclarationOrigin.Java) {
                boolean bl2 = false;
                return bl2;
            }
            if (this.getAnnotations().isEmpty() && ((collection = (Collection)FirVersionRequirementsTableKeyKt.getVersionRequirements(this.getFir())) == null || collection.isEmpty()) && !this.getRawStatus().isOverride()) {
                boolean bl3 = true;
                return bl3;
            }
            if (Intrinsics.areEqual((Object)((FirCallableDeclaration)this.getFir()).getDeprecationsProvider(), (Object)EmptyDeprecationsProvider.INSTANCE)) {
                boolean bl4 = true;
                return bl4;
            }
            boolean bl5 = false;
            return bl5;
        }
        finally {
            this_$iv.get_lazyResolveIsAllowed().set(current$iv);
        }
    }

    private final void ensureType(FirTypeRef typeRef) {
        FirTypeRef firTypeRef = typeRef;
        if (firTypeRef != null && !(firTypeRef instanceof FirResolvedTypeRef)) {
            if (firTypeRef instanceof FirImplicitTypeRef) {
                FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.IMPLICIT_TYPES_BODY_RESOLVE);
            } else {
                FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.TYPES);
            }
        }
    }

    @NotNull
    public String toString() {
        String string;
        boolean bl = this.isBound();
        if (bl) {
            string = this.callableIdAsString();
        } else if (!bl) {
            string = "(unbound)";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String description = string;
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + ' ' + description;
    }

    @NotNull
    public final String callableIdAsString() {
        Object object = this.getCallableId();
        if (object == null || (object = ((CallableId)object).toString()) == null) {
            object = "<local>/" + this.getName();
        }
        return object;
    }
}

