/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.JsIntrinsics;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.CallsTransformer;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeysKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.JsStandardClassIds;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/BoxedLongCallsTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/CallsTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "intrinsics", "Lorg/jetbrains/kotlin/ir/backend/js/JsIntrinsics;", "longAsBigInt", "", "longLowGetter", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "longHighGetter", "longLowField", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "longHighField", "transformFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "doNotIntrinsify", "insertNumberConversionInDateConstructorCall", "transformFieldAccess", "access", "Lorg/jetbrains/kotlin/ir/expressions/IrFieldAccessExpression;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nBoxedLongCallsTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoxedLongCallsTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/lower/calls/BoxedLongCallsTransformer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n350#2,12:101\n350#2,12:113\n1#3:125\n776#4:126\n872#4,2:127\n*S KotlinDebug\n*F\n+ 1 BoxedLongCallsTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/lower/calls/BoxedLongCallsTransformer\n*L\n34#1:101,12\n35#1:113,12\n70#1:126\n70#1:127,2\n*E\n"})
public final class BoxedLongCallsTransformer
implements CallsTransformer {
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final JsIntrinsics intrinsics;
    private final boolean longAsBigInt;
    @Nullable
    private final IrSimpleFunctionSymbol longLowGetter;
    @Nullable
    private final IrSimpleFunctionSymbol longHighGetter;
    @NotNull
    private final IrFieldSymbol longLowField;
    @NotNull
    private final IrFieldSymbol longHighField;

    public BoxedLongCallsTransformer(@NotNull JsIrBackendContext context2) {
        IrFieldSymbol it;
        Sequence<IrFieldSymbol> $this$single$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.irBuiltIns = context2.getIrBuiltIns();
        this.intrinsics = context2.getIntrinsics();
        this.longAsBigInt = JSConfigurationKeysKt.getCompileLongAsBigint(context2.getConfiguration());
        this.longLowGetter = AdditionalIrUtilsKt.getPropertyGetter(this.intrinsics.getLongClassSymbol(), "low");
        this.longHighGetter = AdditionalIrUtilsKt.getPropertyGetter(this.intrinsics.getLongClassSymbol(), "high");
        Sequence<IrFieldSymbol> sequence2 = IrUtilsKt.getFields(this.intrinsics.getLongClassSymbol());
        BoxedLongCallsTransformer boxedLongCallsTransformer = this;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            it = (IrFieldSymbol)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((IrField)it.getOwner()).getName().asString(), (Object)"low")) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        boxedLongCallsTransformer.longLowField = single$iv;
        $this$single$iv = IrUtilsKt.getFields(this.intrinsics.getLongClassSymbol());
        boxedLongCallsTransformer = this;
        $i$f$single = false;
        single$iv = null;
        found$iv = false;
        for (Object element$iv : $this$single$iv) {
            it = (IrFieldSymbol)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((IrField)it.getOwner()).getName().asString(), (Object)"high")) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        boxedLongCallsTransformer.longHighField = single$iv;
    }

    @Override
    @NotNull
    public IrExpression transformFunctionAccess(@NotNull IrFunctionAccessExpression call2, boolean doNotIntrinsify) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        if (Intrinsics.areEqual(call2.getSymbol(), (Object)this.intrinsics.getJsLongToString())) {
            return IrUtilsKt.irCall$default(call2, this.intrinsics.getLongToStringImpl(), null, null, 12, null);
        }
        if (this.longAsBigInt) {
            IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor((IrClass)this.intrinsics.getLongClassSymbol().getOwner());
            if (Intrinsics.areEqual(call2.getSymbol(), (Object)(irConstructor != null ? irConstructor.getSymbol() : null))) {
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.intrinsics.getLongFromTwoInts();
                Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
                return IrUtilsKt.irCall$default(call2, irSimpleFunctionSymbol, null, null, 12, null);
            }
        }
        if (this.longAsBigInt) {
            IrSimpleFunction irSimpleFunction = IrJsUtilsKt.getPrimaryConstructorReplacement((IrClass)this.intrinsics.getLongClassSymbol().getOwner());
            if (Intrinsics.areEqual(call2.getSymbol(), (Object)(irSimpleFunction != null ? irSimpleFunction.getSymbol() : null))) {
                IrCall irCall;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.intrinsics.getLongFromTwoInts();
                Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
                IrCall $this$transformFunctionAccess_u24lambda_u240 = irCall = IrUtilsKt.irCall$default(call2, irSimpleFunctionSymbol, null, null, 12, null);
                boolean bl = false;
                AddToStdlibKt.assignFrom($this$transformFunctionAccess_u24lambda_u240.getArguments(), CollectionsKt.drop((Iterable)call2.getArguments(), (int)1));
                return irCall;
            }
        }
        if (this.longAsBigInt && Intrinsics.areEqual(call2.getSymbol(), (Object)this.longLowGetter)) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.intrinsics.getLongLowBits();
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
            return IrUtilsKt.irCall$default(call2, irSimpleFunctionSymbol, null, null, 12, null);
        }
        if (this.longAsBigInt && Intrinsics.areEqual(call2.getSymbol(), (Object)this.longHighGetter)) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.intrinsics.getLongHighBits();
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
            return IrUtilsKt.irCall$default(call2, irSimpleFunctionSymbol, null, null, 12, null);
        }
        IrExpression irExpression = this.insertNumberConversionInDateConstructorCall(call2);
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl = false;
            return it;
        }
        return call2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression insertNumberConversionInDateConstructorCall(IrFunctionAccessExpression call2) {
        void $this$filterTo$iv$iv;
        if (!this.longAsBigInt) {
            return null;
        }
        Object object = IrUtilsKt.getParentClassOrNull(((IrFunctionSymbol)call2.getSymbol()).getOwner());
        if (!Intrinsics.areEqual((Object)(object != null && (object = AdditionalIrUtilsKt.getClassId((IrClass)object)) != null ? ((ClassId)object).getOutermostClassId() : null), (Object)JsStandardClassIds.Date)) {
            return null;
        }
        Iterable $this$filter$iv = ((IrFunctionSymbol)call2.getSymbol()).getOwner().getParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrValueParameter it = (IrValueParameter)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)this.irBuiltIns.getNumberType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List parametersWithNumberType = (List)destination$iv$iv;
        if (parametersWithNumberType.isEmpty()) {
            return null;
        }
        for (IrValueParameter numberParameter : parametersWithNumberType) {
            void $this$insertNumberConversionInDateConstructorCall_u24lambda_u241;
            IrExpression arg;
            PrimitiveType argPrimitiveType;
            if (call2.getArguments().get(numberParameter) == null || CollectionsKt.contains((Iterable)PrimitiveType.NUMBER_TYPES, (Object)((Object)(argPrimitiveType = IrTypePredicatesKt.getPrimitiveType(arg.getType())))) && argPrimitiveType != PrimitiveType.LONG) continue;
            IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.intrinsics.getJsNumberToDouble(), null, null, null, null, 0, 0, 126, null);
            IrCall irCall2 = irCall;
            IrValueParameter irValueParameter = numberParameter;
            IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = call2.getArguments();
            boolean bl = false;
            $this$insertNumberConversionInDateConstructorCall_u24lambda_u241.getArguments().set(0, arg);
            Unit unit = Unit.INSTANCE;
            valueArgumentsList.set(irValueParameter, irCall);
        }
        return call2;
    }

    @Override
    @NotNull
    public IrExpression transformFieldAccess(@NotNull IrFieldAccessExpression access) {
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        if (this.intrinsics.getLongLowBits() != null && Intrinsics.areEqual((Object)access.getSymbol(), (Object)this.longLowField)) {
            IrCallImpl irCallImpl;
            IrCallImpl $this$transformFieldAccess_u24lambda_u240 = irCallImpl = BuildersKt.IrCallImpl$default(access.getStartOffset(), access.getEndOffset(), ((IrField)this.longLowField.getOwner()).getType(), this.intrinsics.getLongLowBits(), 0, null, null, 112, null);
            boolean bl = false;
            $this$transformFieldAccess_u24lambda_u240.getArguments().set(0, access.getReceiver());
            return irCallImpl;
        }
        if (this.intrinsics.getLongHighBits() != null && Intrinsics.areEqual((Object)access.getSymbol(), (Object)this.longHighField)) {
            IrCallImpl irCallImpl;
            IrCallImpl $this$transformFieldAccess_u24lambda_u241 = irCallImpl = BuildersKt.IrCallImpl$default(access.getStartOffset(), access.getEndOffset(), ((IrField)this.longHighField.getOwner()).getType(), this.intrinsics.getLongHighBits(), 0, null, null, 112, null);
            boolean bl = false;
            $this$transformFieldAccess_u24lambda_u241.getArguments().set(0, access.getReceiver());
            return irCallImpl;
        }
        return access;
    }
}

