/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.proxy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.proxy.Proxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.ProxyKt;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\r*\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0082\u0004J\n\u0010\u0017\u001a\u00020\u0011H\u0096\u0080\u0004J\n\u0010\u0018\u001a\u00020\u0013H\u0096\u0080\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/proxy/CommonProxy;", "Lorg/jetbrains/kotlin/ir/interpreter/proxy/Proxy;", "state", "Lorg/jetbrains/kotlin/ir/interpreter/state/Common;", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Common;Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;)V", "getState", "()Lorg/jetbrains/kotlin/ir/interpreter/state/Common;", "getCallInterceptor", "()Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "defaultEquals", "", "other", "", "defaultHashCode", "", "defaultToString", "", "wasAlreadyCalled", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "equals", "hashCode", "toString", "Companion", "ir.interpreter"})
public final class CommonProxy
implements Proxy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Common state;
    @NotNull
    private final CallInterceptor callInterceptor;

    private CommonProxy(Common state, CallInterceptor callInterceptor) {
        this.state = state;
        this.callInterceptor = callInterceptor;
    }

    @Override
    @NotNull
    public Common getState() {
        return this.state;
    }

    @Override
    @NotNull
    public CallInterceptor getCallInterceptor() {
        return this.callInterceptor;
    }

    private final boolean defaultEquals(Object other) {
        return other instanceof Proxy ? this.getState() == ((Proxy)other).getState() : false;
    }

    private final int defaultHashCode() {
        return System.identityHashCode(this.getState());
    }

    private final String defaultToString() {
        StringBuilder stringBuilder = new StringBuilder().append(UtilsKt.internalName(this.getState().getIrClass())).append('@');
        String string = Integer.toString(this.hashCode(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return stringBuilder.append(StringsKt.padStart((String)string, (int)8, (char)'0')).toString();
    }

    private final boolean wasAlreadyCalled(IrFunction $this$wasAlreadyCalled) {
        IrValueParameter irValueParameter = UtilsKt.getLastOverridden($this$wasAlreadyCalled).getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter);
        IrValueParameterSymbol anyParameter = irValueParameter.getSymbol();
        CallStack callStack = this.getCallInterceptor().getEnvironment().getCallStack$ir_interpreter();
        if (callStack.containsStateInMemory(anyParameter) && callStack.loadState(anyParameter) == this.getState()) {
            return true;
        }
        return Intrinsics.areEqual((Object)$this$wasAlreadyCalled, (Object)this.getCallInterceptor().getEnvironment().getCallStack$ir_interpreter().getCurrentFrameOwner$ir_interpreter());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        List valueArguments = new ArrayList();
        IrSimpleFunction equalsFun = this.getState().getEqualsFunction();
        if (IrUtilsKt.isFakeOverriddenFromAny(equalsFun) || this.wasAlreadyCalled(equalsFun)) {
            return this.defaultEquals(other);
        }
        valueArguments.add(this.getState());
        valueArguments.add(other instanceof Proxy ? ((Proxy)other).getState() : (State)other);
        Object object = CallInterceptor.interceptProxy$default(this.getCallInterceptor(), equalsFun, valueArguments, null, 4, null);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        return (Boolean)object;
    }

    @Override
    public int hashCode() {
        List valueArguments = new ArrayList();
        IrSimpleFunction hashCodeFun = this.getState().getHashCodeFunction();
        if (IrUtilsKt.isFakeOverriddenFromAny(hashCodeFun) || this.wasAlreadyCalled(hashCodeFun)) {
            return this.defaultHashCode();
        }
        valueArguments.add(this.getState());
        Object object = CallInterceptor.interceptProxy$default(this.getCallInterceptor(), hashCodeFun, valueArguments, null, 4, null);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        return (Integer)object;
    }

    @Override
    @NotNull
    public String toString() {
        if (IrTypeUtilsKt.isUnsigned(IrUtilsKt.getDefaultType(this.getState().getIrClass()))) {
            return UtilsKt.unsignedToString(this.getState());
        }
        List valueArguments = new ArrayList();
        IrSimpleFunction toStringFun = this.getState().getToStringFunction();
        if (IrUtilsKt.isFakeOverriddenFromAny(toStringFun) || this.wasAlreadyCalled(toStringFun)) {
            return this.defaultToString();
        }
        valueArguments.add(this.getState());
        Object object = CallInterceptor.interceptProxy$default(this.getCallInterceptor(), toStringFun, valueArguments, null, 4, null);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    public /* synthetic */ CommonProxy(Common state, CallInterceptor callInterceptor, DefaultConstructorMarker $constructor_marker) {
        this(state, callInterceptor);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b\nJ\u0014\u0010\u000b\u001a\u00020\u0001*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/proxy/CommonProxy$Companion;", "", "<init>", "()V", "asProxy", "Lorg/jetbrains/kotlin/ir/interpreter/state/Common;", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "extendFrom", "Ljava/lang/Class;", "asProxy$ir_interpreter", "fallbackIfMethodNotFound", "Lorg/jetbrains/kotlin/ir/interpreter/proxy/CommonProxy;", "method", "Ljava/lang/reflect/Method;", "ir.interpreter"})
    @SourceDebugExtension(value={"SMAP\nCommonProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonProxy.kt\norg/jetbrains/kotlin/ir/interpreter/proxy/CommonProxy$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n37#2,2:110\n1595#3:112\n1628#3,4:113\n*S KotlinDebug\n*F\n+ 1 CommonProxy.kt\norg/jetbrains/kotlin/ir/interpreter/proxy/CommonProxy$Companion\n*L\n103#1:110,2\n90#1:112\n90#1:113,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object asProxy$ir_interpreter(@NotNull Common $this$asProxy, @NotNull CallInterceptor callInterceptor, @Nullable Class<?> extendFrom) {
            Class[] classArray;
            Class[] classArray2;
            Intrinsics.checkNotNullParameter((Object)$this$asProxy, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
            CommonProxy commonProxy = new CommonProxy($this$asProxy, callInterceptor, null);
            Class<?> clazz = extendFrom;
            if (clazz == null || Intrinsics.areEqual(clazz, Object.class)) {
                classArray2 = new Class[]{Proxy.class};
                classArray = classArray2;
            } else {
                classArray2 = new Class[]{extendFrom, Proxy.class};
                classArray = classArray2;
            }
            Class[] interfaces = classArray;
            Object object = java.lang.reflect.Proxy.newProxyInstance($this$asProxy.getClass().getClassLoader(), interfaces, (arg_0, arg_1, arg_2) -> Companion.asProxy$lambda$0(commonProxy, callInterceptor, arg_0, arg_1, arg_2));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newProxyInstance(...)");
            return object;
        }

        public static /* synthetic */ Object asProxy$ir_interpreter$default(Companion companion, Common common, CallInterceptor callInterceptor, Class clazz, int n2, Object object) {
            if ((n2 & 2) != 0) {
                clazz = null;
            }
            return companion.asProxy$ir_interpreter(common, callInterceptor, clazz);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final Object fallbackIfMethodNotFound(CommonProxy $this$fallbackIfMethodNotFound, Method method) {
            Object[] objectArray;
            Wrapper wrapper;
            if (!Intrinsics.areEqual((Object)method.getName(), (Object)"toArray")) throw new AssertionError((Object)("Cannot find method " + method + " in " + $this$fallbackIfMethodNotFound.getState()));
            Class<?>[] classArray = method.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
            if (!(((Object[])classArray).length == 0)) throw new AssertionError((Object)("Cannot find method " + method + " in " + $this$fallbackIfMethodNotFound.getState()));
            Wrapper wrapper2 = wrapper = $this$fallbackIfMethodNotFound.getState().getSuperWrapperClass();
            if (wrapper2 == null) {
                objectArray = new Object[]{};
                return objectArray;
            } else {
                Object object = wrapper2.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Collection<*>");
                Collection $this$toTypedArray$iv = (Collection)object;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                objectArray = thisCollection$iv.toArray(new Object[0]);
            }
            return objectArray;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private static final Object asProxy$lambda$0(CommonProxy $commonProxy, CallInterceptor $callInterceptor, Object object, Method method, Object[] args) {
            void $this$mapIndexedTo$iv$iv;
            Object object2;
            if (Intrinsics.areEqual(method.getDeclaringClass(), Proxy.class) && Intrinsics.areEqual((Object)method.getName(), (Object)"getState")) {
                object2 = $commonProxy.getState();
                return object2;
            }
            if (Intrinsics.areEqual(method.getDeclaringClass(), Proxy.class) && Intrinsics.areEqual((Object)method.getName(), (Object)"getCallInterceptor")) {
                object2 = $commonProxy.getCallInterceptor();
                return object2;
            }
            if (Intrinsics.areEqual((Object)method.getName(), (Object)"equals")) {
                Class<?>[] classArray = method.getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
                Object object3 = ArraysKt.single((Object[])classArray);
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"single(...)");
                if (ProxyKt.isObject((Class)object3)) {
                    Intrinsics.checkNotNull((Object)args);
                    object2 = $commonProxy.equals(ArraysKt.single((Object[])args));
                    return object2;
                }
            }
            if (Intrinsics.areEqual((Object)method.getName(), (Object)"hashCode")) {
                Class<?>[] classArray = method.getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
                if (((Object[])classArray).length == 0) {
                    object2 = $commonProxy.hashCode();
                    return object2;
                }
            }
            if (Intrinsics.areEqual((Object)method.getName(), (Object)"toString")) {
                Class<?>[] classArray = method.getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
                if (((Object[])classArray).length == 0) {
                    object2 = $commonProxy.toString();
                    return object2;
                }
            }
            Common common = $commonProxy.getState();
            Intrinsics.checkNotNull((Object)method);
            IrFunction irFunction = common.getIrFunction(method);
            if (irFunction == null) {
                return Companion.fallbackIfMethodNotFound($commonProxy, method);
            }
            IrFunction irFunction2 = irFunction;
            Object[] objectArray = new State[]{$commonProxy.getState()};
            List valueArguments = CollectionsKt.mutableListOf((Object[])objectArray);
            Collection collection = valueArguments;
            Iterable $this$mapIndexed$iv = IrUtilsKt.getNonDispatchParameters(irFunction2);
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            Iterator iterator2 = $this$mapIndexedTo$iv$iv.iterator();
            while (true) {
                void parameter;
                void index;
                int n2;
                if (!iterator2.hasNext()) {
                    Iterable iterable2 = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
                    Class<?> clazz = method.getReturnType();
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"getReturnType(...)");
                    object2 = $callInterceptor.interceptProxy(irFunction2, valueArguments, clazz);
                    return object2;
                }
                Object item$iv$iv = iterator2.next();
                if ((n2 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                int n3 = n2;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add($callInterceptor.getEnvironment().convertToState$ir_interpreter(args[index], parameter.getType()));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

