/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.validation.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrReplSnippet;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.util.IrTreeSymbolsVisitor;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.validation.IrValidationError;
import org.jetbrains.kotlin.ir.validation.IrValidatorConfig;
import org.jetbrains.kotlin.ir.validation.checkers.IrTreeConsistencyException;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0016H\u0016J\u0018\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010#\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)H\u0016J\u001a\u0010*\u001a\u00020\u00052\u0006\u0010#\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u001bH\u0002J\"\u0010-\u001a\u00020\u00052\u0006\u0010#\u001a\u00020+2\b\u0010.\u001a\u0004\u0018\u00010\u001b2\u0006\u0010,\u001a\u00020\u001bH\u0002J\u0010\u0010/\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0016H\u0002R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/ir/validation/checkers/CheckTreeConsistencyVisitor;", "Lorg/jetbrains/kotlin/ir/util/IrTreeSymbolsVisitor;", "reportError", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/validation/IrValidationError;", "", "config", "Lorg/jetbrains/kotlin/ir/validation/IrValidatorConfig;", "<init>", "(Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/ir/validation/IrValidatorConfig;)V", "getReportError", "()Lkotlin/jvm/functions/Function1;", "getConfig", "()Lorg/jetbrains/kotlin/ir/validation/IrValidatorConfig;", "hasInconsistency", "", "getHasInconsistency", "()Z", "setHasInconsistency", "(Z)V", "visitedElements", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lkotlin/collections/HashSet;", "parentChain", "", "currentActualParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "visitElement", "element", "visitTypeRecursively", "container", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "visitDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitPackageFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "visitSymbol", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "handleParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "actualParent", "reportWrongParent", "expectedParent", "checkDuplicateNode", "ir.validation"})
@SourceDebugExtension(value={"SMAP\nCheckTreeConsistencyVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckTreeConsistencyVisitor.kt\norg/jetbrains/kotlin/ir/validation/checkers/CheckTreeConsistencyVisitor\n+ 2 Utils.kt\norg/jetbrains/kotlin/ir/validation/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n18#2,6:150\n18#2,6:158\n1914#3,2:156\n1806#3,3:164\n*S KotlinDebug\n*F\n+ 1 CheckTreeConsistencyVisitor.kt\norg/jetbrains/kotlin/ir/validation/checkers/CheckTreeConsistencyVisitor\n*L\n32#1:150,6\n52#1:158,6\n42#1:156,2\n119#1:164,3\n*E\n"})
final class CheckTreeConsistencyVisitor
extends IrTreeSymbolsVisitor {
    @NotNull
    private final Function1<IrValidationError, Unit> reportError;
    @NotNull
    private final IrValidatorConfig config;
    private boolean hasInconsistency;
    @NotNull
    private final HashSet<IrElement> visitedElements;
    @NotNull
    private final List<IrElement> parentChain;
    @Nullable
    private IrDeclarationParent currentActualParent;

    public CheckTreeConsistencyVisitor(@NotNull Function1<? super IrValidationError, Unit> reportError, @NotNull IrValidatorConfig config) {
        Intrinsics.checkNotNullParameter(reportError, (String)"reportError");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.reportError = reportError;
        this.config = config;
        this.visitedElements = new HashSet();
        this.parentChain = new ArrayList();
    }

    @NotNull
    public final Function1<IrValidationError, Unit> getReportError() {
        return this.reportError;
    }

    @NotNull
    public final IrValidatorConfig getConfig() {
        return this.config;
    }

    public final boolean getHasInconsistency() {
        return this.hasInconsistency;
    }

    public final void setHasInconsistency(boolean bl) {
        this.hasInconsistency = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitElement(@NotNull IrElement element) {
        void $this$temporarilyPushing$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.checkDuplicateNode(element);
        List<IrElement> list = this.parentChain;
        IrElement element$iv = element;
        boolean $i$f$temporarilyPushing = false;
        $this$temporarilyPushing$iv.add(element$iv);
        IrElement it = element$iv;
        boolean bl = false;
        IrVisitorsKt.acceptChildrenVoid(element, this);
        Unit result$iv = Unit.INSTANCE;
        $this$temporarilyPushing$iv.remove($this$temporarilyPushing$iv.size() - 1);
    }

    @Override
    public void visitTypeRecursively(@NotNull IrElement container, @NotNull IrType type) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.visitType(container, type);
        if (type instanceof IrSimpleType) {
            Iterable $this$forEach$iv = ((IrSimpleType)type).getArguments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrTypeArgument it = (IrTypeArgument)element$iv;
                boolean bl = false;
                if (!(it instanceof IrTypeProjection)) continue;
                this.visitTypeRecursively(container, ((IrTypeProjection)it).getType());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        void $this$temporarilyPushing$iv;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.checkDuplicateNode(declaration);
        List<IrElement> list = this.parentChain;
        IrDeclarationBase element$iv = declaration;
        boolean $i$f$temporarilyPushing = false;
        $this$temporarilyPushing$iv.add(element$iv);
        IrElement it = element$iv;
        boolean bl = false;
        this.handleParent(declaration, this.currentActualParent);
        IrDeclarationParent previousActualParent = this.currentActualParent;
        IrDeclarationParent irDeclarationParent = declaration instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)declaration) : null;
        if (irDeclarationParent == null) {
            irDeclarationParent = this.currentActualParent;
        }
        this.currentActualParent = irDeclarationParent;
        IrVisitorsKt.acceptChildrenVoid((IrElement)declaration, this);
        this.currentActualParent = previousActualParent;
        Unit result$iv = Unit.INSTANCE;
        $this$temporarilyPushing$iv.remove($this$temporarilyPushing$iv.size() - 1);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.currentActualParent = declaration;
        this.visitElement(declaration);
    }

    @Override
    public void visitSymbol(@NotNull IrElement container, @NotNull IrSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (this.config.getCheckUnboundSymbols() && !symbol.isBound()) {
            this.hasInconsistency = true;
            this.reportError.invoke((Object)new IrValidationError(null, container, IrValidationError.Cause.UnboundSymbol.INSTANCE, "Unexpected unbound symbol", this.parentChain));
        }
    }

    private final void handleParent(IrDeclaration declaration, IrDeclarationParent actualParent) {
        if (!this.config.getCheckTreeConsistency()) {
            return;
        }
        if (actualParent == null) {
            return;
        }
        try {
            IrDeclarationParent assignedParent = declaration.getParent();
            if (!Intrinsics.areEqual((Object)assignedParent, (Object)actualParent) && !(actualParent instanceof IrReplSnippet)) {
                this.reportWrongParent(declaration, assignedParent, actualParent);
            }
        }
        catch (Exception exception) {
            this.reportWrongParent(declaration, null, actualParent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportWrongParent(IrDeclaration declaration, IrDeclarationParent expectedParent, IrDeclarationParent actualParent) {
        void $this$reportWrongParent_u24lambda_u240;
        StringBuilder stringBuilder;
        this.hasInconsistency = true;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        IrValidationError.Cause cause = IrValidationError.Cause.IrTreeInconsistency.INSTANCE;
        IrElement irElement = declaration;
        IrFile irFile = null;
        Function1<IrValidationError, Unit> function1 = this.reportError;
        boolean bl = false;
        $this$reportWrongParent_u24lambda_u240.append("Declaration with wrong parent:").append('\n');
        $this$reportWrongParent_u24lambda_u240.append("declaration: " + RenderIrElementKt.render$default(declaration, null, 1, null)).append('\n');
        IrDeclarationParent irDeclarationParent = expectedParent;
        $this$reportWrongParent_u24lambda_u240.append("expectedParent: " + (irDeclarationParent != null ? RenderIrElementKt.render$default(irDeclarationParent, null, 1, null) : null)).append('\n');
        $this$reportWrongParent_u24lambda_u240.append("actualParent: " + RenderIrElementKt.render$default(actualParent, null, 1, null)).append('\n');
        Unit unit = Unit.INSTANCE;
        List<IrElement> list = this.parentChain;
        String string = stringBuilder.toString();
        IrValidationError.Cause cause2 = cause;
        IrElement irElement2 = irElement;
        IrFile irFile2 = irFile;
        function1.invoke((Object)new IrValidationError(irFile2, irElement2, cause2, string, list));
    }

    private final void checkDuplicateNode(IrElement element) {
        if (!this.visitedElements.add(element)) {
            if (this.config.getCheckTreeConsistency()) {
                boolean bl;
                block7: {
                    Iterable $this$any$iv = this.parentChain;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            IrElement it = (IrElement)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof IrReplSnippet)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    this.hasInconsistency = true;
                    String renderString = element instanceof IrTypeParameter ? RenderIrElementKt.render$default(element, null, 1, null) + " of " + RenderIrElementKt.render$default(((IrTypeParameter)element).getParent(), null, 1, null) : RenderIrElementKt.render$default(element, null, 1, null);
                    this.reportError.invoke((Object)new IrValidationError(null, element, IrValidationError.Cause.IrTreeInconsistency.INSTANCE, "Duplicate IR node: " + renderString, this.parentChain));
                }
            }
            if (this.parentChain.contains(element)) {
                throw new IrTreeConsistencyException(element);
            }
        }
    }
}

