/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.validation.checkers.symbol;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.validation.checkers.CheckerUtilsKt;
import org.jetbrains.kotlin.ir.validation.checkers.IrSymbolChecker;
import org.jetbrains.kotlin.ir.validation.checkers.context.CheckerContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/validation/checkers/symbol/IrVisibilityChecker;", "Lorg/jetbrains/kotlin/ir/validation/checkers/IrSymbolChecker;", "treatInternalAsPublic", "", "<init>", "(Z)V", "check", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "container", "Lorg/jetbrains/kotlin/ir/IrElement;", "context", "Lorg/jetbrains/kotlin/ir/validation/checkers/context/CheckerContext;", "Companion", "ir.validation"})
public final class IrVisibilityChecker
implements IrSymbolChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean treatInternalAsPublic;
    @NotNull
    private static final IrVisibilityChecker Strict = new IrVisibilityChecker(false);
    @NotNull
    private static final IrVisibilityChecker Relaxed = new IrVisibilityChecker(true);

    private IrVisibilityChecker(boolean treatInternalAsPublic) {
        this.treatInternalAsPublic = treatInternalAsPublic;
    }

    @Override
    public void check(@NotNull IrSymbol symbol, @NotNull IrElement container, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getWithinScripOrScriptClass()) {
            return;
        }
        CheckerUtilsKt.checkVisibility(this, symbol, container, context2, this.treatInternalAsPublic);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/validation/checkers/symbol/IrVisibilityChecker$Companion;", "", "<init>", "()V", "Strict", "Lorg/jetbrains/kotlin/ir/validation/checkers/symbol/IrVisibilityChecker;", "getStrict", "()Lorg/jetbrains/kotlin/ir/validation/checkers/symbol/IrVisibilityChecker;", "Relaxed", "getRelaxed", "ir.validation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrVisibilityChecker getStrict() {
            return Strict;
        }

        @NotNull
        public final IrVisibilityChecker getRelaxed() {
            return Relaxed;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

