/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.components.candidate.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableFromCallableDescriptor;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.LambdaKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionPart;
import org.jetbrains.kotlin.resolve.calls.model.SimpleTypeArgument;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/PostponedVariablesInitializerResolutionPart;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolutionPart;", "<init>", "()V", "process", "", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;", "workIndex", "", "resolution"})
public final class PostponedVariablesInitializerResolutionPart
extends ResolutionPart {
    @NotNull
    public static final PostponedVariablesInitializerResolutionPart INSTANCE = new PostponedVariablesInitializerResolutionPart();

    private PostponedVariablesInitializerResolutionPart() {
    }

    @Override
    public void process(@NotNull ResolutionCandidate $this$process, int workIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$process, (String)"<this>");
        ConstraintSystemBuilder csBuilder = $this$process.getSystem().getBuilder();
        for (Map.Entry<KotlinCallArgument, ValueParameterDescriptor> entry : $this$process.getResolvedCall().getArgumentToCandidateParameter().entrySet()) {
            KotlinCallArgument argument = entry.getKey();
            ValueParameterDescriptor parameter = entry.getValue();
            if (!$this$process.getCallComponents().getStatelessCallbacks().isBuilderInferenceCall(argument, parameter)) continue;
            KotlinType kotlinType = parameter.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            if (FunctionTypesKt.getReceiverTypeFromFunctionType(kotlinType) == null) continue;
            boolean dontUseBuilderInferenceIfPossible = $this$process.getCallComponents().getLanguageVersionSettings().supportsFeature(LanguageFeature.UseBuilderInferenceOnlyIfNeeded);
            if (argument instanceof LambdaKotlinCallArgument && !((LambdaKotlinCallArgument)argument).getHasBuilderInferenceAnnotation()) {
                ((LambdaKotlinCallArgument)argument).setHasBuilderInferenceAnnotation(true);
            }
            if (dontUseBuilderInferenceIfPossible) continue;
            for (TypeVariableFromCallableDescriptor freshVariable : $this$process.getResolvedCall().getFreshVariablesSubstitutor().getFreshVariables()) {
                KotlinType receiverType;
                if ($this$process.getResolvedCall().getTypeArgumentMappingByOriginal().getTypeArgument(freshVariable.getOriginalTypeParameter()) instanceof SimpleTypeArgument || csBuilder.isPostponedTypeVariable(freshVariable) || !TypeUtilsKt.contains(receiverType, (Function1<? super UnwrappedType, Boolean>)((Function1)arg_0 -> PostponedVariablesInitializerResolutionPart.process$lambda$0(freshVariable, arg_0)))) continue;
                csBuilder.markPostponedVariable(freshVariable);
            }
        }
    }

    private static final boolean process$lambda$0(TypeVariableFromCallableDescriptor $freshVariable, UnwrappedType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getConstructor(), (Object)$freshVariable.getOriginalTypeParameter().getTypeConstructor());
    }
}

