/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import com.intellij.openapi.util.CompositeModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticsWithSuppression;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0016J\u001b\u0010\u0018\u001a\r\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\u00190\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0001H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#J\u000e\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\tJ\u0012\u0010&\u001a\u0004\u0018\u00010\f2\u0006\u0010%\u001a\u00020\tH\u0002J\u0006\u0010'\u001a\u00020!J\u0006\u0010(\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/MutableDiagnosticsWithSuppression;", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "suppressCache", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache;", "delegateDiagnostics", "<init>", "(Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache;Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V", "diagnosticList", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "Lkotlin/collections/ArrayList;", "diagnosticsCallback", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink$DiagnosticsCallback;", "cache", "Lcom/intellij/util/CachedValueImpl;", "Lorg/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression;", "kotlin.jvm.PlatformType", "readonlyView", "modificationTracker", "Lcom/intellij/openapi/util/CompositeModificationTracker;", "getModificationTracker", "()Lcom/intellij/openapi/util/CompositeModificationTracker;", "all", "", "forElement", "Lkotlin/jvm/internal/EnhancedNullability;", "psiElement", "Lcom/intellij/psi/PsiElement;", "noSuppression", "setCallbackIfNotSet", "", "callback", "resetCallback", "", "getOwnDiagnostics", "", "report", "diagnostic", "onTheFlyDiagnosticsCallback", "clear", "getReadonlyView", "frontend"})
public final class MutableDiagnosticsWithSuppression
implements Diagnostics {
    @NotNull
    private final KotlinSuppressCache suppressCache;
    @NotNull
    private final Diagnostics delegateDiagnostics;
    @NotNull
    private final ArrayList<Diagnostic> diagnosticList;
    @Nullable
    private volatile DiagnosticSink.DiagnosticsCallback diagnosticsCallback;
    @NotNull
    private final CachedValueImpl<DiagnosticsWithSuppression> cache;
    @NotNull
    private final CompositeModificationTracker modificationTracker;

    public MutableDiagnosticsWithSuppression(@NotNull KotlinSuppressCache suppressCache, @NotNull Diagnostics delegateDiagnostics) {
        Intrinsics.checkNotNullParameter((Object)suppressCache, (String)"suppressCache");
        Intrinsics.checkNotNullParameter((Object)delegateDiagnostics, (String)"delegateDiagnostics");
        this.suppressCache = suppressCache;
        this.delegateDiagnostics = delegateDiagnostics;
        this.diagnosticList = new ArrayList();
        this.cache = new CachedValueImpl(() -> MutableDiagnosticsWithSuppression.cache$lambda$0(this));
        this.modificationTracker = new CompositeModificationTracker(this.delegateDiagnostics.getModificationTracker());
    }

    private final DiagnosticsWithSuppression readonlyView() {
        DiagnosticsWithSuppression diagnosticsWithSuppression = this.cache.getValue();
        Intrinsics.checkNotNull((Object)diagnosticsWithSuppression);
        return diagnosticsWithSuppression;
    }

    @Override
    @NotNull
    public CompositeModificationTracker getModificationTracker() {
        return this.modificationTracker;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> all() {
        Collection<Diagnostic> collection = this.readonlyView().all();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"all(...)");
        return collection;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> forElement(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Collection<Diagnostic> collection = this.readonlyView().forElement(psiElement);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"forElement(...)");
        return collection;
    }

    @Override
    @NotNull
    public Diagnostics noSuppression() {
        Diagnostics diagnostics = this.readonlyView().noSuppression();
        Intrinsics.checkNotNullExpressionValue((Object)diagnostics, (String)"noSuppression(...)");
        return diagnostics;
    }

    @Override
    public boolean setCallbackIfNotSet(@NotNull DiagnosticSink.DiagnosticsCallback callback) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (this.diagnosticsCallback == null) {
            this.diagnosticsCallback = callback;
            this.delegateDiagnostics.setCallbackIfNotSet(callback);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void resetCallback() {
        this.diagnosticsCallback = null;
        this.delegateDiagnostics.resetCallback();
    }

    @NotNull
    public final List<Diagnostic> getOwnDiagnostics() {
        return this.diagnosticList;
    }

    public final void report(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        DiagnosticSink.DiagnosticsCallback diagnosticsCallback = this.onTheFlyDiagnosticsCallback(diagnostic);
        if (diagnosticsCallback != null) {
            diagnosticsCallback.callback(diagnostic);
        }
        this.diagnosticList.add(diagnostic);
        this.getModificationTracker().incModificationCount();
    }

    private final DiagnosticSink.DiagnosticsCallback onTheFlyDiagnosticsCallback(Diagnostic diagnostic) {
        DiagnosticSink.DiagnosticsCallback diagnosticsCallback = this.diagnosticsCallback;
        if (diagnosticsCallback == null) {
            return null;
        }
        DiagnosticSink.DiagnosticsCallback callback = diagnosticsCallback;
        PsiElement element = diagnostic.getPsiElement();
        while (element != null && !(element instanceof PsiFile)) {
            List<KtAnnotationEntry> annotationEntries;
            KtAnnotated annotated;
            KtAnnotated ktAnnotated = annotated = KtStubbedPsiUtil.getPsiOrStubParent(element, KtAnnotated.class, false);
            List<KtAnnotationEntry> list = annotationEntries = ktAnnotated != null ? ktAnnotated.getAnnotationEntries() : null;
            boolean bl = list != null ? !((Collection)list).isEmpty() : false;
            if (bl) {
                return null;
            }
            KtAnnotated ktAnnotated2 = annotated;
            element = ktAnnotated2 != null ? ktAnnotated2.getParent() : null;
        }
        boolean filtered = (Boolean)this.suppressCache.getFilter().invoke((Object)diagnostic);
        if (!filtered) {
            return null;
        }
        return callback;
    }

    public final void clear() {
        this.diagnosticList.clear();
        this.getModificationTracker().incModificationCount();
    }

    @NotNull
    public final DiagnosticsWithSuppression getReadonlyView() {
        return this.readonlyView();
    }

    private static final CachedValueProvider.Result cache$lambda$0(MutableDiagnosticsWithSuppression this$0) {
        List allDiagnostics = CollectionsKt.plus(this$0.delegateDiagnostics.noSuppression().all(), (Iterable)this$0.diagnosticList);
        Object[] objectArray = new Object[]{this$0.getModificationTracker()};
        return new CachedValueProvider.Result<DiagnosticsWithSuppression>(new DiagnosticsWithSuppression(this$0.suppressCache, allDiagnostics), objectArray);
    }
}

