/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.K1Deprecation;
import org.jetbrains.kotlin.backend.jvm.JvmPhasesKt;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CreatePhaseConfigKt;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.extensions.ScriptEvaluationExtension;
import org.jetbrains.kotlin.cli.common.extensions.ShellExtension;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.modules.ModuleChunk;
import org.jetbrains.kotlin.cli.common.profiling.ProfilingCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompilerKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompilerKt;
import org.jetbrains.kotlin.cli.jvm.config.ClassicFrontendSpecificJvmConfigurationKeys;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.pipeline.jvm.JvmCliPipeline;
import org.jetbrains.kotlin.cli.pipeline.jvm.JvmFrontendPipelinePhase;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.config.phaser.PhaseConfig;
import org.jetbrains.kotlin.incremental.components.EnumWhenTracker;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.ICFileMappingTracker;
import org.jetbrains.kotlin.incremental.components.ImportTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.load.java.JavaClassesTracker;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.util.PerformanceManager;
import org.jetbrains.kotlin.util.PhaseType;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J*\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\u001a\u0010\u0017\u001a\u00020\u0018*\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J \u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u001c\u001a\u00020\u0002H\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "<init>", "()V", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "doExecutePhased", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "services", "Lorg/jetbrains/kotlin/config/Services;", "basicMessageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "doExecute", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "addPlatformOptions", "", "", "", "setupPlatformSpecificArgumentsAndServices", "createArguments", "executableScriptFileName", "createMetadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "versionArray", "", "createPerformanceManager", "Lorg/jetbrains/kotlin/util/PerformanceManager;", "Companion", "cli"})
@SourceDebugExtension(value={"SMAP\nK2JVMCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2JVMCompiler.kt\norg/jetbrains/kotlin/cli/jvm/K2JVMCompiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n1#2:323\n*E\n"})
public final class K2JVMCompiler
extends CLICompiler<K2JVMCompilerArguments> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public TargetPlatform getPlatform() {
        return JvmPlatforms.INSTANCE.getDefaultJvmPlatform();
    }

    @Override
    @NotNull
    protected ExitCode doExecutePhased(@NotNull K2JVMCompilerArguments arguments, @NotNull Services services, @NotNull MessageCollector basicMessageCollector) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)basicMessageCollector, (String)"basicMessageCollector");
        return new JvmCliPipeline(this.getDefaultPerformanceManager()).execute((CommonCompilerArguments)arguments, services, basicMessageCollector);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JVMCompilerArguments arguments, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths2) {
        PhaseConfig phaseConfig;
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)rootDisposable, (String)"rootDisposable");
        MessageCollector messageCollector = configuration.getNotNull(CommonConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector, (String)"getNotNull(...)");
        MessageCollector messageCollector2 = messageCollector;
        PhaseConfig phaseConfig2 = phaseConfig = CreatePhaseConfigKt.createPhaseConfig(arguments, JvmPhasesKt.getJvmPhases());
        CompilerConfiguration compilerConfiguration = configuration;
        boolean bl = false;
        if (arguments.getListPhases()) {
            void it;
            CreatePhaseConfigKt.listPhases((PhaseConfig)it, JvmPhasesKt.getJvmPhases());
        }
        CommonConfigurationKeysKt.setPhaseConfig(compilerConfiguration, phaseConfig);
        if (!JvmArgumentsKt.configureJdkHome(configuration, arguments)) {
            return ExitCode.COMPILATION_ERROR;
        }
        configuration.put(JVMConfigurationKeys.DISABLE_STANDARD_SCRIPT_DEFINITION, arguments.getDisableStandardScript());
        ExitCode pluginLoadResult = this.loadPlugins(paths2, (CommonCompilerArguments)arguments, configuration, rootDisposable);
        if (pluginLoadResult != ExitCode.OK) {
            return pluginLoadResult;
        }
        String string = arguments.getModuleName();
        if (string == null) {
            string = "main";
        }
        String moduleName2 = string;
        configuration.put(CommonConfigurationKeys.MODULE_NAME, moduleName2);
        JvmArgumentsKt.configureJavaModulesContentRoots(configuration, arguments);
        JvmArgumentsKt.configureStandardLibs(configuration, paths2, arguments);
        JvmArgumentsKt.configureAdvancedJvmOptions(configuration, arguments);
        JvmArgumentsKt.configureKlibPaths(configuration, arguments);
        if (arguments.getBuildFile() == null && !arguments.getVersion() && !arguments.getAllowNoSourceFiles() && (arguments.getScript() || arguments.getExpression() != null || arguments.getRepl() || arguments.getFreeArgs().isEmpty())) {
            Object v5;
            KotlinCoreEnvironment.ProjectEnvironment projectEnvironment;
            block25: {
                JvmArgumentsKt.configureContentRootsFromClassPath(configuration, arguments);
                JvmContentRootsKt.configureJdkClasspathRoots(configuration);
                if (arguments.getScript() && arguments.getFreeArgs().isEmpty()) {
                    MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Specify script source path to evaluate", null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                projectEnvironment = new KotlinCoreEnvironment.ProjectEnvironment(rootDisposable, KotlinCoreEnvironment.Companion.getOrCreateApplicationEnvironmentForProduction(rootDisposable, configuration), configuration);
                projectEnvironment.registerExtensionsFromPlugins(configuration);
                if (arguments.getScript() || arguments.getExpression() != null) {
                    Object v3;
                    block24: {
                        MockProject mockProject = projectEnvironment.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"getProject(...)");
                        Iterable iterable = ScriptEvaluationExtension.Companion.getInstances(mockProject);
                        for (Object t2 : iterable) {
                            ScriptEvaluationExtension it = (ScriptEvaluationExtension)t2;
                            boolean bl2 = false;
                            if (!it.isAccepted(arguments)) continue;
                            v3 = t2;
                            break block24;
                        }
                        v3 = null;
                    }
                    ScriptEvaluationExtension scriptingEvaluator = v3;
                    if (scriptingEvaluator == null) {
                        MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Unable to evaluate script, no scripting plugin loaded", null, 4, null);
                        return ExitCode.COMPILATION_ERROR;
                    }
                    return scriptingEvaluator.eval(arguments, configuration, projectEnvironment);
                }
                if (!arguments.getRepl()) {
                    MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Kotlin REPL is deprecated and should be enabled explicitly for now; please use the '-Xrepl' option", null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                if (!((Collection)arguments.getFreeArgs()).isEmpty()) {
                    MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.STRONG_WARNING, "The arguments are ignored in the REPL mode", null, 4, null);
                }
                MockProject mockProject = projectEnvironment.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"getProject(...)");
                Iterable iterable = ShellExtension.Companion.getInstances(mockProject);
                for (Object t3 : iterable) {
                    ShellExtension it = (ShellExtension)t3;
                    boolean bl3 = false;
                    if (!it.isAccepted(arguments)) continue;
                    v5 = t3;
                    break block25;
                }
                v5 = null;
            }
            ShellExtension shell = v5;
            if (shell == null) {
                MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Unable to run REPL, no scripting plugin loaded", null, 4, null);
                return ExitCode.COMPILATION_ERROR;
            }
            return shell.run(arguments, configuration, projectEnvironment);
        }
        MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.LOGGING, "Configuring the compilation environment", null, 4, null);
        try {
            File file;
            String string2 = arguments.getBuildFile();
            if (string2 != null) {
                String it = string2;
                boolean bl4 = false;
                file = new File(it);
            } else {
                file = null;
            }
            File buildFile = file;
            ModuleChunk moduleChunk = K2JVMCompilerKt.configureModuleChunk(configuration, arguments, buildFile);
            List<Module> list = moduleChunk.getModules();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getModules(...)");
            List<Module> chunk = list;
            KotlinToJVMBytecodeCompilerKt.configureSourceRoots(configuration, chunk, buildFile);
            JvmContentRootsKt.configureJdkClasspathRoots(configuration);
            String dumpModelDir = configuration.get(CommonConfigurationKeys.DUMP_MODEL);
            KotlinCoreEnvironment kotlinCoreEnvironment = Companion.createCoreEnvironment(rootDisposable, configuration, messageCollector2, K2JVMCompilerKt.targetDescription(moduleChunk));
            if (kotlinCoreEnvironment == null) {
                K2JVMCompiler $this$doExecute_u24lambda_u244 = this;
                boolean bl5 = false;
                PerformanceManager performanceManager = CommonConfigurationKeysKt.getPerfManager(configuration);
                if (performanceManager != null) {
                    performanceManager.notifyPhaseFinished(PhaseType.Initialization);
                }
                return ExitCode.COMPILATION_ERROR;
            }
            KotlinCoreEnvironment environment = kotlinCoreEnvironment;
            boolean it = JvmArgumentsKt.registerJavacIfNeeded(environment, arguments);
            boolean bl6 = false;
            if (!it) {
                return ExitCode.COMPILATION_ERROR;
            }
            if (environment.getSourceFiles().isEmpty() && !arguments.getAllowNoSourceFiles() && buildFile == null) {
                if (arguments.getVersion()) {
                    return ExitCode.OK;
                }
                MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "No source files", null, 4, null);
                return ExitCode.COMPILATION_ERROR;
            }
            if (dumpModelDir != null) {
                JvmFrontendPipelinePhase.INSTANCE.dumpModel(dumpModelDir, chunk, configuration, arguments);
            }
            if (!KotlinToJVMBytecodeCompiler.INSTANCE.compileModules$cli(environment, buildFile, chunk)) {
                return ExitCode.COMPILATION_ERROR;
            }
            return ExitCode.OK;
        }
        catch (CompilationException e2) {
            String string3 = OutputMessageUtil.renderException(e2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"renderException(...)");
            messageCollector2.report(CompilerMessageSeverity.EXCEPTION, string3, MessageUtil.psiElementToMessageLocation(e2.getElement()));
            return ExitCode.INTERNAL_ERROR;
        }
    }

    @Override
    protected void addPlatformOptions(@NotNull List<String> $this$addPlatformOptions, @NotNull K2JVMCompilerArguments arguments) {
        Intrinsics.checkNotNullParameter($this$addPlatformOptions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String[] stringArray = arguments.getScriptTemplates();
        boolean bl = stringArray != null ? !(stringArray.length == 0) : false;
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder().append("plugin:kotlin.scripting:script-templates=");
            Object[] objectArray = arguments.getScriptTemplates();
            Intrinsics.checkNotNull((Object)objectArray);
            $this$addPlatformOptions.add(stringBuilder.append(ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).toString());
        }
        String[] stringArray2 = arguments.getScriptResolverEnvironment();
        boolean bl2 = stringArray2 != null ? !(stringArray2.length == 0) : false;
        if (bl2) {
            StringBuilder stringBuilder = new StringBuilder().append("plugin:kotlin.scripting:script-resolver-environment=");
            Object[] objectArray = arguments.getScriptResolverEnvironment();
            Intrinsics.checkNotNull((Object)objectArray);
            $this$addPlatformOptions.add(stringBuilder.append(ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).toString());
        }
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2JVMCompilerArguments arguments, @NotNull Services services) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        CompilerConfiguration $this$setupPlatformSpecificArgumentsAndServices_u24lambda_u240 = configuration;
        boolean bl = false;
        if (UtilsKt.incrementalCompilationIsEnabled(arguments)) {
            $this$setupPlatformSpecificArgumentsAndServices_u24lambda_u240.putIfNotNull(CommonConfigurationKeys.LOOKUP_TRACKER, services.get(LookupTracker.class));
            $this$setupPlatformSpecificArgumentsAndServices_u24lambda_u240.putIfNotNull(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER, services.get(ExpectActualTracker.class));
            $this$setupPlatformSpecificArgumentsAndServices_u24lambda_u240.putIfNotNull(CommonConfigurationKeys.INLINE_CONST_TRACKER, services.get(InlineConstTracker.class));
            $this$setupPlatformSpecificArgumentsAndServices_u24lambda_u240.putIfNotNull(CommonConfigurationKeys.ENUM_WHEN_TRACKER, services.get(EnumWhenTracker.class));
            $this$setupPlatformSpecificArgumentsAndServices_u24lambda_u240.putIfNotNull(CommonConfigurationKeys.IMPORT_TRACKER, services.get(ImportTracker.class));
            $this$setupPlatformSpecificArgumentsAndServices_u24lambda_u240.putIfNotNull(CommonConfigurationKeys.FILE_MAPPING_TRACKER, services.get(ICFileMappingTracker.class));
            $this$setupPlatformSpecificArgumentsAndServices_u24lambda_u240.putIfNotNull(JVMConfigurationKeys.INCREMENTAL_COMPILATION_COMPONENTS, services.get(IncrementalCompilationComponents.class));
            $this$setupPlatformSpecificArgumentsAndServices_u24lambda_u240.putIfNotNull(ClassicFrontendSpecificJvmConfigurationKeys.JAVA_CLASSES_TRACKER, services.get(JavaClassesTracker.class));
        }
        JvmArgumentsKt.setupJvmSpecificArguments($this$setupPlatformSpecificArgumentsAndServices_u24lambda_u240, arguments);
    }

    @Override
    @NotNull
    public K2JVMCompilerArguments createArguments() {
        K2JVMCompilerArguments k2JVMCompilerArguments;
        K2JVMCompilerArguments $this$createArguments_u24lambda_u240 = k2JVMCompilerArguments = new K2JVMCompilerArguments();
        boolean bl = false;
        if (System.getenv("KOTLIN_REPORT_PERF") != null) {
            $this$createArguments_u24lambda_u240.setReportPerf(true);
        }
        return k2JVMCompilerArguments;
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlinc-jvm";
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        Intrinsics.checkNotNullParameter((Object)versionArray, (String)"versionArray");
        return new MetadataVersion(Arrays.copyOf(versionArray, versionArray.length));
    }

    @Override
    @NotNull
    protected PerformanceManager createPerformanceManager(@NotNull K2JVMCompilerArguments arguments, @NotNull Services services) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        PerformanceManager performanceManager = Companion.createCustomPerformanceManagerOrNull$cli(arguments, services);
        if (performanceManager == null) {
            performanceManager = this.getDefaultPerformanceManager();
        }
        return performanceManager;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\tJ*\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0007J\u001f\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler$Companion;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "createCoreEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "targetDescription", "createCustomPerformanceManagerOrNull", "Lorg/jetbrains/kotlin/util/PerformanceManager;", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "services", "Lorg/jetbrains/kotlin/config/Services;", "createCustomPerformanceManagerOrNull$cli", "cli"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            CLICompiler.Companion.doMain(new K2JVMCompiler(), args);
        }

        @K1Deprecation
        @Nullable
        public final KotlinCoreEnvironment createCoreEnvironment(@NotNull Disposable rootDisposable, @NotNull CompilerConfiguration configuration, @NotNull MessageCollector messageCollector, @NotNull String targetDescription) {
            KotlinCoreEnvironment environment;
            block2: {
                PerformanceManager perfManager;
                Intrinsics.checkNotNullParameter((Object)rootDisposable, (String)"rootDisposable");
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
                Intrinsics.checkNotNullParameter((Object)targetDescription, (String)"targetDescription");
                PerformanceManager performanceManager = perfManager = CommonConfigurationKeysKt.getPerfManager(configuration);
                if (performanceManager != null) {
                    performanceManager.setTargetDescription(targetDescription);
                }
                if (messageCollector.hasErrors()) {
                    return null;
                }
                environment = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JVM_CONFIG_FILES);
                List<KtFile> sourceFiles = environment.getSourceFiles();
                PerformanceManager performanceManager2 = perfManager;
                if (performanceManager2 == null) break block2;
                performanceManager2.addSourcesStats(sourceFiles.size(), environment.countLinesOfCode(sourceFiles));
            }
            return messageCollector.hasErrors() ? null : environment;
        }

        @Nullable
        public final PerformanceManager createCustomPerformanceManagerOrNull$cli(@NotNull K2JVMCompilerArguments arguments, @NotNull Services services) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Intrinsics.checkNotNullParameter((Object)services, (String)"services");
            PerformanceManager externalManager = services.get(PerformanceManager.class);
            if (externalManager != null) {
                return externalManager;
            }
            String string = arguments.getProfileCompilerCommand();
            if (string == null) {
                return null;
            }
            String argument = string;
            return ProfilingCompilerPerformanceManager.Companion.create(argument, arguments.getDetailedPerf());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

