/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.descriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.InternalSymbolFinderAPI;
import org.jetbrains.kotlin.ir.SymbolFinder;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.DescriptorSymbolTableExtension;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@InternalSymbolFinderAPI
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\f\u0010\u001f\u001a\u00020\u0018*\u00020\u0014H\u0002J\f\u0010\u001f\u001a\u00020\u0010*\u00020 H\u0002J\f\u0010\u001f\u001a\u00020\u0012*\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/psi2ir/descriptors/SymbolFinderOverDescriptors;", "Lorg/jetbrains/kotlin/ir/SymbolFinder;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "<init>", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/ir/util/SymbolTable;)V", "builtInsPackage", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "packageNameSegments", "", "", "builtInsPackage$ir_psi2ir", "([Ljava/lang/String;)Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "findGetter", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "property", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "getClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getScopeToLookup", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "findFunctions", "", "findProperties", "toIrSymbol", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "ir.psi2ir"})
@SourceDebugExtension(value={"SMAP\nIrBuiltInsOverDescriptors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrBuiltInsOverDescriptors.kt\norg/jetbrains/kotlin/psi2ir/descriptors/SymbolFinderOverDescriptors\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,653:1\n1586#2:654\n1661#2,3:655\n1586#2:658\n1661#2,3:659\n*S KotlinDebug\n*F\n+ 1 IrBuiltInsOverDescriptors.kt\norg/jetbrains/kotlin/psi2ir/descriptors/SymbolFinderOverDescriptors\n*L\n631#1:654\n631#1:655,3\n638#1:658\n638#1:659,3\n*E\n"})
public final class SymbolFinderOverDescriptors
extends SymbolFinder {
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final SymbolTable symbolTable;

    public SymbolFinderOverDescriptors(@NotNull KotlinBuiltIns builtIns, @NotNull SymbolTable symbolTable) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        this.builtIns = builtIns;
        this.symbolTable = symbolTable;
    }

    @NotNull
    public final MemberScope builtInsPackage$ir_psi2ir(String ... packageNameSegments) {
        Intrinsics.checkNotNullParameter((Object)packageNameSegments, (String)"packageNameSegments");
        return this.builtIns.getBuiltInsModule().getPackage(FqName.Companion.fromSegments(CollectionsKt.listOf((Object[])Arrays.copyOf(packageNameSegments, packageNameSegments.length)))).getMemberScope();
    }

    @Override
    @Nullable
    public IrSimpleFunctionSymbol findGetter(@NotNull IrPropertySymbol property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        DescriptorSymbolTableExtension descriptorSymbolTableExtension = this.symbolTable.getDescriptorExtension();
        PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)property2.getDescriptor()).getGetter();
        Intrinsics.checkNotNull((Object)propertyGetterDescriptor);
        return descriptorSymbolTableExtension.referenceSimpleFunction(propertyGetterDescriptor);
    }

    private final ClassDescriptor getClassDescriptor(ClassId classId) {
        MemberScope memberScope2;
        ClassId parentClassId = classId.getParentClassId();
        if (parentClassId == null) {
            memberScope2 = this.builtIns.getBuiltInsModule().getPackage(classId.getPackageFqName()).getMemberScope();
        } else {
            ClassDescriptor classDescriptor = this.getClassDescriptor(parentClassId);
            memberScope2 = classDescriptor != null ? classDescriptor.getUnsubstitutedInnerClassesScope() : null;
        }
        MemberScope memberScope3 = memberScope2;
        ClassifierDescriptor classifierDescriptor = memberScope3 != null ? memberScope3.getContributedClassifier(classId.getShortClassName(), NoLookupLocation.FROM_BACKEND) : null;
        return classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
    }

    @Override
    @Nullable
    public IrClassSymbol findClass(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        ClassDescriptor classDescriptor = this.getClassDescriptor(classId);
        return classDescriptor != null ? this.toIrSymbol(classDescriptor) : null;
    }

    private final MemberScope getScopeToLookup(CallableId callableId) {
        MemberScope memberScope2;
        ClassId classId = callableId.getClassId();
        if (classId == null) {
            memberScope2 = this.builtIns.getBuiltInsModule().getPackage(callableId.getPackageName()).getMemberScope();
        } else {
            ClassDescriptor classDescriptor = this.getClassDescriptor(classId);
            memberScope2 = classDescriptor != null ? classDescriptor.getUnsubstitutedMemberScope() : null;
        }
        return memberScope2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<IrSimpleFunctionSymbol> findFunctions(@NotNull CallableId callableId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        MemberScope memberScope2 = this.getScopeToLookup(callableId);
        Collection collection = memberScope2 != null ? memberScope2.getContributedFunctions(callableId.getCallableName(), NoLookupLocation.FROM_BACKEND) : null;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.toIrSymbol((FunctionDescriptor)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<IrPropertySymbol> findProperties(@NotNull CallableId callableId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        MemberScope memberScope2 = this.getScopeToLookup(callableId);
        Collection collection = memberScope2 != null ? memberScope2.getContributedVariables(callableId.getCallableName(), NoLookupLocation.FROM_BACKEND) : null;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.toIrSymbol((PropertyDescriptor)it));
        }
        return (List)destination$iv$iv;
    }

    private final IrClassSymbol toIrSymbol(ClassDescriptor $this$toIrSymbol) {
        return this.symbolTable.getDescriptorExtension().referenceClass($this$toIrSymbol);
    }

    private final IrSimpleFunctionSymbol toIrSymbol(FunctionDescriptor $this$toIrSymbol) {
        return this.symbolTable.getDescriptorExtension().referenceSimpleFunction($this$toIrSymbol);
    }

    private final IrPropertySymbol toIrSymbol(PropertyDescriptor $this$toIrSymbol) {
        return this.symbolTable.getDescriptorExtension().referenceProperty($this$toIrSymbol);
    }
}

