/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CompilerSystemProperties;
import org.jetbrains.kotlin.cli.common.environment.UtilKt;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.CompatKt;
import org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler;
import org.jetbrains.kotlin.daemon.CompileServiceImplBase;
import org.jetbrains.kotlin.daemon.CompilerSelector;
import org.jetbrains.kotlin.daemon.KotlinCompileDaemonBase;
import org.jetbrains.kotlin.daemon.LogStream;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.common.OptionsGroup;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J!\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010H\u0014\u00a2\u0006\u0002\u0010\u0011J<\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH$J\u0012\u0010 \u001a\u0004\u0018\u00010\u00012\u0006\u0010!\u001a\u00020\u0014H\u0014J\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u0014J\u001b\u0010%\u001a\u00020#2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0'H\u0004\u00a2\u0006\u0002\u0010(R#\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/daemon/KotlinCompileDaemonBase;", "", "<init>", "()V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "log$delegate", "Lkotlin/Lazy;", "loadVersionFromResource", "", "runSynchronized", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getCompileServiceAndPort", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase;", "", "compilerSelector", "Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "timer", "Ljava/util/Timer;", "runCompileService", "compileService", "awaitServerRun", "", "serverRun", "mainImpl", "args", "", "([Ljava/lang/String;)V", "kotlin-daemon"})
@SourceDebugExtension(value={"SMAP\nKotlinCompileDaemon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCompileDaemon.kt\norg/jetbrains/kotlin/daemon/KotlinCompileDaemonBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n1#2:225\n*E\n"})
public abstract class KotlinCompileDaemonBase {
    @NotNull
    private final Lazy log$delegate;

    public KotlinCompileDaemonBase() {
        Pair pair;
        String string = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss-SSS").format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        String logTime = string;
        String string2 = CompilerSystemProperties.COMPILE_DAEMON_LOG_PATH_PROPERTY.getValue();
        if (string2 != null && (string2 = DaemonParamsKt.trimQuotes(string2)) != null) {
            String it = string2;
            boolean bl = false;
            pair = new Pair((Object)it, (Object)new File(it).isFile());
        } else {
            pair = new Pair((Object)"%t", (Object)false);
        }
        Pair pair2 = pair;
        String logPath = (String)pair2.component1();
        boolean fileIsGiven = (Boolean)pair2.component2();
        String cfg = "handlers = java.util.logging.FileHandler\njava.util.logging.FileHandler.level     = ALL\njava.util.logging.FileHandler.formatter = java.util.logging.SimpleFormatter\njava.util.logging.FileHandler.encoding  = UTF-8\njava.util.logging.FileHandler.limit     = " + (fileIsGiven ? 0 : 0x100000) + "\njava.util.logging.FileHandler.count     = " + (fileIsGiven ? 1 : 3) + "\njava.util.logging.FileHandler.append    = " + fileIsGiven + "\njava.util.logging.FileHandler.pattern   = " + (fileIsGiven ? logPath : logPath + File.separator + "kotlin-daemon." + logTime + ".%u%g.log") + "\njava.util.logging.SimpleFormatter.format = %1$tF %1$tT.%1$tL [%3$s] %4$s: %5$s%n\n";
        LogManager logManager = LogManager.getLogManager();
        String string3 = cfg;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        logManager.readConfiguration(new ByteArrayInputStream(byArray));
        this.log$delegate = LazyKt.lazy((Function0)log.2.INSTANCE);
    }

    public final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    private final String loadVersionFromResource() {
        URLClassLoader uRLClassLoader;
        Object object = KotlinCompileDaemonBase.class.getClassLoader();
        URLClassLoader uRLClassLoader2 = uRLClassLoader = object instanceof URLClassLoader ? (URLClassLoader)object : null;
        if (uRLClassLoader != null && (object = uRLClassLoader.findResource("META-INF/MANIFEST.MF")) != null) {
            Object it = object;
            boolean bl = false;
            try {
                String string = new Manifest(((URL)it).openStream()).getMainAttributes().getValue("Implementation-Version");
                if (string == null) {
                    string = null;
                }
                return string;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    protected <T> T runSynchronized(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return (T)block.invoke();
    }

    @NotNull
    protected abstract Pair<CompileServiceImplBase, Integer> getCompileServiceAndPort(@NotNull CompilerSelector var1, @NotNull CompilerId var2, @NotNull DaemonOptions var3, @NotNull DaemonJVMOptions var4, @NotNull Timer var5);

    @Nullable
    protected Object runCompileService(@NotNull CompileServiceImplBase compileService) {
        Intrinsics.checkNotNullParameter((Object)compileService, (String)"compileService");
        return null;
    }

    protected void awaitServerRun(@Nullable Object serverRun) {
    }

    protected final void mainImpl(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        NetworkUtilsKt.ensureServerHostnameIsSetUp();
        List<String> jvmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        Logger logger = this.getLog();
        StringBuilder stringBuilder = new StringBuilder().append("Kotlin compiler daemon version ");
        String string = this.loadVersionFromResource();
        if (string == null) {
            string = "<unknown>";
        }
        logger.info(stringBuilder.append(string).toString());
        Logger logger2 = this.getLog();
        StringBuilder stringBuilder2 = new StringBuilder().append("daemon JVM args: ");
        Intrinsics.checkNotNull(jvmArguments);
        logger2.info(stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)jvmArguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)).toString());
        this.getLog().info("daemon args: " + ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        UtilKt.setIdeaIoUseFallback();
        CompatKt.setupIdeaStandaloneExecution();
        CompilerId compilerId = new CompilerId(null, null, 3, null);
        DaemonOptions daemonOptions = new DaemonOptions(null, 0L, 0, 0, 0L, 0L, false, false, 255, null);
        this.runSynchronized((Function0)new Function0<Unit>(args, compilerId, daemonOptions, this){
            final /* synthetic */ String[] $args;
            final /* synthetic */ CompilerId $compilerId;
            final /* synthetic */ DaemonOptions $daemonOptions;
            final /* synthetic */ KotlinCompileDaemonBase this$0;
            {
                this.$args = $args;
                this.$compilerId = $compilerId;
                this.$daemonOptions = $daemonOptions;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Object serverRun = null;
                try {
                    DaemonJVMOptions daemonJVMOptions = DaemonParamsKt.configureDaemonJVMOptions(new String[0], true, true, true);
                    OptionsGroup[] optionsGroupArray = new OptionsGroup[]{this.$compilerId, this.$daemonOptions};
                    Iterable<String> filteredArgs = DaemonParamsKt.filterExtractProps(ArraysKt.asIterable((Object[])this.$args), optionsGroupArray, "--daemon-");
                    if (CollectionsKt.any(filteredArgs)) {
                        String helpLine = "usage: <daemon> <compilerId options> <daemon options>";
                        this.this$0.getLog().info(helpLine);
                        System.out.println((Object)helpLine);
                        throw new IllegalArgumentException("Unknown arguments: " + CollectionsKt.joinToString$default(filteredArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                    }
                    this.this$0.getLog().info("starting daemon");
                    CompilerSelector compilerSelector2 = new CompilerSelector(){
                        private final Lazy jvm$delegate;
                        private final Lazy js$delegate;
                        private final Lazy metadata$delegate;
                        {
                            this.jvm$delegate = LazyKt.lazy((Function0)mainImpl.compilerSelector.jvm.2.INSTANCE);
                            this.js$delegate = LazyKt.lazy((Function0)mainImpl.compilerSelector.js.2.INSTANCE);
                            this.metadata$delegate = LazyKt.lazy((Function0)mainImpl.compilerSelector.metadata.2.INSTANCE);
                        }

                        private final K2JVMCompiler getJvm() {
                            Lazy lazy = this.jvm$delegate;
                            return (K2JVMCompiler)lazy.getValue();
                        }

                        private final K2JSCompiler getJs() {
                            Lazy lazy = this.js$delegate;
                            return (K2JSCompiler)lazy.getValue();
                        }

                        private final K2MetadataCompiler getMetadata() {
                            Lazy lazy = this.metadata$delegate;
                            return (K2MetadataCompiler)lazy.getValue();
                        }

                        public CLICompiler<?> get(CompileService.TargetPlatform targetPlatform) {
                            CLICompiler cLICompiler;
                            Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
                            switch (mainImpl.compilerSelector.WhenMappings.$EnumSwitchMapping$0[targetPlatform.ordinal()]) {
                                case 1: {
                                    cLICompiler = (CLICompiler)this.getJvm();
                                    break;
                                }
                                case 2: {
                                    cLICompiler = (CLICompiler)this.getJs();
                                    break;
                                }
                                case 3: {
                                    cLICompiler = (CLICompiler)this.getMetadata();
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            return cLICompiler;
                        }
                    };
                    Timer timer = new Timer(true);
                    Pair<CompileServiceImplBase, Integer> pair = this.this$0.getCompileServiceAndPort(compilerSelector2, this.$compilerId, this.$daemonOptions, daemonJVMOptions, timer);
                    CompileServiceImplBase compilerService2 = (CompileServiceImplBase)pair.component1();
                    int port = ((Number)pair.component2()).intValue();
                    compilerService2.startDaemonElections();
                    compilerService2.configurePeriodicActivities();
                    serverRun = this.this$0.runCompileService(compilerService2);
                    System.out.println((Object)"Kotlin compile daemon is ready");
                    this.this$0.getLog().info("daemon is listening on port: " + port);
                    System.out.close();
                    System.err.close();
                    System.setErr(new PrintStream(new LogStream("stderr")));
                    System.setOut(new PrintStream(new LogStream("stdout")));
                }
                catch (Exception e) {
                    System.err.println("Exception: " + e.getMessage());
                    e.printStackTrace(System.err);
                    this.this$0.getLog().log(Level.INFO, "Exception: ", e);
                    throw e;
                }
                this.this$0.awaitServerRun(serverRun);
            }
        });
    }
}

