/*
 * Copyright 2010-2018 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.gradle.dsl

import groovy.lang.Closure
import org.gradle.api.Action
import org.gradle.api.Task
import org.gradle.api.tasks.Internal
import org.jetbrains.kotlin.gradle.tasks.KotlinCompilationTask

/**
 * Represents a Kotlin task compiling using configurable [kotlinOptions].
 *
 * See [KotlinCommonOptions] and its inheritors for possible Kotlin compiler options.
 *
 * **Note**: This interface is soft-deprecated and only exists for compatibility to configure Kotlin compilation options
 * using soft-deprecated [kotlinOptions].
 * Instead, better to use [KotlinCompilationTask] to configure Kotlin compilation options via [KotlinCompilationTask.compilerOptions].
 *
 * @see [KotlinCommonOptions]
 */
@KotlinGradlePluginDsl
interface KotlinCompile<out T : KotlinCommonOptions> : Task {

    /**
     * Represents the compiler options used by a Kotlin compilation process.
     *
     * This can be used to get the values of currently configured options or modify them.
     *
     * The [kotlinOptions] configuration is delegated to the related task `compilerOptions` input configuration.
     */
    @get:Internal
    val kotlinOptions: T

    /**
     * Configures the [kotlinOptions] with the provided configuration.
     */
    fun kotlinOptions(fn: T.() -> Unit) {
        kotlinOptions.fn()
    }

    /**
     * Configures the [kotlinOptions] with the provided configuration.
     */
    fun kotlinOptions(fn: Action<in T>) {
        fn.execute(kotlinOptions)
    }

    /**
     * @suppress
     */
    @Deprecated("Should be autogenerated by Gradle")
    fun kotlinOptions(fn: Closure<*>) {
        project.configure(kotlinOptions, fn)
    }
}
