/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.IoPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.gradle.BuildListener;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.FinishBuildListener;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper$createPluginIsolatedClassLoader$kotlinPluginDependencies$1;
import org.jetbrains.kotlin.gradle.plugin.ParentLastURLClassLoader;

@KotlinClass(abiVersion=19, data={"\r\b)92j\u001c;mS:\u0014\u0015m]3QYV<\u0017N\\,sCB\u0004XM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*1qM]1eY\u0016Ta\u0001\u001d7vO&t'B\u0002)mk\u001eLgNC\u0002ba&Tq\u0001\u0015:pU\u0016\u001cGO\u0003\u0004=S:LGO\u0010\u0006\u0004Y><'B\u0002'pO\u001e,'OC\u0004m_\u001e<\u0017N\\4\u000b/-|G\u000f\\5o])4XN\f)mCR4wN]7UsB,'BB4fi2{wMC\u0003baBd\u0017PC\u0004qe>TWm\u0019;\u000b\tUs\u0017\u000e\u001e\u0006 GJ,\u0017\r^3QYV<\u0017N\\%t_2\fG/\u001a3DY\u0006\u001c8\u000fT8bI\u0016\u0014(B\u00049s_*,7\r\u001e,feNLwN\u001c\u0006\u0007'R\u0014\u0018N\\4\u000b#M|WO]2f\u0005VLG\u000eZ*de&\u0004HOC\u0007TGJL\u0007\u000f\u001e%b]\u0012dWM\u001d\u0006\u000fS:LG/[1mSj\fG/[8o\u0015\r!7\u000f\u001c\u0006\u0019!\u0006\u0014XM\u001c;MCN$XK\u0015'DY\u0006\u001c8\u000fT8bI\u0016\u0014(\u0002\u00026bm\u0006TA\u0001\\1oO*)b-\u001b8e'>,(oY3Ck&dGmU2sSB$(BE4fiBcWoZ5o\u00072\f7o\u001d(b[\u0016TQ\u0004\\8bI.{G\u000f\\5o-\u0016\u00148/[8o\rJ|WNU3t_V\u00148-\u001aT\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)!\u0001\u0002\u0001\t\u0005\u0015\u0011Aa\u0001E\u0004\u000b\r!9\u0001C\u0002\r\u0001\u0015\u0019Aq\u0001\u0005\u0005\u0019\u0001)!\u0001b\u0002\t\r\u0015\u0019A!\u0002E\u0006\u0019\u0001)!\u0001B\u0003\t\f\u0015\t\u00012A\u0003\u0004\t\u001bA\t\u0002\u0004\u0001\u0006\u0005\u0011\u001d\u0001\u0002B\u0003\u0004\t\u001bA!\u0002\u0004\u0001\u0006\u0005\u0011\u001d\u0001rC\u0003\u0003\t#AA\"B\u0002\u0005\u0013!YA\u0002A\u0003\u0004\t\tAI\u0002\u0004\u0001\u0006\u0005\u0011\u0011\u0001\u0012D\u0003\u0002\u00115)!\u0001B\u0006\t\u001c\u0015\u0011Aq\u0003\u0005\u000b\u000b\t!\u0011\u0002C\u0006\u0005!1\u0015\u0011DB\u0003\u0002\u0011\u0011I1!\u0003\u0002\u0006\u0003!%Q\u0006\u0006\u0003a\ta)\u0011eB\u0003\u0002\u0011\u0017\u0001j!F\u0002\u0006\u0003!-A\u0012A+\u0004\u0011\u0015\u0019A!B\u0005\u0002\u0011\u0019i1\u0001B\u0004\n\u0003!1Qf\u0005\u0003\f1\u001fij\u0001\u0002\u0001\t\u00115\u0011Q!\u0001E\u0005!\u000e\u0001\u0011EA\u0003\u0002\u0011\u001d\t6!\u0002C\b\u0013\u0005!\u0001!D\u0001\t\u00105fB!\u0001\r\n;\u001b!\u0001\u0001c\u0005\u000e\u0005\u0015\t\u0001\u0002\u0003)\u0004\u0001u5A\u0001\u0001E\u000b\u001b\t)\u0011\u0001c\u0005Q\u0007\u0003\t#!B\u0001\t\u0015E\u001bq\u0001B\u0005\n\u0003!UQ\"\u0001\u0005\r\u001b\u0005AI\"\f\u000b\u0005\u0003aqQT\u0002\u0003\u0001\u0011!i!!B\u0001\t\nA\u001b\u0001!I\u0002\u0006\u0003!MA\u0012A)\u0004\u000b\u0011q\u0011\"\u0001E\r\u001b\u0005Ay!l\u0005\u0005'au\u0011EA\u0003\u0002\u0011!\t6a\u0001C\u000f\u0013\u0005AA\"l\u0005\u0005\u0003ay\u0011EA\u0003\u0002\u0011!\t6a\u0001\u0003\u0010\u0013\u0005AA\"N\u0006\u0006\u0015\u0011\u0019\u000f\u0001'\u0003\"\u0005\u0015\t\u0001RA)\u0004\u0007\u0011%\u0011\"\u0001\u0003\u0001"})
public abstract class KotlinBasePluginWrapper
implements KObject,
Plugin<Project> {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    @NotNull
    private final Logger log = Logging.getLogger(this.getClass());

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(KotlinBasePluginWrapper.class);
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    public void apply(@JetValueParameter(name="project") @NotNull Project project) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ScriptHandler sourceBuildScript = this.findSourceBuildScript(project);
        if (sourceBuildScript == null) {
            this.log.error("Failed to determine source cofiguration of kotlin plugin. Can not download core. Please verify that this or any parent project " + "contains 'kotlin-gradle-plugin' in buildscript's classpath configuration.");
            return;
        }
        String kotlinPluginVersion = this.loadKotlinVersionFromResource();
        ExtraPropertiesExtension extraPropertiesExtension = project.getExtensions().getExtraProperties();
        if (extraPropertiesExtension != null) {
            extraPropertiesExtension.set("kotlin.gradle.plugin.version", (Object)kotlinPluginVersion);
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
        ParentLastURLClassLoader pluginClassLoader = this.createPluginIsolatedClassLoader(kotlinPluginVersion, sourceBuildScript);
        Class<?> cls = Class.forName(this.getPluginClassName(), true, pluginClassLoader);
        this.log.debug("Plugin class loaded");
        Constructor<?> constructor = cls.getConstructor(ScriptHandler.class);
        Method method = cls.getMethod("apply", Project.class);
        this.log.debug("'apply' method found, invoking...");
        Object plugin = constructor.newInstance(sourceBuildScript);
        this.log.debug("Plugin class instantiated");
        Method method2 = method;
        Object object2 = method2 != null ? method2.invoke(plugin, project) : null;
        this.log.debug("'apply' method invoked successfully");
        Object object3 = project.getClass().getMethod("getGradle", new Class[0]).invoke((Object)project, new Object[0]);
        if (object3 == null) {
            throw new TypeCastException("kotlin.Any! cannot be cast to org.gradle.api.invocation.Gradle");
        }
        Gradle gradle = (Gradle)object3;
        gradle.addBuildListener((BuildListener)new FinishBuildListener(pluginClassLoader));
    }

    /*
     * WARNING - void declaration
     */
    private final ParentLastURLClassLoader createPluginIsolatedClassLoader(@JetValueParameter(name="projectVersion") String projectVersion, @JetValueParameter(name="sourceBuildScript") ScriptHandler sourceBuildScript) {
        Iterable iterable;
        DependencyHandler dependencyHandler = sourceBuildScript.getDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)dependencyHandler, (String)"sourceBuildScript.getDependencies()");
        DependencyHandler dependencyHandler2 = dependencyHandler;
        ConfigurationContainer configurationContainer = sourceBuildScript.getConfigurations();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer, (String)"sourceBuildScript.getConfigurations()");
        ConfigurationContainer configurationsContainer = configurationContainer;
        this.log.debug("Creating configuration and dependency");
        String kotlinPluginCoreCoordinates = "org.jetbrains.kotlin:kotlin-gradle-plugin-core:" + projectVersion;
        Dependency dependency = dependencyHandler2.create((Object)kotlinPluginCoreCoordinates);
        Configuration configuration = configurationsContainer.detachedConfiguration(new Dependency[]{dependency});
        this.log.debug("Resolving [" + kotlinPluginCoreCoordinates + "]");
        Set set = configuration.getResolvedConfiguration().getFiles((Spec)KotlinBasePluginWrapper$createPluginIsolatedClassLoader$kotlinPluginDependencies$1.INSTANCE$);
        if (set == null) {
            Intrinsics.throwNpe();
        }
        Iterable iterable2 = iterable = (Iterable)set;
        Collection collection = new ArrayList();
        for (Object t : iterable2) {
            void it;
            File file = (File)t;
            Collection collection2 = collection;
            URL uRL = it.toURI().toURL();
            collection2.add(uRL);
        }
        List kotlinPluginDependencies2 = (ArrayList)collection;
        this.log.debug("Resolved files: [" + kotlinPluginDependencies2.toString() + "]");
        this.log.debug("Load plugin in parent-last URL classloader");
        ParentLastURLClassLoader kotlinPluginClassloader = new ParentLastURLClassLoader(kotlinPluginDependencies2, this.getClass().getClassLoader());
        this.log.debug("Class loader created");
        return kotlinPluginClassloader;
    }

    private final String loadKotlinVersionFromResource() {
        InputStream inputStream;
        this.log.debug("Loading version information");
        Properties props = new Properties();
        String propFileName = "project.properties";
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            Intrinsics.throwNpe();
        }
        if ((inputStream = classLoader.getResourceAsStream(propFileName)) == null) {
            throw (Throwable)new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
        }
        props.load(inputStream);
        Object object2 = props.get("project.version");
        if (object2 == null) {
            throw new TypeCastException("kotlin.Any! cannot be cast to kotlin.String");
        }
        String projectVersion = (String)object2;
        this.log.debug("Found project version [" + projectVersion + "]");
        return projectVersion;
    }

    @NotNull
    public abstract String getPluginClassName();

    private final ScriptHandler findSourceBuildScript(@JetValueParameter(name="project") Project project) {
        this.log.debug("Looking for proper script handler");
        Project curProject = project;
        while (Intrinsics.areEqual((Object)curProject, (Object)curProject.getParent()) ^ true) {
            boolean found;
            File file;
            this.log.debug("Looking in project " + project);
            ScriptHandler scriptHandler = curProject.getBuildscript();
            Configuration configuration = (Configuration)scriptHandler.getConfigurations().findByName("classpath");
            if (configuration != null) {
                Object v1;
                block5: {
                    Iterable iterable = (Iterable)configuration;
                    for (Object t : iterable) {
                        File it = (File)t;
                        if (!KotlinPackage.contains((String)IoPackage.getName((File)it), (CharSequence)"kotlin-gradle-plugin")) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                file = v1;
            } else {
                file = null;
            }
            boolean bl = found = file != null;
            if (found) {
                this.log.debug("Found! returning...");
                return scriptHandler;
            }
            this.log.debug("not found, switching to parent");
            if (curProject.getParent() != null) continue;
            Intrinsics.throwNpe();
        }
        return null;
    }
}

