/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ParentLastURLClassLoader
extends ClassLoader {
    private ChildURLClassLoader childClassLoader;

    public ParentLastURLClassLoader(List<URL> classpath, ClassLoader parent) {
        super(Thread.currentThread().getContextClassLoader());
        URL[] urls = classpath.toArray(new URL[classpath.size()]);
        this.childClassLoader = new ChildURLClassLoader(urls, new FindClassClassLoader(parent));
    }

    @Override
    protected synchronized Class<?> loadClass(@NotNull String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.childClassLoader.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name, resolve);
        }
    }

    public static class ChildURLClassLoader
    extends URLClassLoader {
        private final Map<String, Class<?>> cache = new HashMap();
        private FindClassClassLoader realParent;

        public ChildURLClassLoader(URL[] urls, FindClassClassLoader realParent) {
            super(urls, (ClassLoader)null);
            this.realParent = realParent;
        }

        @Override
        @NotNull
        public Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
            try {
                if (name.equals("com.intellij.openapi.util.io.ZipFileCache") || name.equals("com.intellij.openapi.util.LowMemoryWatcher")) {
                    if (this.cache.containsKey(name)) {
                        return this.cache.get(name);
                    }
                    Class<?> aClass = super.findClass(name);
                    this.cache.put(name, aClass);
                    return aClass;
                }
                return super.findClass(name);
            }
            catch (ClassNotFoundException e) {
                return this.realParent.loadClass(name);
            }
        }
    }

    private static class FindClassClassLoader
    extends ClassLoader {
        public FindClassClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        @NotNull
        public Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
            return super.findClass(name);
        }
    }
}

