/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.ParentLastURLClassLoader;

@KotlinClass(abiVersion=19, data={"\u0012\b)\u0019b)\u001b8jg\"\u0014U/\u001b7e\u0019&\u001cH/\u001a8fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0004he\u0006$G.\u001a\u0006\u0007a2,x-\u001b8\u000b\u0019\t+\u0018\u000e\u001c3BI\u0006\u0004H/\u001a:\u000b\rqJg.\u001b;?\u0015E\u0001H.^4j]\u000ec\u0017m]:M_\u0006$WM\u001d\u0006\u0019!\u0006\u0014XM\u001c;MCN$XK\u0015'DY\u0006\u001c8\u000fT8bI\u0016\u0014(b\u00017pO*1Aj\\4hKJT1!\u00199j\u0015\u001dawnZ4j]\u001eTqc[8uY&tgF\u001b<n]Ac\u0017\r\u001e4pe6$\u0016\u0010]3\u000b\r\u001d,G\u000fT8h\u0015Q9W\r\u001e)mk\u001eLgn\u00117bgNdu.\u00193fe*!2/\u001a;QYV<\u0017N\\\"mCN\u001cHj\\1eKJTQBY;jY\u00124\u0015N\\5tQ\u0016$'B\u0002:fgVdGOC\u0006Ck&dGMU3tk2$(\u0002B+oSRTAcY1mYZ{\u0017\u000eZ*uCRL7-T3uQ>$'bC2mCN\u001ch)\u001d(b[\u0016Taa\u0015;sS:<'BC7fi\"|GMT1nK*!!.\u0019<b\u0015\u0011a\u0017M\\4\u000b%I,Wn\u001c<f)\"\u0014X-\u00193M_\u000e\fGn\u001d\u0006\u0015gR|\u0007\u000fT8x\u001b\u0016lwN]=XCR\u001c\u0007.\u001a:\u000b!M$x\u000e\u001d.ja\u001aKG.Z\"bG\",G2\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\t!\u0001\u0001\u0003\u0002\u0006\u0007\u0011\u0019\u0001b\u0001\u0007\u0001\u000b\r!!\u0001#\u0003\r\u0001\u0015\u0011AA\u0001E\u0005\u000b\t!1\u0001\u0003\u0004\u0006\u0005\u0011)\u0001RB\u0003\u0004\t\u0017AY\u0001\u0004\u0001\u0006\u0005\u0011-\u00012B\u0003\u0004\t\rA!\u0002\u0004\u0001\u0006\u0003!\rQa\u0001C\b\u0011+a\u0001!\u0002\u0002\u0005\u0007!QQa\u0001C\b\u00111a\u0001!B\u0001\t\u001b\u0015\u0011A1\u0003E\u000e\u000b\t!!\u0002\u0003\u0007\u0005\u00011\u0015\u0011DA\u0003\u0002\u0011\u000fiC\u0003\u00021\u00051\u0015\ts!B\u0001\t\rA9QcA\u0003\u0002\u0011\u0019a\t!V\u0002\t\u000b\r!Q!C\u0001\t\u000e5\u0019AqB\u0005\u0002\u0011\u001bic\u0003\u0002a\r1\u0011\t3!B\u0001\t\t1\u0005Qk\u0001\b\u0006\u0007\u0011!\u0011\"\u0001E\u0005\u001b\r!\u0001\"C\u0001\t\nE)A\u0011C\u0005\u0002\t\u0001i\u0011\u0001#\u0003.)\u0011Y\u0001$CO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!9A\u0012\u0001)\u0004\u0001\u0005\u0012Q!\u0001\u0005\t#\u000e)A!C\u0005\u0002\t\u0001i\u0011\u0001#\u0005.:\u0011\t\u0001dCO\u0007\t\u0001A9\"\u0004\u0002\u0006\u0003!I\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001\u0012D\u0007\u0003\u000b\u0005A\u0011\u0002UB\u0001C\t)\u0011\u0001\u0003\u0005R\u0007\u001d!1\"C\u0001\u0005\u00015\t\u0001RC\u0007\u0002\u0011+i\u001b\u0002B\u0002\u0019\u001d\u0005\u0012Q!\u0001\u0005\t#\u000e\u0019AAD\u0005\u0002\t\u0001i\u001b\u0002B\u0001\u0019\u001e\u0005\u0012Q!\u0001\u0005\t#\u000e\u0019AQD\u0005\u0002\t\u0001i\u001b\u0002B\u0001\u0019\u001f\u0005\u0012Q!\u0001\u0005\t#\u000e\u0019AaD\u0005\u0002\t\u0001)\\#\"\u000b\u0005G\u0004A:!h\u0004\u0005\u0001!!QbA\u0003\u0002\u0011\u0011a\t\u0001U\u0002\u0001C\t)\u0011\u0001#\u0002R\u0007\u0015!9!C\u0001\u0005\u00015\t\u0001\u0012\u0002"})
public final class FinishBuildListener
extends BuildAdapter
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    @NotNull
    private final Logger log;
    @Nullable
    private ParentLastURLClassLoader pluginClassLoader;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(FinishBuildListener.class);
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    public void buildFinished(@JetValueParameter(name="result", type="?") @Nullable BuildResult result) {
        Unit unit;
        this.log.debug("Build finished listener");
        this.stopZipFileCache();
        this.stopLowMemoryWatcher();
        this.removeThreadLocals();
        this.pluginClassLoader = null;
        BuildResult buildResult = result;
        if (buildResult != null && (buildResult = buildResult.getGradle()) != null) {
            buildResult.removeListener((Object)this);
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
    }

    public final void removeThreadLocals() {
        try {
            this.log.debug("Remove ChildURLClassLoader thread locals");
            Thread thread = Thread.currentThread();
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Class<?> threadLocalMapClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Field tableField = threadLocalMapClass.getDeclaredField("table");
            tableField.setAccessible(true);
            Field referentField = Reference.class.getDeclaredField("referent");
            referentField.setAccessible(true);
            Object object = tableField.get(threadLocalsField.get(thread));
            if (object == null) {
                throw new TypeCastException("kotlin.Any! cannot be cast to kotlin.Array<*>");
            }
            Object[] table = (Object[])object;
            for (int i = 0; i < table.length; ++i) {
                Unit unit;
                ClassLoader classLoader;
                Object entry = table[i];
                if (!(entry != null)) continue;
                ThreadLocal threadLocal = (ThreadLocal)referentField.get(entry);
                Object object2 = threadLocal;
                ClassLoader classLoader2 = object2 != null && (object2 = object2.getClass()) != null ? ((Class)object2).getClassLoader() : (classLoader = null);
                if (!(classLoader instanceof ParentLastURLClassLoader.ChildURLClassLoader)) continue;
                ThreadLocal threadLocal2 = threadLocal;
                if (threadLocal2 != null) {
                    threadLocal2.remove();
                    unit = Unit.INSTANCE$;
                    continue;
                }
                unit = null;
            }
            this.log.debug("Removing ChildURLClassLoader thread locals finished successfully");
        }
        catch (Throwable e) {
            this.log.debug("Exception during thread locals remove: " + e);
        }
    }

    private final void stopZipFileCache() {
        this.callVoidStaticMethod("com.intellij.openapi.util.io.ZipFileCache", "shutdown");
        this.log.debug("ZipFileCache finished successfully");
    }

    private final void stopLowMemoryWatcher() {
        this.callVoidStaticMethod("com.intellij.openapi.util.LowMemoryWatcher", "shutdown");
        this.log.debug("LowMemoryWatcher finished successfully");
    }

    private final void callVoidStaticMethod(@JetValueParameter(name="classFqName") String classFqName, @JetValueParameter(name="methodName") String methodName) {
        String shortName = KotlinPackage.substring((String)classFqName, (int)(KotlinPackage.lastIndexOf((String)classFqName, (char)'.') + 1));
        this.log.debug("Looking for " + shortName + " class");
        Class<?> lowMemoryWatcherClass = Class.forName(classFqName, false, this.pluginClassLoader);
        this.log.debug("Looking for " + methodName + "() method");
        Method shutdownMethod = lowMemoryWatcherClass.getMethod(methodName, new Class[0]);
        this.log.debug("Call " + shortName + "." + methodName + "()");
        shutdownMethod.invoke(null, new Object[0]);
    }

    @Nullable
    public final ParentLastURLClassLoader getPluginClassLoader() {
        return this.pluginClassLoader;
    }

    public final void setPluginClassLoader(@JetValueParameter(name="<set-?>", type="?") @Nullable ParentLastURLClassLoader parentLastURLClassLoader) {
        this.pluginClassLoader = parentLastURLClassLoader;
    }

    public FinishBuildListener(@JetValueParameter(name="pluginClassLoader", type="?") @Nullable ParentLastURLClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
        this.log = Logging.getLogger(((Object)((Object)this)).getClass());
    }
}

