/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.IoPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.gradle.BuildListener;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.FinishBuildListener;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper;
import org.jetbrains.kotlin.gradle.plugin.ParentLastURLClassLoader;

@KotlinClass(abiVersion=19, data={"&\b)92j\u001c;mS:\u0014\u0015m]3QYV<\u0017N\\,sCB\u0004XM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*1qM]1eY\u0016Ta\u0001\u001d7vO&t'B\u0002)mk\u001eLgNC\u0002ba&Tq\u0001\u0015:pU\u0016\u001cGO\u0003\u0004=S:LGO\u0010\u0006\u0004Y><'B\u0002'pO\u001e,'OC\u0004m_\u001e<\u0017N\\4\u000b/-|G\u000f\\5o])4XN\f)mCR4wN]7UsB,'BB4fi2{wMC\u0003baBd\u0017PC\u0004qe>TWm\u0019;\u000b\tUs\u0017\u000e\u001e\u0006 GJ,\u0017\r^3QYV<\u0017N\\%t_2\fG/\u001a3DY\u0006\u001c8\u000fT8bI\u0016\u0014(B\u00049s_*,7\r\u001e,feNLwN\u001c\u0006\u0007'R\u0014\u0018N\\4\u000b#M|WO]2f\u0005VLG\u000eZ*de&\u0004HOC\u0007TGJL\u0007\u000f\u001e%b]\u0012dWM\u001d\u0006\u000fS:LG/[1mSj\fG/[8o\u0015\r!7\u000f\u001c\u0006\u0019!\u0006\u0014XM\u001c;MCN$XK\u0015'DY\u0006\u001c8\u000fT8bI\u0016\u0014(\u0002\u00026bm\u0006TA\u0001\\1oO*)b-\u001b8e'>,(oY3Ck&dGmU2sSB$(\"C4fiBcWoZ5o\u0015E\u0001H.^4j]\u000ec\u0017m]:M_\u0006$WM\u001d\u0006\u000eg\u000e\u0014\u0018\u000e\u001d;IC:$G.\u001a:\u000b;1|\u0017\rZ&pi2LgNV3sg&|gN\u0012:p[J+7o\\;sG\u0016d\u001bA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0005\u0011\u0001\u0001BA\u0003\u0003\t\rA9!B\u0002\u0005\b!\u0019A\u0002A\u0003\u0004\t\u000fAA\u0001\u0004\u0001\u0006\u0005\u0011\u001d\u0001BB\u0003\u0004\t\u0015AY\u0001\u0004\u0001\u0006\u0005\u0011)\u00012B\u0003\u0002\u0011\u0007)1\u0001\"\u0004\t\u00121\u0001QA\u0001C\u0004\u0011\u0011)1\u0001\"\u0004\t\u00151\u0001QA\u0001C\u0004\u0011/)!\u0001\"\u0005\t\u0019\u0015\u0019A!\u0003\u0005\f\u0019\u0001)1\u0001\u0002\u0002\t\u001a1\u0001QA\u0001\u0003\u0003\u00113)\u0011\u0001C\u0007\u0006\u0005\u0011Y\u00012D\u0003\u0003\t/A!\"\u0002\u0002\u0005\u0013!YQA\u0001C\u0004\u0011\r!\u0001\u0003$\u0002\u001a\r\u0015\t\u0001\u0002B\u0005\u0004\u0013\t)\u0011\u0001#\u0003.)\u0011\u0001G\u0001G\u0003\"\u000f\u0015\t\u00012\u0002I\u0007+\r)\u0011\u0001c\u0003\r\u0002U\u001b\u0001\"B\u0002\u0005\u000b%\t\u0001BB\u0007\u0004\t\u001dI\u0011\u0001\u0003\u0004.'\u0011Y\u0001tBO\u0007\t\u0001A\u0001\"\u0004\u0002\u0006\u0003!%\u0001k\u0001\u0001\"\u0005\u0015\t\u0001bB)\u0004\u000b\u0011=\u0011\"\u0001\u0003\u0001\u001b\u0005Ay!,\u000f\u0005\u0003aIQT\u0002\u0003\u0001\u0011'i!!B\u0001\t\u0011A\u001b\u0001!(\u0004\u0005\u0001!UQBA\u0003\u0002\u0011'\u00016\u0011A\u0011\u0003\u000b\u0005A!\"U\u0002\b\t%I\u0011\u0001#\u0006\u000e\u0003!aQ\"\u0001E\r[Q!\u0011\u0001\u0007\b\u001e\u000e\u0011\u0001\u0001\u0002C\u0007\u0003\u000b\u0005AI\u0001U\u0002\u0001C\r)\u0011\u0001c\u0005\r\u0002E\u001bQ\u0001\u0002\b\n\u0003!eQ\"\u0001E\b[\u0003\"!\u0003'\b\u001e\u000e\u0011\u0001\u0001bD\u0007\u0003\u000b\u0005A!\u0002U\u0002\u0001;\u001b!\u0001\u0001c\b\u000e\u0005\u0015\t\u00012\u0003)\u0004\u0002\u00052Q!\u0001\u0005\u0005\u0013\rI!!B\u0001\t\nE\u001bq\u0001\"\b\n\u0003!iQ\"\u0001E\u000b\u001b\u0005AI\"l\u0005\u0005\u0003a\u0001\u0012EA\u0003\u0002\u0011!\t6a\u0001\u0003\u0011\u0013\u0005AA\"N\u0006\u0006\u0015\u0011\u0019\u000f\u0001'\u0003\"\u0005\u0015\t\u0001RA)\u0004\u0007\u0011%\u0011\"\u0001\u0003\u0001"})
public abstract class KotlinBasePluginWrapper
implements KObject,
Plugin<Project> {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    @NotNull
    private final Logger log = Logging.getLogger(this.getClass());

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(KotlinBasePluginWrapper.class);
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    public void apply(@JetValueParameter(name="project") @NotNull Project project) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ScriptHandler sourceBuildScript = this.findSourceBuildScript(project);
        if (sourceBuildScript == null) {
            this.log.error("Failed to determine source cofiguration of kotlin plugin. Can not download core. Please verify that this or any parent project " + "contains 'kotlin-gradle-plugin' in buildscript's classpath configuration.");
            return;
        }
        String kotlinPluginVersion = this.loadKotlinVersionFromResource();
        ExtraPropertiesExtension extraPropertiesExtension = project.getExtensions().getExtraProperties();
        if (extraPropertiesExtension != null) {
            extraPropertiesExtension.set("kotlin.gradle.plugin.version", (Object)kotlinPluginVersion);
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
        ParentLastURLClassLoader pluginClassLoader = this.createPluginIsolatedClassLoader(kotlinPluginVersion, sourceBuildScript);
        Plugin<Project> plugin = this.getPlugin(pluginClassLoader, sourceBuildScript);
        plugin.apply((Object)project);
        project.getGradle().addBuildListener((BuildListener)new FinishBuildListener(pluginClassLoader));
    }

    @NotNull
    protected abstract Plugin<Project> getPlugin(@JetValueParameter(name="pluginClassLoader") @NotNull ParentLastURLClassLoader var1, @JetValueParameter(name="scriptHandler") @NotNull ScriptHandler var2);

    /*
     * WARNING - void declaration
     */
    private final ParentLastURLClassLoader createPluginIsolatedClassLoader(@JetValueParameter(name="projectVersion") String projectVersion, @JetValueParameter(name="sourceBuildScript") ScriptHandler sourceBuildScript) {
        Iterable iterable;
        DependencyHandler dependencyHandler = sourceBuildScript.getDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)dependencyHandler, (String)"sourceBuildScript.getDependencies()");
        DependencyHandler dependencyHandler2 = dependencyHandler;
        ConfigurationContainer configurationContainer = sourceBuildScript.getConfigurations();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer, (String)"sourceBuildScript.getConfigurations()");
        ConfigurationContainer configurationsContainer = configurationContainer;
        this.log.debug("Creating configuration and dependency");
        String kotlinPluginCoreCoordinates = "org.jetbrains.kotlin:kotlin-gradle-plugin-core:" + projectVersion;
        Dependency dependency = dependencyHandler2.create((Object)kotlinPluginCoreCoordinates);
        Configuration configuration = configurationsContainer.detachedConfiguration(new Dependency[]{dependency});
        this.log.debug("Resolving [" + kotlinPluginCoreCoordinates + "]");
        Set set = configuration.getResolvedConfiguration().getFiles((Spec)createPluginIsolatedClassLoader.kotlinPluginDependencies.1.INSTANCE$);
        if (set == null) {
            Intrinsics.throwNpe();
        }
        Iterable iterable2 = iterable = (Iterable)set;
        Collection collection = new ArrayList();
        for (Object t : iterable2) {
            void it;
            File file = (File)t;
            Collection collection2 = collection;
            URL uRL = it.toURI().toURL();
            collection2.add(uRL);
        }
        List kotlinPluginDependencies2 = (ArrayList)collection;
        this.log.debug("Resolved files: [" + kotlinPluginDependencies2.toString() + "]");
        this.log.debug("Load plugin in parent-last URL classloader");
        ParentLastURLClassLoader kotlinPluginClassloader = new ParentLastURLClassLoader(kotlinPluginDependencies2, this.getClass().getClassLoader());
        this.log.debug("Class loader created");
        return kotlinPluginClassloader;
    }

    private final String loadKotlinVersionFromResource() {
        InputStream inputStream;
        this.log.debug("Loading version information");
        Properties props = new Properties();
        String propFileName = "project.properties";
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            Intrinsics.throwNpe();
        }
        if ((inputStream = classLoader.getResourceAsStream(propFileName)) == null) {
            throw (Throwable)new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
        }
        props.load(inputStream);
        Object object = props.get("project.version");
        if (object == null) {
            throw new TypeCastException("kotlin.Any! cannot be cast to kotlin.String");
        }
        String projectVersion = (String)object;
        this.log.debug("Found project version [" + projectVersion + "]");
        return projectVersion;
    }

    private final ScriptHandler findSourceBuildScript(@JetValueParameter(name="project") Project project) {
        this.log.debug("Looking for proper script handler");
        Project curProject = project;
        while (Intrinsics.areEqual((Object)curProject, (Object)curProject.getParent()) ^ true) {
            boolean found;
            File file;
            this.log.debug("Looking in project " + project);
            ScriptHandler scriptHandler = curProject.getBuildscript();
            Configuration configuration = (Configuration)scriptHandler.getConfigurations().findByName("classpath");
            if (configuration != null) {
                Object v1;
                block5: {
                    Iterable iterable = (Iterable)configuration;
                    for (Object t : iterable) {
                        File it = (File)t;
                        if (!KotlinPackage.contains((String)IoPackage.getName((File)it), (CharSequence)"kotlin-gradle-plugin")) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                file = v1;
            } else {
                file = null;
            }
            boolean bl = found = file != null;
            if (found) {
                this.log.debug("Found! returning...");
                return scriptHandler;
            }
            this.log.debug("not found, switching to parent");
            if (curProject.getParent() != null) continue;
            Intrinsics.throwNpe();
        }
        return null;
    }
}

