/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ScheduledExecutorService;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.ParentLastURLClassLoader;
import org.jetbrains.kotlin.gradle.plugin.ThreadTracker;

@KotlinClass(abiVersion=22, kind=KotlinClass.Kind.CLASS, data={"B\b)\u0019b)\u001b8jg\"\u0014U/\u001b7e\u0019&\u001cH/\u001a8fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0004he\u0006$G.\u001a\u0006\u0007a2,x-\u001b8\u000b\u0019\t+\u0018\u000e\u001c3BI\u0006\u0004H/\u001a:\u000b\rqJg.\u001b;?\u0015E\u0001H.^4j]\u000ec\u0017m]:M_\u0006$WM\u001d\u0006\u0019!\u0006\u0014XM\u001c;MCN$XK\u0015'DY\u0006\u001c8\u000fT8bI\u0016\u0014(b\u00017pO*1Aj\\4hKJT1!\u00199j\u0015\u001dawnZ4j]\u001eTqc[8uY&tgF\u001b<n]Ac\u0017\r\u001e4pe6$\u0016\u0010]3\u000b\r\u001d,G\u000fT8h\u0015Q9W\r\u001e)mk\u001eLgn\u00117bgNdu.\u00193fe*!2/\u001a;QYV<\u0017N\\\"mCN\u001cHj\\1eKJTQ\u0002\u001e5sK\u0006$GK]1dW\u0016\u0014(\"\u0004+ie\u0016\fG\r\u0016:bG.,'OC\u0007ck&dGMR5oSNDW\r\u001a\u0006\u0007e\u0016\u001cX\u000f\u001c;\u000b\u0017\t+\u0018\u000e\u001c3SKN,H\u000e\u001e\u0006\u0005+:LGO\u0003\u000bdC2dgk\\5e'R\fG/[2NKRDw\u000e\u001a\u0006\fG2\f7o\u001d$r\u001d\u0006lWM\u0003\u0004TiJLgn\u001a\u0006\u000b[\u0016$\bn\u001c3OC6,'\u0002\u00026bm\u0006TA\u0001\\1oO*\u0011\"/Z7pm\u0016$\u0006N]3bI2{7-\u00197t\u0015A\u0019Ho\u001c9K_\n\u001c6\r[3ek2,'O\u0003\u000bti>\u0004Hj\\<NK6|'/_,bi\u000eDWM\u001d\u0006\u0011gR|\u0007OW5q\r&dWmQ1dQ\u0016T\u001aA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0005\u0011\u0001\u0001BA\u0003\u0004\t\rA1\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001\u0012\u0002\u0007\u0001\u000b\t!!\u0001#\u0003\u0006\u0005\u0011\u0019\u0001BB\u0003\u0003\t\u0015Ai!B\u0002\u0005\f!-A\u0002A\u0003\u0003\t\u0017AY!B\u0002\u0005\u0005!MA\u0002A\u0003\u0003\t\tA\u0019\"B\u0002\u0005\u0007!YA\u0002A\u0003\u0002\u0011\u0007)1\u0001\"\u0005\t\u00181\u0001QA\u0001\u0003\u0004\u0011-)1\u0001\"\u0005\t\u001b1\u0001Q!\u0001\u0005\u000f\u000b\t!)\u0002#\b\u0006\u0005\u0011Y\u0001\"\u0004\u0003\u0001\u0019\u000bI\"!B\u0001\t\b5\"B\u0001\u0019\u0003\u0019\u000b\u0005:Q!\u0001\u0005\u0007!\u001d)2!B\u0001\t\r1\u0005Qk\u0001\u0005\u0006\u0007\u0011)\u0011\"\u0001E\u0007\u001b\r!y!C\u0001\t\u000e52B\u00011\u0007\u0019\t\u0005\u001aQ!\u0001\u0005\u0005\u0019\u0003)6AD\u0003\u0004\t\u0011I\u0011\u0001#\u0003\u000e\u0007\u0011A\u0011\"\u0001E\u0005#\u0015!\t\"C\u0001\u0005\u00015\t\u0001\u0012B\u0017\r\t\u0005g\u0001$C\u0011\u0004\u000b\u0005Aq\u0001$\u0001V\u0007\u0011)1\u0001B\u0005\n\u0003!=Q\u0006\u0006\u0003\f1)iz\u0001\u0002\u0001\t\u00165\u0019Q!\u0001\u0005\t\u0019\u0003\u00016\u0001A\u0011\u0003\u000b\u0005A\u0011\"U\u0002\u0006\t)I\u0011\u0001\u0002\u0001\u000e\u0003!MQ\u0016\b\u0003\u000211ij\u0001\u0002\u0001\t\u001a5\u0011Q!\u0001\u0005\u000b!\u000e\u0001QT\u0002\u0003\u0001\u00117i!!B\u0001\t\u0015A\u001b\t!\t\u0002\u0006\u0003!I\u0011kA\u0004\u0005\u0019%\tA\u0001A\u0007\u0002\u0011/i\u0011\u0001c\u0006.\u0014\u0011\u0019\u0001dD\u0011\u0003\u000b\u0005A\u0011\"U\u0002\u0004\t=I\u0011\u0001\u0002\u0001.\u0014\u0011\t\u0001tD\u0011\u0003\u000b\u0005A\u0011\"U\u0002\u0004\t?I\u0011\u0001\u0002\u0001.\u0014\u0011\t\u0001\u0004E\u0011\u0003\u000b\u0005A\u0011\"U\u0002\u0004\tAI\u0011\u0001\u0002\u0001.\u0014\u0011\t\u0001\u0014E\u0011\u0003\u000b\u0005A\u0011\"U\u0002\u0004\tCI\u0011\u0001\u0002\u00016,\u0015%Ba9\u0001\u0019\bu=A\u0001\u0001\u0005\u0005\u001b\r)\u0011\u0001\u0003\u0003\r\u0002A\u001b\u0001!\t\u0002\u0006\u0003!\u0015\u0011kA\u0003\u0005\b%\tA\u0001A\u0007\u0002\u0011\u0013\u0001"})
public final class FinishBuildListener
extends BuildAdapter {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final Logger log;
    private ThreadTracker threadTracker;
    @Nullable
    private ParentLastURLClassLoader pluginClassLoader;

    static {
        $kotlinClass = Reflection.createKotlinClass(FinishBuildListener.class);
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    public void buildFinished(@JetValueParameter(name="result", type="?") @Nullable BuildResult result) {
        Unit unit;
        Unit unit2;
        this.log.debug("Build finished listener");
        this.stopZipFileCache();
        this.stopLowMemoryWatcher();
        this.stopJobScheduler();
        this.removeThreadLocals();
        this.pluginClassLoader = null;
        BuildResult buildResult = result;
        if (buildResult != null && (buildResult = buildResult.getGradle()) != null) {
            buildResult.removeListener((Object)this);
            unit2 = Unit.INSTANCE$;
        } else {
            unit2 = null;
        }
        ThreadTracker threadTracker = this.threadTracker;
        if (threadTracker != null) {
            BuildResult buildResult2 = result;
            threadTracker.checkThreadLeak((Gradle)(buildResult2 != null ? buildResult2.getGradle() : null));
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
        this.threadTracker = null;
    }

    public final void removeThreadLocals() {
        try {
            this.log.debug("Remove ChildURLClassLoader thread locals");
            Thread thread = Thread.currentThread();
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Class<?> threadLocalMapClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Field tableField = threadLocalMapClass.getDeclaredField("table");
            tableField.setAccessible(true);
            Field referentField = Reference.class.getDeclaredField("referent");
            referentField.setAccessible(true);
            Object object = tableField.get(threadLocalsField.get(thread));
            if (object == null) {
                throw new TypeCastException("kotlin.Any! cannot be cast to kotlin.Array<*>");
            }
            Object[] table = (Object[])object;
            for (int i = 0; i < table.length; ++i) {
                Unit unit;
                ClassLoader classLoader;
                Object entry = table[i];
                if (!(entry != null)) continue;
                ThreadLocal threadLocal = (ThreadLocal)referentField.get(entry);
                Object object2 = threadLocal;
                ClassLoader classLoader2 = object2 != null && (object2 = object2.getClass()) != null ? ((Class)object2).getClassLoader() : (classLoader = null);
                if (!(classLoader instanceof ParentLastURLClassLoader.ChildURLClassLoader)) continue;
                ThreadLocal threadLocal2 = threadLocal;
                if (threadLocal2 != null) {
                    threadLocal2.remove();
                    unit = Unit.INSTANCE$;
                    continue;
                }
                unit = null;
            }
            this.log.debug("Removing ChildURLClassLoader thread locals finished successfully");
        }
        catch (Throwable e) {
            this.log.debug("Exception during thread locals remove: " + e);
        }
    }

    private final void stopZipFileCache() {
        this.callVoidStaticMethod("com.intellij.openapi.util.io.ZipFileCache", "stopBackgroundThread");
        this.log.debug("ZipFileCache finished successfully");
    }

    private final void stopLowMemoryWatcher() {
        this.callVoidStaticMethod("com.intellij.openapi.util.LowMemoryWatcher", "stopAll");
        this.log.debug("LowMemoryWatcher finished successfully");
    }

    private final void stopJobScheduler() {
        this.log.debug("Stop JobScheduler");
        Class<?> jobSchedulerClass = Class.forName("com.intellij.concurrency.JobScheduler", false, this.pluginClassLoader);
        Method getSchedulerMethod = jobSchedulerClass.getMethod("getScheduler", new Class[0]);
        Object object = getSchedulerMethod.invoke((Object)this, new Object[0]);
        if (object == null) {
            throw new TypeCastException("kotlin.Any! cannot be cast to java.util.concurrent.ScheduledExecutorService");
        }
        ScheduledExecutorService executorService = (ScheduledExecutorService)object;
        executorService.shutdown();
        this.log.debug("JobScheduler stopped");
    }

    private final void callVoidStaticMethod(@JetValueParameter(name="classFqName") String classFqName, @JetValueParameter(name="methodName") String methodName) {
        String shortName = KotlinPackage.substring((String)classFqName, (int)(KotlinPackage.lastIndexOf((String)classFqName, (char)'.') + 1));
        this.log.debug("Looking for " + shortName + " class");
        Class<?> lowMemoryWatcherClass = Class.forName(classFqName, false, this.pluginClassLoader);
        this.log.debug("Looking for " + methodName + "() method");
        Method shutdownMethod = lowMemoryWatcherClass.getMethod(methodName, new Class[0]);
        this.log.debug("Call " + shortName + "." + methodName + "()");
        shutdownMethod.invoke(null, new Object[0]);
    }

    @Nullable
    public final ParentLastURLClassLoader getPluginClassLoader() {
        return this.pluginClassLoader;
    }

    public final void setPluginClassLoader(@JetValueParameter(name="<set-?>", type="?") @Nullable ParentLastURLClassLoader parentLastURLClassLoader) {
        this.pluginClassLoader = parentLastURLClassLoader;
    }

    public FinishBuildListener(@JetValueParameter(name="pluginClassLoader", type="?") @Nullable ParentLastURLClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
        this.log = Logging.getLogger(((Object)((Object)this)).getClass());
        this.threadTracker = new ThreadTracker();
    }
}

