/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.lang.reflect.Method;
import java.util.concurrent.ScheduledExecutorService;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.PluginPackage$KotlinPluginWrapper$d66d64a4;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={" \u0006)92i\\7qS2,'oU3sm&\u001cWm]\"mK\u0006tW\u000f\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*1qM]1eY\u0016Ta\u0001\u001d7vO&t'bA!os*1A(\u001b8jizR\u0011\u0003\u001d7vO&t7\t\\1tg2{\u0017\rZ3s\u0015-\u0019E.Y:t\u0019>\fG-\u001a:\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twMC\u0002m_\u001eTa\u0001T8hO\u0016\u0014(bA1qS*9An\\4hS:<'bF6pi2LgN\f6w[:\u0002F.\u0019;g_JlG+\u001f9f\u0015\u00199W\r\u001e'pO*!2-\u00197m->LGm\u0015;bi&\u001cW*\u001a;i_\u0012T1b\u00197bgN4\u0015OT1nK*11\u000b\u001e:j]\u001eT!\"\\3uQ>$g*Y7f\u0015\u0011)f.\u001b;\u000b\r%tgo\\6f\u0015A\u0019Ho\u001c9K_\n\u001c6\r[3ek2,'O\u0003\tti>\u0004(,\u001b9GS2,7)Y2iKzT!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019Aa\u0001\u0005\u0004\u0019\u0001)\u0011\u0001C\u0003\u0006\u0005\u0011!\u00012B\u0003\u0004\t\u0013AI\u0001\u0004\u0001\u0006\u0005\u0011%\u0001\u0012B\u0003\u0003\t\u0001A!!\u0002\u0002\u0005\r!9QA\u0001C\u0007\u0011\u001f)1\u0001B\u0004\t\u000e1\u0001QA\u0001\u0003\b\u0011\u001b)1\u0001B\u0002\t\u00151\u0001Qa\u0001\u0003\u0004\u0011-a\u0001!\u0002\u0002\u0005\n!QA\u0001\u0001G\u00033\t)\u0011\u0001c\u0002.)\u0011\u0001G\u0001\u0007\u0004\"\u000f\u0015\t\u0001r\u0002\t\t+\r)\u0011\u0001c\u0004\r\u0002U\u001b\u0001\"B\u0002\u0005\r%\t\u0001\u0002C\u0007\u0004\t#I\u0011\u0001\u0003\u0005.\u0019\u0011\tM\u0002\u0007\u0003\"\u0007\u0015\t\u0001\"\u0002G\u0001+\u000e!Qa\u0001\u0003\u0005\u0013\u0005AY!,\u000f\u0005\u0003aIQT\u0002\u0003\u0001\u0011'i!!B\u0001\t\u0012A\u001b\u0001!(\u0004\u0005\u0001!UQBA\u0003\u0002\u0011#\u00016\u0011A\u0011\u0003\u000b\u0005A\u0011\"U\u0002\b\t%I\u0011\u0001\u0002\u0001\u000e\u0003!MQ\"\u0001E\n['!\u0001\u0001g\u0006\"\u0005\u0015\t\u0001\"C)\u0004\u0007\u0011]\u0011\"\u0001\u0003\u0001['!\u0011\u0001\u0007\u0007\"\u0005\u0015\t\u0001\"C)\u0004\u0007\u0011a\u0011\"\u0001\u0003\u0001['!\u0011\u0001'\u0007\"\u0005\u0015\t\u0001\"C)\u0004\u0007\u0011e\u0011\"\u0001\u0003\u0001kW)I\u0003Br\u00011\u000fiz\u0001\u0002\u0001\t\t5\u0019Q!\u0001\u0005\u0006\u0019\u0003\u00016\u0001A\u0011\u0003\u000b\u0005A)!U\u0002\u0006\t\u000fI\u0011\u0001\u0002\u0001\u000e\u0003!-\u0001"})
public final class CompilerServicesCleanup {
    public static final /* synthetic */ KClass $kotlinClass;
    private final Logger log;
    private ClassLoader pluginClassLoader;

    static {
        $kotlinClass = Reflection.createKotlinClass(CompilerServicesCleanup.class);
    }

    public final Logger getLog() {
        return this.log;
    }

    public final void invoke() {
        KotlinPackage.assert$default((this.pluginClassLoader != null ? 1 : 0) != 0, null, (int)2);
        PluginPackage$KotlinPluginWrapper$d66d64a4.kotlinDebug(this.log, "compiler services cleanup");
        this.stopZipFileCache();
        this.stopJobScheduler();
        this.pluginClassLoader = null;
    }

    private final void stopZipFileCache() {
        this.callVoidStaticMethod("com.intellij.openapi.util.io.ZipFileCache", "stopBackgroundThread");
        PluginPackage$KotlinPluginWrapper$d66d64a4.kotlinDebug(this.log, "ZipFileCache finished successfully");
    }

    private final void stopJobScheduler() {
        PluginPackage$KotlinPluginWrapper$d66d64a4.kotlinDebug(this.log, "Stop JobScheduler");
        Class<?> jobSchedulerClass = Class.forName("com.intellij.concurrency.JobScheduler", false, this.pluginClassLoader);
        Method getSchedulerMethod = jobSchedulerClass.getMethod("getScheduler", new Class[0]);
        Object object = getSchedulerMethod.invoke((Object)this, new Object[0]);
        if (object == null) {
            throw new TypeCastException("kotlin.Any! cannot be cast to java.util.concurrent.ScheduledExecutorService");
        }
        ScheduledExecutorService executorService = (ScheduledExecutorService)object;
        executorService.shutdown();
        PluginPackage$KotlinPluginWrapper$d66d64a4.kotlinDebug(this.log, "JobScheduler stopped");
    }

    private final void callVoidStaticMethod(@JetValueParameter(name="classFqName") String classFqName, @JetValueParameter(name="methodName") String methodName) {
        String shortName = KotlinPackage.substring((String)classFqName, (int)(KotlinPackage.lastIndexOf$default((String)classFqName, (char)'.', (int)0, (boolean)false, (int)6) + 1));
        PluginPackage$KotlinPluginWrapper$d66d64a4.kotlinDebug(this.log, "Looking for " + shortName + " class");
        Class<?> lowMemoryWatcherClass = Class.forName(classFqName, false, this.pluginClassLoader);
        PluginPackage$KotlinPluginWrapper$d66d64a4.kotlinDebug(this.log, "Looking for " + methodName + "() method");
        Method shutdownMethod = lowMemoryWatcherClass.getMethod(methodName, new Class[0]);
        PluginPackage$KotlinPluginWrapper$d66d64a4.kotlinDebug(this.log, "Call " + shortName + "." + methodName + "()");
        shutdownMethod.invoke(null, new Object[0]);
    }

    public CompilerServicesCleanup(@JetValueParameter(name="pluginClassLoader", type="?") @Nullable ClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
        this.log = Logging.getLogger(this.getClass());
    }
}

