/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.lang.reflect.Method;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={" \u0006)92i\\7qS2,'oU3sm&\u001cWm]\"mK\u0006tW\u000f\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*1qM]1eY\u0016Ta\u0001\u001d7vO&t'bA!os*1A(\u001b8jizR\u0011\u0003\u001d7vO&t7\t\\1tg2{\u0017\rZ3s\u0015-\u0019E.Y:t\u0019>\fG-\u001a:\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twMC\u0002m_\u001eTa\u0001T8hO\u0016\u0014(bA1qS*9An\\4hS:<'bF6pi2LgN\f6w[:\u0002F.\u0019;g_JlG+\u001f9f\u0015\u00199W\r\u001e'pO*!2-\u00197m->LGm\u0015;bi&\u001cW*\u001a;i_\u0012T1b\u00197bgN4\u0015OT1nK*11\u000b\u001e:j]\u001eT!\"\\3uQ>$g*Y7f\u0015\u0011)f.\u001b;\u000b\r%tgo\\6f\u0015A\u0019Ho\u001c9K_\n\u001c6\r[3ek2,'O\u0003\tti>\u0004(,\u001b9GS2,7)Y2iKzT!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019Aa\u0001\u0005\u0004\u0019\u0001)\u0011\u0001C\u0003\u0006\u0005\u0011!\u00012B\u0003\u0004\t\u0013AI\u0001\u0004\u0001\u0006\u0005\u0011%\u0001\u0012B\u0003\u0003\t\u0001A!!\u0002\u0002\u0005\r!9QA\u0001C\u0007\u0011\u001f)1\u0001B\u0004\t\u000e1\u0001QA\u0001\u0003\b\u0011\u001b)1\u0001B\u0002\t\u00151\u0001Qa\u0001\u0003\u0004\u0011-a\u0001!\u0002\u0002\u0005\n!QAa\u0001G\u00033\r)\u0011\u0001c\u0002\u0019\b52Ba\u0019\u0003\u0019\r\u0005JQ!\u0001E\b!!)B!B\u0001\t\u00101\u0005\u0001t\u0002M\b+\u000eAQa\u0001\u0003\u0007\u0013\u0005A\u0001\"D\u0002\u0005\u0012%\t\u0001\u0002C\u0017\u000e\t\u0005g\u0001\u0004B\u0011\u0005\u000b\u0005AQ\u0001$\u0001\u0019\u000bU\u001bA!B\u0002\u0005\t%\t\u00012BW \t\u0005A\u0012\"h\u0004\u0005\u0001!MQbA\u0003\u0002\u0011#A\n\u0002U\u0002\u0001;\u001f!\u0001\u0001#\u0006\u000e\u0007\u0015\t\u0001\u0012\u0003M\t!\u000e\u0005\u0011eA\u0003\u0002\u0011%A\u0012\"U\u0002\b\t%I\u0011\u0001\u0002\u0001\u000e\u0003!MQ\"\u0001E\n[+!1\u0001g\u0006\"\u0007\u0015\t\u0001\"\u0003\r\n#\u000e\u0019AqC\u0005\u0002\t\u0001i+\u0002B\u0001\u0019\u0019\u0005\u001aQ!\u0001\u0005\n1%\t6a\u0001\u0003\r\u0013\u0005!\u0001!,\u0006\u0005\u0003ae\u0011eA\u0003\u0002\u0011%A\u0012\"U\u0002\u0004\t3I\u0011\u0001\u0002\u000160\u00155Ba9\u0001\u0019\buEA\u0001\u0001\u0005\u0005\u001b\u0011)\u0011\u0001C\u0003\r\u0002a)\u0001k\u0001\u0001\"\u0007\u0015\t\u0001R\u0001M\u0003#\u000e)AqA\u0005\u0002\t\u0001i\u0011\u0001c\u0003"})
public final class CompilerServicesCleanup {
    public static final /* synthetic */ KClass $kotlinClass;
    private final Logger log;
    private ClassLoader pluginClassLoader;

    static {
        $kotlinClass = Reflection.createKotlinClass(CompilerServicesCleanup.class);
    }

    public final Logger getLog() {
        return this.log;
    }

    public final void invoke() {
        PreconditionsKt.assert((this.pluginClassLoader != null ? 1 : 0) != 0);
        KotlinPluginWrapperKt.kotlinDebug(this.log, "compiler services cleanup");
        this.stopZipFileCache();
        this.stopJobScheduler();
        this.pluginClassLoader = null;
    }

    private final void stopZipFileCache() {
        this.callVoidStaticMethod("com.intellij.openapi.util.io.ZipFileCache", "stopBackgroundThread");
        KotlinPluginWrapperKt.kotlinDebug(this.log, "ZipFileCache finished successfully");
    }

    private final void stopJobScheduler() {
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Stop JobScheduler");
        Class<?> jobSchedulerClass = Class.forName("com.intellij.concurrency.JobScheduler", false, this.pluginClassLoader);
        Method getSchedulerMethod = jobSchedulerClass.getMethod("getScheduler", new Class[0]);
        Object object = getSchedulerMethod.invoke((Object)this, new Object[0]);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.concurrent.ScheduledExecutorService");
        }
        ScheduledExecutorService executorService = (ScheduledExecutorService)object;
        executorService.shutdown();
        KotlinPluginWrapperKt.kotlinDebug(this.log, "JobScheduler stopped");
    }

    private final void callVoidStaticMethod(String classFqName, String methodName) {
        String shortName = StringsKt.substring((String)classFqName, (int)(StringsKt.lastIndexOf$default((String)classFqName, (char)'.', (int)0, (boolean)false, (int)6) + 1));
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Looking for " + shortName + " class");
        Class<?> lowMemoryWatcherClass = Class.forName(classFqName, false, this.pluginClassLoader);
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Looking for " + methodName + "() method");
        Method shutdownMethod = lowMemoryWatcherClass.getMethod(methodName, new Class[0]);
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Call " + shortName + "." + methodName + "()");
        shutdownMethod.invoke(null, new Object[0]);
    }

    public CompilerServicesCleanup(@Nullable ClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
        this.log = Logging.getLogger(this.getClass());
    }
}

