/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.AnnotationProcessingManager;
import org.jetbrains.kotlin.gradle.plugin.KaptExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.gradle.plugin.SubpluginEnvironment;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"v\u0006)9\u0001K]8kK\u000e$(bA8sO*1qM]1eY\u0016T1!\u00199j\u0015e\u0019'/Z1uK.{G\u000f\\5o\u0003\u001a$XM\u001d&bm\u0006$\u0016m]6\u000b\u0011)\fg/\u0019+bg.Tq\"\u00112tiJ\f7\r^\"p[BLG.\u001a\u0006\u0006i\u0006\u001c8n\u001d\u0006\bG>l\u0007/\u001b7f\u0015=Yw\u000e\u001e7j]>+H\u000f];u\t&\u0014(\u0002\u0002$jY\u0016TAA[1wC*\u0011\u0011n\u001c\u0006\fi\u0006\u001c8NR1di>\u0014\u0018PC\u0005Gk:\u001cG/[8oc)11n\u001c;mS:Taa\u0015;sS:<'b\u00016w[*Ia-\u001e8di&|gn\u001d\u0006\u001e\u0003:tw\u000e^1uS>t\u0007K]8dKN\u001c\u0018N\\4NC:\fw-\u001a:Li*A\u0011N\\5u\u0017\u0006\u0004HO\u0003\u0006l_Rd\u0017N\u001c+bg.T1b[1qi6\u000bg.Y4fe*Y\u0012I\u001c8pi\u0006$\u0018n\u001c8Qe>\u001cWm]:j]\u001el\u0015M\\1hKJT\u0011B[3uEJ\f\u0017N\\:\u000b\u0011%tG/\u001a:oC2T1B^1sS\u0006tGOT1nK*!2/\u001e2qYV<\u0017N\\#om&\u0014xN\\7f]RTAcU;ca2,x-\u001b8F]ZL'o\u001c8nK:$(B\u00029mk\u001eLgN\u0003\u0003mC:<G8\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0019A!\u0001\u0005\u0001\u0019\u0001)!\u0001B\u0001\t\b\u0015\u0011AA\u0001\u0005\u0005\u000b\r!)\u0001C\u0002\r\u0001\u0015\t\u00012B\u0003\u0003\t\u000fAa!B\u0002\u0005\t!)A\u0002A\u0003\u0002\u0011\u001f)1\u0001B\u0003\t\u000f1\u0001Qa\u0001\u0003\u0006\u0011!a\u0001!\u0002\u0002\u0005\u0006!\u0019QA\u0001\u0003\u0002\u0011\u0001)!\u0001\u0002\u0003\t\u000b\u0015\u0011A!\u0002E\t\u000b\t!\u0001\u0002C\u0005\u0006\u0005\u0011E\u0001bB\u0003\u0003\t\u0001AA\"\u0002\u0002\u0005\u0014!=QA\u0001\u0003\u000b\u0011\u0005)!\u0001\"\u0006\t\u001a\u0015\u0019Aa\u0003E\f\u0019\u0001)!\u0001\"\u0006\t\u001e\u0015\u0019A\u0001\u0004\u0005\u000f\u0019\u0001)!\u0001B\u0006\t\u0018\u0015\u0011Aq\u0001\u0005\u0010\u000b\t!Y\u0002\u0003\u0005\u0006\u0005\u0011a\u0001BDC<\t\u0005)2!B\u0001\t\u0004a\r\u0001DAO\b\t\u0001A)!D\u0002\u0006\u0003!\u0019\u0001d\u0001)\u0004\u0002u=A\u0001\u0001E\u0005\u001b\r)\u0011\u0001#\u0003\u0019\nA\u001b\u0011!h\t\u0005\u0001!5Q\"D\u0003\u0002\u0011\u0017IA!C\u0002\u0006\u0003!1\u0001DB\u0005\u0005\u0013\r)\u0011\u0001C\u0002\u0019\u0007a-\u0001ka\u0001\"\u0007\u0015\t\u0001b\u0001\r\u0004#\u000eYAAA\u0005\u0002\u0011\u001bi\u0011\u0001C\u0004\u000e\u0003!5Q\"\u0001E\b\u001b\u0005A\u0011\u0002WB\n\u000b\u001b\bAaA\u000b\u0004\u000b\u0005A\u0019\u0001g\u0001\u0019\u0015u=A\u0001\u0001E\u000b\u001b\r)\u0011\u0001C\u0002\u0019\u0007A\u001b\t!h\u0004\u0005\u0001!\u0015QbA\u0003\u0002\u0011\rA2\u0001U\u0002\u0002;\u001f!\u0001\u0001C\u0006\u000e\u0007\u0015\t\u0001r\u0003M\f!\u000e\rQt\u0002\u0003\u0001\u00115i1!B\u0001\t\ra1\u0001k\u0001\u0002\u001e\u0010\u0011\u0001\u0001\u0012B\u0007\u0004\u000b\u0005AI\u0001'\u0003Q\u0007\u000biz\u0001\u0002\u0001\t\u001c5\u0019Q!\u0001E\r13\u00016aAO\u0012\t\u0001Ai!D\u0007\u0006\u0003!-\u0011\u0002B\u0005\u0004\u000b\u0005Aa\u0001\u0007\u0004\n\t%\u0019Q!\u0001\u0005\u00041\rAZ\u0001UB\u0004C\u0011)\u0011\u0001C\u0002\r\u0002a\u0019\u0011kA\n\u0005\u0015%\t\u0001RB\u0007\u0002\u0011\u001di\u0011\u0001#\u0004\u000e\u0003!5Q\"\u0001\u0005\u000e\u001b\u0005Aa\"D\u0001\t\u00105\t\u0001RD\u0007\u0002\u0011%A61\u0003"})
public final class AnnotationProcessingManagerKt {
    @Nullable
    public static final AbstractCompile initKapt(Project $receiver, @NotNull AbstractCompile kotlinTask2, @NotNull AbstractCompile javaTask, @NotNull AnnotationProcessingManager kaptManager, @NotNull String variantName, @NotNull File kotlinOutputDir, @NotNull SubpluginEnvironment subpluginEnvironment, @NotNull Function1<? super String, ? extends AbstractCompile> taskFactory) {
        AbstractCompile kotlinAfterJavaTask2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)kotlinTask2, (String)"kotlinTask");
        Intrinsics.checkParameterIsNotNull((Object)javaTask, (String)"javaTask");
        Intrinsics.checkParameterIsNotNull((Object)kaptManager, (String)"kaptManager");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        Intrinsics.checkParameterIsNotNull((Object)kotlinOutputDir, (String)"kotlinOutputDir");
        Intrinsics.checkParameterIsNotNull((Object)subpluginEnvironment, (String)"subpluginEnvironment");
        Intrinsics.checkParameterIsNotNull(taskFactory, (String)"taskFactory");
        KaptExtension kaptExtension = (KaptExtension)$receiver.getExtensions().getByType(KaptExtension.class);
        if (kaptExtension.getGenerateStubs()) {
            kotlinAfterJavaTask2 = AnnotationProcessingManagerKt.createKotlinAfterJavaTask($receiver, javaTask, kotlinOutputDir, taskFactory);
            KotlinPluginWrapperKt.kotlinDebug(kotlinTask2.getLogger(), "kapt: Using class file stubs");
            File stubsDir = new File($receiver.getBuildDir(), "tmp/kapt/" + variantName + "/classFileStubs");
            kotlinTask2.getExtensions().getExtraProperties().set("kaptStubsDir", (Object)stubsDir);
            AbstractCompile abstractCompile = javaTask;
            FileCollection fileCollection = abstractCompile.getClasspath();
            FileCollection fileCollection2 = (FileCollection)$receiver.files(new Object[]{stubsDir});
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"files(stubsDir)");
            abstractCompile.setClasspath(KotlinPluginKt.plus(fileCollection, fileCollection2));
            kotlinTask2.doFirst((Action)new Action<Task>(kotlinAfterJavaTask2, kotlinTask2){
                final /* synthetic */ AbstractCompile $kotlinAfterJavaTask;
                final /* synthetic */ AbstractCompile $kotlinTask;

                public final void execute(Task it) {
                    this.$kotlinAfterJavaTask.source(new Object[]{this.$kotlinTask.getSource()});
                }
                {
                    this.$kotlinAfterJavaTask = abstractCompile;
                    this.$kotlinTask = abstractCompile2;
                }
            });
            subpluginEnvironment.addSubpluginArguments($receiver, kotlinAfterJavaTask2);
        } else {
            kotlinAfterJavaTask2 = null;
            KotlinPluginWrapperKt.kotlinDebug(kotlinTask2.getLogger(), "kapt: Class file stubs are not used");
        }
        if (kaptExtension.getInheritedAnnotations()) {
            kotlinTask2.getExtensions().getExtraProperties().set("kaptInheritedAnnotations", (Object)true);
        }
        kotlinTask2.doFirst((Action)new Action<Task>(kaptManager, kotlinAfterJavaTask2){
            final /* synthetic */ AnnotationProcessingManager $kaptManager;
            final /* synthetic */ AbstractCompile $kotlinAfterJavaTask;

            public final void execute(Task it) {
                this.$kaptManager.generateJavaHackFile();
                AbstractCompile abstractCompile = this.$kotlinAfterJavaTask;
                SourceTask sourceTask = abstractCompile != null ? abstractCompile.source(new Object[]{this.$kaptManager.getGeneratedKotlinSourceDir()}) : null;
            }
            {
                this.$kaptManager = annotationProcessingManager;
                this.$kotlinAfterJavaTask = abstractCompile;
            }
        });
        javaTask.doFirst((Action)new Action<Task>(kaptManager, kotlinAfterJavaTask2){
            final /* synthetic */ AnnotationProcessingManager $kaptManager;
            final /* synthetic */ AbstractCompile $kotlinAfterJavaTask;

            public final void execute(Task it) {
                this.$kaptManager.setupKapt();
                this.$kaptManager.generateJavaHackFile();
                AbstractCompile abstractCompile = this.$kotlinAfterJavaTask;
                SourceTask sourceTask = abstractCompile != null ? abstractCompile.source(new Object[]{this.$kaptManager.getGeneratedKotlinSourceDir()}) : null;
            }
            {
                this.$kaptManager = annotationProcessingManager;
                this.$kotlinAfterJavaTask = abstractCompile;
            }
        });
        javaTask.doLast((Action)new Action<Task>(kaptManager){
            final /* synthetic */ AnnotationProcessingManager $kaptManager;

            public final void execute(Task it) {
                this.$kaptManager.afterJavaCompile();
            }
            {
                this.$kaptManager = annotationProcessingManager;
            }
        });
        KotlinPluginKt.storeKaptAnnotationsFile(kotlinTask2, kaptManager);
        return kotlinAfterJavaTask2;
    }

    @NotNull
    public static final AbstractCompile createKotlinAfterJavaTask(Project $receiver, @NotNull AbstractCompile javaTask, @NotNull File kotlinOutputDir, @NotNull Function1<? super String, ? extends AbstractCompile> taskFactory) {
        Collection destination;
        Map.Entry it;
        Map.Entry element;
        Iterable $receiver2;
        Map receiver;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)javaTask, (String)"javaTask");
        Intrinsics.checkParameterIsNotNull((Object)kotlinOutputDir, (String)"kotlinOutputDir");
        Intrinsics.checkParameterIsNotNull(taskFactory, (String)"taskFactory");
        Object object = taskFactory.invoke((Object)KotlinPluginKt.getKOTLIN_AFTER_JAVA_TASK_SUFFIX());
        Object $receiver3 = (AbstractCompile)receiver;
        $receiver3.setProperty("kotlinDestinationDir", (Object)kotlinOutputDir);
        $receiver3.setDestinationDir(javaTask.getDestinationDir());
        $receiver3.setClasspath(javaTask.getClasspath());
        AbstractCompile kotlinAfterJavaTask2 = $receiver3;
        receiver = $receiver.getAllTasks(false);
        $receiver3 = $receiver2;
        Collection collection = new ArrayList();
        Iterator iterator = MapsKt.iterator((Map)$receiver3);
        while (iterator.hasNext()) {
            it = element = (Map.Entry)iterator.next();
            Iterable list = (Set)it.getValue();
            CollectionsKt.addAll((Collection)destination, (Iterable)list);
        }
        $receiver2 = (List)destination;
        $receiver3 = $receiver2;
        destination = new ArrayList();
        iterator = $receiver3.iterator();
        while (iterator.hasNext()) {
            element = iterator.next();
            it = (Task)element;
            if (!it.getTaskDependencies().getDependencies((Task)it).contains(javaTask)) continue;
            destination.add(element);
        }
        $receiver2 = (List)destination;
        for (Object element2 : $receiver2) {
            Task it2 = (Task)element2;
            it2.dependsOn(new Object[]{kotlinAfterJavaTask2});
        }
        kotlinAfterJavaTask2.dependsOn(new Object[]{javaTask});
        return kotlinAfterJavaTask2;
    }
}

