/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import jet.Function1;
import jet.KotlinClass;
import jet.TypeCastException;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KSpec;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper$apply$kotlinPluginDependencies$1;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper$apply$kotlinPluginDependencies$2;
import org.jetbrains.kotlin.gradle.plugin.ParentLastURLClassLoader;

@KotlinClass(abiVersion=13, data={"A\u0004)92j\u001c;mS:\u0014\u0015m]3QYV<\u0017N\\,sCB\u0004XM\u001d\u0006\u0007a2,x-\u001b8\u000b\r\u001d\u0014\u0018\r\u001a7f\u0015\u0019Yw\u000e\u001e7j]*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0004_J<'B\u0002)mk\u001eLgNC\u0002ba&Tq\u0001\u0015:pU\u0016\u001cGO\u0003\u0004=S:LGO\u0010\u0006\u0006CB\u0004H.\u001f\u0006\baJ|'.Z2u\u0015\u0011)f.\u001b;\u000b\u0007),GO\u0003\nhKR\u0004F.^4j]\u000ec\u0017m]:OC6,'BB*ue&twM\u0003\u0003kCZ\f'\u0002\u00027b]\u001eT1\u0001\\8h\u0015\u0019aunZ4fe*9An\\4hS:<'BB4fi2{wM \u0006\u0003!\u0015QA\u0001\u0003\u0001\u0011\t)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0002\u000b\t!\u0019\u0001#\u0001\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0019\u0001rA\u0003\u0004\t\u000fA1\u0001\u0004\u0001\u0006\u0007\u0011\u001d\u0001\u0002\u0002\u0007\u0001\u000b\u0005Ai!B\u0002\u0005\u000b!1A\u0002A\u0003\u0003\t\u000fAA!B\u0002\u0005\u000b!=A\u0002A\u0003\u0002\u0011!)!\u0001B\u0004\t\u0012\u0015\u0011Aq\u0002E\b\u000b\t!9\u0001\u0003\u0006\u0006\u0007\u0011E\u00012\u0003\u0007\u0001\u000b\t!\t\u0002c\u0005\u0005!1\u0015\u0011DB\u0003\u0002\u0011\u0011I1!\u0003\u0002\u0006\u0003!%Qf\u0005\u0003\f1\u0015ij\u0001\u0002\u0001\t\f5\u0011Q!\u0001E\u0005!\u000e\u0001\u0011EA\u0003\u0002\u0011\u0017\t6!\u0002\u0003\u0006\u0013\u0005!\u0001!D\u0001\t\r5NAa\u0005\r\bC\t)\u0011\u0001#\u0004R\u0007\r!q!C\u0001\t\u00115zA\u0001\u0019\u0003\u0019\u0013\u0005\u0012Q!\u0001\u0005\n+\u000eAQa\u0001\u0003\n\u0013\u0005A\u0019\"D\u0002\u0005\u0016%\t\u00012C\u001b\f\u000b)!1\u001d\u0001M\u0005C\t)\u0011\u0001#\u0002R\u0007\r!I!C\u0001\u0005\u0001\u0001"})
public abstract class KotlinBasePluginWrapper
implements Plugin<Project> {
    @NotNull
    private final Logger log;

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    public void apply(@JetValueParameter(name="project") @NotNull Project project) {
        DependencyHandler dependencyHandler = project.getBuildscript().getDependencies();
        ConfigurationContainer configurationsContainer = project.getBuildscript().getConfigurations();
        this.log.debug("Loading version information");
        Properties props = new Properties();
        String propFileName = "project.properties";
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            Intrinsics.throwNpe();
        }
        InputStream inputStream = classLoader.getResourceAsStream(propFileName);
        boolean bl = true;
        if (inputStream != null) {
            bl = false;
        }
        if (bl) {
            throw (Throwable)new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
        }
        props.load(inputStream);
        Object object = props.get("project.version");
        if (object == null) {
            throw new TypeCastException("jet.Any? cannot be cast to jet.String");
        }
        String projectVersion = (String)object;
        this.log.debug("Found project version [" + projectVersion + "]");
        ExtraPropertiesExtension extraPropertiesExtension = project.getExtensions().getExtraProperties();
        if (extraPropertiesExtension != null) {
            extraPropertiesExtension.set("kotlin.gradle.plugin.version", (Object)projectVersion);
        }
        this.log.debug("Creating configuration and dependency");
        String kotlinPluginCoreCoordinates = "org.jetbrains.kotlin:kotlin-gradle-plugin-core:" + projectVersion;
        Dependency dependency = dependencyHandler.create((Object)kotlinPluginCoreCoordinates);
        Configuration configuration = configurationsContainer.detachedConfiguration(new Dependency[]{dependency});
        if (configuration == null) {
            Intrinsics.throwNpe();
        }
        Configuration configuration2 = configuration;
        this.log.debug("Resolving [" + kotlinPluginCoreCoordinates + "]");
        Set set = configuration2.getResolvedConfiguration().getFiles((Spec)new KSpec((Function1)KotlinBasePluginWrapper$apply$kotlinPluginDependencies$1.instance$));
        if (set == null) {
            Intrinsics.throwNpe();
        }
        List kotlinPluginDependencies2 = KotlinPackage.map((Iterable)set, (Function1)((Function1)KotlinBasePluginWrapper$apply$kotlinPluginDependencies$2.instance$));
        this.log.debug("Resolved files: [" + String.valueOf(kotlinPluginDependencies2) + "]");
        this.log.debug("Load plugin in parent-last URL classloader");
        ParentLastURLClassLoader kotlinPluginClassloader = new ParentLastURLClassLoader(kotlinPluginDependencies2, this.getClass().getClassLoader());
        this.log.debug("Class loader created");
        Class<?> cls = Class.forName(this.getPluginClassName(), true, kotlinPluginClassloader);
        this.log.debug("Plugin class loaded");
        Object pluginInstance = cls.newInstance();
        this.log.debug("Plugin class instantiated");
        Method applyMethod = cls.getMethod("apply", Project.class);
        this.log.debug("'apply' method found, invoking...");
        applyMethod.invoke(pluginInstance, project);
        this.log.debug("'apply' method invoked successfully");
    }

    @NotNull
    public abstract String getPluginClassName();

    @NotNull
    public KotlinBasePluginWrapper() {
        Logger logger = Logging.getLogger(this.getClass());
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        this.log = logger;
    }
}

