/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KSpec;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper$apply$kotlinPluginDependencies$1;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper$apply$kotlinPluginDependencies$2;
import org.jetbrains.kotlin.gradle.plugin.ParentLastURLClassLoader;

@KotlinClass(abiVersion=14, data={"<\u0004)92j\u001c;mS:\u0014\u0015m]3QYV<\u0017N\\,sCB\u0004XM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*1qM]1eY\u0016Ta\u0001\u001d7vO&t'B\u0002)mk\u001eLgNC\u0002ba&Tq\u0001\u0015:pU\u0016\u001cGO\u0003\u0004=S:LGO\u0010\u0006\u0006CB\u0004H.\u001f\u0006\baJ|'.Z2u\u0015\u0011)f.\u001b;\u000b%\u001d,G\u000f\u00157vO&t7\t\\1tg:\u000bW.\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twMC\u0002m_\u001eTa\u0001T8hO\u0016\u0014(b\u00027pO\u001eLgn\u001a\u0006\u0007O\u0016$Hj\\4\u007f\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)!\u0001\u0002\u0001\t\u0005\u0015\u0011Aa\u0001E\u0004\u000b\r!9\u0001C\u0002\r\u0001\u0015\u0019Aq\u0001\u0005\u0005\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011)\u0001B\u0002\u0007\u0001\u000b\t!9\u0001\u0003\u0003\u0006\u0007\u0011)\u0001b\u0002\u0007\u0001\u000b\u0005Ay!\u0002\u0002\u0005\u000f!AQA\u0001C\b\u0011\u001d)!\u0001b\u0002\t\u0014\u0015\u0019A\u0011\u0003\u0005\n\u0019\u0001)!\u0001\"\u0005\t\u0013\u0011\u0001BRA\r\u0007\u000b\u0005AA!C\u0002\n\u0005\u0015\t\u0001\u0012B\u0017\u0014\t-AR!(\u0004\u0005\u0001!-QBA\u0003\u0002\u0011\u0013\u00016\u0001A\u0011\u0003\u000b\u0005AY!U\u0002\u0006\t\u0015I\u0011\u0001\u0002\u0001\u000e\u0003!1Q6\u0003\u0003\u00141\u001b\t#!B\u0001\t\u000eE\u001b1\u0001\"\u0004\n\u0003!AQf\u0004\u0003a\taE\u0011EA\u0003\u0002\u0011%)6\u0001C\u0003\u0004\t#I\u0011\u0001c\u0005\u000e\u0007\u0011Q\u0011\"\u0001E\nk-)!\u0002Br\u00011\u0013\t#!B\u0001\t\u0006E\u001b1\u0001\"\u0003\n\u0003\u0011\u0001\u0001"})
public abstract class KotlinBasePluginWrapper
implements KObject,
Plugin<Project> {
    @NotNull
    private final Logger log;

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    public void apply(@JetValueParameter(name="project") @NotNull Project project) {
        Unit unit;
        DependencyHandler dependencyHandler = project.getBuildscript().getDependencies();
        ConfigurationContainer configurationsContainer = project.getBuildscript().getConfigurations();
        this.log.debug("Loading version information");
        Properties props = new Properties();
        String propFileName = "project.properties";
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            Intrinsics.throwNpe();
        }
        InputStream inputStream = classLoader.getResourceAsStream(propFileName);
        boolean bl = true;
        if (inputStream != null) {
            bl = false;
        }
        if (bl) {
            throw (Throwable)new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
        }
        props.load(inputStream);
        Object object = props.get("project.version");
        if (object == null) {
            throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.String");
        }
        String projectVersion = (String)object;
        this.log.debug("Found project version [" + projectVersion + "]");
        ExtraPropertiesExtension extraPropertiesExtension = project.getExtensions().getExtraProperties();
        if (extraPropertiesExtension != null) {
            extraPropertiesExtension.set("kotlin.gradle.plugin.version", (Object)projectVersion);
            unit = Unit.VALUE;
        } else {
            unit = null;
        }
        this.log.debug("Creating configuration and dependency");
        String kotlinPluginCoreCoordinates = "org.jetbrains.kotlin:kotlin-gradle-plugin-core:" + projectVersion;
        Dependency dependency = dependencyHandler.create((Object)kotlinPluginCoreCoordinates);
        Configuration configuration = configurationsContainer.detachedConfiguration(new Dependency[]{dependency});
        if (configuration == null) {
            Intrinsics.throwNpe();
        }
        Configuration configuration2 = configuration;
        this.log.debug("Resolving [" + kotlinPluginCoreCoordinates + "]");
        Set set = configuration2.getResolvedConfiguration().getFiles((Spec)new KSpec((Function1)KotlinBasePluginWrapper$apply$kotlinPluginDependencies$1.instance$));
        if (set == null) {
            Intrinsics.throwNpe();
        }
        List kotlinPluginDependencies2 = KotlinPackage.map((Iterable)set, (Function1)((Function1)KotlinBasePluginWrapper$apply$kotlinPluginDependencies$2.instance$));
        this.log.debug("Resolved files: [" + kotlinPluginDependencies2.toString() + "]");
        this.log.debug("Load plugin in parent-last URL classloader");
        ParentLastURLClassLoader kotlinPluginClassloader = new ParentLastURLClassLoader(kotlinPluginDependencies2, this.getClass().getClassLoader());
        this.log.debug("Class loader created");
        Class<?> cls = Class.forName(this.getPluginClassName(), true, kotlinPluginClassloader);
        this.log.debug("Plugin class loaded");
        Object pluginInstance = cls.newInstance();
        this.log.debug("Plugin class instantiated");
        Method applyMethod = cls.getMethod("apply", Project.class);
        this.log.debug("'apply' method found, invoking...");
        applyMethod.invoke(pluginInstance, project);
        this.log.debug("'apply' method invoked successfully");
    }

    @NotNull
    public abstract String getPluginClassName();

    @NotNull
    public KotlinBasePluginWrapper() {
        Logger logger = Logging.getLogger(this.getClass());
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        this.log = logger;
    }
}

