/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeProjectProperty;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeToolRunnerKt;
import org.jetbrains.kotlin.gradle.tasks.KonanCompilerDownloadTask;
import org.jetbrains.kotlin.konan.KonanVersion;
import org.jetbrains.kotlin.konan.KonanVersionImpl;
import org.jetbrains.kotlin.konan.MetaVersion;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.util.DependencyDirectories;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/KonanCompilerDownloadTask;", "Lorg/gradle/api/DefaultTask;", "()V", "archiveExtension", "", "getArchiveExtension", "()Ljava/lang/String;", "useZip", "", "archiveFileTree", "Lorg/gradle/api/file/FileTree;", "archive", "Ljava/io/File;", "checkCompiler", "", "downloadAndExtract", "removeRepo", "repo", "Lorg/gradle/api/artifacts/repositories/ArtifactRepository;", "setupRepo", "url", "Companion", "kotlin-gradle-plugin"})
public class KonanCompilerDownloadTask
extends DefaultTask {
    private final boolean useZip = HostManager.Companion.getHostIsMingw();
    @NotNull
    private static final String simpleOsName;
    @NotNull
    private static final KonanVersion compilerVersion;
    @NotNull
    public static final String BASE_DOWNLOAD_URL = "https://download.jetbrains.com/kotlin/native/builds";
    @NotNull
    public static final String KONAN_DOWNLOAD_TASK_NAME = "checkNativeCompiler";
    public static final Companion Companion;

    private final String getArchiveExtension() {
        return this.useZip ? "zip" : "tar.gz";
    }

    private final FileTree archiveFileTree(File archive) {
        FileTree fileTree;
        if (this.useZip) {
            FileTree fileTree2 = this.getProject().zipTree((Object)archive);
            fileTree = fileTree2;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTree2, (String)"project.zipTree(archive)");
        } else {
            FileTree fileTree3 = this.getProject().tarTree((Object)archive);
            fileTree = fileTree3;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTree3, (String)"project.tarTree(archive)");
        }
        return fileTree;
    }

    private final ArtifactRepository setupRepo(String url) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        IvyArtifactRepository ivyArtifactRepository = project.getRepositories().ivy((Action)new Action<IvyArtifactRepository>(url){
            final /* synthetic */ String $url;

            public final void execute(IvyArtifactRepository repo) {
                repo.setUrl((Object)this.$url);
                repo.layout("pattern", (Action)setupRepo.1.INSTANCE);
                repo.metadataSources((Action)setupRepo.2.INSTANCE);
            }
            {
                this.$url = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)ivyArtifactRepository, (String)"project.repositories.ivy\u2026)\n            }\n        }");
        return (ArtifactRepository)ivyArtifactRepository;
    }

    private final void removeRepo(ArtifactRepository repo) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        project.getRepositories().remove((Object)repo);
    }

    private final void downloadAndExtract() {
        Configuration configuration;
        StringBuilder stringBuilder;
        String versionString = compilerVersion.toString();
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append("https://download.jetbrains.com/kotlin/native/builds/");
        $receiver.append(compilerVersion.getMeta() == MetaVersion.DEV ? "dev/" : "releases/");
        $receiver.append(versionString + '/');
        $receiver.append(simpleOsName);
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String url = string;
        ArtifactRepository repo = this.setupRepo(url);
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Dependency compilerDependency = project.getDependencies().create((Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"name", (Object)("kotlin-native-" + simpleOsName)), TuplesKt.to((Object)"version", (Object)versionString), TuplesKt.to((Object)"ext", (Object)this.getArchiveExtension())}));
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Configuration configuration2 = configuration = project2.getConfigurations().detachedConfiguration(new Dependency[]{compilerDependency});
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"configuration");
        Set set = configuration2.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"configuration.files");
        File archive = (File)CollectionsKt.single((Iterable)set);
        Logger logger = this.getLogger();
        StringBuilder stringBuilder2 = new StringBuilder().append("Use Kotlin/Native compiler archive: ");
        File file = archive;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"archive");
        logger.info(stringBuilder2.append(file.getAbsolutePath()).toString());
        this.getLogger().lifecycle("Unpack Kotlin/Native compiler (version " + versionString + ")...");
        this.getProject().copy((Action)new Action<CopySpec>(this, archive){
            final /* synthetic */ KonanCompilerDownloadTask this$0;
            final /* synthetic */ File $archive;

            public final void execute(CopySpec it) {
                Object[] objectArray = new Object[1];
                File file = this.$archive;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"archive");
                objectArray[0] = KonanCompilerDownloadTask.access$archiveFileTree(this.this$0, file);
                it.from(objectArray);
                it.into((Object)DependencyDirectories.INSTANCE.getLocalKonanDir());
            }
            {
                this.this$0 = konanCompilerDownloadTask;
                this.$archive = file;
            }
        });
        this.removeRepo(repo);
    }

    @TaskAction
    public final void checkCompiler() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        if (!KotlinNativeToolRunnerKt.hasProperty(project, KotlinNativeProjectProperty.DOWNLOAD_COMPILER)) {
            Project project2 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            Object konanHome = KotlinNativeToolRunnerKt.getProperty(project2, KotlinNativeProjectProperty.KONAN_HOME);
            this.getLogger().info("Use a user-defined compiler path: " + konanHome);
        } else {
            if (!Companion.getCompilerDirectory().exists()) {
                this.downloadAndExtract();
            }
            this.getLogger().info("Use Kotlin/Native distribution: " + Companion.getCompilerDirectory());
        }
    }

    static {
        Companion = new Companion(null);
        simpleOsName = HostManager.Companion.simpleOsName();
        compilerVersion = (KonanVersion)new KonanVersionImpl(MetaVersion.RELEASE, 0, 8, 2, 0, 16, null);
    }

    @NotNull
    public static final /* synthetic */ FileTree access$archiveFileTree(KonanCompilerDownloadTask $this, @NotNull File archive) {
        return $this.archiveFileTree(archive);
    }

    @Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/KonanCompilerDownloadTask$Companion;", "", "()V", "BASE_DOWNLOAD_URL", "", "KONAN_DOWNLOAD_TASK_NAME", "compilerDirectory", "Ljava/io/File;", "getCompilerDirectory", "()Ljava/io/File;", "compilerVersion", "Lorg/jetbrains/kotlin/konan/KonanVersion;", "getCompilerVersion", "()Lorg/jetbrains/kotlin/konan/KonanVersion;", "simpleOsName", "getSimpleOsName", "()Ljava/lang/String;", "kotlin-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final String getSimpleOsName() {
            return simpleOsName;
        }

        @NotNull
        public final File getCompilerDirectory() {
            return FilesKt.resolve((File)DependencyDirectories.INSTANCE.getLocalKonanDir(), (String)("kotlin-native-" + Companion.getSimpleOsName() + '-' + Companion.getCompilerVersion()));
        }

        @NotNull
        public final KonanVersion getCompilerVersion() {
            return compilerVersion;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

