/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeProjectProperty;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0016\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0014\u0010\r\u001a\u00020\n*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u001e\u0010\u0010\u001a\u00020\u0011*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0000\"\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0018\u0010\u0006\u001a\u00020\u0002*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"jvmArgs", "", "", "Lorg/gradle/api/Project;", "getJvmArgs", "(Lorg/gradle/api/Project;)Ljava/util/List;", "konanHome", "getKonanHome", "(Lorg/gradle/api/Project;)Ljava/lang/String;", "findProperty", "", "property", "Lorg/jetbrains/kotlin/compilerRunner/KotlinNativeProjectProperty;", "getProperty", "hasProperty", "", "setProperty", "", "value", "kotlin-gradle-plugin"})
public final class KotlinNativeToolRunnerKt {
    public static final boolean hasProperty(@NotNull Project $receiver, @NotNull KotlinNativeProjectProperty property) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)((Object)property), (String)"property");
        return $receiver.hasProperty(property.getPropertyName());
    }

    @Nullable
    public static final Object findProperty(@NotNull Project $receiver, @NotNull KotlinNativeProjectProperty property) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)((Object)property), (String)"property");
        return $receiver.findProperty(property.getPropertyName());
    }

    public static final void setProperty(@NotNull Project $receiver, @NotNull KotlinNativeProjectProperty property, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)((Object)property), (String)"property");
        ExtensionContainer extensionContainer = $receiver.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionContainer, (String)"extensions");
        extensionContainer.getExtraProperties().set(property.getPropertyName(), value);
    }

    @NotNull
    public static final Object getProperty(@NotNull Project $receiver, @NotNull KotlinNativeProjectProperty property) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)((Object)property), (String)"property");
        Object object = KotlinNativeToolRunnerKt.findProperty($receiver, property);
        if (object == null) {
            throw (Throwable)new IllegalArgumentException("No such property in the project: " + property.getPropertyName());
        }
        return object;
    }

    @NotNull
    public static final List<String> getJvmArgs(@NotNull Project $receiver) {
        Object object;
        List list;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = (String)KotlinNativeToolRunnerKt.findProperty($receiver, KotlinNativeProjectProperty.KONAN_JVM_ARGS);
        if (string != null) {
            charSequence = string;
            String string2 = "\\s+";
            string2 = new Regex(string2);
            int n = 0;
            list = string2.split(charSequence, n);
        } else {
            list = null;
        }
        if ((object = (charSequence = list)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public static final String getKonanHome(@NotNull Project $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        boolean bl = KotlinNativeToolRunnerKt.hasProperty($receiver, KotlinNativeProjectProperty.KONAN_HOME);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        File file = $receiver.getProject().file(KotlinNativeToolRunnerKt.getProperty($receiver, KotlinNativeProjectProperty.KONAN_HOME));
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.file(getProperty\u2026jectProperty.KONAN_HOME))");
        String string = file.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.file(getProperty\u2026ONAN_HOME)).canonicalPath");
        return string;
    }
}

