/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.util.Collection;
import java.util.HashSet;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!yQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00011\u0001\u0011$\u0001M\u0001C\u000b\t6!\u0001\u0005\u0002K!AY!D\u0001\u0019\re!\u0001RB\u0007\u0003\u0019\u0003Ar!J\u0004\u0005\u0003!=Q\u0002B\u0005\u0003\u0013\u0005A*\u0001\u0007\u0002*\u0017\u0011\tE\u0004c\u0001\u000e\u000b%\u0011\u0011\"\u0001M\u0003\u0019\u0003A\"!U\u0002\u0002\u000b\u0001Ic\u0002B\"\t\u0011\riQ\u0001\u0005\u0003\u0016\u00051\u0005\u0001t\u0001M\u0004#\u000e!Q\u0001A\u0007\u0003\t\u0013AQ\u0001"}, strings={"Lorg/jetbrains/kotlin/gradle/plugin/ThreadTracker;", "", "()V", "before", "", "Ljava/lang/Thread;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/gradle/api/logging/Logger;", "checkThreadLeak", "", "gradle", "Lorg/gradle/api/invocation/Gradle;", "getThreads"}, moduleName="kotlin-gradle-plugin")
public final class ThreadTracker {
    private final Logger log = Logging.getLogger(this.getClass());
    private Collection<? extends Thread> before = this.getThreads();

    public final Logger getLog() {
        return this.log;
    }

    private final Collection<Thread> getThreads() {
        return Thread.getAllStackTraces().keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkThreadLeak(@Nullable Gradle gradle) {
        try {
            boolean testThreads = gradle != null && gradle.getRootProject().hasProperty("kotlin.gradle.test") && !gradle.getRootProject().hasProperty("kotlin.gradle.noThreadTest");
            Thread.sleep(testThreads ? 200L : 50L);
            HashSet<Thread> after = new HashSet<Thread>(this.getThreads());
            Collection<? extends Thread> collection = this.before;
            if (collection == null) {
                Intrinsics.throwNpe();
            }
            after.removeAll(collection);
            for (Thread thread : after) {
                if (Intrinsics.areEqual((Object)thread, (Object)Thread.currentThread())) continue;
                String name = thread.getName();
                if (testThreads) {
                    throw (Throwable)new RuntimeException("Thread leaked: " + thread + ": " + name + "\n" + " " + ArraysKt.joinToString$default((Object[])thread.getStackTrace(), (CharSequence)"\n", (CharSequence)" at ", null, (int)0, null, null, (int)60));
                }
                this.log.info("Thread leaked: " + thread + ": " + name);
            }
        }
        finally {
            this.before = null;
        }
    }
}

