/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"\u0013\u0015\u0001Q!\u0001\u0005\b\u000b\u0005A\u0001!\u0002\u0001\u0006\u00031\tQ\u0001A\u0007\u000e\t\u0001A\u0001!D\u0001\u0019\u0002U\t\u0001$AM\u0005\u0011\u0007i\u0011\u0001\u0007\u0002Q\u0007\u0003!6Q\u0001"}, strings={"loadKotlinVersionFromResource", "", "", "log", "Lorg/gradle/api/logging/Logger;", "KotlinPluginVersionKt"}, moduleName="kotlin-gradle-plugin")
public final class KotlinPluginVersionKt {
    @NotNull
    public static final String loadKotlinVersionFromResource(Object $receiver, @NotNull Logger log) {
        InputStream inputStream;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        KotlinPluginWrapperKt.kotlinDebug(log, "Loading version information");
        Properties props = new Properties();
        String propFileName = "project.properties";
        ClassLoader classLoader = $receiver.getClass().getClassLoader();
        if (classLoader == null) {
            Intrinsics.throwNpe();
        }
        if ((inputStream = classLoader.getResourceAsStream(propFileName)) == null) {
            throw (Throwable)new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
        }
        props.load(inputStream);
        Object object = MapsKt.get((Map)props, (Object)"project.version");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String projectVersion = (String)object;
        KotlinPluginWrapperKt.kotlinDebug(log, "Found project version [" + projectVersion + "]");
        return projectVersion;
    }
}

