/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.gradle.BuildListener;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.FinishBuildListener;
import org.jetbrains.kotlin.gradle.plugin.FinishBuildListenerKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginVersionKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH$R\u0019\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinBasePluginWrapper;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/gradle/api/logging/Logger;", "apply", "", "project", "findSourceBuildScript", "Lorg/gradle/api/initialization/dsl/ScriptHandler;", "getPlugin", "pluginClassLoader", "Ljava/lang/ClassLoader;", "scriptHandler", "kotlin-gradle-plugin"})
@KotlinClass(version={1, 1, 0}, data={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH$R\u0019\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, strings={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinBasePluginWrapper;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/gradle/api/logging/Logger;", "apply", "", "project", "findSourceBuildScript", "Lorg/gradle/api/initialization/dsl/ScriptHandler;", "getPlugin", "pluginClassLoader", "Ljava/lang/ClassLoader;", "scriptHandler", "kotlin-gradle-plugin"})
public abstract class KotlinBasePluginWrapper
implements Plugin<Project> {
    private final Logger log = Logging.getLogger(this.getClass());

    public final Logger getLog() {
        return this.log;
    }

    public void apply(@NotNull Project project) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        long startMemory = FinishBuildListenerKt.getUsedMemoryKb();
        ScriptHandler sourceBuildScript = this.findSourceBuildScript(project);
        if (sourceBuildScript == null) {
            this.log.error("Failed to determine source cofiguration of kotlin plugin. Can not download core. Please verify that this or any parent project " + "contains 'kotlin-gradle-plugin' in buildscript's classpath configuration.");
            return;
        }
        Logger logger = this.log;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
        String kotlinPluginVersion = KotlinPluginVersionKt.loadKotlinVersionFromResource(this, logger);
        ExtraPropertiesExtension extraPropertiesExtension = project.getExtensions().getExtraProperties();
        if (extraPropertiesExtension != null) {
            extraPropertiesExtension.set("kotlin.gradle.plugin.version", (Object)kotlinPluginVersion);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"this.javaClass.classLoader");
        Plugin<Project> plugin = this.getPlugin(classLoader, sourceBuildScript);
        plugin.apply((Object)project);
        Gradle gradle = project.getGradle();
        ClassLoader classLoader2 = this.getClass().getClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"this.javaClass.classLoader");
        gradle.addBuildListener((BuildListener)new FinishBuildListener(classLoader2, startMemory));
    }

    @NotNull
    protected abstract Plugin<Project> getPlugin(@NotNull ClassLoader var1, @NotNull ScriptHandler var2);

    /*
     * WARNING - void declaration
     */
    private final ScriptHandler findSourceBuildScript(Project project) {
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Looking for proper script handler");
        Project curProject = project;
        while (Intrinsics.areEqual((Object)curProject, (Object)curProject.getParent()) ^ true) {
            boolean found;
            File file;
            KotlinPluginWrapperKt.kotlinDebug(this.log, "Looking in project " + project);
            ScriptHandler scriptHandler = curProject.getBuildscript();
            Configuration configuration = (Configuration)scriptHandler.getConfigurations().findByName("classpath");
            if (configuration != null) {
                Object v1;
                block5: {
                    void $receiver$iv;
                    Iterable iterable = (Iterable)configuration;
                    for (Object element$iv : $receiver$iv) {
                        File it = (File)element$iv;
                        if (!StringsKt.contains$default((CharSequence)it.getName(), (CharSequence)"kotlin-gradle-plugin", (boolean)false, (int)2, null)) continue;
                        v1 = element$iv;
                        break block5;
                    }
                    v1 = null;
                }
                file = v1;
            } else {
                file = null;
            }
            boolean bl = found = file != null;
            if (found) {
                KotlinPluginWrapperKt.kotlinDebug(this.log, "Found! returning...");
                return scriptHandler;
            }
            KotlinPluginWrapperKt.kotlinDebug(this.log, "not found, switching to parent");
            if (curProject.getParent() != null) continue;
            break;
        }
        return null;
    }
}

