/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import com.android.build.gradle.BaseExtension;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ConstantsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.AnnotationProcessingManager;
import org.jetbrains.kotlin.gradle.plugin.KaptExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000 :2\u00020\u0001:\u0001:BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0006\u0010\u0019\u001a\u00020\u0015J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0002J&\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0006\u0010\u001e\u001a\u00020\u0015J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u0006\u0010!\u001a\u00020\nJ\f\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0002J\u0006\u0010$\u001a\u00020\nJ\u0010\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007H\u0002J)\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u00072\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010*\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010+J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0018\u0010.\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0007H\u0002J\u0006\u00100\u001a\u00020\u0015J+\u00101\u001a\u00020\u0015*\u00020\u00052\u0006\u00102\u001a\u00020\u00072\u0014\u00103\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\u000704H\u0082\bJ\u0014\u00105\u001a\u00020\u0015*\u00020\u00052\u0006\u00106\u001a\u00020\nH\u0002J'\u00107\u001a\u00020\u0015*\u00020\u00052\u0018\u00108\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000709\u0012\u0004\u0012\u00020\u001504H\u0082\bR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/AnnotationProcessingManager;", "", "task", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "javaTask", "Lorg/gradle/api/tasks/compile/JavaCompile;", "taskQualifier", "", "aptFiles", "", "Ljava/io/File;", "aptOutputDir", "aptWorkingDir", "coreClassLoader", "Ljava/lang/ClassLoader;", "androidVariant", "(Lorg/gradle/api/tasks/compile/AbstractCompile;Lorg/gradle/api/tasks/compile/JavaCompile;Ljava/lang/String;Ljava/util/Set;Ljava/io/File;Ljava/io/File;Ljava/lang/ClassLoader;Ljava/lang/Object;)V", "project", "Lorg/gradle/api/Project;", "kotlin.jvm.PlatformType", "addGeneratedSourcesOutputToCompilerArgs", "", "outputDir", "addWrappersToCompilerArgs", "wrapperFqNames", "afterJavaCompile", "appendAdditionalComplerArgs", "appendAnnotationsArguments", "generateAnnotationProcessorStubs", "processorFqNames", "generateJavaHackFile", "getAndroidExtension", "Lcom/android/build/gradle/BaseExtension;", "getAnnotationFile", "getCoreKaptPackageClass", "Ljava/lang/Class;", "getGeneratedKotlinSourceDir", "getProcessorStubClassName", "processorFqName", "invokeCoreKaptMethod", "methodName", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "lookupAnnotationProcessors", "files", "setProcessorPath", "path", "setupKapt", "addCompilerArgument", "name", "value", "Lkotlin/Function1;", "appendClasspath", "file", "modifyCompilerArguments", "modifier", "", "Companion", "kotlin-gradle-plugin"})
public final class AnnotationProcessingManager {
    private final Project project;
    private final AbstractCompile task;
    private final JavaCompile javaTask;
    private final String taskQualifier;
    private final Set<File> aptFiles;
    private final File aptOutputDir;
    private final File aptWorkingDir;
    private final ClassLoader coreClassLoader;
    private final Object androidVariant;
    @NotNull
    private static final Regex JAVA_FQNAME_PATTERN;
    @NotNull
    private static final String WRAPPERS_DIRECTORY = "wrappers";
    @NotNull
    private static final String GEN_ANNOTATION = "__gen/annotation";
    private static final String ANDROID_APT_PLUGIN_ID = "com.neenbedankt.android-apt";
    public static final Companion Companion;

    @NotNull
    public final File getAnnotationFile() {
        if (!this.aptWorkingDir.exists()) {
            this.aptWorkingDir.mkdirs();
        }
        return new File(this.aptWorkingDir, Companion.getWRAPPERS_DIRECTORY() + "/annotations." + this.taskQualifier + ".txt");
    }

    @NotNull
    public final File getGeneratedKotlinSourceDir() {
        File kotlinGeneratedDir = new File(this.aptWorkingDir, "kotlinGenerated");
        if (!kotlinGeneratedDir.exists()) {
            kotlinGeneratedDir.mkdirs();
        }
        return kotlinGeneratedDir;
    }

    public final void setupKapt() {
        if (this.aptFiles.isEmpty()) {
            return;
        }
        if (this.project.getPlugins().findPlugin(AnnotationProcessingManager.Companion.getANDROID_APT_PLUGIN_ID()) != null) {
            this.project.getLogger().warn("Please do not use `" + AnnotationProcessingManager.Companion.getANDROID_APT_PLUGIN_ID() + "` with kapt.");
        }
        Set<String> annotationProcessorFqNames = this.lookupAnnotationProcessors(this.aptFiles);
        File stubOutputDir = new File(this.aptWorkingDir, Companion.getWRAPPERS_DIRECTORY());
        this.generateAnnotationProcessorStubs(this.javaTask, annotationProcessorFqNames, stubOutputDir);
        Set processorPath = SetsKt.plus((Set)SetsKt.setOf((Object)stubOutputDir), (Iterable)this.aptFiles);
        Iterable iterable = (Iterable)this.javaTask.getClasspath();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"javaTask.classpath");
        Iterable iterable2 = SetsKt.plus((Set)processorPath, (Iterable)iterable);
        CharSequence charSequence = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"File.pathSeparator");
        this.setProcessorPath(this.javaTask, CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)charSequence, null, null, (int)0, null, null, (int)62, null));
        this.appendClasspath(this.javaTask, stubOutputDir);
        this.addGeneratedSourcesOutputToCompilerArgs(this.javaTask, this.aptOutputDir);
        this.appendAnnotationsArguments();
        this.appendAdditionalComplerArgs();
    }

    public final void afterJavaCompile() {
        File generatedFile = new File(this.javaTask.getDestinationDir(), Companion.getGEN_ANNOTATION() + "/Cl.class");
        if (generatedFile.exists()) {
            generatedFile.delete();
        } else {
            KotlinPluginWrapperKt.kotlinDebug(this.project.getLogger(), "kapt: Java file stub was not found at " + generatedFile);
        }
    }

    public final void generateJavaHackFile() {
        File javaHackClFile;
        File javaAptSourceDir = new File(this.aptWorkingDir, "java_src");
        File javaHackPackageDir = new File(javaAptSourceDir, Companion.getGEN_ANNOTATION());
        if (!javaHackPackageDir.exists()) {
            javaHackPackageDir.mkdirs();
        }
        if (!(javaHackClFile = new File(javaHackPackageDir, "Cl.java")).exists()) {
            FilesKt.writeText$default((File)javaHackClFile, (String)"package __gen.annotation; class Cl { @__gen.KotlinAptAnnotation boolean v; }", null, (int)2, null);
            KotlinPluginWrapperKt.kotlinDebug(this.project.getLogger(), "kapt: Java file stub generated: " + javaHackClFile);
        }
        if (!this.javaTask.getSource().contains(javaHackClFile)) {
            this.javaTask.source(new Object[]{javaAptSourceDir});
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendAnnotationsArguments() {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        JavaCompile javaCompile = this.javaTask;
        AnnotationProcessingManager this_$iv = this;
        List list = $receiver$iv.getOptions().getCompilerArgs();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
        List compilerArgs$iv = list;
        Iterable iterable = compilerArgs$iv;
        Collection collection = CollectionsKt.arrayListOf((Object[])new String[0]);
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it$iv;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            void var9_9 = destination$iv$iv;
            String string = it$iv.toString();
            var9_9.add(string);
        }
        ArrayList newCompilerArgs$iv = (ArrayList)destination$iv$iv;
        List list2 = newCompilerArgs$iv;
        list2.add("-Akapt.annotations=" + this.getAnnotationFile());
        list2.add("-Akapt.kotlin.generated=" + this.getGeneratedKotlinSourceDir());
        $receiver$iv.getOptions().setCompilerArgs((List)newCompilerArgs$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendAdditionalComplerArgs() {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        KaptExtension kaptExtension = (KaptExtension)this.project.getExtensions().getByType(KaptExtension.class);
        Project project = this.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        List<String> args = kaptExtension.getAdditionalArguments(project, this.androidVariant, this.getAndroidExtension());
        if (args.isEmpty()) {
            return;
        }
        JavaCompile javaCompile = this.javaTask;
        AnnotationProcessingManager this_$iv = this;
        List list = $receiver$iv.getOptions().getCompilerArgs();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
        List compilerArgs$iv = list;
        Iterable iterable = compilerArgs$iv;
        Collection collection = CollectionsKt.arrayListOf((Object[])new String[0]);
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it$iv;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            void var11_11 = destination$iv$iv;
            String string = it$iv.toString();
            var11_11.add(string);
        }
        ArrayList newCompilerArgs$iv = (ArrayList)destination$iv$iv;
        List list2 = newCompilerArgs$iv;
        list2.addAll((Collection)args);
        $receiver$iv.getOptions().setCompilerArgs((List)newCompilerArgs$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateAnnotationProcessorStubs(JavaCompile javaTask, Set<String> processorFqNames, File outputDir) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        File wrapperFile;
        Object object = this.invokeCoreKaptMethod("generateKotlinAptAnnotation", outputDir);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.io.File");
        }
        File aptAnnotationFile = (File)object;
        KotlinPluginWrapperKt.kotlinDebug(this.project.getLogger(), "kapt: Stub annotation generated: " + aptAnnotationFile);
        File stubOutputPackageDir = new File(outputDir, "__gen");
        stubOutputPackageDir.mkdirs();
        for (String processorFqName : processorFqNames) {
            Object object2 = this.invokeCoreKaptMethod("generateAnnotationProcessorWrapper", processorFqName, "__gen", stubOutputPackageDir, this.getProcessorStubClassName(processorFqName), this.taskQualifier);
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.io.File");
            }
            wrapperFile = (File)object2;
            KotlinPluginWrapperKt.kotlinDebug(this.project.getLogger(), "kapt: Wrapper for " + processorFqName + " generated: " + wrapperFile);
        }
        Iterable iterable = processorFqNames;
        wrapperFile = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void fqName;
            String string = (String)item$iv$iv;
            void var16_13 = destination$iv$iv;
            String string2 = "__gen." + this.getProcessorStubClassName((String)fqName);
            var16_13.add(string2);
        }
        String annotationProcessorWrapperFqNames = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        this.addWrappersToCompilerArgs(javaTask, annotationProcessorWrapperFqNames);
    }

    private final void appendClasspath(JavaCompile $receiver, File file) {
        JavaCompile javaCompile = $receiver;
        javaCompile.setClasspath(javaCompile.getClasspath().plus((FileCollection)$receiver.getProject().files(new Object[]{file})));
    }

    /*
     * WARNING - void declaration
     */
    private final void addWrappersToCompilerArgs(JavaCompile javaTask, String wrapperFqNames) {
        int argIndex$iv;
        void name$iv;
        List args$iv;
        ArrayList newCompilerArgs$iv$iv;
        void $receiver$iv$iv;
        block6: {
            int n;
            int n2;
            void $receiver$iv$iv2;
            void destination$iv$iv$iv;
            void $receiver$iv$iv$iv;
            void this_$iv;
            void $receiver$iv;
            JavaCompile javaCompile = javaTask;
            AnnotationProcessingManager annotationProcessingManager = this;
            String string = "-processor";
            void var6_6 = $receiver$iv;
            void var7_7 = this_$iv;
            List list = $receiver$iv$iv.getOptions().getCompilerArgs();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
            List compilerArgs$iv$iv = list;
            Iterable iterable = compilerArgs$iv$iv;
            Collection collection = CollectionsKt.arrayListOf((Object[])new String[0]);
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it$iv$iv;
                Object item$iv$iv$iv;
                Object t = item$iv$iv$iv = iterator.next();
                void var14_14 = destination$iv$iv$iv;
                String string2 = it$iv$iv.toString();
                var14_14.add(string2);
            }
            newCompilerArgs$iv$iv = (ArrayList)destination$iv$iv$iv;
            List list2 = args$iv = (List)newCompilerArgs$iv$iv;
            IntRange intRange = CollectionsKt.getIndices((Collection)((Collection)$receiver$iv$iv2));
            int n3 = intRange.getFirst();
            if (n3 <= (n2 = intRange.getLast())) {
                while (true) {
                    void index$iv$iv;
                    String it$iv;
                    if (Intrinsics.areEqual((Object)name$iv, (Object)(it$iv = (String)$receiver$iv$iv2.get((int)index$iv$iv)))) {
                        n = index$iv$iv;
                        break block6;
                    }
                    if (index$iv$iv == n2) break;
                    ++index$iv$iv;
                }
            }
            n = argIndex$iv = -1;
        }
        if (argIndex$iv >= 0 && args$iv.size() > argIndex$iv + 1) {
            void prevValue;
            String string = (String)args$iv.get(argIndex$iv + 1);
            int n = argIndex$iv + 1;
            List list = args$iv;
            String string3 = prevValue != null ? (String)prevValue + "," + wrapperFqNames : wrapperFqNames;
            list.set(n, string3);
        } else {
            args$iv.add(name$iv);
            String prevValue = null;
            List list = args$iv;
            String string = prevValue != null ? prevValue + "," + wrapperFqNames : wrapperFqNames;
            list.add(string);
        }
        $receiver$iv$iv.getOptions().setCompilerArgs((List)newCompilerArgs$iv$iv);
    }

    private final BaseExtension getAndroidExtension() {
        try {
            Object object = this.project.getExtensions().getByName("android");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.BaseExtension");
            }
            return (BaseExtension)object;
        }
        catch (UnknownDomainObjectException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addGeneratedSourcesOutputToCompilerArgs(JavaCompile javaTask, File outputDir) {
        int argIndex$iv;
        void name$iv;
        List args$iv;
        ArrayList newCompilerArgs$iv$iv;
        void $receiver$iv$iv;
        block8: {
            int n;
            int n2;
            void $receiver$iv$iv2;
            void destination$iv$iv$iv;
            void $receiver$iv$iv$iv;
            void this_$iv;
            void $receiver$iv;
            outputDir.mkdirs();
            JavaCompile javaCompile = javaTask;
            AnnotationProcessingManager annotationProcessingManager = this;
            String string = "-s";
            void var6_6 = $receiver$iv;
            void var7_7 = this_$iv;
            List list = $receiver$iv$iv.getOptions().getCompilerArgs();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
            List compilerArgs$iv$iv = list;
            Iterable iterable = compilerArgs$iv$iv;
            Collection collection = CollectionsKt.arrayListOf((Object[])new String[0]);
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it$iv$iv;
                Object item$iv$iv$iv;
                Object t = item$iv$iv$iv = iterator.next();
                void var14_14 = destination$iv$iv$iv;
                String string2 = it$iv$iv.toString();
                var14_14.add(string2);
            }
            newCompilerArgs$iv$iv = (ArrayList)destination$iv$iv$iv;
            List list2 = args$iv = (List)newCompilerArgs$iv$iv;
            IntRange intRange = CollectionsKt.getIndices((Collection)((Collection)$receiver$iv$iv2));
            int n3 = intRange.getFirst();
            if (n3 <= (n2 = intRange.getLast())) {
                while (true) {
                    void index$iv$iv;
                    String it$iv;
                    if (Intrinsics.areEqual((Object)name$iv, (Object)(it$iv = (String)$receiver$iv$iv2.get((int)index$iv$iv)))) {
                        n = index$iv$iv;
                        break block8;
                    }
                    if (index$iv$iv == n2) break;
                    ++index$iv$iv;
                }
            }
            n = argIndex$iv = -1;
        }
        if (argIndex$iv >= 0 && args$iv.size() > argIndex$iv + 1) {
            void prevValue;
            String string = (String)args$iv.get(argIndex$iv + 1);
            int n = argIndex$iv + 1;
            List list = args$iv;
            if (prevValue != null) {
                javaTask.getLogger().warn("Destination for generated sources was modified by kapt. Previous value = " + (String)prevValue);
            }
            String string3 = outputDir.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"outputDir.absolutePath");
            String string4 = string3;
            list.set(n, string4);
        } else {
            args$iv.add(name$iv);
            String prevValue = null;
            List list = args$iv;
            if (prevValue != null) {
                javaTask.getLogger().warn("Destination for generated sources was modified by kapt. Previous value = " + prevValue);
            }
            String string = outputDir.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputDir.absolutePath");
            String string5 = string;
            list.add(string5);
        }
        $receiver$iv$iv.getOptions().setCompilerArgs((List)newCompilerArgs$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void setProcessorPath(JavaCompile javaTask, String path) {
        int argIndex$iv;
        void name$iv;
        List args$iv;
        ArrayList newCompilerArgs$iv$iv;
        void $receiver$iv$iv;
        block8: {
            int n;
            int n2;
            void $receiver$iv$iv2;
            void destination$iv$iv$iv;
            void $receiver$iv$iv$iv;
            void this_$iv;
            void $receiver$iv;
            JavaCompile javaCompile = javaTask;
            AnnotationProcessingManager annotationProcessingManager = this;
            String string = "-processorpath";
            void var6_6 = $receiver$iv;
            void var7_7 = this_$iv;
            List list = $receiver$iv$iv.getOptions().getCompilerArgs();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
            List compilerArgs$iv$iv = list;
            Iterable iterable = compilerArgs$iv$iv;
            Collection collection = CollectionsKt.arrayListOf((Object[])new String[0]);
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it$iv$iv;
                Object item$iv$iv$iv;
                Object t = item$iv$iv$iv = iterator.next();
                void var14_14 = destination$iv$iv$iv;
                String string2 = it$iv$iv.toString();
                var14_14.add(string2);
            }
            newCompilerArgs$iv$iv = (ArrayList)destination$iv$iv$iv;
            List list2 = args$iv = (List)newCompilerArgs$iv$iv;
            IntRange intRange = CollectionsKt.getIndices((Collection)((Collection)$receiver$iv$iv2));
            int n3 = intRange.getFirst();
            if (n3 <= (n2 = intRange.getLast())) {
                while (true) {
                    void index$iv$iv;
                    String it$iv;
                    if (Intrinsics.areEqual((Object)name$iv, (Object)(it$iv = (String)$receiver$iv$iv2.get((int)index$iv$iv)))) {
                        n = index$iv$iv;
                        break block8;
                    }
                    if (index$iv$iv == n2) break;
                    ++index$iv$iv;
                }
            }
            n = argIndex$iv = -1;
        }
        if (argIndex$iv >= 0 && args$iv.size() > argIndex$iv + 1) {
            void prevValue;
            String string = (String)args$iv.get(argIndex$iv + 1);
            int n = argIndex$iv + 1;
            List list = args$iv;
            if (prevValue != null) {
                javaTask.getLogger().warn("Processor path was modified by kapt. Previous value = " + (String)prevValue);
            }
            String string3 = path;
            list.set(n, string3);
        } else {
            args$iv.add(name$iv);
            String prevValue = null;
            List list = args$iv;
            if (prevValue != null) {
                javaTask.getLogger().warn("Processor path was modified by kapt. Previous value = " + prevValue);
            }
            String string = path;
            list.add(string);
        }
        $receiver$iv$iv.getOptions().setCompilerArgs((List)newCompilerArgs$iv$iv);
    }

    private final String getProcessorStubClassName(String processorFqName) {
        return "AnnotationProcessorWrapper_" + this.taskQualifier + "_" + StringsKt.replace$default((String)processorFqName, (char)'.', (char)'_', (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void addCompilerArgument(JavaCompile $receiver, String name, Function1<? super String, String> value) {
        int argIndex;
        List args;
        ArrayList newCompilerArgs$iv;
        void $receiver$iv;
        block6: {
            int n;
            int n2;
            void $receiver$iv2;
            void destination$iv$iv;
            void $receiver$iv$iv;
            JavaCompile javaCompile = $receiver;
            AnnotationProcessingManager annotationProcessingManager = this;
            List list = $receiver$iv.getOptions().getCompilerArgs();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
            List compilerArgs$iv = list;
            Iterable iterable = compilerArgs$iv;
            Collection collection = CollectionsKt.arrayListOf((Object[])new String[0]);
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it$iv;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                void var13_12 = destination$iv$iv;
                String string = it$iv.toString();
                var13_12.add(string);
            }
            newCompilerArgs$iv = (ArrayList)destination$iv$iv;
            List list2 = args = (List)newCompilerArgs$iv;
            IntRange intRange = CollectionsKt.getIndices((Collection)((Collection)$receiver$iv2));
            int n3 = intRange.getFirst();
            if (n3 <= (n2 = intRange.getLast())) {
                while (true) {
                    void index$iv;
                    String it;
                    if (Intrinsics.areEqual((Object)name, (Object)(it = (String)$receiver$iv2.get((int)index$iv)))) {
                        n = index$iv;
                        break block6;
                    }
                    if (index$iv == n2) break;
                    ++index$iv;
                }
            }
            n = argIndex = -1;
        }
        if (argIndex >= 0 && args.size() > argIndex + 1) {
            args.set(argIndex + 1, value.invoke(args.get(argIndex + 1)));
        } else {
            args.add(name);
            args.add(value.invoke(null));
        }
        $receiver$iv.getOptions().setCompilerArgs((List)newCompilerArgs$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void modifyCompilerArguments(JavaCompile $receiver, Function1<? super List<String>, Unit> modifier) {
        void destination$iv;
        void $receiver$iv;
        List list = $receiver.getOptions().getCompilerArgs();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.options.compilerArgs");
        List compilerArgs = list;
        Iterable iterable = compilerArgs;
        Collection collection = CollectionsKt.arrayListOf((Object[])new String[0]);
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv;
            Object t = item$iv = iterator.next();
            void var13_9 = destination$iv;
            String string = it.toString();
            var13_9.add(string);
        }
        ArrayList newCompilerArgs = (ArrayList)destination$iv;
        modifier.invoke((Object)newCompilerArgs);
        $receiver.getOptions().setCompilerArgs((List)newCompilerArgs);
    }

    private final Set<String> lookupAnnotationProcessors(Set<? extends File> files) {
        lookupAnnotationProcessors.1 withZipFile$ = lookupAnnotationProcessors.1.INSTANCE;
        HashSet annotationProcessors = SetsKt.hashSetOf((Object[])new String[0]);
        Function1<Sequence<? extends String>, Unit> processLines$ = new Function1<Sequence<? extends String>, Unit>(annotationProcessors){
            final /* synthetic */ HashSet $annotationProcessors;

            public final void invoke(@NotNull Sequence<String> lines) {
                Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
                for (String line : lines) {
                    if (StringsKt.isBlank((CharSequence)line) || !AnnotationProcessingManager.Companion.getJAVA_FQNAME_PATTERN().matches((CharSequence)line)) continue;
                    this.$annotationProcessors.add(line);
                }
            }
            {
                this.$annotationProcessors = hashSet;
                super(1);
            }
        };
        for (File file : files) {
            withZipFile$.invoke(file, (Function1<? super ZipFile, Unit>)((Function1)new Function1<ZipFile, Unit>(processLines$){
                final /* synthetic */ lookupAnnotationProcessors.2 $processLines;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull ZipFile zipFile) {
                    Intrinsics.checkParameterIsNotNull((Object)zipFile, (String)"zipFile");
                    ZipEntry entry = zipFile.getEntry("META-INF/services/javax.annotation.processing.Processor");
                    if (entry != null) {
                        void $receiver$iv$iv;
                        InputStream inputStream = zipFile.getInputStream(entry);
                        Object object = null;
                        boolean bl = true;
                        Object var6_6 = null;
                        if (var6_6 != null) {
                            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reader");
                        }
                        if (bl & true) {
                            object = Charsets.UTF_8;
                        }
                        Reader $receiver$iv = new InputStreamReader(inputStream, (Charset)object);
                        object = $receiver$iv;
                        int $i$f$reader = 0;
                        boolean bl2 = true;
                        Object var7_11 = null;
                        if (var7_11 != null) {
                            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
                        }
                        if (bl2 & true) {
                            $i$f$reader = ConstantsKt.DEFAULT_BUFFER_SIZE;
                        }
                        object = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, $i$f$reader);
                        boolean closed$iv$iv = false;
                        try {
                            BufferedReader it$iv = (BufferedReader)$receiver$iv$iv;
                            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                            this.$processLines.invoke((Sequence<String>)lines);
                            it$iv = Unit.INSTANCE;
                        }
                        catch (Exception e$iv$iv) {
                            closed$iv$iv = true;
                            try {
                                $receiver$iv$iv.close();
                            }
                            catch (Exception closeException$iv$iv) {
                                // empty catch block
                            }
                            throw (Throwable)e$iv$iv;
                        }
                        finally {
                            if (!closed$iv$iv) {
                                $receiver$iv$iv.close();
                            }
                        }
                    }
                }
                {
                    this.$processLines = var1_1;
                    super(1);
                }
            }));
        }
        KotlinPluginWrapperKt.kotlinDebug(this.project.getLogger(), "kapt: Discovered annotation processors: " + CollectionsKt.joinToString$default((Iterable)annotationProcessors, null, null, null, (int)0, null, null, (int)63, null));
        return annotationProcessors;
    }

    /*
     * WARNING - void declaration
     */
    private final Object invokeCoreKaptMethod(String methodName, Object ... args) {
        void $receiver$iv;
        Class[] array = new Class[args.length];
        Object[] objectArray = args;
        int index$iv = 0;
        for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
            void arg;
            void item$iv = $receiver$iv[i];
            int n = index$iv++;
            void var8_8 = item$iv;
            int i2 = n;
            array[i2] = arg.getClass();
        }
        Method method = this.getCoreKaptPackageClass().getMethod(methodName, Arrays.copyOf(array, array.length));
        Object object = method.invoke(null, Arrays.copyOf(args, args.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"method.invoke(null, *args)");
        return object;
    }

    private final Class<?> getCoreKaptPackageClass() {
        Class<?> clazz = Class.forName("org.jetbrains.kotlin.gradle.tasks.kapt.KaptStubGeneratorUtilsKt", false, this.coreClassLoader);
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(\"org.jetbr\u2026, false, coreClassLoader)");
        return clazz;
    }

    public AnnotationProcessingManager(@NotNull AbstractCompile task, @NotNull JavaCompile javaTask, @NotNull String taskQualifier, @NotNull Set<? extends File> aptFiles, @NotNull File aptOutputDir, @NotNull File aptWorkingDir, @NotNull ClassLoader coreClassLoader, @Nullable Object androidVariant) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)javaTask, (String)"javaTask");
        Intrinsics.checkParameterIsNotNull((Object)taskQualifier, (String)"taskQualifier");
        Intrinsics.checkParameterIsNotNull(aptFiles, (String)"aptFiles");
        Intrinsics.checkParameterIsNotNull((Object)aptOutputDir, (String)"aptOutputDir");
        Intrinsics.checkParameterIsNotNull((Object)aptWorkingDir, (String)"aptWorkingDir");
        Intrinsics.checkParameterIsNotNull((Object)coreClassLoader, (String)"coreClassLoader");
        this.task = task;
        this.javaTask = javaTask;
        this.taskQualifier = taskQualifier;
        this.aptFiles = aptFiles;
        this.aptOutputDir = aptOutputDir;
        this.aptWorkingDir = aptWorkingDir;
        this.coreClassLoader = coreClassLoader;
        this.androidVariant = androidVariant;
        this.project = this.task.getProject();
    }

    public /* synthetic */ AnnotationProcessingManager(AbstractCompile abstractCompile, JavaCompile javaCompile, String string, Set set, File file, File file2, ClassLoader classLoader, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            object = null;
        }
        this(abstractCompile, javaCompile, string, set, file, file2, classLoader, object);
    }

    static {
        Companion = new Companion(null);
        String $receiver$iv = "^([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*$";
        JAVA_FQNAME_PATTERN = new Regex($receiver$iv);
        WRAPPERS_DIRECTORY = WRAPPERS_DIRECTORY;
        GEN_ANNOTATION = GEN_ANNOTATION;
        ANDROID_APT_PLUGIN_ID = ANDROID_APT_PLUGIN_ID;
    }

    public static final /* synthetic */ void access$modifyCompilerArguments(AnnotationProcessingManager $this, JavaCompile $receiver, @NotNull Function1 modifier) {
        $this.modifyCompilerArguments($receiver, (Function1<? super List<String>, Unit>)modifier);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/AnnotationProcessingManager$Companion;", "", "()V", "ANDROID_APT_PLUGIN_ID", "", "getANDROID_APT_PLUGIN_ID", "()Ljava/lang/String;", "GEN_ANNOTATION", "getGEN_ANNOTATION", "JAVA_FQNAME_PATTERN", "Lkotlin/text/Regex;", "getJAVA_FQNAME_PATTERN", "()Lkotlin/text/Regex;", "WRAPPERS_DIRECTORY", "getWRAPPERS_DIRECTORY", "kotlin-gradle-plugin"})
    private static final class Companion {
        @NotNull
        public final Regex getJAVA_FQNAME_PATTERN() {
            return JAVA_FQNAME_PATTERN;
        }

        @NotNull
        public final String getWRAPPERS_DIRECTORY() {
            return WRAPPERS_DIRECTORY;
        }

        @NotNull
        public final String getGEN_ANNOTATION() {
            return GEN_ANNOTATION;
        }

        private final String getANDROID_APT_PLUGIN_ID() {
            return ANDROID_APT_PLUGIN_ID;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

