/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.lang.reflect.Method;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang.SystemUtils;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.CleanUpBuildListenerKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\u000bH\u0002J\u0011\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\rH\u0086\u0002J\b\u0010\u0012\u001a\u00020\u000bH\u0002J\b\u0010\u0013\u001a\u00020\u000bH\u0002R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/CompilerServicesCleanup;", "", "pluginClassLoader", "Ljava/lang/ClassLoader;", "(Ljava/lang/ClassLoader;)V", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/gradle/api/logging/Logger;", "callVoidStaticMethod", "", "classFqName", "", "methodName", "cleanJarCache", "invoke", "gradleVersion", "stopJobScheduler", "stopZipFileCache", "kotlin-gradle-plugin"})
public final class CompilerServicesCleanup {
    private final Logger log;
    private ClassLoader pluginClassLoader;

    public final Logger getLog() {
        return this.log;
    }

    public final void invoke(@NotNull String gradleVersion) {
        Unit unit;
        Unit unit2;
        Intrinsics.checkParameterIsNotNull((Object)gradleVersion, (String)"gradleVersion");
        boolean value$iv = this.pluginClassLoader != null;
        if (_Assertions.ENABLED) {
            if (!value$iv) {
                String message$iv$iv = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
            }
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = Unit.INSTANCE;
        }
        KotlinPluginWrapperKt.kotlinDebug(this.log, "compiler services cleanup");
        if (SystemUtils.IS_OS_WINDOWS) {
            this.cleanJarCache();
        }
        String string = CleanUpBuildListenerKt.access$comparableVersionStr(gradleVersion);
        if (string != null) {
            String $receiver$iv = string;
            String it = $receiver$iv;
            KotlinPluginWrapperKt.kotlinDebug(this.log, "detected gradle version " + it);
            String string2 = CleanUpBuildListenerKt.access$comparableVersionStr("2.4");
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if (it.compareTo(string2) < 0) {
                this.stopZipFileCache();
                this.stopJobScheduler();
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        this.pluginClassLoader = null;
    }

    private final void stopZipFileCache() {
        this.callVoidStaticMethod("com.intellij.openapi.util.io.ZipFileCache", "stopBackgroundThread");
        KotlinPluginWrapperKt.kotlinDebug(this.log, "ZipFileCache finished successfully");
    }

    private final void stopJobScheduler() {
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Stop JobScheduler");
        Class<?> jobSchedulerClass = Class.forName("com.intellij.concurrency.JobScheduler", false, this.pluginClassLoader);
        Method getSchedulerMethod = jobSchedulerClass.getMethod("getScheduler", new Class[0]);
        Object object = getSchedulerMethod.invoke((Object)this, new Object[0]);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.concurrent.ScheduledExecutorService");
        }
        ScheduledExecutorService executorService = (ScheduledExecutorService)object;
        executorService.shutdown();
        KotlinPluginWrapperKt.kotlinDebug(this.log, "JobScheduler stopped");
    }

    /*
     * WARNING - void declaration
     */
    private final void callVoidStaticMethod(String classFqName, String methodName) {
        void startIndex$iv;
        void $receiver$iv;
        String string = classFqName;
        int n = StringsKt.lastIndexOf$default((CharSequence)classFqName, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)v0).substring((int)startIndex$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String shortName = string2;
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Looking for " + shortName + " class");
        ClassLoader classLoader = this.pluginClassLoader;
        if (classLoader == null) {
            Intrinsics.throwNpe();
        }
        Class<?> cls = classLoader.loadClass(classFqName);
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Looking for " + methodName + "() method");
        Method method = cls.getMethod(methodName, new Class[0]);
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Call " + shortName + "." + methodName + "()");
        method.invoke(null, new Object[0]);
    }

    private final void cleanJarCache() {
        KotlinPluginWrapperKt.kotlinDebug(this.log, "Clean JAR cache");
        this.callVoidStaticMethod("com.intellij.openapi.vfs.impl.ZipHandler", "clearFileAccessorCache");
        KotlinPluginWrapperKt.kotlinDebug(this.log, "JAR cache cleared");
    }

    public CompilerServicesCleanup(@Nullable ClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
        this.log = Logging.getLogger(this.getClass());
    }
}

