/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.gradle.api.Project;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.util.PatternFilterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.internal.KotlinSourceSetImpl;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPropertiesKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\t\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003BC\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010:\u001a\u00020;H\u0014J\b\u0010<\u001a\u00020;H\u0014J\u0017\u0010=\u001a\u00028\u00002\b\b\u0002\u0010>\u001a\u00020\u000bH\u0014\u00a2\u0006\u0002\u0010?J\n\u0010@\u001a\u0004\u0018\u00010\u001aH\u0014J\n\u0010A\u001a\u0004\u0018\u00010 H\u0014J\b\u0010B\u001a\u00020;H$J\u0006\u0010C\u001a\u00020;R\u0014\u0010\u0011\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001a8DX\u0084\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 8DX\u0084\u0004\u00a2\u0006\f\n\u0004\b#\u0010\u001e\u001a\u0004\b!\u0010\"R\u001a\u0010$\u001a\u00028\u00008DX\u0084\u0004\u00a2\u0006\f\n\u0004\b'\u0010\u001e\u001a\u0004\b%\u0010&R\u001a\u0010(\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\f\n\u0004\b*\u0010\u001e\u001a\u0004\b)\u0010\u0013R\u0019\u0010+\u001a\n -*\u0004\u0018\u00010,0,\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0013R\u0011\u0010\r\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u0013\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSetProcessor;", "T", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "", "project", "Lorg/gradle/api/internal/project/ProjectInternal;", "javaBasePlugin", "Lorg/gradle/api/plugins/JavaBasePlugin;", "sourceSet", "Lorg/gradle/api/tasks/SourceSet;", "pluginName", "", "compileTaskNameSuffix", "taskDescription", "compilerClass", "Ljava/lang/Class;", "(Lorg/gradle/api/internal/project/ProjectInternal;Lorg/gradle/api/plugins/JavaBasePlugin;Lorg/gradle/api/tasks/SourceSet;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)V", "absoluteSourceRootDir", "getAbsoluteSourceRootDir", "()Ljava/lang/String;", "getCompileTaskNameSuffix", "getCompilerClass", "()Ljava/lang/Class;", "getJavaBasePlugin", "()Lorg/gradle/api/plugins/JavaBasePlugin;", "kotlinDirSet", "Lorg/gradle/api/file/SourceDirectorySet;", "getKotlinDirSet", "()Lorg/gradle/api/file/SourceDirectorySet;", "kotlinDirSet$delegate", "Lkotlin/Lazy;", "kotlinSourceSet", "Lorg/jetbrains/kotlin/gradle/internal/KotlinSourceSet;", "getKotlinSourceSet", "()Lorg/jetbrains/kotlin/gradle/internal/KotlinSourceSet;", "kotlinSourceSet$delegate", "kotlinTask", "getKotlinTask", "()Lorg/gradle/api/tasks/compile/AbstractCompile;", "kotlinTask$delegate", "kotlinTaskName", "getKotlinTaskName", "kotlinTaskName$delegate", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/gradle/api/logging/Logger;", "getPluginName", "getProject", "()Lorg/gradle/api/internal/project/ProjectInternal;", "sourceRootDir", "getSourceRootDir", "getSourceSet", "()Lorg/gradle/api/tasks/SourceSet;", "sourceSetName", "getSourceSetName", "getTaskDescription", "addSourcesToKotlinDirSet", "", "commonTaskConfiguration", "createKotlinCompileTask", "suffix", "(Ljava/lang/String;)Lorg/gradle/api/tasks/compile/AbstractCompile;", "createKotlinDirSet", "createKotlinSourceSet", "doTargetSpecificProcessing", "run", "kotlin-gradle-plugin"})
public abstract class KotlinSourceSetProcessor<T extends AbstractCompile> {
    private final Logger logger;
    @NotNull
    private final String sourceSetName;
    @NotNull
    private final String sourceRootDir;
    @NotNull
    private final String absoluteSourceRootDir;
    @Nullable
    private final Lazy kotlinSourceSet$delegate;
    @Nullable
    private final Lazy kotlinDirSet$delegate;
    @NotNull
    private final Lazy kotlinTask$delegate;
    @NotNull
    private final Lazy kotlinTaskName$delegate;
    @NotNull
    private final ProjectInternal project;
    @NotNull
    private final JavaBasePlugin javaBasePlugin;
    @NotNull
    private final SourceSet sourceSet;
    @NotNull
    private final String pluginName;
    @NotNull
    private final String compileTaskNameSuffix;
    @NotNull
    private final String taskDescription;
    @NotNull
    private final Class<T> compilerClass;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    protected abstract void doTargetSpecificProcessing();

    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    protected final String getSourceSetName() {
        return this.sourceSetName;
    }

    @NotNull
    protected final String getSourceRootDir() {
        return this.sourceRootDir;
    }

    @NotNull
    protected final String getAbsoluteSourceRootDir() {
        return this.absoluteSourceRootDir;
    }

    @Nullable
    protected final KotlinSourceSet getKotlinSourceSet() {
        Lazy lazy = this.kotlinSourceSet$delegate;
        KotlinSourceSetProcessor kotlinSourceSetProcessor = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (KotlinSourceSet)lazy.getValue();
    }

    @Nullable
    protected final SourceDirectorySet getKotlinDirSet() {
        Lazy lazy = this.kotlinDirSet$delegate;
        KotlinSourceSetProcessor kotlinSourceSetProcessor = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (SourceDirectorySet)lazy.getValue();
    }

    @NotNull
    protected final T getKotlinTask() {
        Lazy lazy = this.kotlinTask$delegate;
        KotlinSourceSetProcessor kotlinSourceSetProcessor = this;
        KProperty kProperty = $$delegatedProperties[2];
        return (T)((AbstractCompile)lazy.getValue());
    }

    @NotNull
    protected final String getKotlinTaskName() {
        Lazy lazy = this.kotlinTaskName$delegate;
        KotlinSourceSetProcessor kotlinSourceSetProcessor = this;
        KProperty kProperty = $$delegatedProperties[3];
        return (String)lazy.getValue();
    }

    public final void run() {
        if (this.getKotlinSourceSet() == null || this.getKotlinDirSet() == null) {
            return;
        }
        this.addSourcesToKotlinDirSet();
        this.commonTaskConfiguration();
        this.doTargetSpecificProcessing();
    }

    @Nullable
    protected KotlinSourceSet createKotlinSourceSet() {
        KotlinSourceSet kotlinSourceSet2;
        if (this.sourceSet instanceof HasConvention) {
            KotlinPluginWrapperKt.kotlinDebug(this.logger, "Creating KotlinSourceSet for source set " + this.sourceSet);
            KotlinSourceSetImpl kotlinSourceSet3 = new KotlinSourceSetImpl(this.sourceSet.getName(), this.project.getFileResolver());
            ((HasConvention)this.sourceSet).getConvention().getPlugins().put(this.pluginName, kotlinSourceSet3);
            kotlinSourceSet2 = kotlinSourceSet3;
        } else {
            kotlinSourceSet2 = null;
        }
        return kotlinSourceSet2;
    }

    @Nullable
    protected SourceDirectorySet createKotlinDirSet() {
        SourceDirectorySet kotlinDirSet2;
        File srcDir = this.project.file((Object)this.sourceRootDir);
        KotlinPluginWrapperKt.kotlinDebug(this.logger, "Creating Kotlin SourceDirectorySet for source set " + this.getKotlinSourceSet() + " with src dir " + srcDir);
        KotlinSourceSet kotlinSourceSet2 = this.getKotlinSourceSet();
        SourceDirectorySet sourceDirectorySet = kotlinDirSet2 = kotlinSourceSet2 != null ? kotlinSourceSet2.getKotlin() : null;
        Object object = sourceDirectorySet != null ? sourceDirectorySet.srcDir((Object)srcDir) : null;
        return kotlinDirSet2;
    }

    protected void addSourcesToKotlinDirSet() {
        KotlinPluginWrapperKt.kotlinDebug(this.logger, "Adding Kotlin SourceDirectorySet " + this.getKotlinDirSet() + " to source set " + this.sourceSet);
        SourceDirectorySet sourceDirectorySet = this.sourceSet.getAllJava();
        SourceDirectorySet sourceDirectorySet2 = sourceDirectorySet != null ? sourceDirectorySet.source(this.getKotlinDirSet()) : null;
        SourceDirectorySet sourceDirectorySet3 = this.sourceSet.getAllSource();
        SourceDirectorySet sourceDirectorySet4 = sourceDirectorySet3 != null ? sourceDirectorySet3.source(this.getKotlinDirSet()) : null;
        SourceDirectorySet sourceDirectorySet5 = this.sourceSet.getResources();
        PatternFilterable patternFilterable = sourceDirectorySet5 != null && (sourceDirectorySet5 = sourceDirectorySet5.getFilter()) != null ? sourceDirectorySet5.exclude((Spec)new Spec<FileTreeElement>(this){
            final /* synthetic */ KotlinSourceSetProcessor this$0;

            public final boolean isSatisfiedBy(FileTreeElement it) {
                SourceDirectorySet sourceDirectorySet = this.this$0.getKotlinDirSet();
                if (sourceDirectorySet == null) {
                    Intrinsics.throwNpe();
                }
                return sourceDirectorySet.contains(it.getFile());
            }
            {
                this.this$0 = kotlinSourceSetProcessor;
            }
        }) : null;
    }

    @NotNull
    protected T createKotlinCompileTask(@NotNull String suffix) {
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        String name = this.sourceSet.getCompileTaskName(this.compileTaskNameSuffix) + suffix;
        KotlinPluginWrapperKt.kotlinDebug(this.logger, "Creating kotlin compile task " + name + " with class " + this.compilerClass);
        AbstractCompile compile = (AbstractCompile)this.project.getTasks().create(name, this.compilerClass);
        compile.getExtensions().getExtraProperties().set("defaultModuleName", (Object)(this.project.getName() + "-" + name));
        AbstractCompile abstractCompile = compile;
        Intrinsics.checkExpressionValueIsNotNull((Object)abstractCompile, (String)"compile");
        return (T)abstractCompile;
    }

    @NotNull
    protected static /* bridge */ /* synthetic */ AbstractCompile createKotlinCompileTask$default(KotlinSourceSetProcessor kotlinSourceSetProcessor, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createKotlinCompileTask");
        }
        if ((n & 1) != 0) {
            string = "";
        }
        return kotlinSourceSetProcessor.createKotlinCompileTask(string);
    }

    protected void commonTaskConfiguration() {
        this.javaBasePlugin.configureForSourceSet(this.sourceSet, this.getKotlinTask());
        this.getKotlinTask().setDescription(this.taskDescription);
        this.getKotlinTask().source(new Object[]{this.getKotlinDirSet()});
        KotlinPropertiesKt.mapKotlinTaskProperties((Project)this.project, this.getKotlinTask());
    }

    @NotNull
    public final ProjectInternal getProject() {
        return this.project;
    }

    @NotNull
    public final JavaBasePlugin getJavaBasePlugin() {
        return this.javaBasePlugin;
    }

    @NotNull
    public final SourceSet getSourceSet() {
        return this.sourceSet;
    }

    @NotNull
    public final String getPluginName() {
        return this.pluginName;
    }

    @NotNull
    public final String getCompileTaskNameSuffix() {
        return this.compileTaskNameSuffix;
    }

    @NotNull
    public final String getTaskDescription() {
        return this.taskDescription;
    }

    @NotNull
    public final Class<T> getCompilerClass() {
        return this.compilerClass;
    }

    public KotlinSourceSetProcessor(@NotNull ProjectInternal project, @NotNull JavaBasePlugin javaBasePlugin, @NotNull SourceSet sourceSet, @NotNull String pluginName, @NotNull String compileTaskNameSuffix, @NotNull String taskDescription, @NotNull Class<T> compilerClass) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)javaBasePlugin, (String)"javaBasePlugin");
        Intrinsics.checkParameterIsNotNull((Object)sourceSet, (String)"sourceSet");
        Intrinsics.checkParameterIsNotNull((Object)pluginName, (String)"pluginName");
        Intrinsics.checkParameterIsNotNull((Object)compileTaskNameSuffix, (String)"compileTaskNameSuffix");
        Intrinsics.checkParameterIsNotNull((Object)taskDescription, (String)"taskDescription");
        Intrinsics.checkParameterIsNotNull(compilerClass, (String)"compilerClass");
        this.project = project;
        this.javaBasePlugin = javaBasePlugin;
        this.sourceSet = sourceSet;
        this.pluginName = pluginName;
        this.compileTaskNameSuffix = compileTaskNameSuffix;
        this.taskDescription = taskDescription;
        this.compilerClass = compilerClass;
        this.logger = Logging.getLogger(this.getClass());
        String string = this.sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceSet.name");
        this.sourceSetName = string;
        this.sourceRootDir = "src/" + this.sourceSetName + "/kotlin";
        this.absoluteSourceRootDir = this.project.getProjectDir().getPath() + "/" + this.sourceRootDir;
        this.kotlinSourceSet$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KotlinSourceSet>(this){
            final /* synthetic */ KotlinSourceSetProcessor this$0;

            @Nullable
            public final KotlinSourceSet invoke() {
                return this.this$0.createKotlinSourceSet();
            }
            {
                this.this$0 = kotlinSourceSetProcessor;
                super(0);
            }
        }));
        this.kotlinDirSet$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SourceDirectorySet>(this){
            final /* synthetic */ KotlinSourceSetProcessor this$0;

            @Nullable
            public final SourceDirectorySet invoke() {
                return this.this$0.createKotlinDirSet();
            }
            {
                this.this$0 = kotlinSourceSetProcessor;
                super(0);
            }
        }));
        this.kotlinTask$delegate = LazyKt.lazy((Function0)new Function0<T>(this){
            final /* synthetic */ KotlinSourceSetProcessor this$0;

            @NotNull
            public final T invoke() {
                return (T)KotlinSourceSetProcessor.createKotlinCompileTask$default(this.this$0, null, 1, null);
            }
            {
                this.this$0 = kotlinSourceSetProcessor;
                super(0);
            }
        });
        this.kotlinTaskName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ KotlinSourceSetProcessor this$0;

            public final String invoke() {
                return this.this$0.getKotlinTask().getName();
            }
            {
                this.this$0 = kotlinSourceSetProcessor;
                super(0);
            }
        }));
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(KotlinSourceSetProcessor.class), "kotlinSourceSet", "getKotlinSourceSet()Lorg/jetbrains/kotlin/gradle/internal/KotlinSourceSet;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(KotlinSourceSetProcessor.class), "kotlinDirSet", "getKotlinDirSet()Lorg/gradle/api/file/SourceDirectorySet;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(KotlinSourceSetProcessor.class), "kotlinTask", "getKotlinTask()Lorg/gradle/api/tasks/compile/AbstractCompile;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(KotlinSourceSetProcessor.class), "kotlinTaskName", "getKotlinTaskName()Ljava/lang/String;"))};
    }
}

