/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.CompilerServicesCleanup;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\u0010J\u000f\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/CleanUpBuildListener;", "Lorg/gradle/BuildAdapter;", "pluginClassLoader", "Ljava/lang/ClassLoader;", "project", "Lorg/gradle/api/Project;", "(Ljava/lang/ClassLoader;Lorg/gradle/api/Project;)V", "cleanup", "Lorg/jetbrains/kotlin/gradle/plugin/CompilerServicesCleanup;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "startMemory", "", "Ljava/lang/Long;", "buildFinished", "", "result", "Lorg/gradle/BuildResult;", "buildStarted", "getUsedMemoryKb", "()Ljava/lang/Long;", "Companion", "kotlin-gradle-plugin"})
public final class CleanUpBuildListener
extends BuildAdapter {
    private final Logger log;
    private final CompilerServicesCleanup cleanup;
    private Long startMemory;
    private final Project project;
    @NotNull
    public static final String FORCE_SYSTEM_GC_MESSAGE = "Forcing System.gc()";
    public static final Companion Companion = new Companion(null);

    public final void buildStarted() {
        if (this.log.isDebugEnabled()) {
            Long l = this.getUsedMemoryKb();
            if (l == null) {
                Intrinsics.throwNpe();
            }
            this.startMemory = l;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void buildFinished(@Nullable BuildResult result) {
        block11: {
            block10: {
                v0 = result;
                v1 /* !! */  = gradle = v0 != null ? v0.getGradle() : null;
                if (gradle == null) break block11;
                var4_3 = (Iterable)this.project.getTasks();
                var5_4 = $receiver$iv;
                var6_6 = new ArrayList<E>();
                var7_7 = $receiver$iv$iv.iterator();
                while (var7_7.hasNext()) {
                    element$iv$iv = var7_7.next();
                    it = (Task)element$iv$iv;
                    if (!StringsKt.contains((CharSequence)it.getName(), (CharSequence)"kotlin", (boolean)true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (T element$iv : $receiver$iv) {
                    task = (Task)element$iv;
                    if (!task.hasProperty("compilerCalled")) ** GOTO lbl-1000
                    v2 = task.property("compilerCalled");
                    if (!(v2 instanceof Boolean)) {
                        v2 = null;
                    }
                    v3 = (Boolean)v2;
                    if (v3 != null ? v3 : false) {
                        v4 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = false;
                    }
                    if (!v4) continue;
                    v5 = true;
                    break block10;
                }
                v5 = kotlinCompilerCalled = false;
            }
            if (kotlinCompilerCalled) {
                KotlinPluginWrapperKt.kotlinDebug(this.log, "Cleanup after kotlin");
                v6 = gradle.getGradleVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"gradle.gradleVersion");
                this.cleanup.invoke(v6);
            } else {
                KotlinPluginWrapperKt.kotlinDebug(this.log, "Skipping kotlin cleanup since compiler wasn't called");
            }
            gradle.removeListener((Object)this);
            if (!kotlinCompilerCalled) break block11;
            v7 = this.startMemory;
            if (v7 != null) {
                var4_3 = v7;
                startMemoryCopy = ((Number)var4_3).longValue();
                v8 = this.getUsedMemoryKb();
                if (v8 != null) {
                    var7_7 = v8;
                    endMemory = ((Number)var7_7).longValue();
                    var10_12 = "%+d";
                    var11_13 = new Object[]{endMemory - startMemoryCopy};
                    var12_14 = new StringBuilder().append("[PERF] Used memory after build: ").append(endMemory).append(" kb (difference since build start: ");
                    var13_15 = this.log;
                    v9 = String.format(var10_12, Arrays.copyOf(var11_13, var11_13.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"java.lang.String.format(this, *args)");
                    var14_16 = v9;
                    KotlinPluginWrapperKt.kotlinDebug(var13_15, var12_14.append(var14_16).append(" kb)").toString());
                    v10 = Unit.INSTANCE;
                } else {
                    v10 = null;
                }
                (Unit)v10;
            }
        }
    }

    private final Long getUsedMemoryKb() {
        if (!this.log.isDebugEnabled()) {
            return null;
        }
        this.log.lifecycle(FORCE_SYSTEM_GC_MESSAGE);
        System.gc();
        Runtime rt = Runtime.getRuntime();
        return (rt.totalMemory() - rt.freeMemory()) / (long)1024;
    }

    public CleanUpBuildListener(@NotNull ClassLoader pluginClassLoader, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)pluginClassLoader, (String)"pluginClassLoader");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.log = Logging.getLogger(((Object)((Object)this)).getClass());
        this.cleanup = new CompilerServicesCleanup(pluginClassLoader);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/CleanUpBuildListener$Companion;", "", "()V", "FORCE_SYSTEM_GC_MESSAGE", "", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

