/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.bytecode;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.TypePath;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J%\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000bH\u0082\bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/bytecode/AnnotationsRemover;", "", "annotations", "", "", "(Ljava/lang/Iterable;)V", "Ljava/util/HashSet;", "checkAnnotation", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "desc", "default", "Lkotlin/Function0;", "transformClassFile", "", "inputFile", "Ljava/io/File;", "outputFile", "ClassAnnotationRemover", "FieldAnnotationRemover", "MethodAnnotationRemover", "kotlin-gradle-plugin"})
public final class AnnotationsRemover {
    private final HashSet<String> annotations;

    public final void transformClassFile(@NotNull File inputFile, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)inputFile, (String)"inputFile");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        String string = FilesKt.getExtension((File)inputFile);
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        boolean bl = Intrinsics.areEqual((Object)string3, (Object)"class");
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Expected class file: " + inputFile;
            throw (Throwable)((Object)new AssertionError((Object)string4));
        }
        byte[] bytes = FilesKt.readBytes((File)inputFile);
        ClassReader reader = new ClassReader(bytes);
        ClassWriter classWriter = new ClassWriter(0);
        ClassAnnotationRemover visitor = new ClassAnnotationRemover((ClassVisitor)classWriter);
        reader.accept((ClassVisitor)visitor, 0);
        byte[] byArray = classWriter.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"classWriter.toByteArray()");
        FilesKt.writeBytes((File)outputFile, (byte[])byArray);
    }

    private final AnnotationVisitor checkAnnotation(String desc, Function0<? extends AnnotationVisitor> function0) {
        if (CollectionsKt.contains((Iterable)this.annotations, (Object)desc)) {
            return null;
        }
        return (AnnotationVisitor)function0.invoke();
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationsRemover(@NotNull Iterable<String> annotations) {
        Collection collection;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Iterable<String> iterable = annotations;
        Collection collection2 = new HashSet();
        AnnotationsRemover annotationsRemover2 = this;
        for (Object item$iv : $receiver$iv) {
            void it;
            void destination$iv;
            String string = (String)item$iv;
            collection = destination$iv;
            String string2 = "L" + (String)it + ";";
            collection.add(string2);
        }
        collection = collection2;
        annotationsRemover2.annotations = (HashSet)collection;
    }

    @Nullable
    public static final /* synthetic */ AnnotationVisitor access$checkAnnotation(AnnotationsRemover $this, @Nullable String desc, @NotNull Function0 function0) {
        return $this.checkAnnotation(desc, (Function0<? extends AnnotationVisitor>)function0);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016JE\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0010\u0010\u0014\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J.\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/bytecode/AnnotationsRemover$ClassAnnotationRemover;", "Lorg/jetbrains/org/objectweb/asm/ClassVisitor;", "classVisitor", "(Lorg/jetbrains/kotlin/bytecode/AnnotationsRemover;Lorg/jetbrains/org/objectweb/asm/ClassVisitor;)V", "visitAnnotation", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "desc", "", "visible", "", "visitField", "Lorg/jetbrains/org/objectweb/asm/FieldVisitor;", "access", "", "name", "signature", "value", "", "visitMethod", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "exceptions", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "visitTypeAnnotation", "typeRef", "typePath", "Lorg/jetbrains/org/objectweb/asm/TypePath;", "kotlin-gradle-plugin"})
    public final class ClassAnnotationRemover
    extends ClassVisitor {
        @Nullable
        public AnnotationVisitor visitAnnotation(@Nullable String desc, boolean visible) {
            AnnotationsRemover this_$iv = AnnotationsRemover.this;
            return CollectionsKt.contains((Iterable)this_$iv.annotations, (Object)desc) ? (AnnotationVisitor)null : super.visitAnnotation(desc, visible);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, @Nullable String desc, boolean visible) {
            void this_$iv;
            AnnotationsRemover annotationsRemover2 = AnnotationsRemover.this;
            return CollectionsKt.contains((Iterable)((AnnotationsRemover)this_$iv).annotations, (Object)desc) ? (AnnotationVisitor)null : super.visitTypeAnnotation(typeRef, typePath, desc, visible);
        }

        @NotNull
        public MethodVisitor visitMethod(int access, @Nullable String name, @Nullable String desc, @Nullable String signature, @Nullable String[] exceptions) {
            MethodVisitor methodVisitor;
            MethodVisitor methodVisitor2 = methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            Intrinsics.checkExpressionValueIsNotNull((Object)methodVisitor2, (String)"methodVisitor");
            return new MethodAnnotationRemover(methodVisitor2);
        }

        @NotNull
        public FieldVisitor visitField(int access, @Nullable String name, @Nullable String desc, @Nullable String signature, @Nullable Object value) {
            FieldVisitor fieldVisitor;
            FieldVisitor fieldVisitor2 = fieldVisitor = super.visitField(access, name, desc, signature, value);
            Intrinsics.checkExpressionValueIsNotNull((Object)fieldVisitor2, (String)"fieldVisitor");
            return new FieldAnnotationRemover(fieldVisitor2);
        }

        public ClassAnnotationRemover(ClassVisitor classVisitor) {
            Intrinsics.checkParameterIsNotNull((Object)classVisitor, (String)"classVisitor");
            super(327680, classVisitor);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/bytecode/AnnotationsRemover$MethodAnnotationRemover;", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "methodVisitor", "(Lorg/jetbrains/kotlin/bytecode/AnnotationsRemover;Lorg/jetbrains/org/objectweb/asm/MethodVisitor;)V", "visitAnnotation", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "desc", "", "visible", "", "visitParameterAnnotation", "parameter", "", "visitTypeAnnotation", "typeRef", "typePath", "Lorg/jetbrains/org/objectweb/asm/TypePath;", "kotlin-gradle-plugin"})
    public final class MethodAnnotationRemover
    extends MethodVisitor {
        @Nullable
        public AnnotationVisitor visitAnnotation(@Nullable String desc, boolean visible) {
            AnnotationsRemover this_$iv = AnnotationsRemover.this;
            return CollectionsKt.contains((Iterable)this_$iv.annotations, (Object)desc) ? (AnnotationVisitor)null : super.visitAnnotation(desc, visible);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, @Nullable String desc, boolean visible) {
            void this_$iv;
            AnnotationsRemover annotationsRemover2 = AnnotationsRemover.this;
            return CollectionsKt.contains((Iterable)((AnnotationsRemover)this_$iv).annotations, (Object)desc) ? (AnnotationVisitor)null : super.visitTypeAnnotation(typeRef, typePath, desc, visible);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public AnnotationVisitor visitParameterAnnotation(int parameter, @Nullable String desc, boolean visible) {
            void this_$iv;
            AnnotationsRemover annotationsRemover2 = AnnotationsRemover.this;
            return CollectionsKt.contains((Iterable)((AnnotationsRemover)this_$iv).annotations, (Object)desc) ? (AnnotationVisitor)null : super.visitParameterAnnotation(parameter, desc, visible);
        }

        public MethodAnnotationRemover(MethodVisitor methodVisitor) {
            Intrinsics.checkParameterIsNotNull((Object)methodVisitor, (String)"methodVisitor");
            super(327680, methodVisitor);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/bytecode/AnnotationsRemover$FieldAnnotationRemover;", "Lorg/jetbrains/org/objectweb/asm/FieldVisitor;", "fieldVisitor", "(Lorg/jetbrains/kotlin/bytecode/AnnotationsRemover;Lorg/jetbrains/org/objectweb/asm/FieldVisitor;)V", "visitAnnotation", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "desc", "", "visible", "", "visitTypeAnnotation", "typeRef", "", "typePath", "Lorg/jetbrains/org/objectweb/asm/TypePath;", "kotlin-gradle-plugin"})
    public final class FieldAnnotationRemover
    extends FieldVisitor {
        @Nullable
        public AnnotationVisitor visitAnnotation(@Nullable String desc, boolean visible) {
            AnnotationsRemover this_$iv = AnnotationsRemover.this;
            return CollectionsKt.contains((Iterable)this_$iv.annotations, (Object)desc) ? (AnnotationVisitor)null : super.visitAnnotation(desc, visible);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, @Nullable String desc, boolean visible) {
            void this_$iv;
            AnnotationsRemover annotationsRemover2 = AnnotationsRemover.this;
            return CollectionsKt.contains((Iterable)((AnnotationsRemover)this_$iv).annotations, (Object)desc) ? (AnnotationVisitor)null : super.visitTypeAnnotation(typeRef, typePath, desc, visible);
        }

        public FieldAnnotationRemover(FieldVisitor fieldVisitor) {
            Intrinsics.checkParameterIsNotNull((Object)fieldVisitor, (String)"fieldVisitor");
            super(327680, fieldVisitor);
        }
    }
}

