/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.model.SourceProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.annotation.SourceAnnotationsRegistry;
import org.jetbrains.kotlin.gradle.internal.Kapt2GradleSubplugin;
import org.jetbrains.kotlin.gradle.plugin.KaptExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinGradleSubplugin;
import org.jetbrains.kotlin.gradle.plugin.SubpluginOption;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0003J:\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0016\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0016H\u0002R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u0006\u0012\u0002\b\u00030\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/gradle/internal/Kapt2KotlinGradleSubplugin;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleSubplugin;", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "()V", "sourceProviders", "", "Lcom/android/builder/model/SourceProvider;", "Lcom/android/build/gradle/internal/variant/BaseVariantData;", "getSourceProviders", "(Lcom/android/build/gradle/internal/variant/BaseVariantData;)Ljava/util/List;", "apply", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginOption;", "project", "Lorg/gradle/api/Project;", "kotlinCompile", "javaCompile", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "variantData", "", "javaSourceSet", "Lorg/gradle/api/tasks/SourceSet;", "getArtifactName", "", "getGroupName", "getKaptGeneratedDir", "Ljava/io/File;", "sourceSetName", "getPluginName", "isApplicable", "", "task", "findKaptConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "Companion", "kotlin-gradle-plugin"})
public final class Kapt2KotlinGradleSubplugin
implements KotlinGradleSubplugin<KotlinCompile> {
    private static final String VERBOSE_OPTION_NAME = "kapt.verbose";
    public static final Companion Companion = new Companion(null);

    public boolean isApplicable(@NotNull Project project, @NotNull KotlinCompile task) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return Kapt2GradleSubplugin.Companion.isEnabled(project);
    }

    @NotNull
    public final File getKaptGeneratedDir(@NotNull Project project, @NotNull String sourceSetName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
        return new File(project.getProject().getBuildDir(), "generated/source/kapt2/" + sourceSetName);
    }

    private final Configuration findKaptConfiguration(@NotNull Project $receiver, String sourceSetName) {
        return (Configuration)$receiver.getProject().getConfigurations().findByName(Companion.getKaptConfigurationName(sourceSetName));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<SubpluginOption> apply(@NotNull Project project, @NotNull KotlinCompile kotlinCompile, @NotNull AbstractCompile javaCompile, @Nullable Object variantData, @Nullable SourceSet javaSourceSet) {
        BaseExtension baseExtension;
        SubpluginOption subpluginOption;
        Object $receiver$iv$iv;
        Object options;
        Object javaCompile2;
        SubpluginOption subpluginOption2;
        Collection collection;
        Iterator<Map.Entry<String, String>> it;
        Object $receiver$iv;
        String sourceSetName;
        String string;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)kotlinCompile, (String)"kotlinCompile");
        Intrinsics.checkParameterIsNotNull((Object)javaCompile, (String)"javaCompile");
        boolean bl = variantData != null ^ javaSourceSet != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        List pluginOptions = CollectionsKt.mutableListOf((Object[])new SubpluginOption[0]);
        ArrayList kaptClasspath = CollectionsKt.arrayListOf((Object[])new File[0]);
        Function1<String, Unit> handleSourceSet$ = new Function1<String, Unit>(this, project, javaCompile, kaptClasspath){
            final /* synthetic */ Kapt2KotlinGradleSubplugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ AbstractCompile $javaCompile;
            final /* synthetic */ ArrayList $kaptClasspath;

            public final void invoke(@NotNull String sourceSetName) {
                Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
                Configuration kapt2Configuration = Kapt2KotlinGradleSubplugin.access$findKaptConfiguration(this.this$0, this.$project, sourceSetName);
                if (kapt2Configuration != null && kapt2Configuration.getDependencies().size() > 1) {
                    this.$javaCompile.dependsOn(new Object[]{kapt2Configuration.getBuildDependencies()});
                    this.$kaptClasspath.addAll(kapt2Configuration.resolve());
                }
            }
            {
                this.this$0 = kapt2KotlinGradleSubplugin;
                this.$project = project;
                this.$javaCompile = abstractCompile;
                this.$kaptClasspath = arrayList;
                super(1);
            }
        };
        if (variantData != null) {
            Object object2 = variantData;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.variant.BaseVariantData<*>");
            }
            object = this.getSourceProviders((BaseVariantData)object2).iterator();
            while (object.hasNext()) {
                SourceProvider provider;
                SourceProvider sourceProvider = provider = object.next();
                if (sourceProvider == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.api.AndroidSourceSet");
                }
                String string3 = ((AndroidSourceSet)sourceProvider).getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(provider as AndroidSourceSet).name");
                handleSourceSet$.invoke(string3);
            }
            string = ((BaseVariantData)variantData).getName();
        } else {
            if (javaSourceSet == null) {
                String provider = "Java source set should not be null";
                throw (Throwable)new IllegalStateException(provider.toString());
            }
            String string4 = javaSourceSet.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"javaSourceSet.name");
            handleSourceSet$.invoke(string4);
            string = javaSourceSet.getName();
        }
        String string5 = sourceSetName = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"sourceSetName");
        File generatedFilesDir = this.getKaptGeneratedDir(project, string5);
        if (variantData != null) {
            Object object3 = variantData;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.variant.BaseVariantData<*>");
            }
            ((BaseVariantData)object3).addJavaSourceFoldersToModel(new File[]{generatedFilesDir});
        }
        if (kaptClasspath.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        object = kaptClasspath;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            it = (File)element$iv;
            collection = pluginOptions;
            String string6 = ((File)((Object)it)).getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"it.absolutePath");
            subpluginOption2 = new SubpluginOption("apclasspath", string6);
            collection.add(subpluginOption2);
        }
        javaCompile.source(new Object[]{generatedFilesDir});
        AbstractCompile abstractCompile = javaCompile;
        if (!(abstractCompile instanceof JavaCompile)) {
            abstractCompile = null;
        }
        JavaCompile javaCompile3 = (JavaCompile)abstractCompile;
        if (javaCompile3 != null) {
            void destination$iv$iv;
            void $receiver$iv2;
            $receiver$iv = javaCompile3;
            javaCompile2 = $receiver$iv;
            options = javaCompile2.getOptions();
            it = options.getCompilerArgs();
            collection = options;
            subpluginOption2 = $receiver$iv2;
            Collection $i$a$2$forEach = new ArrayList();
            subpluginOption = $receiver$iv$iv.iterator();
            while (subpluginOption.hasNext()) {
                Object element$iv$iv = subpluginOption.next();
                String it2 = (String)element$iv$iv;
                if (!(!StringsKt.startsWith$default((String)it2, (String)"-proc:", (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            collection.setCompilerArgs(CollectionsKt.plus((Collection)list, (Object)"-proc:none"));
        }
        $receiver$iv = pluginOptions;
        String string7 = generatedFilesDir.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"generatedFilesDir.canonicalPath");
        javaCompile2 = new SubpluginOption("generated", string7);
        $receiver$iv.add(javaCompile2);
        $receiver$iv = pluginOptions;
        String string8 = kotlinCompile.getDestinationDir().getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"kotlinCompile.destinationDir.canonicalPath");
        javaCompile2 = new SubpluginOption("classes", string8);
        $receiver$iv.add(javaCompile2);
        KaptExtension kaptExtension = (KaptExtension)project.getExtensions().getByType(KaptExtension.class);
        if (kaptExtension.getGenerateStubs()) {
            project.getLogger().warn("'kapt.generateStubs' is not used by the 'kotlin-kapt' plugin");
        }
        if (project.hasProperty(Kapt2KotlinGradleSubplugin.Companion.getVERBOSE_OPTION_NAME()) && Intrinsics.areEqual((Object)project.property(Kapt2KotlinGradleSubplugin.Companion.getVERBOSE_OPTION_NAME()), (Object)"true")) {
            javaCompile2 = pluginOptions;
            options = new SubpluginOption("verbose", "true");
            javaCompile2.add(options);
        }
        Object object4 = variantData;
        if (object4 != null) {
            options = object4;
            it = options;
            Object object5 = project.getExtensions().findByName("android");
            if (!(object5 instanceof BaseExtension)) {
                object5 = null;
            }
            baseExtension = (BaseExtension)object5;
        } else {
            baseExtension = null;
        }
        BaseExtension androidPlugin = baseExtension;
        Map<String, String> $i$a$1$let = kaptExtension.getAdditionalArguments(project, variantData, androidPlugin);
        it = $i$a$1$let.entrySet().iterator();
        while (it.hasNext()) {
            $receiver$iv$iv = options = it.next();
            String key = (String)$receiver$iv$iv.getKey();
            Object object6 = options;
            String value = (String)object6.getValue();
            object6 = pluginOptions;
            subpluginOption = new SubpluginOption("apoption", key + ":" + value);
            object6.add(subpluginOption);
        }
        File annotationsFile = new File(kotlinCompile.getTaskBuildDirectory$kotlin_gradle_plugin(), "source-annotations.txt");
        kotlinCompile.setSourceAnnotationsRegistry$kotlin_gradle_plugin(new SourceAnnotationsRegistry(annotationsFile));
        File incrementalCompilationDataFile = new File(project.getBuildDir(), "tmp/kapt2/" + sourceSetName + "/incrementalData.txt");
        collection = pluginOptions;
        String string9 = incrementalCompilationDataFile.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"incrementalCompilationDataFile.absolutePath");
        subpluginOption2 = new SubpluginOption("incrementalData", string9);
        collection.add(subpluginOption2);
        return pluginOptions;
    }

    private final List<SourceProvider> getSourceProviders(@NotNull BaseVariantData<?> $receiver) {
        List list = $receiver.getVariantConfiguration().getSortedSourceProviders();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"variantConfiguration.sortedSourceProviders");
        return list;
    }

    @NotNull
    public String getPluginName() {
        return "org.jetbrains.kotlin.kapt2";
    }

    @NotNull
    public String getGroupName() {
        return "org.jetbrains.kotlin";
    }

    @NotNull
    public String getArtifactName() {
        return "kotlin-annotation-processing";
    }

    static {
        VERBOSE_OPTION_NAME = VERBOSE_OPTION_NAME;
    }

    @Nullable
    public static final /* synthetic */ Configuration access$findKaptConfiguration(Kapt2KotlinGradleSubplugin $this, @NotNull Project $receiver, @NotNull String sourceSetName) {
        return $this.findKaptConfiguration($receiver, sourceSetName);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/Kapt2KotlinGradleSubplugin$Companion;", "", "()V", "VERBOSE_OPTION_NAME", "", "getVERBOSE_OPTION_NAME", "()Ljava/lang/String;", "getKaptConfigurationName", "sourceSetName", "kotlin-gradle-plugin"})
    public static final class Companion {
        private final String getVERBOSE_OPTION_NAME() {
            return VERBOSE_OPTION_NAME;
        }

        @NotNull
        public final String getKaptConfigurationName(@NotNull String sourceSetName) {
            Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
            return Intrinsics.areEqual((Object)sourceSetName, (Object)"main") ^ true ? "kapt" + StringsKt.capitalize((String)sourceSetName) : "kapt";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

